// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.monitoring.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class MonitoringClient extends ApiClient {

  public MonitoringClient(String appId, String apiKey) {
    this(appId, apiKey, null);
  }

  public MonitoringClient(String appId, String apiKey, ClientOptions options) {
    super(appId, apiKey, "Monitoring", options, getDefaultHosts());
  }

  private static List<Host> getDefaultHosts() {
    List<Host> hosts = new ArrayList<>();
    hosts.add(new Host("status.algolia.com", EnumSet.of(CallType.READ, CallType.WRITE)));
    return hosts;
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customDeleteAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDelete(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customGetAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGet(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGet(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGet(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPostAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPost(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPostAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPutAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPut(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPutAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, null);
  }

  /**
   * Retrieves known incidents for the selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IncidentsResponse getClusterIncidents(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getClusterIncidentsAsync(clusters, requestOptions));
  }

  /**
   * Retrieves known incidents for the selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IncidentsResponse getClusterIncidents(@Nonnull String clusters) throws AlgoliaRuntimeException {
    return this.getClusterIncidents(clusters, null);
  }

  /**
   * (asynchronously) Retrieves known incidents for the selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IncidentsResponse> getClusterIncidentsAsync(@Nonnull String clusters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getClusterIncidents`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/incidents/{clusters}", clusters).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<IncidentsResponse>() {});
  }

  /**
   * (asynchronously) Retrieves known incidents for the selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IncidentsResponse> getClusterIncidentsAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
    return this.getClusterIncidentsAsync(clusters, null);
  }

  /**
   * Retrieves the status of selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public StatusResponse getClusterStatus(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getClusterStatusAsync(clusters, requestOptions));
  }

  /**
   * Retrieves the status of selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public StatusResponse getClusterStatus(@Nonnull String clusters) throws AlgoliaRuntimeException {
    return this.getClusterStatus(clusters, null);
  }

  /**
   * (asynchronously) Retrieves the status of selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<StatusResponse> getClusterStatusAsync(@Nonnull String clusters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getClusterStatus`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/status/{clusters}", clusters).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<StatusResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the status of selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<StatusResponse> getClusterStatusAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
    return this.getClusterStatusAsync(clusters, null);
  }

  /**
   * Retrieves known incidents for all clusters.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IncidentsResponse getIncidents(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getIncidentsAsync(requestOptions));
  }

  /**
   * Retrieves known incidents for all clusters.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IncidentsResponse getIncidents() throws AlgoliaRuntimeException {
    return this.getIncidents(null);
  }

  /**
   * (asynchronously) Retrieves known incidents for all clusters.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IncidentsResponse> getIncidentsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/incidents").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<IncidentsResponse>() {});
  }

  /**
   * (asynchronously) Retrieves known incidents for all clusters.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IncidentsResponse> getIncidentsAsync() throws AlgoliaRuntimeException {
    return this.getIncidentsAsync(null);
  }

  /**
   * Retrieves average times for indexing operations for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexingTimeResponse getIndexingTime(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getIndexingTimeAsync(clusters, requestOptions));
  }

  /**
   * Retrieves average times for indexing operations for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexingTimeResponse getIndexingTime(@Nonnull String clusters) throws AlgoliaRuntimeException {
    return this.getIndexingTime(clusters, null);
  }

  /**
   * (asynchronously) Retrieves average times for indexing operations for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexingTimeResponse> getIndexingTimeAsync(@Nonnull String clusters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getIndexingTime`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/indexing/{clusters}", clusters).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<IndexingTimeResponse>() {});
  }

  /**
   * (asynchronously) Retrieves average times for indexing operations for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexingTimeResponse> getIndexingTimeAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
    return this.getIndexingTimeAsync(clusters, null);
  }

  /**
   * Retrieves the average latency for search requests for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public LatencyResponse getLatency(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getLatencyAsync(clusters, requestOptions));
  }

  /**
   * Retrieves the average latency for search requests for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public LatencyResponse getLatency(@Nonnull String clusters) throws AlgoliaRuntimeException {
    return this.getLatency(clusters, null);
  }

  /**
   * (asynchronously) Retrieves the average latency for search requests for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<LatencyResponse> getLatencyAsync(@Nonnull String clusters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getLatency`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/latency/{clusters}", clusters).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<LatencyResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the average latency for search requests for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<LatencyResponse> getLatencyAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
    return this.getLatencyAsync(clusters, null);
  }

  /**
   * Retrieves metrics related to your Algolia infrastructure, aggregated over a selected time
   * window. Access to this API is available as part of the [Premium or Elevate
   * plans](https://www.algolia.com/pricing). You must authenticate requests with the
   * `x-algolia-application-id` and `x-algolia-api-key` headers (using the Monitoring API key).
   *
   * @param metric Metric to report. For more information about the individual metrics, see the
   *     description of the API response. To include all metrics, use `*`. (required)
   * @param period Period over which to aggregate the metrics: - `minute`. Aggregate the last
   *     minute. 1 data point per 10 seconds. - `hour`. Aggregate the last hour. 1 data point per
   *     minute. - `day`. Aggregate the last day. 1 data point per 10 minutes. - `week`. Aggregate
   *     the last week. 1 data point per hour. - `month`. Aggregate the last month. 1 data point per
   *     day. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public InfrastructureResponse getMetrics(@Nonnull Metric metric, @Nonnull Period period, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getMetricsAsync(metric, period, requestOptions));
  }

  /**
   * Retrieves metrics related to your Algolia infrastructure, aggregated over a selected time
   * window. Access to this API is available as part of the [Premium or Elevate
   * plans](https://www.algolia.com/pricing). You must authenticate requests with the
   * `x-algolia-application-id` and `x-algolia-api-key` headers (using the Monitoring API key).
   *
   * @param metric Metric to report. For more information about the individual metrics, see the
   *     description of the API response. To include all metrics, use `*`. (required)
   * @param period Period over which to aggregate the metrics: - `minute`. Aggregate the last
   *     minute. 1 data point per 10 seconds. - `hour`. Aggregate the last hour. 1 data point per
   *     minute. - `day`. Aggregate the last day. 1 data point per 10 minutes. - `week`. Aggregate
   *     the last week. 1 data point per hour. - `month`. Aggregate the last month. 1 data point per
   *     day. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public InfrastructureResponse getMetrics(@Nonnull Metric metric, @Nonnull Period period) throws AlgoliaRuntimeException {
    return this.getMetrics(metric, period, null);
  }

  /**
   * (asynchronously) Retrieves metrics related to your Algolia infrastructure, aggregated over a
   * selected time window. Access to this API is available as part of the [Premium or Elevate
   * plans](https://www.algolia.com/pricing). You must authenticate requests with the
   * `x-algolia-application-id` and `x-algolia-api-key` headers (using the Monitoring API key).
   *
   * @param metric Metric to report. For more information about the individual metrics, see the
   *     description of the API response. To include all metrics, use `*`. (required)
   * @param period Period over which to aggregate the metrics: - `minute`. Aggregate the last
   *     minute. 1 data point per 10 seconds. - `hour`. Aggregate the last hour. 1 data point per
   *     minute. - `day`. Aggregate the last day. 1 data point per 10 minutes. - `week`. Aggregate
   *     the last week. 1 data point per hour. - `month`. Aggregate the last month. 1 data point per
   *     day. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<InfrastructureResponse> getMetricsAsync(
    @Nonnull Metric metric,
    @Nonnull Period period,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(metric, "Parameter `metric` is required when calling `getMetrics`.");

    Parameters.requireNonNull(period, "Parameter `period` is required when calling `getMetrics`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/infrastructure/{metric}/period/{period}", metric, period)
      .setMethod("GET")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<InfrastructureResponse>() {});
  }

  /**
   * (asynchronously) Retrieves metrics related to your Algolia infrastructure, aggregated over a
   * selected time window. Access to this API is available as part of the [Premium or Elevate
   * plans](https://www.algolia.com/pricing). You must authenticate requests with the
   * `x-algolia-application-id` and `x-algolia-api-key` headers (using the Monitoring API key).
   *
   * @param metric Metric to report. For more information about the individual metrics, see the
   *     description of the API response. To include all metrics, use `*`. (required)
   * @param period Period over which to aggregate the metrics: - `minute`. Aggregate the last
   *     minute. 1 data point per 10 seconds. - `hour`. Aggregate the last hour. 1 data point per
   *     minute. - `day`. Aggregate the last day. 1 data point per 10 minutes. - `week`. Aggregate
   *     the last week. 1 data point per hour. - `month`. Aggregate the last month. 1 data point per
   *     day. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<InfrastructureResponse> getMetricsAsync(@Nonnull Metric metric, @Nonnull Period period)
    throws AlgoliaRuntimeException {
    return this.getMetricsAsync(metric, period, null);
  }

  /**
   * Test whether clusters are reachable or not.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Map<String, Map<String, Boolean>> getReachability(@Nonnull String clusters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getReachabilityAsync(clusters, requestOptions));
  }

  /**
   * Test whether clusters are reachable or not.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Map<String, Map<String, Boolean>> getReachability(@Nonnull String clusters) throws AlgoliaRuntimeException {
    return this.getReachability(clusters, null);
  }

  /**
   * (asynchronously) Test whether clusters are reachable or not.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Map<String, Map<String, Boolean>>> getReachabilityAsync(@Nonnull String clusters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getReachability`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/reachability/{clusters}/probes", clusters).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<Map<String, Map<String, Boolean>>>() {});
  }

  /**
   * (asynchronously) Test whether clusters are reachable or not.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Map<String, Map<String, Boolean>>> getReachabilityAsync(@Nonnull String clusters)
    throws AlgoliaRuntimeException {
    return this.getReachabilityAsync(clusters, null);
  }

  /**
   * Retrieves the servers that belong to clusters. The response depends on whether you authenticate
   * your API request: - With authentication, the response lists the servers assigned to your
   * Algolia application's cluster. - Without authentication, the response lists the servers for all
   * Algolia clusters.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public InventoryResponse getServers(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getServersAsync(requestOptions));
  }

  /**
   * Retrieves the servers that belong to clusters. The response depends on whether you authenticate
   * your API request: - With authentication, the response lists the servers assigned to your
   * Algolia application's cluster. - Without authentication, the response lists the servers for all
   * Algolia clusters.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public InventoryResponse getServers() throws AlgoliaRuntimeException {
    return this.getServers(null);
  }

  /**
   * (asynchronously) Retrieves the servers that belong to clusters. The response depends on whether
   * you authenticate your API request: - With authentication, the response lists the servers
   * assigned to your Algolia application's cluster. - Without authentication, the response lists
   * the servers for all Algolia clusters.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<InventoryResponse> getServersAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/inventory/servers").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<InventoryResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the servers that belong to clusters. The response depends on whether
   * you authenticate your API request: - With authentication, the response lists the servers
   * assigned to your Algolia application's cluster. - Without authentication, the response lists
   * the servers for all Algolia clusters.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<InventoryResponse> getServersAsync() throws AlgoliaRuntimeException {
    return this.getServersAsync(null);
  }

  /**
   * Retrieves the status of all Algolia clusters and instances.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public StatusResponse getStatus(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getStatusAsync(requestOptions));
  }

  /**
   * Retrieves the status of all Algolia clusters and instances.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public StatusResponse getStatus() throws AlgoliaRuntimeException {
    return this.getStatus(null);
  }

  /**
   * (asynchronously) Retrieves the status of all Algolia clusters and instances.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<StatusResponse> getStatusAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/status").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<StatusResponse>() {});
  }

  /**
   * (asynchronously) Retrieves the status of all Algolia clusters and instances.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<StatusResponse> getStatusAsync() throws AlgoliaRuntimeException {
    return this.getStatusAsync(null);
  }
}
