// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.recommend;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.Objects;

/**
 * Condition that triggers the rule. If not specified, the rule is triggered for all
 * recommendations.
 */
public class Condition {

  @JsonProperty("filters")
  private String filters;

  @JsonProperty("context")
  private String context;

  public Condition setFilters(String filters) {
    this.filters = filters;
    return this;
  }

  /**
   * Filter expression to only include items that match the filter criteria in the response. You can
   * use these filter expressions: - **Numeric filters.** `<facet> <op> <number>`, where `<op>` is
   * one of `<`, `<=`, `=`, `!=`, `>`, `>=`. - **Ranges.** `<facet>:<lower> TO <upper>` where
   * `<lower>` and `<upper>` are the lower and upper limits of the range (inclusive). - **Facet
   * filters.** `<facet>:<value>` where `<facet>` is a facet attribute (case-sensitive) and
   * `<value>` a facet value. - **Tag filters.** `_tags:<value>` or just `<value>` (case-sensitive).
   * - **Boolean filters.** `<facet>: true | false`. You can combine filters with `AND`, `OR`, and
   * `NOT` operators with the following restrictions: - You can only combine filters of the same
   * type with `OR`. **Not supported:** `facet:value OR num > 3`. - You can't use `NOT` with
   * combinations of filters. **Not supported:** `NOT(facet:value OR facet:value)` - You can't
   * combine conjunctions (`AND`) with `OR`. **Not supported:** `facet:value OR (facet:value AND
   * facet:value)` Use quotes around your filters, if the facet attribute name or facet value has
   * spaces, keywords (`OR`, `AND`, `NOT`), or quotes. If a facet attribute is an array, the filter
   * matches if it matches at least one element of the array. For more information, see
   * [Filters](https://www.algolia.com/doc/guides/managing-results/refine-results/filtering/).
   */
  @javax.annotation.Nullable
  public String getFilters() {
    return filters;
  }

  public Condition setContext(String context) {
    this.context = context;
    return this;
  }

  /**
   * An additional restriction that only triggers the rule, when the search has the same value as
   * `ruleContexts` parameter. For example, if `context: mobile`, the rule is only triggered when
   * the search request has a matching `ruleContexts: mobile`. A rule context must only contain
   * alphanumeric characters.
   */
  @javax.annotation.Nullable
  public String getContext() {
    return context;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Condition condition = (Condition) o;
    return Objects.equals(this.filters, condition.filters) && Objects.equals(this.context, condition.context);
  }

  @Override
  public int hashCode() {
    return Objects.hash(filters, context);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Condition {\n");
    sb.append("    filters: ").append(toIndentedString(filters)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
