// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/**
 * Filters to promote or demote records in the search results. Optional filters work like facet
 * filters, but they don't exclude records from the search results. Records that match the optional
 * filter rank before records that don't match. If you're using a negative filter `facet:-value`,
 * matching records rank after records that don't match. - Optional filters don't work on virtual
 * replicas. - Optional filters are applied _after_ sort-by attributes. - Optional filters don't
 * work with numeric attributes.
 */
@JsonDeserialize(using = OptionalFilters.Deserializer.class)
public interface OptionalFilters {
  // OptionalFilters as List<OptionalFilters> wrapper.
  static OptionalFilters of(List<OptionalFilters> value) {
    return new ListOfOptionalFiltersWrapper(value);
  }

  // OptionalFilters as String wrapper.
  static OptionalFilters of(String value) {
    return new StringWrapper(value);
  }

  // OptionalFilters as List<OptionalFilters> wrapper.
  @JsonSerialize(using = ListOfOptionalFiltersWrapper.Serializer.class)
  class ListOfOptionalFiltersWrapper implements OptionalFilters {

    private final List<OptionalFilters> value;

    ListOfOptionalFiltersWrapper(List<OptionalFilters> value) {
      this.value = value;
    }

    public List<OptionalFilters> getValue() {
      return value;
    }

    static class Serializer extends JsonSerializer<ListOfOptionalFiltersWrapper> {

      @Override
      public void serialize(ListOfOptionalFiltersWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeObject(value.getValue());
      }
    }
  }

  // OptionalFilters as String wrapper.
  @JsonSerialize(using = StringWrapper.Serializer.class)
  class StringWrapper implements OptionalFilters {

    private final String value;

    StringWrapper(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    static class Serializer extends JsonSerializer<StringWrapper> {

      @Override
      public void serialize(StringWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeObject(value.getValue());
      }
    }
  }

  class Deserializer extends JsonDeserializer<OptionalFilters> {

    private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

    @Override
    public OptionalFilters deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();
      // deserialize List<OptionalFilters>
      if (tree.isArray()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          List<OptionalFilters> value = parser.readValueAs(new TypeReference<List<OptionalFilters>>() {});
          return new OptionalFilters.ListOfOptionalFiltersWrapper(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf List<OptionalFilters> (error: " + e.getMessage() + ") (type: List<OptionalFilters>)");
        }
      }
      // deserialize String
      if (tree.isTextual()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          String value = parser.readValueAs(String.class);
          return new OptionalFilters.StringWrapper(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf String (error: " + e.getMessage() + ") (type: String)");
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public OptionalFilters getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "OptionalFilters cannot be null");
    }
  }
}
