// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.usage;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

/** StatisticValue */
@JsonDeserialize(using = StatisticValue.Deserializer.class)
public interface StatisticValue {
  // StatisticValue as Integer wrapper.
  static StatisticValue of(Integer value) {
    return new IntegerWrapper(value);
  }

  // StatisticValue as Map<String, Integer> wrapper.
  static StatisticValue of(Map<String, Integer> value) {
    return new MapOfStringIntegerWrapper(value);
  }

  // StatisticValue as Integer wrapper.
  @JsonSerialize(using = IntegerWrapper.Serializer.class)
  class IntegerWrapper implements StatisticValue {

    private final Integer value;

    IntegerWrapper(Integer value) {
      this.value = value;
    }

    public Integer getValue() {
      return value;
    }

    static class Serializer extends JsonSerializer<IntegerWrapper> {

      @Override
      public void serialize(IntegerWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeObject(value.getValue());
      }
    }
  }

  // StatisticValue as Map<String, Integer> wrapper.
  @JsonSerialize(using = MapOfStringIntegerWrapper.Serializer.class)
  class MapOfStringIntegerWrapper implements StatisticValue {

    private final Map<String, Integer> value;

    MapOfStringIntegerWrapper(Map<String, Integer> value) {
      this.value = value;
    }

    public Map<String, Integer> getValue() {
      return value;
    }

    static class Serializer extends JsonSerializer<MapOfStringIntegerWrapper> {

      @Override
      public void serialize(MapOfStringIntegerWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeObject(value.getValue());
      }
    }
  }

  class Deserializer extends JsonDeserializer<StatisticValue> {

    private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

    @Override
    public StatisticValue deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();
      // deserialize Integer
      if (tree.isInt()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Integer value = parser.readValueAs(Integer.class);
          return new StatisticValue.IntegerWrapper(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Integer (error: " + e.getMessage() + ") (type: Integer)");
        }
      }
      // deserialize Map<String, Integer>
      if (tree.isObject()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Map<String, Integer> value = parser.readValueAs(new TypeReference<Map<String, Integer>>() {});
          return new StatisticValue.MapOfStringIntegerWrapper(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Map<String, Integer> (error: " + e.getMessage() + ") (type: Map<String, Integer>)");
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public StatisticValue getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "StatisticValue cannot be null");
    }
  }
}
