// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.ingestion.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class IngestionClient extends ApiClient {

  private static final String[] allowedRegions = { "eu", "us" };

  public IngestionClient(String appId, String apiKey, String region) {
    this(appId, apiKey, region, null);
  }

  public IngestionClient(String appId, String apiKey, String region, ClientOptions options) {
    super(appId, apiKey, "Ingestion", options, getDefaultHosts(region));
  }

  private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
    List<Host> hosts = new ArrayList<>();

    boolean found = false;
    if (region != null) {
      for (String allowed : allowedRegions) {
        if (allowed.equals(region)) {
          found = true;
          break;
        }
      }
    }

    if (region == null || !found) {
      throw new AlgoliaRuntimeException("`region` is required and must be one of the following: eu, us");
    }

    String url = "data.{region}.algolia.com".replace("{region}", region);

    hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
    return hosts;
  }

  /**
   * Creates a new authentication resource.
   *
   * @param authenticationCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AuthenticationCreateResponse createAuthentication(
    @Nonnull AuthenticationCreate authenticationCreate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(createAuthenticationAsync(authenticationCreate, requestOptions));
  }

  /**
   * Creates a new authentication resource.
   *
   * @param authenticationCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AuthenticationCreateResponse createAuthentication(@Nonnull AuthenticationCreate authenticationCreate)
    throws AlgoliaRuntimeException {
    return this.createAuthentication(authenticationCreate, null);
  }

  /**
   * (asynchronously) Creates a new authentication resource.
   *
   * @param authenticationCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AuthenticationCreateResponse> createAuthenticationAsync(
    @Nonnull AuthenticationCreate authenticationCreate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(authenticationCreate, "Parameter `authenticationCreate` is required when calling `createAuthentication`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/authentications").setMethod("POST").setBody(authenticationCreate).build();
    return executeAsync(request, requestOptions, new TypeReference<AuthenticationCreateResponse>() {});
  }

  /**
   * (asynchronously) Creates a new authentication resource.
   *
   * @param authenticationCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AuthenticationCreateResponse> createAuthenticationAsync(@Nonnull AuthenticationCreate authenticationCreate)
    throws AlgoliaRuntimeException {
    return this.createAuthenticationAsync(authenticationCreate, null);
  }

  /**
   * Creates a new destination.
   *
   * @param destinationCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DestinationCreateResponse createDestination(@Nonnull DestinationCreate destinationCreate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(createDestinationAsync(destinationCreate, requestOptions));
  }

  /**
   * Creates a new destination.
   *
   * @param destinationCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DestinationCreateResponse createDestination(@Nonnull DestinationCreate destinationCreate) throws AlgoliaRuntimeException {
    return this.createDestination(destinationCreate, null);
  }

  /**
   * (asynchronously) Creates a new destination.
   *
   * @param destinationCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DestinationCreateResponse> createDestinationAsync(
    @Nonnull DestinationCreate destinationCreate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(destinationCreate, "Parameter `destinationCreate` is required when calling `createDestination`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/destinations").setMethod("POST").setBody(destinationCreate).build();
    return executeAsync(request, requestOptions, new TypeReference<DestinationCreateResponse>() {});
  }

  /**
   * (asynchronously) Creates a new destination.
   *
   * @param destinationCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DestinationCreateResponse> createDestinationAsync(@Nonnull DestinationCreate destinationCreate)
    throws AlgoliaRuntimeException {
    return this.createDestinationAsync(destinationCreate, null);
  }

  /**
   * Creates a new source.
   *
   * @param sourceCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceCreateResponse createSource(@Nonnull SourceCreate sourceCreate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(createSourceAsync(sourceCreate, requestOptions));
  }

  /**
   * Creates a new source.
   *
   * @param sourceCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceCreateResponse createSource(@Nonnull SourceCreate sourceCreate) throws AlgoliaRuntimeException {
    return this.createSource(sourceCreate, null);
  }

  /**
   * (asynchronously) Creates a new source.
   *
   * @param sourceCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceCreateResponse> createSourceAsync(@Nonnull SourceCreate sourceCreate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceCreate, "Parameter `sourceCreate` is required when calling `createSource`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources").setMethod("POST").setBody(sourceCreate).build();

    return executeAsync(request, requestOptions, new TypeReference<SourceCreateResponse>() {});
  }

  /**
   * (asynchronously) Creates a new source.
   *
   * @param sourceCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceCreateResponse> createSourceAsync(@Nonnull SourceCreate sourceCreate) throws AlgoliaRuntimeException {
    return this.createSourceAsync(sourceCreate, null);
  }

  /**
   * Creates a new task.
   *
   * @param taskCreate Request body for creating a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskCreateResponse createTask(@Nonnull TaskCreate taskCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(createTaskAsync(taskCreate, requestOptions));
  }

  /**
   * Creates a new task.
   *
   * @param taskCreate Request body for creating a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskCreateResponse createTask(@Nonnull TaskCreate taskCreate) throws AlgoliaRuntimeException {
    return this.createTask(taskCreate, null);
  }

  /**
   * (asynchronously) Creates a new task.
   *
   * @param taskCreate Request body for creating a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskCreateResponse> createTaskAsync(@Nonnull TaskCreate taskCreate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskCreate, "Parameter `taskCreate` is required when calling `createTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks").setMethod("POST").setBody(taskCreate).build();

    return executeAsync(request, requestOptions, new TypeReference<TaskCreateResponse>() {});
  }

  /**
   * (asynchronously) Creates a new task.
   *
   * @param taskCreate Request body for creating a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskCreateResponse> createTaskAsync(@Nonnull TaskCreate taskCreate) throws AlgoliaRuntimeException {
    return this.createTaskAsync(taskCreate, null);
  }

  /**
   * Creates a new transformation.
   *
   * @param transformationCreate Request body for creating a transformation. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TransformationCreateResponse createTransformation(
    @Nonnull TransformationCreate transformationCreate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(createTransformationAsync(transformationCreate, requestOptions));
  }

  /**
   * Creates a new transformation.
   *
   * @param transformationCreate Request body for creating a transformation. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TransformationCreateResponse createTransformation(@Nonnull TransformationCreate transformationCreate)
    throws AlgoliaRuntimeException {
    return this.createTransformation(transformationCreate, null);
  }

  /**
   * (asynchronously) Creates a new transformation.
   *
   * @param transformationCreate Request body for creating a transformation. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TransformationCreateResponse> createTransformationAsync(
    @Nonnull TransformationCreate transformationCreate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(transformationCreate, "Parameter `transformationCreate` is required when calling `createTransformation`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/transformations").setMethod("POST").setBody(transformationCreate).build();
    return executeAsync(request, requestOptions, new TypeReference<TransformationCreateResponse>() {});
  }

  /**
   * (asynchronously) Creates a new transformation.
   *
   * @param transformationCreate Request body for creating a transformation. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TransformationCreateResponse> createTransformationAsync(@Nonnull TransformationCreate transformationCreate)
    throws AlgoliaRuntimeException {
    return this.createTransformationAsync(transformationCreate, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customDeleteAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDelete(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customGetAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGet(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGet(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGet(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPostAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPost(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPostAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPutAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPut(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPutAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, null);
  }

  /**
   * Deletes an authentication resource. You can't delete authentication resources that are used by
   * a source or a destination.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteAuthentication(@Nonnull String authenticationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteAuthenticationAsync(authenticationID, requestOptions));
  }

  /**
   * Deletes an authentication resource. You can't delete authentication resources that are used by
   * a source or a destination.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteAuthentication(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
    return this.deleteAuthentication(authenticationID, null);
  }

  /**
   * (asynchronously) Deletes an authentication resource. You can't delete authentication resources
   * that are used by a source or a destination.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteAuthenticationAsync(@Nonnull String authenticationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(authenticationID, "Parameter `authenticationID` is required when calling `deleteAuthentication`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/authentications/{authenticationID}", authenticationID)
      .setMethod("DELETE")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<DeleteResponse>() {});
  }

  /**
   * (asynchronously) Deletes an authentication resource. You can't delete authentication resources
   * that are used by a source or a destination.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteAuthenticationAsync(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
    return this.deleteAuthenticationAsync(authenticationID, null);
  }

  /**
   * Deletes a destination by its ID. You can't delete destinations that are referenced in tasks.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteDestination(@Nonnull String destinationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteDestinationAsync(destinationID, requestOptions));
  }

  /**
   * Deletes a destination by its ID. You can't delete destinations that are referenced in tasks.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteDestination(@Nonnull String destinationID) throws AlgoliaRuntimeException {
    return this.deleteDestination(destinationID, null);
  }

  /**
   * (asynchronously) Deletes a destination by its ID. You can't delete destinations that are
   * referenced in tasks.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteDestinationAsync(@Nonnull String destinationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(destinationID, "Parameter `destinationID` is required when calling `deleteDestination`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/destinations/{destinationID}", destinationID).setMethod("DELETE").build();
    return executeAsync(request, requestOptions, new TypeReference<DeleteResponse>() {});
  }

  /**
   * (asynchronously) Deletes a destination by its ID. You can't delete destinations that are
   * referenced in tasks.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteDestinationAsync(@Nonnull String destinationID) throws AlgoliaRuntimeException {
    return this.deleteDestinationAsync(destinationID, null);
  }

  /**
   * Deletes a source by its ID. You can't delete sources that are referenced in tasks.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteSource(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteSourceAsync(sourceID, requestOptions));
  }

  /**
   * Deletes a source by its ID. You can't delete sources that are referenced in tasks.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteSource(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.deleteSource(sourceID, null);
  }

  /**
   * (asynchronously) Deletes a source by its ID. You can't delete sources that are referenced in
   * tasks.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteSourceAsync(@Nonnull String sourceID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `deleteSource`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}", sourceID).setMethod("DELETE").build();
    return executeAsync(request, requestOptions, new TypeReference<DeleteResponse>() {});
  }

  /**
   * (asynchronously) Deletes a source by its ID. You can't delete sources that are referenced in
   * tasks.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteSourceAsync(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.deleteSourceAsync(sourceID, null);
  }

  /**
   * Deletes a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteTaskAsync(taskID, requestOptions));
  }

  /**
   * Deletes a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.deleteTask(taskID, null);
  }

  /**
   * (asynchronously) Deletes a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteTaskAsync(@Nonnull String taskID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `deleteTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}", taskID).setMethod("DELETE").build();

    return executeAsync(request, requestOptions, new TypeReference<DeleteResponse>() {});
  }

  /**
   * (asynchronously) Deletes a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.deleteTaskAsync(taskID, null);
  }

  /**
   * Deletes a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteTransformation(@Nonnull String transformationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteTransformationAsync(transformationID, requestOptions));
  }

  /**
   * Deletes a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeleteResponse deleteTransformation(@Nonnull String transformationID) throws AlgoliaRuntimeException {
    return this.deleteTransformation(transformationID, null);
  }

  /**
   * (asynchronously) Deletes a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteTransformationAsync(@Nonnull String transformationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(transformationID, "Parameter `transformationID` is required when calling `deleteTransformation`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/transformations/{transformationID}", transformationID)
      .setMethod("DELETE")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<DeleteResponse>() {});
  }

  /**
   * (asynchronously) Deletes a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeleteResponse> deleteTransformationAsync(@Nonnull String transformationID) throws AlgoliaRuntimeException {
    return this.deleteTransformationAsync(transformationID, null);
  }

  /**
   * Disables a task.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse disableTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(disableTaskAsync(taskID, requestOptions));
  }

  /**
   * Disables a task.
   *
   * @param taskID Unique identifier of a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse disableTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.disableTask(taskID, null);
  }

  /**
   * (asynchronously) Disables a task.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> disableTaskAsync(@Nonnull String taskID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `disableTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}/disable", taskID).setMethod("PUT").build();

    return executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>() {});
  }

  /**
   * (asynchronously) Disables a task.
   *
   * @param taskID Unique identifier of a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> disableTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.disableTaskAsync(taskID, null);
  }

  /**
   * Enables a task.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse enableTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(enableTaskAsync(taskID, requestOptions));
  }

  /**
   * Enables a task.
   *
   * @param taskID Unique identifier of a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse enableTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.enableTask(taskID, null);
  }

  /**
   * (asynchronously) Enables a task.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> enableTaskAsync(@Nonnull String taskID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `enableTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}/enable", taskID).setMethod("PUT").build();

    return executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>() {});
  }

  /**
   * (asynchronously) Enables a task.
   *
   * @param taskID Unique identifier of a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> enableTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.enableTaskAsync(taskID, null);
  }

  /**
   * Retrieves an authentication resource by its ID.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Authentication getAuthentication(@Nonnull String authenticationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAuthenticationAsync(authenticationID, requestOptions));
  }

  /**
   * Retrieves an authentication resource by its ID.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Authentication getAuthentication(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
    return this.getAuthentication(authenticationID, null);
  }

  /**
   * (asynchronously) Retrieves an authentication resource by its ID.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Authentication> getAuthenticationAsync(@Nonnull String authenticationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(authenticationID, "Parameter `authenticationID` is required when calling `getAuthentication`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/authentications/{authenticationID}", authenticationID).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<Authentication>() {});
  }

  /**
   * (asynchronously) Retrieves an authentication resource by its ID.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Authentication> getAuthenticationAsync(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
    return this.getAuthenticationAsync(authenticationID, null);
  }

  /**
   * Retrieves a list of all authentication resources.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Type of authentication resource to retrieve. (optional)
   * @param platform Ecommerce platform for which to retrieve authentication resources. (optional)
   * @param sort Property by which to sort the list of authentication resources. (optional, default
   *     to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListAuthenticationsResponse getAuthentications(
    Integer itemsPerPage,
    Integer page,
    List<AuthenticationType> type,
    List<PlatformWithNone> platform,
    AuthenticationSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAuthenticationsAsync(itemsPerPage, page, type, platform, sort, order, requestOptions));
  }

  /**
   * Retrieves a list of all authentication resources.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Type of authentication resource to retrieve. (optional)
   * @param platform Ecommerce platform for which to retrieve authentication resources. (optional)
   * @param sort Property by which to sort the list of authentication resources. (optional, default
   *     to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListAuthenticationsResponse getAuthentications(
    Integer itemsPerPage,
    Integer page,
    List<AuthenticationType> type,
    List<PlatformWithNone> platform,
    AuthenticationSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getAuthentications(itemsPerPage, page, type, platform, sort, order, null);
  }

  /**
   * Retrieves a list of all authentication resources.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListAuthenticationsResponse getAuthentications(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getAuthentications(null, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves a list of all authentication resources.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListAuthenticationsResponse getAuthentications() throws AlgoliaRuntimeException {
    return this.getAuthentications(null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves a list of all authentication resources.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Type of authentication resource to retrieve. (optional)
   * @param platform Ecommerce platform for which to retrieve authentication resources. (optional)
   * @param sort Property by which to sort the list of authentication resources. (optional, default
   *     to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListAuthenticationsResponse> getAuthenticationsAsync(
    Integer itemsPerPage,
    Integer page,
    List<AuthenticationType> type,
    List<PlatformWithNone> platform,
    AuthenticationSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/authentications")
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("type", type)
      .addQueryParameter("platform", platform)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListAuthenticationsResponse>() {});
  }

  /**
   * (asynchronously) Retrieves a list of all authentication resources.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Type of authentication resource to retrieve. (optional)
   * @param platform Ecommerce platform for which to retrieve authentication resources. (optional)
   * @param sort Property by which to sort the list of authentication resources. (optional, default
   *     to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListAuthenticationsResponse> getAuthenticationsAsync(
    Integer itemsPerPage,
    Integer page,
    List<AuthenticationType> type,
    List<PlatformWithNone> platform,
    AuthenticationSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getAuthenticationsAsync(itemsPerPage, page, type, platform, sort, order, null);
  }

  /**
   * (asynchronously) Retrieves a list of all authentication resources.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListAuthenticationsResponse> getAuthenticationsAsync(RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getAuthenticationsAsync(null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves a list of all authentication resources.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListAuthenticationsResponse> getAuthenticationsAsync() throws AlgoliaRuntimeException {
    return this.getAuthenticationsAsync(null, null, null, null, null, null, null);
  }

  /**
   * Retrieves a destination by its ID.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Destination getDestination(@Nonnull String destinationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getDestinationAsync(destinationID, requestOptions));
  }

  /**
   * Retrieves a destination by its ID.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Destination getDestination(@Nonnull String destinationID) throws AlgoliaRuntimeException {
    return this.getDestination(destinationID, null);
  }

  /**
   * (asynchronously) Retrieves a destination by its ID.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Destination> getDestinationAsync(@Nonnull String destinationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(destinationID, "Parameter `destinationID` is required when calling `getDestination`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/destinations/{destinationID}", destinationID).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<Destination>() {});
  }

  /**
   * (asynchronously) Retrieves a destination by its ID.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Destination> getDestinationAsync(@Nonnull String destinationID) throws AlgoliaRuntimeException {
    return this.getDestinationAsync(destinationID, null);
  }

  /**
   * Retrieves a list of destinations.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Destination type. (optional)
   * @param authenticationID Authentication ID used by destinations. (optional)
   * @param sort Property by which to sort the destinations. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListDestinationsResponse getDestinations(
    Integer itemsPerPage,
    Integer page,
    List<DestinationType> type,
    List<String> authenticationID,
    DestinationSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getDestinationsAsync(itemsPerPage, page, type, authenticationID, sort, order, requestOptions));
  }

  /**
   * Retrieves a list of destinations.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Destination type. (optional)
   * @param authenticationID Authentication ID used by destinations. (optional)
   * @param sort Property by which to sort the destinations. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListDestinationsResponse getDestinations(
    Integer itemsPerPage,
    Integer page,
    List<DestinationType> type,
    List<String> authenticationID,
    DestinationSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getDestinations(itemsPerPage, page, type, authenticationID, sort, order, null);
  }

  /**
   * Retrieves a list of destinations.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListDestinationsResponse getDestinations(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getDestinations(null, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves a list of destinations.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListDestinationsResponse getDestinations() throws AlgoliaRuntimeException {
    return this.getDestinations(null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves a list of destinations.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Destination type. (optional)
   * @param authenticationID Authentication ID used by destinations. (optional)
   * @param sort Property by which to sort the destinations. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListDestinationsResponse> getDestinationsAsync(
    Integer itemsPerPage,
    Integer page,
    List<DestinationType> type,
    List<String> authenticationID,
    DestinationSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/destinations")
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("type", type)
      .addQueryParameter("authenticationID", authenticationID)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListDestinationsResponse>() {});
  }

  /**
   * (asynchronously) Retrieves a list of destinations.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Destination type. (optional)
   * @param authenticationID Authentication ID used by destinations. (optional)
   * @param sort Property by which to sort the destinations. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListDestinationsResponse> getDestinationsAsync(
    Integer itemsPerPage,
    Integer page,
    List<DestinationType> type,
    List<String> authenticationID,
    DestinationSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getDestinationsAsync(itemsPerPage, page, type, authenticationID, sort, order, null);
  }

  /**
   * (asynchronously) Retrieves a list of destinations.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListDestinationsResponse> getDestinationsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getDestinationsAsync(null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves a list of destinations.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListDestinationsResponse> getDestinationsAsync() throws AlgoliaRuntimeException {
    return this.getDestinationsAsync(null, null, null, null, null, null, null);
  }

  /**
   * Retrieves a single task run event by its ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param eventID Unique identifier of an event. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Event getEvent(@Nonnull String runID, @Nonnull String eventID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getEventAsync(runID, eventID, requestOptions));
  }

  /**
   * Retrieves a single task run event by its ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param eventID Unique identifier of an event. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Event getEvent(@Nonnull String runID, @Nonnull String eventID) throws AlgoliaRuntimeException {
    return this.getEvent(runID, eventID, null);
  }

  /**
   * (asynchronously) Retrieves a single task run event by its ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param eventID Unique identifier of an event. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Event> getEventAsync(@Nonnull String runID, @Nonnull String eventID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(runID, "Parameter `runID` is required when calling `getEvent`.");

    Parameters.requireNonNull(eventID, "Parameter `eventID` is required when calling `getEvent`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/runs/{runID}/events/{eventID}", runID, eventID).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<Event>() {});
  }

  /**
   * (asynchronously) Retrieves a single task run event by its ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param eventID Unique identifier of an event. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Event> getEventAsync(@Nonnull String runID, @Nonnull String eventID) throws AlgoliaRuntimeException {
    return this.getEventAsync(runID, eventID, null);
  }

  /**
   * Retrieves a list of events for a task run, identified by it's ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param status Event status for filtering the list of task runs. (optional)
   * @param type Event type for filtering the list of task runs. (optional)
   * @param sort Property by which to sort the list of task run events. (optional)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param startDate Date and time in RFC 3339 format for the earliest events to retrieve. By
   *     default, the current time minus three hours is used. (optional)
   * @param endDate Date and time in RFC 3339 format for the latest events to retrieve. By default,
   *     the current time is used. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListEventsResponse getEvents(
    @Nonnull String runID,
    Integer itemsPerPage,
    Integer page,
    List<EventStatus> status,
    List<EventType> type,
    EventSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getEventsAsync(runID, itemsPerPage, page, status, type, sort, order, startDate, endDate, requestOptions));
  }

  /**
   * Retrieves a list of events for a task run, identified by it's ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param status Event status for filtering the list of task runs. (optional)
   * @param type Event type for filtering the list of task runs. (optional)
   * @param sort Property by which to sort the list of task run events. (optional)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param startDate Date and time in RFC 3339 format for the earliest events to retrieve. By
   *     default, the current time minus three hours is used. (optional)
   * @param endDate Date and time in RFC 3339 format for the latest events to retrieve. By default,
   *     the current time is used. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListEventsResponse getEvents(
    @Nonnull String runID,
    Integer itemsPerPage,
    Integer page,
    List<EventStatus> status,
    List<EventType> type,
    EventSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate
  ) throws AlgoliaRuntimeException {
    return this.getEvents(runID, itemsPerPage, page, status, type, sort, order, startDate, endDate, null);
  }

  /**
   * Retrieves a list of events for a task run, identified by it's ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListEventsResponse getEvents(@Nonnull String runID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getEvents(runID, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves a list of events for a task run, identified by it's ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListEventsResponse getEvents(@Nonnull String runID) throws AlgoliaRuntimeException {
    return this.getEvents(runID, null, null, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves a list of events for a task run, identified by it's ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param status Event status for filtering the list of task runs. (optional)
   * @param type Event type for filtering the list of task runs. (optional)
   * @param sort Property by which to sort the list of task run events. (optional)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param startDate Date and time in RFC 3339 format for the earliest events to retrieve. By
   *     default, the current time minus three hours is used. (optional)
   * @param endDate Date and time in RFC 3339 format for the latest events to retrieve. By default,
   *     the current time is used. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListEventsResponse> getEventsAsync(
    @Nonnull String runID,
    Integer itemsPerPage,
    Integer page,
    List<EventStatus> status,
    List<EventType> type,
    EventSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(runID, "Parameter `runID` is required when calling `getEvents`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/runs/{runID}/events", runID)
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("status", status)
      .addQueryParameter("type", type)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListEventsResponse>() {});
  }

  /**
   * (asynchronously) Retrieves a list of events for a task run, identified by it's ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param status Event status for filtering the list of task runs. (optional)
   * @param type Event type for filtering the list of task runs. (optional)
   * @param sort Property by which to sort the list of task run events. (optional)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param startDate Date and time in RFC 3339 format for the earliest events to retrieve. By
   *     default, the current time minus three hours is used. (optional)
   * @param endDate Date and time in RFC 3339 format for the latest events to retrieve. By default,
   *     the current time is used. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListEventsResponse> getEventsAsync(
    @Nonnull String runID,
    Integer itemsPerPage,
    Integer page,
    List<EventStatus> status,
    List<EventType> type,
    EventSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate
  ) throws AlgoliaRuntimeException {
    return this.getEventsAsync(runID, itemsPerPage, page, status, type, sort, order, startDate, endDate, null);
  }

  /**
   * (asynchronously) Retrieves a list of events for a task run, identified by it's ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListEventsResponse> getEventsAsync(@Nonnull String runID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getEventsAsync(runID, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves a list of events for a task run, identified by it's ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListEventsResponse> getEventsAsync(@Nonnull String runID) throws AlgoliaRuntimeException {
    return this.getEventsAsync(runID, null, null, null, null, null, null, null, null, null);
  }

  /**
   * Retrieve a single task run by its ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Run getRun(@Nonnull String runID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRunAsync(runID, requestOptions));
  }

  /**
   * Retrieve a single task run by its ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Run getRun(@Nonnull String runID) throws AlgoliaRuntimeException {
    return this.getRun(runID, null);
  }

  /**
   * (asynchronously) Retrieve a single task run by its ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Run> getRunAsync(@Nonnull String runID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(runID, "Parameter `runID` is required when calling `getRun`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/runs/{runID}", runID).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<Run>() {});
  }

  /**
   * (asynchronously) Retrieve a single task run by its ID.
   *
   * @param runID Unique identifier of a task run. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Run> getRunAsync(@Nonnull String runID) throws AlgoliaRuntimeException {
    return this.getRunAsync(runID, null);
  }

  /**
   * Retrieve a list of task runs.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param status Run status for filtering the list of task runs. (optional)
   * @param taskID Task ID for filtering the list of task runs. (optional)
   * @param sort Property by which to sort the list of task runs. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param startDate Date in RFC 3339 format for the earliest run to retrieve. By default, the
   *     current day minus seven days is used. (optional)
   * @param endDate Date in RFC 3339 format for the latest run to retrieve. By default, the current
   *     day is used. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunListResponse getRuns(
    Integer itemsPerPage,
    Integer page,
    List<RunStatus> status,
    String taskID,
    RunSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRunsAsync(itemsPerPage, page, status, taskID, sort, order, startDate, endDate, requestOptions));
  }

  /**
   * Retrieve a list of task runs.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param status Run status for filtering the list of task runs. (optional)
   * @param taskID Task ID for filtering the list of task runs. (optional)
   * @param sort Property by which to sort the list of task runs. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param startDate Date in RFC 3339 format for the earliest run to retrieve. By default, the
   *     current day minus seven days is used. (optional)
   * @param endDate Date in RFC 3339 format for the latest run to retrieve. By default, the current
   *     day is used. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunListResponse getRuns(
    Integer itemsPerPage,
    Integer page,
    List<RunStatus> status,
    String taskID,
    RunSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate
  ) throws AlgoliaRuntimeException {
    return this.getRuns(itemsPerPage, page, status, taskID, sort, order, startDate, endDate, null);
  }

  /**
   * Retrieve a list of task runs.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunListResponse getRuns(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getRuns(null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieve a list of task runs.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunListResponse getRuns() throws AlgoliaRuntimeException {
    return this.getRuns(null, null, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieve a list of task runs.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param status Run status for filtering the list of task runs. (optional)
   * @param taskID Task ID for filtering the list of task runs. (optional)
   * @param sort Property by which to sort the list of task runs. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param startDate Date in RFC 3339 format for the earliest run to retrieve. By default, the
   *     current day minus seven days is used. (optional)
   * @param endDate Date in RFC 3339 format for the latest run to retrieve. By default, the current
   *     day is used. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunListResponse> getRunsAsync(
    Integer itemsPerPage,
    Integer page,
    List<RunStatus> status,
    String taskID,
    RunSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/runs")
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("status", status)
      .addQueryParameter("taskID", taskID)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<RunListResponse>() {});
  }

  /**
   * (asynchronously) Retrieve a list of task runs.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param status Run status for filtering the list of task runs. (optional)
   * @param taskID Task ID for filtering the list of task runs. (optional)
   * @param sort Property by which to sort the list of task runs. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param startDate Date in RFC 3339 format for the earliest run to retrieve. By default, the
   *     current day minus seven days is used. (optional)
   * @param endDate Date in RFC 3339 format for the latest run to retrieve. By default, the current
   *     day is used. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunListResponse> getRunsAsync(
    Integer itemsPerPage,
    Integer page,
    List<RunStatus> status,
    String taskID,
    RunSortKeys sort,
    OrderKeys order,
    String startDate,
    String endDate
  ) throws AlgoliaRuntimeException {
    return this.getRunsAsync(itemsPerPage, page, status, taskID, sort, order, startDate, endDate, null);
  }

  /**
   * (asynchronously) Retrieve a list of task runs.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunListResponse> getRunsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getRunsAsync(null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieve a list of task runs.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunListResponse> getRunsAsync() throws AlgoliaRuntimeException {
    return this.getRunsAsync(null, null, null, null, null, null, null, null, null);
  }

  /**
   * Retrieve a source by its ID.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Source getSource(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSourceAsync(sourceID, requestOptions));
  }

  /**
   * Retrieve a source by its ID.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Source getSource(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.getSource(sourceID, null);
  }

  /**
   * (asynchronously) Retrieve a source by its ID.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Source> getSourceAsync(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `getSource`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}", sourceID).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<Source>() {});
  }

  /**
   * (asynchronously) Retrieve a source by its ID.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Source> getSourceAsync(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.getSourceAsync(sourceID, null);
  }

  /**
   * Retrieves a list of sources.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Source type. Some sources require authentication. (optional)
   * @param authenticationID Authentication IDs of the sources to retrieve. 'none' returns sources
   *     that doesn't have an authentication resource. (optional)
   * @param sort Property by which to sort the list of sources. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListSourcesResponse getSources(
    Integer itemsPerPage,
    Integer page,
    List<SourceType> type,
    List<String> authenticationID,
    SourceSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getSourcesAsync(itemsPerPage, page, type, authenticationID, sort, order, requestOptions));
  }

  /**
   * Retrieves a list of sources.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Source type. Some sources require authentication. (optional)
   * @param authenticationID Authentication IDs of the sources to retrieve. 'none' returns sources
   *     that doesn't have an authentication resource. (optional)
   * @param sort Property by which to sort the list of sources. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListSourcesResponse getSources(
    Integer itemsPerPage,
    Integer page,
    List<SourceType> type,
    List<String> authenticationID,
    SourceSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getSources(itemsPerPage, page, type, authenticationID, sort, order, null);
  }

  /**
   * Retrieves a list of sources.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListSourcesResponse getSources(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getSources(null, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves a list of sources.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListSourcesResponse getSources() throws AlgoliaRuntimeException {
    return this.getSources(null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves a list of sources.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Source type. Some sources require authentication. (optional)
   * @param authenticationID Authentication IDs of the sources to retrieve. 'none' returns sources
   *     that doesn't have an authentication resource. (optional)
   * @param sort Property by which to sort the list of sources. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListSourcesResponse> getSourcesAsync(
    Integer itemsPerPage,
    Integer page,
    List<SourceType> type,
    List<String> authenticationID,
    SourceSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/sources")
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("type", type)
      .addQueryParameter("authenticationID", authenticationID)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListSourcesResponse>() {});
  }

  /**
   * (asynchronously) Retrieves a list of sources.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param type Source type. Some sources require authentication. (optional)
   * @param authenticationID Authentication IDs of the sources to retrieve. 'none' returns sources
   *     that doesn't have an authentication resource. (optional)
   * @param sort Property by which to sort the list of sources. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListSourcesResponse> getSourcesAsync(
    Integer itemsPerPage,
    Integer page,
    List<SourceType> type,
    List<String> authenticationID,
    SourceSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getSourcesAsync(itemsPerPage, page, type, authenticationID, sort, order, null);
  }

  /**
   * (asynchronously) Retrieves a list of sources.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListSourcesResponse> getSourcesAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getSourcesAsync(null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves a list of sources.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListSourcesResponse> getSourcesAsync() throws AlgoliaRuntimeException {
    return this.getSourcesAsync(null, null, null, null, null, null, null);
  }

  /**
   * Retrieves a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Task getTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTaskAsync(taskID, requestOptions));
  }

  /**
   * Retrieves a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Task getTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.getTask(taskID, null);
  }

  /**
   * (asynchronously) Retrieves a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Task> getTaskAsync(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `getTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}", taskID).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<Task>() {});
  }

  /**
   * (asynchronously) Retrieves a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Task> getTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.getTaskAsync(taskID, null);
  }

  /**
   * Retrieves a list of tasks.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param action Actions for filtering the list of tasks. (optional)
   * @param enabled Whether to filter the list of tasks by the `enabled` status. (optional)
   * @param sourceID Source IDs for filtering the list of tasks. (optional)
   * @param destinationID Destination IDs for filtering the list of tasks. (optional)
   * @param triggerType Type of task trigger for filtering the list of tasks. (optional)
   * @param sort Property by which to sort the list of tasks. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTasksResponse getTasks(
    Integer itemsPerPage,
    Integer page,
    List<ActionType> action,
    Boolean enabled,
    List<String> sourceID,
    List<String> destinationID,
    List<TriggerType> triggerType,
    TaskSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(
      getTasksAsync(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, requestOptions)
    );
  }

  /**
   * Retrieves a list of tasks.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param action Actions for filtering the list of tasks. (optional)
   * @param enabled Whether to filter the list of tasks by the `enabled` status. (optional)
   * @param sourceID Source IDs for filtering the list of tasks. (optional)
   * @param destinationID Destination IDs for filtering the list of tasks. (optional)
   * @param triggerType Type of task trigger for filtering the list of tasks. (optional)
   * @param sort Property by which to sort the list of tasks. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTasksResponse getTasks(
    Integer itemsPerPage,
    Integer page,
    List<ActionType> action,
    Boolean enabled,
    List<String> sourceID,
    List<String> destinationID,
    List<TriggerType> triggerType,
    TaskSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getTasks(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, null);
  }

  /**
   * Retrieves a list of tasks.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTasksResponse getTasks(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getTasks(null, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * Retrieves a list of tasks.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTasksResponse getTasks() throws AlgoliaRuntimeException {
    return this.getTasks(null, null, null, null, null, null, null, null, null, null);
  }

  /**
   * (asynchronously) Retrieves a list of tasks.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param action Actions for filtering the list of tasks. (optional)
   * @param enabled Whether to filter the list of tasks by the `enabled` status. (optional)
   * @param sourceID Source IDs for filtering the list of tasks. (optional)
   * @param destinationID Destination IDs for filtering the list of tasks. (optional)
   * @param triggerType Type of task trigger for filtering the list of tasks. (optional)
   * @param sort Property by which to sort the list of tasks. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTasksResponse> getTasksAsync(
    Integer itemsPerPage,
    Integer page,
    List<ActionType> action,
    Boolean enabled,
    List<String> sourceID,
    List<String> destinationID,
    List<TriggerType> triggerType,
    TaskSortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/tasks")
      .setMethod("GET")
      .addQueryParameter("itemsPerPage", itemsPerPage)
      .addQueryParameter("page", page)
      .addQueryParameter("action", action)
      .addQueryParameter("enabled", enabled)
      .addQueryParameter("sourceID", sourceID)
      .addQueryParameter("destinationID", destinationID)
      .addQueryParameter("triggerType", triggerType)
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListTasksResponse>() {});
  }

  /**
   * (asynchronously) Retrieves a list of tasks.
   *
   * @param itemsPerPage Number of items per page. (optional, default to 10)
   * @param page Page number of the paginated API response. (optional)
   * @param action Actions for filtering the list of tasks. (optional)
   * @param enabled Whether to filter the list of tasks by the `enabled` status. (optional)
   * @param sourceID Source IDs for filtering the list of tasks. (optional)
   * @param destinationID Destination IDs for filtering the list of tasks. (optional)
   * @param triggerType Type of task trigger for filtering the list of tasks. (optional)
   * @param sort Property by which to sort the list of tasks. (optional, default to createdAt)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTasksResponse> getTasksAsync(
    Integer itemsPerPage,
    Integer page,
    List<ActionType> action,
    Boolean enabled,
    List<String> sourceID,
    List<String> destinationID,
    List<TriggerType> triggerType,
    TaskSortKeys sort,
    OrderKeys order
  ) throws AlgoliaRuntimeException {
    return this.getTasksAsync(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, null);
  }

  /**
   * (asynchronously) Retrieves a list of tasks.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTasksResponse> getTasksAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getTasksAsync(null, null, null, null, null, null, null, null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves a list of tasks.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTasksResponse> getTasksAsync() throws AlgoliaRuntimeException {
    return this.getTasksAsync(null, null, null, null, null, null, null, null, null, null);
  }

  /**
   * Retrieves a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Transformation getTransformation(@Nonnull String transformationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTransformationAsync(transformationID, requestOptions));
  }

  /**
   * Retrieves a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Transformation getTransformation(@Nonnull String transformationID) throws AlgoliaRuntimeException {
    return this.getTransformation(transformationID, null);
  }

  /**
   * (asynchronously) Retrieves a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Transformation> getTransformationAsync(@Nonnull String transformationID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(transformationID, "Parameter `transformationID` is required when calling `getTransformation`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/transformations/{transformationID}", transformationID).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<Transformation>() {});
  }

  /**
   * (asynchronously) Retrieves a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Transformation> getTransformationAsync(@Nonnull String transformationID) throws AlgoliaRuntimeException {
    return this.getTransformationAsync(transformationID, null);
  }

  /**
   * Retrieves a list of transformations.
   *
   * @param sort Property by which to sort the list. (optional, default to desc)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTransformationsResponse getTransformations(SortKeys sort, OrderKeys order, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getTransformationsAsync(sort, order, requestOptions));
  }

  /**
   * Retrieves a list of transformations.
   *
   * @param sort Property by which to sort the list. (optional, default to desc)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTransformationsResponse getTransformations(SortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
    return this.getTransformations(sort, order, null);
  }

  /**
   * Retrieves a list of transformations.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTransformationsResponse getTransformations(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getTransformations(null, null, requestOptions);
  }

  /**
   * Retrieves a list of transformations.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public ListTransformationsResponse getTransformations() throws AlgoliaRuntimeException {
    return this.getTransformations(null, null, null);
  }

  /**
   * (asynchronously) Retrieves a list of transformations.
   *
   * @param sort Property by which to sort the list. (optional, default to desc)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTransformationsResponse> getTransformationsAsync(
    SortKeys sort,
    OrderKeys order,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/transformations")
      .setMethod("GET")
      .addQueryParameter("sort", sort)
      .addQueryParameter("order", order)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<ListTransformationsResponse>() {});
  }

  /**
   * (asynchronously) Retrieves a list of transformations.
   *
   * @param sort Property by which to sort the list. (optional, default to desc)
   * @param order Sort order of the response, ascending or descending. (optional, default to desc)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTransformationsResponse> getTransformationsAsync(SortKeys sort, OrderKeys order)
    throws AlgoliaRuntimeException {
    return this.getTransformationsAsync(sort, order, null);
  }

  /**
   * (asynchronously) Retrieves a list of transformations.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTransformationsResponse> getTransformationsAsync(RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return this.getTransformationsAsync(null, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves a list of transformations.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<ListTransformationsResponse> getTransformationsAsync() throws AlgoliaRuntimeException {
    return this.getTransformationsAsync(null, null, null);
  }

  /**
   * Runs a task. You can check the status of task runs with the observability endpoints.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunResponse runTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(runTaskAsync(taskID, requestOptions));
  }

  /**
   * Runs a task. You can check the status of task runs with the observability endpoints.
   *
   * @param taskID Unique identifier of a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RunResponse runTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.runTask(taskID, null);
  }

  /**
   * (asynchronously) Runs a task. You can check the status of task runs with the observability
   * endpoints.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunResponse> runTaskAsync(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `runTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}/run", taskID).setMethod("POST").build();

    return executeAsync(request, requestOptions, new TypeReference<RunResponse>() {});
  }

  /**
   * (asynchronously) Runs a task. You can check the status of task runs with the observability
   * endpoints.
   *
   * @param taskID Unique identifier of a task. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RunResponse> runTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
    return this.runTaskAsync(taskID, null);
  }

  /**
   * Searches for authentication resources.
   *
   * @param authenticationSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Authentication> searchAuthentications(@Nonnull AuthenticationSearch authenticationSearch, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchAuthenticationsAsync(authenticationSearch, requestOptions));
  }

  /**
   * Searches for authentication resources.
   *
   * @param authenticationSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Authentication> searchAuthentications(@Nonnull AuthenticationSearch authenticationSearch) throws AlgoliaRuntimeException {
    return this.searchAuthentications(authenticationSearch, null);
  }

  /**
   * (asynchronously) Searches for authentication resources.
   *
   * @param authenticationSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Authentication>> searchAuthenticationsAsync(
    @Nonnull AuthenticationSearch authenticationSearch,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(authenticationSearch, "Parameter `authenticationSearch` is required when calling `searchAuthentications`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/authentications/search")
      .setMethod("POST")
      .setBody(authenticationSearch)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<List<Authentication>>() {});
  }

  /**
   * (asynchronously) Searches for authentication resources.
   *
   * @param authenticationSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Authentication>> searchAuthenticationsAsync(@Nonnull AuthenticationSearch authenticationSearch)
    throws AlgoliaRuntimeException {
    return this.searchAuthenticationsAsync(authenticationSearch, null);
  }

  /**
   * Searches for destinations.
   *
   * @param destinationSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Destination> searchDestinations(@Nonnull DestinationSearch destinationSearch, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchDestinationsAsync(destinationSearch, requestOptions));
  }

  /**
   * Searches for destinations.
   *
   * @param destinationSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Destination> searchDestinations(@Nonnull DestinationSearch destinationSearch) throws AlgoliaRuntimeException {
    return this.searchDestinations(destinationSearch, null);
  }

  /**
   * (asynchronously) Searches for destinations.
   *
   * @param destinationSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Destination>> searchDestinationsAsync(
    @Nonnull DestinationSearch destinationSearch,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(destinationSearch, "Parameter `destinationSearch` is required when calling `searchDestinations`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/destinations/search").setMethod("POST").setBody(destinationSearch).build();
    return executeAsync(request, requestOptions, new TypeReference<List<Destination>>() {});
  }

  /**
   * (asynchronously) Searches for destinations.
   *
   * @param destinationSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Destination>> searchDestinationsAsync(@Nonnull DestinationSearch destinationSearch)
    throws AlgoliaRuntimeException {
    return this.searchDestinationsAsync(destinationSearch, null);
  }

  /**
   * Searches for sources.
   *
   * @param sourceSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Source> searchSources(@Nonnull SourceSearch sourceSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchSourcesAsync(sourceSearch, requestOptions));
  }

  /**
   * Searches for sources.
   *
   * @param sourceSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Source> searchSources(@Nonnull SourceSearch sourceSearch) throws AlgoliaRuntimeException {
    return this.searchSources(sourceSearch, null);
  }

  /**
   * (asynchronously) Searches for sources.
   *
   * @param sourceSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Source>> searchSourcesAsync(@Nonnull SourceSearch sourceSearch, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceSearch, "Parameter `sourceSearch` is required when calling `searchSources`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources/search").setMethod("POST").setBody(sourceSearch).build();
    return executeAsync(request, requestOptions, new TypeReference<List<Source>>() {});
  }

  /**
   * (asynchronously) Searches for sources.
   *
   * @param sourceSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Source>> searchSourcesAsync(@Nonnull SourceSearch sourceSearch) throws AlgoliaRuntimeException {
    return this.searchSourcesAsync(sourceSearch, null);
  }

  /**
   * Searches for tasks.
   *
   * @param taskSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Task> searchTasks(@Nonnull TaskSearch taskSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchTasksAsync(taskSearch, requestOptions));
  }

  /**
   * Searches for tasks.
   *
   * @param taskSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Task> searchTasks(@Nonnull TaskSearch taskSearch) throws AlgoliaRuntimeException {
    return this.searchTasks(taskSearch, null);
  }

  /**
   * (asynchronously) Searches for tasks.
   *
   * @param taskSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Task>> searchTasksAsync(@Nonnull TaskSearch taskSearch, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskSearch, "Parameter `taskSearch` is required when calling `searchTasks`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/search").setMethod("POST").setBody(taskSearch).build();
    return executeAsync(request, requestOptions, new TypeReference<List<Task>>() {});
  }

  /**
   * (asynchronously) Searches for tasks.
   *
   * @param taskSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Task>> searchTasksAsync(@Nonnull TaskSearch taskSearch) throws AlgoliaRuntimeException {
    return this.searchTasksAsync(taskSearch, null);
  }

  /**
   * Searches for transformations.
   *
   * @param transformationSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Transformation> searchTransformations(@Nonnull TransformationSearch transformationSearch, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchTransformationsAsync(transformationSearch, requestOptions));
  }

  /**
   * Searches for transformations.
   *
   * @param transformationSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<Transformation> searchTransformations(@Nonnull TransformationSearch transformationSearch) throws AlgoliaRuntimeException {
    return this.searchTransformations(transformationSearch, null);
  }

  /**
   * (asynchronously) Searches for transformations.
   *
   * @param transformationSearch (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Transformation>> searchTransformationsAsync(
    @Nonnull TransformationSearch transformationSearch,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(transformationSearch, "Parameter `transformationSearch` is required when calling `searchTransformations`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/transformations/search")
      .setMethod("POST")
      .setBody(transformationSearch)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<List<Transformation>>() {});
  }

  /**
   * (asynchronously) Searches for transformations.
   *
   * @param transformationSearch (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<Transformation>> searchTransformationsAsync(@Nonnull TransformationSearch transformationSearch)
    throws AlgoliaRuntimeException {
    return this.searchTransformationsAsync(transformationSearch, null);
  }

  /**
   * Triggers a stream-listing request for a source. Triggering stream-listing requests only works
   * with sources with `type: docker` and `imageType: singer`.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceWatchResponse triggerDockerSourceDiscover(@Nonnull String sourceID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(triggerDockerSourceDiscoverAsync(sourceID, requestOptions));
  }

  /**
   * Triggers a stream-listing request for a source. Triggering stream-listing requests only works
   * with sources with `type: docker` and `imageType: singer`.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceWatchResponse triggerDockerSourceDiscover(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.triggerDockerSourceDiscover(sourceID, null);
  }

  /**
   * (asynchronously) Triggers a stream-listing request for a source. Triggering stream-listing
   * requests only works with sources with `type: docker` and `imageType: singer`.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceWatchResponse> triggerDockerSourceDiscoverAsync(@Nonnull String sourceID, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `triggerDockerSourceDiscover`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}/discover", sourceID).setMethod("POST").build();
    return executeAsync(request, requestOptions, new TypeReference<SourceWatchResponse>() {});
  }

  /**
   * (asynchronously) Triggers a stream-listing request for a source. Triggering stream-listing
   * requests only works with sources with `type: docker` and `imageType: singer`.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceWatchResponse> triggerDockerSourceDiscoverAsync(@Nonnull String sourceID) throws AlgoliaRuntimeException {
    return this.triggerDockerSourceDiscoverAsync(sourceID, null);
  }

  /**
   * Try a transformation.
   *
   * @param transformationTry (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TransformationTryResponse tryTransformations(@Nonnull TransformationTry transformationTry, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(tryTransformationsAsync(transformationTry, requestOptions));
  }

  /**
   * Try a transformation.
   *
   * @param transformationTry (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TransformationTryResponse tryTransformations(@Nonnull TransformationTry transformationTry) throws AlgoliaRuntimeException {
    return this.tryTransformations(transformationTry, null);
  }

  /**
   * (asynchronously) Try a transformation.
   *
   * @param transformationTry (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TransformationTryResponse> tryTransformationsAsync(
    @Nonnull TransformationTry transformationTry,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(transformationTry, "Parameter `transformationTry` is required when calling `tryTransformations`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/transformations/try").setMethod("POST").setBody(transformationTry).build();
    return executeAsync(request, requestOptions, new TypeReference<TransformationTryResponse>() {});
  }

  /**
   * (asynchronously) Try a transformation.
   *
   * @param transformationTry (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TransformationTryResponse> tryTransformationsAsync(@Nonnull TransformationTry transformationTry)
    throws AlgoliaRuntimeException {
    return this.tryTransformationsAsync(transformationTry, null);
  }

  /**
   * Updates an authentication resource.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @param authenticationUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AuthenticationUpdateResponse updateAuthentication(
    @Nonnull String authenticationID,
    @Nonnull AuthenticationUpdate authenticationUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateAuthenticationAsync(authenticationID, authenticationUpdate, requestOptions));
  }

  /**
   * Updates an authentication resource.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @param authenticationUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public AuthenticationUpdateResponse updateAuthentication(
    @Nonnull String authenticationID,
    @Nonnull AuthenticationUpdate authenticationUpdate
  ) throws AlgoliaRuntimeException {
    return this.updateAuthentication(authenticationID, authenticationUpdate, null);
  }

  /**
   * (asynchronously) Updates an authentication resource.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @param authenticationUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AuthenticationUpdateResponse> updateAuthenticationAsync(
    @Nonnull String authenticationID,
    @Nonnull AuthenticationUpdate authenticationUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(authenticationID, "Parameter `authenticationID` is required when calling `updateAuthentication`.");

    Parameters.requireNonNull(authenticationUpdate, "Parameter `authenticationUpdate` is required when calling `updateAuthentication`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/authentications/{authenticationID}", authenticationID)
      .setMethod("PATCH")
      .setBody(authenticationUpdate)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<AuthenticationUpdateResponse>() {});
  }

  /**
   * (asynchronously) Updates an authentication resource.
   *
   * @param authenticationID Unique identifier of an authentication resource. (required)
   * @param authenticationUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<AuthenticationUpdateResponse> updateAuthenticationAsync(
    @Nonnull String authenticationID,
    @Nonnull AuthenticationUpdate authenticationUpdate
  ) throws AlgoliaRuntimeException {
    return this.updateAuthenticationAsync(authenticationID, authenticationUpdate, null);
  }

  /**
   * Updates the destination by its ID.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @param destinationUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DestinationUpdateResponse updateDestination(
    @Nonnull String destinationID,
    @Nonnull DestinationUpdate destinationUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateDestinationAsync(destinationID, destinationUpdate, requestOptions));
  }

  /**
   * Updates the destination by its ID.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @param destinationUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DestinationUpdateResponse updateDestination(@Nonnull String destinationID, @Nonnull DestinationUpdate destinationUpdate)
    throws AlgoliaRuntimeException {
    return this.updateDestination(destinationID, destinationUpdate, null);
  }

  /**
   * (asynchronously) Updates the destination by its ID.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @param destinationUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DestinationUpdateResponse> updateDestinationAsync(
    @Nonnull String destinationID,
    @Nonnull DestinationUpdate destinationUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(destinationID, "Parameter `destinationID` is required when calling `updateDestination`.");

    Parameters.requireNonNull(destinationUpdate, "Parameter `destinationUpdate` is required when calling `updateDestination`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/destinations/{destinationID}", destinationID)
      .setMethod("PATCH")
      .setBody(destinationUpdate)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<DestinationUpdateResponse>() {});
  }

  /**
   * (asynchronously) Updates the destination by its ID.
   *
   * @param destinationID Unique identifier of a destination. (required)
   * @param destinationUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DestinationUpdateResponse> updateDestinationAsync(
    @Nonnull String destinationID,
    @Nonnull DestinationUpdate destinationUpdate
  ) throws AlgoliaRuntimeException {
    return this.updateDestinationAsync(destinationID, destinationUpdate, null);
  }

  /**
   * Updates a source by its ID.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param sourceUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceUpdateResponse updateSource(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateSourceAsync(sourceID, sourceUpdate, requestOptions));
  }

  /**
   * Updates a source by its ID.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param sourceUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceUpdateResponse updateSource(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate) throws AlgoliaRuntimeException {
    return this.updateSource(sourceID, sourceUpdate, null);
  }

  /**
   * (asynchronously) Updates a source by its ID.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param sourceUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceUpdateResponse> updateSourceAsync(
    @Nonnull String sourceID,
    @Nonnull SourceUpdate sourceUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `updateSource`.");

    Parameters.requireNonNull(sourceUpdate, "Parameter `sourceUpdate` is required when calling `updateSource`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}", sourceID).setMethod("PATCH").setBody(sourceUpdate).build();
    return executeAsync(request, requestOptions, new TypeReference<SourceUpdateResponse>() {});
  }

  /**
   * (asynchronously) Updates a source by its ID.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param sourceUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceUpdateResponse> updateSourceAsync(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate)
    throws AlgoliaRuntimeException {
    return this.updateSourceAsync(sourceID, sourceUpdate, null);
  }

  /**
   * Updates a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param taskUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse updateTask(@Nonnull String taskID, @Nonnull TaskUpdate taskUpdate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateTaskAsync(taskID, taskUpdate, requestOptions));
  }

  /**
   * Updates a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param taskUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TaskUpdateResponse updateTask(@Nonnull String taskID, @Nonnull TaskUpdate taskUpdate) throws AlgoliaRuntimeException {
    return this.updateTask(taskID, taskUpdate, null);
  }

  /**
   * (asynchronously) Updates a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param taskUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> updateTaskAsync(
    @Nonnull String taskID,
    @Nonnull TaskUpdate taskUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `updateTask`.");

    Parameters.requireNonNull(taskUpdate, "Parameter `taskUpdate` is required when calling `updateTask`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}", taskID).setMethod("PATCH").setBody(taskUpdate).build();
    return executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>() {});
  }

  /**
   * (asynchronously) Updates a task by its ID.
   *
   * @param taskID Unique identifier of a task. (required)
   * @param taskUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TaskUpdateResponse> updateTaskAsync(@Nonnull String taskID, @Nonnull TaskUpdate taskUpdate)
    throws AlgoliaRuntimeException {
    return this.updateTaskAsync(taskID, taskUpdate, null);
  }

  /**
   * Updates a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @param transformationCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TransformationUpdateResponse updateTransformation(
    @Nonnull String transformationID,
    @Nonnull TransformationCreate transformationCreate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateTransformationAsync(transformationID, transformationCreate, requestOptions));
  }

  /**
   * Updates a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @param transformationCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public TransformationUpdateResponse updateTransformation(
    @Nonnull String transformationID,
    @Nonnull TransformationCreate transformationCreate
  ) throws AlgoliaRuntimeException {
    return this.updateTransformation(transformationID, transformationCreate, null);
  }

  /**
   * (asynchronously) Updates a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @param transformationCreate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TransformationUpdateResponse> updateTransformationAsync(
    @Nonnull String transformationID,
    @Nonnull TransformationCreate transformationCreate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(transformationID, "Parameter `transformationID` is required when calling `updateTransformation`.");

    Parameters.requireNonNull(transformationCreate, "Parameter `transformationCreate` is required when calling `updateTransformation`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/transformations/{transformationID}", transformationID)
      .setMethod("PUT")
      .setBody(transformationCreate)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<TransformationUpdateResponse>() {});
  }

  /**
   * (asynchronously) Updates a transformation by its ID.
   *
   * @param transformationID Unique identifier of a transformation. (required)
   * @param transformationCreate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<TransformationUpdateResponse> updateTransformationAsync(
    @Nonnull String transformationID,
    @Nonnull TransformationCreate transformationCreate
  ) throws AlgoliaRuntimeException {
    return this.updateTransformationAsync(transformationID, transformationCreate, null);
  }

  /**
   * Validates a source payload to ensure it can be created and that the data source can be reached
   * by Algolia.
   *
   * @param sourceCreate (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceWatchResponse validateSource(SourceCreate sourceCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(validateSourceAsync(sourceCreate, requestOptions));
  }

  /**
   * Validates a source payload to ensure it can be created and that the data source can be reached
   * by Algolia.
   *
   * @param sourceCreate (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceWatchResponse validateSource(SourceCreate sourceCreate) throws AlgoliaRuntimeException {
    return this.validateSource(sourceCreate, null);
  }

  /**
   * Validates a source payload to ensure it can be created and that the data source can be reached
   * by Algolia.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceWatchResponse validateSource(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.validateSource(null, requestOptions);
  }

  /**
   * Validates a source payload to ensure it can be created and that the data source can be reached
   * by Algolia.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceWatchResponse validateSource() throws AlgoliaRuntimeException {
    return this.validateSource(null, null);
  }

  /**
   * (asynchronously) Validates a source payload to ensure it can be created and that the data
   * source can be reached by Algolia.
   *
   * @param sourceCreate (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceWatchResponse> validateSourceAsync(SourceCreate sourceCreate, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/sources/validate").setMethod("POST").setBody(sourceCreate).build();
    return executeAsync(request, requestOptions, new TypeReference<SourceWatchResponse>() {});
  }

  /**
   * (asynchronously) Validates a source payload to ensure it can be created and that the data
   * source can be reached by Algolia.
   *
   * @param sourceCreate (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceWatchResponse> validateSourceAsync(SourceCreate sourceCreate) throws AlgoliaRuntimeException {
    return this.validateSourceAsync(sourceCreate, null);
  }

  /**
   * (asynchronously) Validates a source payload to ensure it can be created and that the data
   * source can be reached by Algolia.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceWatchResponse> validateSourceAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.validateSourceAsync(null, requestOptions);
  }

  /**
   * (asynchronously) Validates a source payload to ensure it can be created and that the data
   * source can be reached by Algolia.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceWatchResponse> validateSourceAsync() throws AlgoliaRuntimeException {
    return this.validateSourceAsync(null, null);
  }

  /**
   * Validates an update of a source payload to ensure it can be created and that the data source
   * can be reached by Algolia.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param sourceUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceWatchResponse validateSourceBeforeUpdate(
    @Nonnull String sourceID,
    @Nonnull SourceUpdate sourceUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(validateSourceBeforeUpdateAsync(sourceID, sourceUpdate, requestOptions));
  }

  /**
   * Validates an update of a source payload to ensure it can be created and that the data source
   * can be reached by Algolia.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param sourceUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SourceWatchResponse validateSourceBeforeUpdate(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate)
    throws AlgoliaRuntimeException {
    return this.validateSourceBeforeUpdate(sourceID, sourceUpdate, null);
  }

  /**
   * (asynchronously) Validates an update of a source payload to ensure it can be created and that
   * the data source can be reached by Algolia.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param sourceUpdate (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceWatchResponse> validateSourceBeforeUpdateAsync(
    @Nonnull String sourceID,
    @Nonnull SourceUpdate sourceUpdate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `validateSourceBeforeUpdate`.");

    Parameters.requireNonNull(sourceUpdate, "Parameter `sourceUpdate` is required when calling `validateSourceBeforeUpdate`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/sources/{sourceID}/validate", sourceID)
      .setMethod("POST")
      .setBody(sourceUpdate)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<SourceWatchResponse>() {});
  }

  /**
   * (asynchronously) Validates an update of a source payload to ensure it can be created and that
   * the data source can be reached by Algolia.
   *
   * @param sourceID Unique identifier of a source. (required)
   * @param sourceUpdate (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SourceWatchResponse> validateSourceBeforeUpdateAsync(
    @Nonnull String sourceID,
    @Nonnull SourceUpdate sourceUpdate
  ) throws AlgoliaRuntimeException {
    return this.validateSourceBeforeUpdateAsync(sourceID, sourceUpdate, null);
  }
}
