// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.querysuggestions;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** API response for retrieving Query Suggestions configurations. */
public class ConfigurationResponse {

  @JsonProperty("appID")
  private String appID;

  @JsonProperty("indexName")
  private String indexName;

  @JsonProperty("sourceIndices")
  private List<SourceIndex> sourceIndices = new ArrayList<>();

  @JsonProperty("languages")
  private Languages languages;

  @JsonProperty("exclude")
  private List<String> exclude;

  @JsonProperty("enablePersonalization")
  private Boolean enablePersonalization;

  @JsonProperty("allowSpecialCharacters")
  private Boolean allowSpecialCharacters;

  public ConfigurationResponse setAppID(String appID) {
    this.appID = appID;
    return this;
  }

  /** Algolia application ID to which this Query Suggestions configuration belongs. */
  @javax.annotation.Nonnull
  public String getAppID() {
    return appID;
  }

  public ConfigurationResponse setIndexName(String indexName) {
    this.indexName = indexName;
    return this;
  }

  /** Name of the Query Suggestions index (case-sensitive). */
  @javax.annotation.Nonnull
  public String getIndexName() {
    return indexName;
  }

  public ConfigurationResponse setSourceIndices(List<SourceIndex> sourceIndices) {
    this.sourceIndices = sourceIndices;
    return this;
  }

  public ConfigurationResponse addSourceIndices(SourceIndex sourceIndicesItem) {
    this.sourceIndices.add(sourceIndicesItem);
    return this;
  }

  /** Algolia indices from which to get the popular searches for query suggestions. */
  @javax.annotation.Nonnull
  public List<SourceIndex> getSourceIndices() {
    return sourceIndices;
  }

  public ConfigurationResponse setLanguages(Languages languages) {
    this.languages = languages;
    return this;
  }

  /** Get languages */
  @javax.annotation.Nonnull
  public Languages getLanguages() {
    return languages;
  }

  public ConfigurationResponse setExclude(List<String> exclude) {
    this.exclude = exclude;
    return this;
  }

  public ConfigurationResponse addExclude(String excludeItem) {
    this.exclude.add(excludeItem);
    return this;
  }

  /** Get exclude */
  @javax.annotation.Nullable
  public List<String> getExclude() {
    return exclude;
  }

  public ConfigurationResponse setEnablePersonalization(Boolean enablePersonalization) {
    this.enablePersonalization = enablePersonalization;
    return this;
  }

  /** Whether to turn on personalized query suggestions. */
  @javax.annotation.Nonnull
  public Boolean getEnablePersonalization() {
    return enablePersonalization;
  }

  public ConfigurationResponse setAllowSpecialCharacters(Boolean allowSpecialCharacters) {
    this.allowSpecialCharacters = allowSpecialCharacters;
    return this;
  }

  /** Whether to include suggestions with special characters. */
  @javax.annotation.Nonnull
  public Boolean getAllowSpecialCharacters() {
    return allowSpecialCharacters;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConfigurationResponse configurationResponse = (ConfigurationResponse) o;
    return (
      Objects.equals(this.appID, configurationResponse.appID) &&
      Objects.equals(this.indexName, configurationResponse.indexName) &&
      Objects.equals(this.sourceIndices, configurationResponse.sourceIndices) &&
      Objects.equals(this.languages, configurationResponse.languages) &&
      Objects.equals(this.exclude, configurationResponse.exclude) &&
      Objects.equals(this.enablePersonalization, configurationResponse.enablePersonalization) &&
      Objects.equals(this.allowSpecialCharacters, configurationResponse.allowSpecialCharacters)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(appID, indexName, sourceIndices, languages, exclude, enablePersonalization, allowSpecialCharacters);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConfigurationResponse {\n");
    sb.append("    appID: ").append(toIndentedString(appID)).append("\n");
    sb.append("    indexName: ").append(toIndentedString(indexName)).append("\n");
    sb.append("    sourceIndices: ").append(toIndentedString(sourceIndices)).append("\n");
    sb.append("    languages: ").append(toIndentedString(languages)).append("\n");
    sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
    sb.append("    enablePersonalization: ").append(toIndentedString(enablePersonalization)).append("\n");
    sb.append("    allowSpecialCharacters: ").append(toIndentedString(allowSpecialCharacters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
