// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/**
 * Filter the search by facet values, so that only records with the same facet values are retrieved.
 * **Prefer using the `filters` parameter, which supports all filter types and combinations with
 * boolean operators.** - `[filter1, filter2]` is interpreted as `filter1 AND filter2`. -
 * `[[filter1, filter2], filter3]` is interpreted as `filter1 OR filter2 AND filter3`. -
 * `facet:-value` is interpreted as `NOT facet:value`. While it's best to avoid attributes that
 * start with a `-`, you can still filter them by escaping with a backslash: `facet:\\-value`.
 */
@JsonDeserialize(using = FacetFilters.Deserializer.class)
public interface FacetFilters {
  // FacetFilters as List<FacetFilters> wrapper.
  static FacetFilters of(List<FacetFilters> value) {
    return new ListOfFacetFiltersWrapper(value);
  }

  // FacetFilters as String wrapper.
  static FacetFilters of(String value) {
    return new StringWrapper(value);
  }

  // FacetFilters as List<FacetFilters> wrapper.
  @JsonSerialize(using = ListOfFacetFiltersWrapper.Serializer.class)
  class ListOfFacetFiltersWrapper implements FacetFilters {

    private final List<FacetFilters> value;

    ListOfFacetFiltersWrapper(List<FacetFilters> value) {
      this.value = value;
    }

    public List<FacetFilters> getValue() {
      return value;
    }

    static class Serializer extends JsonSerializer<ListOfFacetFiltersWrapper> {

      @Override
      public void serialize(ListOfFacetFiltersWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeObject(value.getValue());
      }
    }
  }

  // FacetFilters as String wrapper.
  @JsonSerialize(using = StringWrapper.Serializer.class)
  class StringWrapper implements FacetFilters {

    private final String value;

    StringWrapper(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    static class Serializer extends JsonSerializer<StringWrapper> {

      @Override
      public void serialize(StringWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeObject(value.getValue());
      }
    }
  }

  class Deserializer extends JsonDeserializer<FacetFilters> {

    private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

    @Override
    public FacetFilters deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();
      // deserialize List<FacetFilters>
      if (tree.isArray()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          List<FacetFilters> value = parser.readValueAs(new TypeReference<List<FacetFilters>>() {});
          return new FacetFilters.ListOfFacetFiltersWrapper(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf List<FacetFilters> (error: " + e.getMessage() + ") (type: List<FacetFilters>)");
        }
      }
      // deserialize String
      if (tree.isTextual()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          String value = parser.readValueAs(String.class);
          return new FacetFilters.StringWrapper(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf String (error: " + e.getMessage() + ") (type: String)");
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public FacetFilters getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "FacetFilters cannot be null");
    }
  }
}
