/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaApiException;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.internal.JsonSerializer;
import com.algolia.model.search.Action;
import com.algolia.model.search.AddApiKeyResponse;
import com.algolia.model.search.ApiKey;
import com.algolia.model.search.ApiKeyOperation;
import com.algolia.model.search.AssignUserIdParams;
import com.algolia.model.search.AttributeToUpdate;
import com.algolia.model.search.BatchAssignUserIdsParams;
import com.algolia.model.search.BatchDictionaryEntriesParams;
import com.algolia.model.search.BatchParams;
import com.algolia.model.search.BatchRequest;
import com.algolia.model.search.BatchResponse;
import com.algolia.model.search.BatchWriteParams;
import com.algolia.model.search.BrowseParams;
import com.algolia.model.search.BrowseParamsObject;
import com.algolia.model.search.BrowseResponse;
import com.algolia.model.search.CreatedAtResponse;
import com.algolia.model.search.DeleteApiKeyResponse;
import com.algolia.model.search.DeleteByParams;
import com.algolia.model.search.DeleteSourceResponse;
import com.algolia.model.search.DeletedAtResponse;
import com.algolia.model.search.DictionarySettingsParams;
import com.algolia.model.search.DictionaryType;
import com.algolia.model.search.GetApiKeyResponse;
import com.algolia.model.search.GetDictionarySettingsResponse;
import com.algolia.model.search.GetLogsResponse;
import com.algolia.model.search.GetObjectsParams;
import com.algolia.model.search.GetObjectsResponse;
import com.algolia.model.search.GetTaskResponse;
import com.algolia.model.search.GetTopUserIdsResponse;
import com.algolia.model.search.HasPendingMappingsResponse;
import com.algolia.model.search.Hit;
import com.algolia.model.search.IndexSettings;
import com.algolia.model.search.Languages;
import com.algolia.model.search.ListApiKeysResponse;
import com.algolia.model.search.ListClustersResponse;
import com.algolia.model.search.ListIndicesResponse;
import com.algolia.model.search.ListUserIdsResponse;
import com.algolia.model.search.LogType;
import com.algolia.model.search.MultipleBatchResponse;
import com.algolia.model.search.OperationIndexParams;
import com.algolia.model.search.OperationType;
import com.algolia.model.search.RemoveUserIdResponse;
import com.algolia.model.search.ReplaceAllObjectsResponse;
import com.algolia.model.search.ReplaceSourceResponse;
import com.algolia.model.search.Rule;
import com.algolia.model.search.SaveObjectResponse;
import com.algolia.model.search.SaveSynonymResponse;
import com.algolia.model.search.ScopeType;
import com.algolia.model.search.SearchDictionaryEntriesParams;
import com.algolia.model.search.SearchDictionaryEntriesResponse;
import com.algolia.model.search.SearchForFacetValuesRequest;
import com.algolia.model.search.SearchForFacetValuesResponse;
import com.algolia.model.search.SearchForFacets;
import com.algolia.model.search.SearchForHits;
import com.algolia.model.search.SearchMethodParams;
import com.algolia.model.search.SearchParams;
import com.algolia.model.search.SearchQuery;
import com.algolia.model.search.SearchResponse;
import com.algolia.model.search.SearchResponses;
import com.algolia.model.search.SearchRulesParams;
import com.algolia.model.search.SearchRulesResponse;
import com.algolia.model.search.SearchStrategy;
import com.algolia.model.search.SearchSynonymsParams;
import com.algolia.model.search.SearchSynonymsResponse;
import com.algolia.model.search.SearchUserIdsParams;
import com.algolia.model.search.SearchUserIdsResponse;
import com.algolia.model.search.SecuredApiKeyRestrictions;
import com.algolia.model.search.Source;
import com.algolia.model.search.SynonymHit;
import com.algolia.model.search.TaskStatus;
import com.algolia.model.search.UpdateApiKeyResponse;
import com.algolia.model.search.UpdatedAtResponse;
import com.algolia.model.search.UpdatedAtWithObjectIdResponse;
import com.algolia.model.search.UpdatedRuleResponse;
import com.algolia.model.search.UserId;
import com.algolia.utils.AlgoliaIterableHelper;
import com.algolia.utils.Holder;
import com.algolia.utils.Parameters;
import com.algolia.utils.StringUtils;
import com.algolia.utils.TaskUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SearchClient
extends ApiClient {
    public SearchClient(String appId, String apiKey) {
        this(appId, apiKey, null);
    }

    public SearchClient(String appId, String apiKey, ClientOptions options) {
        super(appId, apiKey, "Search", options, SearchClient.getDefaultHosts(appId));
    }

    private static List<Host> getDefaultHosts(String appId) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        hosts.add(new Host(appId + "-dsn.algolia.net", EnumSet.of(CallType.READ)));
        hosts.add(new Host(appId + ".algolia.net", EnumSet.of(CallType.WRITE)));
        ArrayList commonHosts = new ArrayList();
        hosts.add(new Host(appId + "-1.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new Host(appId + "-2.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new Host(appId + "-3.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        Collections.shuffle(commonHosts, new Random());
        return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
    }

    public AddApiKeyResponse addApiKey(@Nonnull ApiKey apiKey, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.addApiKeyAsync(apiKey, requestOptions));
    }

    public AddApiKeyResponse addApiKey(@Nonnull ApiKey apiKey) throws AlgoliaRuntimeException {
        return this.addApiKey(apiKey, null);
    }

    public CompletableFuture<AddApiKeyResponse> addApiKeyAsync(@Nonnull ApiKey apiKey, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(apiKey, "Parameter `apiKey` is required when calling `addApiKey`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/keys").setMethod("POST").setBody(apiKey).build();
        return this.executeAsync(request, requestOptions, new TypeReference<AddApiKeyResponse>(){});
    }

    public CompletableFuture<AddApiKeyResponse> addApiKeyAsync(@Nonnull ApiKey apiKey) throws AlgoliaRuntimeException {
        return this.addApiKeyAsync(apiKey, null);
    }

    public UpdatedAtWithObjectIdResponse addOrUpdateObject(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.addOrUpdateObjectAsync(indexName, objectID, body, requestOptions));
    }

    public UpdatedAtWithObjectIdResponse addOrUpdateObject(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Object body) throws AlgoliaRuntimeException {
        return this.addOrUpdateObject(indexName, objectID, body, null);
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> addOrUpdateObjectAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `addOrUpdateObject`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `addOrUpdateObject`.");
        Parameters.requireNonNull(body, "Parameter `body` is required when calling `addOrUpdateObject`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{objectID}", indexName, objectID).setMethod("PUT").setBody(body).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtWithObjectIdResponse>(){});
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> addOrUpdateObjectAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Object body) throws AlgoliaRuntimeException {
        return this.addOrUpdateObjectAsync(indexName, objectID, body, null);
    }

    public CreatedAtResponse appendSource(@Nonnull Source source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.appendSourceAsync(source, requestOptions));
    }

    public CreatedAtResponse appendSource(@Nonnull Source source) throws AlgoliaRuntimeException {
        return this.appendSource(source, null);
    }

    public CompletableFuture<CreatedAtResponse> appendSourceAsync(@Nonnull Source source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(source, "Parameter `source` is required when calling `appendSource`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/security/sources/append").setMethod("POST").setBody(source).build();
        return this.executeAsync(request, requestOptions, new TypeReference<CreatedAtResponse>(){});
    }

    public CompletableFuture<CreatedAtResponse> appendSourceAsync(@Nonnull Source source) throws AlgoliaRuntimeException {
        return this.appendSourceAsync(source, null);
    }

    public CreatedAtResponse assignUserId(@Nonnull String xAlgoliaUserID, @Nonnull AssignUserIdParams assignUserIdParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.assignUserIdAsync(xAlgoliaUserID, assignUserIdParams, requestOptions));
    }

    public CreatedAtResponse assignUserId(@Nonnull String xAlgoliaUserID, @Nonnull AssignUserIdParams assignUserIdParams) throws AlgoliaRuntimeException {
        return this.assignUserId(xAlgoliaUserID, assignUserIdParams, null);
    }

    public CompletableFuture<CreatedAtResponse> assignUserIdAsync(@Nonnull String xAlgoliaUserID, @Nonnull AssignUserIdParams assignUserIdParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(xAlgoliaUserID, "Parameter `xAlgoliaUserID` is required when calling `assignUserId`.");
        Parameters.requireNonNull(assignUserIdParams, "Parameter `assignUserIdParams` is required when calling `assignUserId`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/clusters/mapping").setMethod("POST").setBody(assignUserIdParams).addHeader("X-Algolia-User-ID", xAlgoliaUserID).build();
        return this.executeAsync(request, requestOptions, new TypeReference<CreatedAtResponse>(){});
    }

    public CompletableFuture<CreatedAtResponse> assignUserIdAsync(@Nonnull String xAlgoliaUserID, @Nonnull AssignUserIdParams assignUserIdParams) throws AlgoliaRuntimeException {
        return this.assignUserIdAsync(xAlgoliaUserID, assignUserIdParams, null);
    }

    public BatchResponse batch(@Nonnull String indexName, @Nonnull BatchWriteParams batchWriteParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.batchAsync(indexName, batchWriteParams, requestOptions));
    }

    public BatchResponse batch(@Nonnull String indexName, @Nonnull BatchWriteParams batchWriteParams) throws AlgoliaRuntimeException {
        return this.batch(indexName, batchWriteParams, null);
    }

    public CompletableFuture<BatchResponse> batchAsync(@Nonnull String indexName, @Nonnull BatchWriteParams batchWriteParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `batch`.");
        Parameters.requireNonNull(batchWriteParams, "Parameter `batchWriteParams` is required when calling `batch`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/batch", indexName).setMethod("POST").setBody(batchWriteParams).build();
        return this.executeAsync(request, requestOptions, new TypeReference<BatchResponse>(){});
    }

    public CompletableFuture<BatchResponse> batchAsync(@Nonnull String indexName, @Nonnull BatchWriteParams batchWriteParams) throws AlgoliaRuntimeException {
        return this.batchAsync(indexName, batchWriteParams, null);
    }

    public CreatedAtResponse batchAssignUserIds(@Nonnull String xAlgoliaUserID, @Nonnull BatchAssignUserIdsParams batchAssignUserIdsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.batchAssignUserIdsAsync(xAlgoliaUserID, batchAssignUserIdsParams, requestOptions));
    }

    public CreatedAtResponse batchAssignUserIds(@Nonnull String xAlgoliaUserID, @Nonnull BatchAssignUserIdsParams batchAssignUserIdsParams) throws AlgoliaRuntimeException {
        return this.batchAssignUserIds(xAlgoliaUserID, batchAssignUserIdsParams, null);
    }

    public CompletableFuture<CreatedAtResponse> batchAssignUserIdsAsync(@Nonnull String xAlgoliaUserID, @Nonnull BatchAssignUserIdsParams batchAssignUserIdsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(xAlgoliaUserID, "Parameter `xAlgoliaUserID` is required when calling `batchAssignUserIds`.");
        Parameters.requireNonNull(batchAssignUserIdsParams, "Parameter `batchAssignUserIdsParams` is required when calling `batchAssignUserIds`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/clusters/mapping/batch").setMethod("POST").setBody(batchAssignUserIdsParams).addHeader("X-Algolia-User-ID", xAlgoliaUserID).build();
        return this.executeAsync(request, requestOptions, new TypeReference<CreatedAtResponse>(){});
    }

    public CompletableFuture<CreatedAtResponse> batchAssignUserIdsAsync(@Nonnull String xAlgoliaUserID, @Nonnull BatchAssignUserIdsParams batchAssignUserIdsParams) throws AlgoliaRuntimeException {
        return this.batchAssignUserIdsAsync(xAlgoliaUserID, batchAssignUserIdsParams, null);
    }

    public UpdatedAtResponse batchDictionaryEntries(@Nonnull DictionaryType dictionaryName, @Nonnull BatchDictionaryEntriesParams batchDictionaryEntriesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.batchDictionaryEntriesAsync(dictionaryName, batchDictionaryEntriesParams, requestOptions));
    }

    public UpdatedAtResponse batchDictionaryEntries(@Nonnull DictionaryType dictionaryName, @Nonnull BatchDictionaryEntriesParams batchDictionaryEntriesParams) throws AlgoliaRuntimeException {
        return this.batchDictionaryEntries(dictionaryName, batchDictionaryEntriesParams, null);
    }

    public CompletableFuture<UpdatedAtResponse> batchDictionaryEntriesAsync(@Nonnull DictionaryType dictionaryName, @Nonnull BatchDictionaryEntriesParams batchDictionaryEntriesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull((Object)dictionaryName, "Parameter `dictionaryName` is required when calling `batchDictionaryEntries`.");
        Parameters.requireNonNull(batchDictionaryEntriesParams, "Parameter `batchDictionaryEntriesParams` is required when calling `batchDictionaryEntries`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/dictionaries/{dictionaryName}/batch", new Object[]{dictionaryName}).setMethod("POST").setBody(batchDictionaryEntriesParams).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> batchDictionaryEntriesAsync(@Nonnull DictionaryType dictionaryName, @Nonnull BatchDictionaryEntriesParams batchDictionaryEntriesParams) throws AlgoliaRuntimeException {
        return this.batchDictionaryEntriesAsync(dictionaryName, batchDictionaryEntriesParams, null);
    }

    public <T> BrowseResponse<T> browse(@Nonnull String indexName, BrowseParams browseParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.browseAsync(indexName, browseParams, innerType, requestOptions));
    }

    public <T> BrowseResponse<T> browse(@Nonnull String indexName, BrowseParams browseParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.browse(indexName, browseParams, innerType, null);
    }

    public <T> BrowseResponse<T> browse(@Nonnull String indexName, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.browse(indexName, null, innerType, requestOptions);
    }

    public <T> BrowseResponse<T> browse(@Nonnull String indexName, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.browse(indexName, null, innerType, null);
    }

    public <T> CompletableFuture<BrowseResponse<T>> browseAsync(@Nonnull String indexName, BrowseParams browseParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `browse`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/browse", indexName).setMethod("POST").setBody(browseParams).build();
        return this.executeAsync(request, requestOptions, BrowseResponse.class, innerType);
    }

    public <T> CompletableFuture<BrowseResponse<T>> browseAsync(@Nonnull String indexName, BrowseParams browseParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.browseAsync(indexName, browseParams, innerType, null);
    }

    public <T> CompletableFuture<BrowseResponse<T>> browseAsync(@Nonnull String indexName, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.browseAsync(indexName, null, innerType, requestOptions);
    }

    public <T> CompletableFuture<BrowseResponse<T>> browseAsync(@Nonnull String indexName, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.browseAsync(indexName, null, innerType, null);
    }

    public UpdatedAtResponse clearObjects(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.clearObjectsAsync(indexName, requestOptions));
    }

    public UpdatedAtResponse clearObjects(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.clearObjects(indexName, null);
    }

    public CompletableFuture<UpdatedAtResponse> clearObjectsAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `clearObjects`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/clear", indexName).setMethod("POST").build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> clearObjectsAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.clearObjectsAsync(indexName, null);
    }

    public UpdatedAtResponse clearRules(@Nonnull String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.clearRulesAsync(indexName, forwardToReplicas, requestOptions));
    }

    public UpdatedAtResponse clearRules(@Nonnull String indexName, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.clearRules(indexName, forwardToReplicas, null);
    }

    public UpdatedAtResponse clearRules(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.clearRules(indexName, null, requestOptions);
    }

    public UpdatedAtResponse clearRules(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.clearRules(indexName, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> clearRulesAsync(@Nonnull String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `clearRules`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/rules/clear", indexName).setMethod("POST").addQueryParameter("forwardToReplicas", forwardToReplicas).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> clearRulesAsync(@Nonnull String indexName, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.clearRulesAsync(indexName, forwardToReplicas, null);
    }

    public CompletableFuture<UpdatedAtResponse> clearRulesAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.clearRulesAsync(indexName, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> clearRulesAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.clearRulesAsync(indexName, null, null);
    }

    public UpdatedAtResponse clearSynonyms(@Nonnull String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.clearSynonymsAsync(indexName, forwardToReplicas, requestOptions));
    }

    public UpdatedAtResponse clearSynonyms(@Nonnull String indexName, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.clearSynonyms(indexName, forwardToReplicas, null);
    }

    public UpdatedAtResponse clearSynonyms(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.clearSynonyms(indexName, null, requestOptions);
    }

    public UpdatedAtResponse clearSynonyms(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.clearSynonyms(indexName, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> clearSynonymsAsync(@Nonnull String indexName, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `clearSynonyms`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/synonyms/clear", indexName).setMethod("POST").addQueryParameter("forwardToReplicas", forwardToReplicas).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> clearSynonymsAsync(@Nonnull String indexName, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.clearSynonymsAsync(indexName, forwardToReplicas, null);
    }

    public CompletableFuture<UpdatedAtResponse> clearSynonymsAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.clearSynonymsAsync(indexName, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> clearSynonymsAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.clearSynonymsAsync(indexName, null, null);
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customDeleteAsync(path, parameters, requestOptions));
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDelete(path, parameters, null);
    }

    public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, requestOptions);
    }

    public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, null);
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customGetAsync(path, parameters, requestOptions));
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGet(path, parameters, null);
    }

    public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGet(path, null, requestOptions);
    }

    public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGet(path, null, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, null);
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPostAsync(path, parameters, body, requestOptions));
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPost(path, parameters, body, null);
    }

    public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, requestOptions);
    }

    public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, null);
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPutAsync(path, parameters, body, requestOptions));
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPut(path, parameters, body, null);
    }

    public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, requestOptions);
    }

    public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, null);
    }

    public DeleteApiKeyResponse deleteApiKey(@Nonnull String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteApiKeyAsync(key, requestOptions));
    }

    public DeleteApiKeyResponse deleteApiKey(@Nonnull String key) throws AlgoliaRuntimeException {
        return this.deleteApiKey(key, null);
    }

    public CompletableFuture<DeleteApiKeyResponse> deleteApiKeyAsync(@Nonnull String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(key, "Parameter `key` is required when calling `deleteApiKey`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/keys/{key}", key).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeleteApiKeyResponse>(){});
    }

    public CompletableFuture<DeleteApiKeyResponse> deleteApiKeyAsync(@Nonnull String key) throws AlgoliaRuntimeException {
        return this.deleteApiKeyAsync(key, null);
    }

    public DeletedAtResponse deleteBy(@Nonnull String indexName, @Nonnull DeleteByParams deleteByParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteByAsync(indexName, deleteByParams, requestOptions));
    }

    public DeletedAtResponse deleteBy(@Nonnull String indexName, @Nonnull DeleteByParams deleteByParams) throws AlgoliaRuntimeException {
        return this.deleteBy(indexName, deleteByParams, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteByAsync(@Nonnull String indexName, @Nonnull DeleteByParams deleteByParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteBy`.");
        Parameters.requireNonNull(deleteByParams, "Parameter `deleteByParams` is required when calling `deleteBy`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/deleteByQuery", indexName).setMethod("POST").setBody(deleteByParams).build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>(){});
    }

    public CompletableFuture<DeletedAtResponse> deleteByAsync(@Nonnull String indexName, @Nonnull DeleteByParams deleteByParams) throws AlgoliaRuntimeException {
        return this.deleteByAsync(indexName, deleteByParams, null);
    }

    public DeletedAtResponse deleteIndex(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteIndexAsync(indexName, requestOptions));
    }

    public DeletedAtResponse deleteIndex(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.deleteIndex(indexName, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteIndexAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteIndex`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}", indexName).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>(){});
    }

    public CompletableFuture<DeletedAtResponse> deleteIndexAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.deleteIndexAsync(indexName, null);
    }

    public DeletedAtResponse deleteObject(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteObjectAsync(indexName, objectID, requestOptions));
    }

    public DeletedAtResponse deleteObject(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.deleteObject(indexName, objectID, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteObjectAsync(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteObject`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `deleteObject`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{objectID}", indexName, objectID).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>(){});
    }

    public CompletableFuture<DeletedAtResponse> deleteObjectAsync(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.deleteObjectAsync(indexName, objectID, null);
    }

    public UpdatedAtResponse deleteRule(@Nonnull String indexName, @Nonnull String objectID, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteRuleAsync(indexName, objectID, forwardToReplicas, requestOptions));
    }

    public UpdatedAtResponse deleteRule(@Nonnull String indexName, @Nonnull String objectID, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.deleteRule(indexName, objectID, forwardToReplicas, null);
    }

    public UpdatedAtResponse deleteRule(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.deleteRule(indexName, objectID, null, requestOptions);
    }

    public UpdatedAtResponse deleteRule(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.deleteRule(indexName, objectID, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(@Nonnull String indexName, @Nonnull String objectID, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteRule`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `deleteRule`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/rules/{objectID}", indexName, objectID).setMethod("DELETE").addQueryParameter("forwardToReplicas", forwardToReplicas).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(@Nonnull String indexName, @Nonnull String objectID, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.deleteRuleAsync(indexName, objectID, forwardToReplicas, null);
    }

    public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.deleteRuleAsync(indexName, objectID, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> deleteRuleAsync(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.deleteRuleAsync(indexName, objectID, null, null);
    }

    public DeleteSourceResponse deleteSource(@Nonnull String source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteSourceAsync(source, requestOptions));
    }

    public DeleteSourceResponse deleteSource(@Nonnull String source) throws AlgoliaRuntimeException {
        return this.deleteSource(source, null);
    }

    public CompletableFuture<DeleteSourceResponse> deleteSourceAsync(@Nonnull String source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(source, "Parameter `source` is required when calling `deleteSource`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/security/sources/{source}", source).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeleteSourceResponse>(){});
    }

    public CompletableFuture<DeleteSourceResponse> deleteSourceAsync(@Nonnull String source) throws AlgoliaRuntimeException {
        return this.deleteSourceAsync(source, null);
    }

    public DeletedAtResponse deleteSynonym(@Nonnull String indexName, @Nonnull String objectID, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteSynonymAsync(indexName, objectID, forwardToReplicas, requestOptions));
    }

    public DeletedAtResponse deleteSynonym(@Nonnull String indexName, @Nonnull String objectID, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.deleteSynonym(indexName, objectID, forwardToReplicas, null);
    }

    public DeletedAtResponse deleteSynonym(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.deleteSynonym(indexName, objectID, null, requestOptions);
    }

    public DeletedAtResponse deleteSynonym(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.deleteSynonym(indexName, objectID, null, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(@Nonnull String indexName, @Nonnull String objectID, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteSynonym`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `deleteSynonym`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/synonyms/{objectID}", indexName, objectID).setMethod("DELETE").addQueryParameter("forwardToReplicas", forwardToReplicas).build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>(){});
    }

    public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(@Nonnull String indexName, @Nonnull String objectID, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.deleteSynonymAsync(indexName, objectID, forwardToReplicas, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.deleteSynonymAsync(indexName, objectID, null, requestOptions);
    }

    public CompletableFuture<DeletedAtResponse> deleteSynonymAsync(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.deleteSynonymAsync(indexName, objectID, null, null);
    }

    public GetApiKeyResponse getApiKey(@Nonnull String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getApiKeyAsync(key, requestOptions));
    }

    public GetApiKeyResponse getApiKey(@Nonnull String key) throws AlgoliaRuntimeException {
        return this.getApiKey(key, null);
    }

    public CompletableFuture<GetApiKeyResponse> getApiKeyAsync(@Nonnull String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(key, "Parameter `key` is required when calling `getApiKey`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/keys/{key}", key).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetApiKeyResponse>(){});
    }

    public CompletableFuture<GetApiKeyResponse> getApiKeyAsync(@Nonnull String key) throws AlgoliaRuntimeException {
        return this.getApiKeyAsync(key, null);
    }

    public GetTaskResponse getAppTask(@Nonnull Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAppTaskAsync(taskID, requestOptions));
    }

    public GetTaskResponse getAppTask(@Nonnull Long taskID) throws AlgoliaRuntimeException {
        return this.getAppTask(taskID, null);
    }

    public CompletableFuture<GetTaskResponse> getAppTaskAsync(@Nonnull Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `getAppTask`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/task/{taskID}", taskID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetTaskResponse>(){});
    }

    public CompletableFuture<GetTaskResponse> getAppTaskAsync(@Nonnull Long taskID) throws AlgoliaRuntimeException {
        return this.getAppTaskAsync(taskID, null);
    }

    public Map<String, Languages> getDictionaryLanguages(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getDictionaryLanguagesAsync(requestOptions));
    }

    public Map<String, Languages> getDictionaryLanguages() throws AlgoliaRuntimeException {
        return this.getDictionaryLanguages(null);
    }

    public CompletableFuture<Map<String, Languages>> getDictionaryLanguagesAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/dictionaries/*/languages").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<Map<String, Languages>>(){});
    }

    public CompletableFuture<Map<String, Languages>> getDictionaryLanguagesAsync() throws AlgoliaRuntimeException {
        return this.getDictionaryLanguagesAsync(null);
    }

    public GetDictionarySettingsResponse getDictionarySettings(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getDictionarySettingsAsync(requestOptions));
    }

    public GetDictionarySettingsResponse getDictionarySettings() throws AlgoliaRuntimeException {
        return this.getDictionarySettings(null);
    }

    public CompletableFuture<GetDictionarySettingsResponse> getDictionarySettingsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/dictionaries/*/settings").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetDictionarySettingsResponse>(){});
    }

    public CompletableFuture<GetDictionarySettingsResponse> getDictionarySettingsAsync() throws AlgoliaRuntimeException {
        return this.getDictionarySettingsAsync(null);
    }

    public GetLogsResponse getLogs(Integer offset, Integer length, String indexName, LogType type, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getLogsAsync(offset, length, indexName, type, requestOptions));
    }

    public GetLogsResponse getLogs(Integer offset, Integer length, String indexName, LogType type) throws AlgoliaRuntimeException {
        return this.getLogs(offset, length, indexName, type, null);
    }

    public GetLogsResponse getLogs(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getLogs(null, null, null, null, requestOptions);
    }

    public GetLogsResponse getLogs() throws AlgoliaRuntimeException {
        return this.getLogs(null, null, null, null, null);
    }

    public CompletableFuture<GetLogsResponse> getLogsAsync(Integer offset, Integer length, String indexName, LogType type, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/logs").setMethod("GET").addQueryParameter("offset", offset).addQueryParameter("length", length).addQueryParameter("indexName", indexName).addQueryParameter("type", (Object)type).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetLogsResponse>(){});
    }

    public CompletableFuture<GetLogsResponse> getLogsAsync(Integer offset, Integer length, String indexName, LogType type) throws AlgoliaRuntimeException {
        return this.getLogsAsync(offset, length, indexName, type, null);
    }

    public CompletableFuture<GetLogsResponse> getLogsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getLogsAsync(null, null, null, null, requestOptions);
    }

    public CompletableFuture<GetLogsResponse> getLogsAsync() throws AlgoliaRuntimeException {
        return this.getLogsAsync(null, null, null, null, null);
    }

    public Map<String, String> getObject(@Nonnull String indexName, @Nonnull String objectID, List<String> attributesToRetrieve, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getObjectAsync(indexName, objectID, attributesToRetrieve, requestOptions));
    }

    public Map<String, String> getObject(@Nonnull String indexName, @Nonnull String objectID, List<String> attributesToRetrieve) throws AlgoliaRuntimeException {
        return this.getObject(indexName, objectID, attributesToRetrieve, null);
    }

    public Map<String, String> getObject(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getObject(indexName, objectID, null, requestOptions);
    }

    public Map<String, String> getObject(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.getObject(indexName, objectID, null, null);
    }

    public CompletableFuture<Map<String, String>> getObjectAsync(@Nonnull String indexName, @Nonnull String objectID, List<String> attributesToRetrieve, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getObject`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `getObject`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{objectID}", indexName, objectID).setMethod("GET").addQueryParameter("attributesToRetrieve", attributesToRetrieve).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Map<String, String>>(){});
    }

    public CompletableFuture<Map<String, String>> getObjectAsync(@Nonnull String indexName, @Nonnull String objectID, List<String> attributesToRetrieve) throws AlgoliaRuntimeException {
        return this.getObjectAsync(indexName, objectID, attributesToRetrieve, null);
    }

    public CompletableFuture<Map<String, String>> getObjectAsync(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getObjectAsync(indexName, objectID, null, requestOptions);
    }

    public CompletableFuture<Map<String, String>> getObjectAsync(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.getObjectAsync(indexName, objectID, null, null);
    }

    public <T> GetObjectsResponse<T> getObjects(@Nonnull GetObjectsParams getObjectsParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getObjectsAsync(getObjectsParams, innerType, requestOptions));
    }

    public <T> GetObjectsResponse<T> getObjects(@Nonnull GetObjectsParams getObjectsParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.getObjects(getObjectsParams, innerType, null);
    }

    public <T> CompletableFuture<GetObjectsResponse<T>> getObjectsAsync(@Nonnull GetObjectsParams getObjectsParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(getObjectsParams, "Parameter `getObjectsParams` is required when calling `getObjects`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/*/objects").setMethod("POST").setBody(getObjectsParams).setRead(true).build();
        return this.executeAsync(request, requestOptions, GetObjectsResponse.class, innerType);
    }

    public <T> CompletableFuture<GetObjectsResponse<T>> getObjectsAsync(@Nonnull GetObjectsParams getObjectsParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.getObjectsAsync(getObjectsParams, innerType, null);
    }

    public Rule getRule(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRuleAsync(indexName, objectID, requestOptions));
    }

    public Rule getRule(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.getRule(indexName, objectID, null);
    }

    public CompletableFuture<Rule> getRuleAsync(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getRule`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `getRule`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/rules/{objectID}", indexName, objectID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<Rule>(){});
    }

    public CompletableFuture<Rule> getRuleAsync(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.getRuleAsync(indexName, objectID, null);
    }

    public IndexSettings getSettings(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSettingsAsync(indexName, requestOptions));
    }

    public IndexSettings getSettings(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getSettings(indexName, null);
    }

    public CompletableFuture<IndexSettings> getSettingsAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getSettings`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/settings", indexName).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<IndexSettings>(){});
    }

    public CompletableFuture<IndexSettings> getSettingsAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getSettingsAsync(indexName, null);
    }

    public List<Source> getSources(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSourcesAsync(requestOptions));
    }

    public List<Source> getSources() throws AlgoliaRuntimeException {
        return this.getSources(null);
    }

    public CompletableFuture<List<Source>> getSourcesAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/security/sources").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<List<Source>>(){});
    }

    public CompletableFuture<List<Source>> getSourcesAsync() throws AlgoliaRuntimeException {
        return this.getSourcesAsync(null);
    }

    public SynonymHit getSynonym(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSynonymAsync(indexName, objectID, requestOptions));
    }

    public SynonymHit getSynonym(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.getSynonym(indexName, objectID, null);
    }

    public CompletableFuture<SynonymHit> getSynonymAsync(@Nonnull String indexName, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getSynonym`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `getSynonym`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/synonyms/{objectID}", indexName, objectID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<SynonymHit>(){});
    }

    public CompletableFuture<SynonymHit> getSynonymAsync(@Nonnull String indexName, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.getSynonymAsync(indexName, objectID, null);
    }

    public GetTaskResponse getTask(@Nonnull String indexName, @Nonnull Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTaskAsync(indexName, taskID, requestOptions));
    }

    public GetTaskResponse getTask(@Nonnull String indexName, @Nonnull Long taskID) throws AlgoliaRuntimeException {
        return this.getTask(indexName, taskID, null);
    }

    public CompletableFuture<GetTaskResponse> getTaskAsync(@Nonnull String indexName, @Nonnull Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getTask`.");
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `getTask`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/task/{taskID}", indexName, taskID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetTaskResponse>(){});
    }

    public CompletableFuture<GetTaskResponse> getTaskAsync(@Nonnull String indexName, @Nonnull Long taskID) throws AlgoliaRuntimeException {
        return this.getTaskAsync(indexName, taskID, null);
    }

    public GetTopUserIdsResponse getTopUserIds(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTopUserIdsAsync(requestOptions));
    }

    public GetTopUserIdsResponse getTopUserIds() throws AlgoliaRuntimeException {
        return this.getTopUserIds(null);
    }

    public CompletableFuture<GetTopUserIdsResponse> getTopUserIdsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/clusters/mapping/top").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetTopUserIdsResponse>(){});
    }

    public CompletableFuture<GetTopUserIdsResponse> getTopUserIdsAsync() throws AlgoliaRuntimeException {
        return this.getTopUserIdsAsync(null);
    }

    public UserId getUserId(@Nonnull String userID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getUserIdAsync(userID, requestOptions));
    }

    public UserId getUserId(@Nonnull String userID) throws AlgoliaRuntimeException {
        return this.getUserId(userID, null);
    }

    public CompletableFuture<UserId> getUserIdAsync(@Nonnull String userID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(userID, "Parameter `userID` is required when calling `getUserId`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/clusters/mapping/{userID}", userID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<UserId>(){});
    }

    public CompletableFuture<UserId> getUserIdAsync(@Nonnull String userID) throws AlgoliaRuntimeException {
        return this.getUserIdAsync(userID, null);
    }

    public HasPendingMappingsResponse hasPendingMappings(Boolean getClusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.hasPendingMappingsAsync(getClusters, requestOptions));
    }

    public HasPendingMappingsResponse hasPendingMappings(Boolean getClusters) throws AlgoliaRuntimeException {
        return this.hasPendingMappings(getClusters, null);
    }

    public HasPendingMappingsResponse hasPendingMappings(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.hasPendingMappings(null, requestOptions);
    }

    public HasPendingMappingsResponse hasPendingMappings() throws AlgoliaRuntimeException {
        return this.hasPendingMappings(null, null);
    }

    public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(Boolean getClusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/clusters/mapping/pending").setMethod("GET").addQueryParameter("getClusters", getClusters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<HasPendingMappingsResponse>(){});
    }

    public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(Boolean getClusters) throws AlgoliaRuntimeException {
        return this.hasPendingMappingsAsync(getClusters, null);
    }

    public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.hasPendingMappingsAsync(null, requestOptions);
    }

    public CompletableFuture<HasPendingMappingsResponse> hasPendingMappingsAsync() throws AlgoliaRuntimeException {
        return this.hasPendingMappingsAsync(null, null);
    }

    public ListApiKeysResponse listApiKeys(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listApiKeysAsync(requestOptions));
    }

    public ListApiKeysResponse listApiKeys() throws AlgoliaRuntimeException {
        return this.listApiKeys(null);
    }

    public CompletableFuture<ListApiKeysResponse> listApiKeysAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/keys").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListApiKeysResponse>(){});
    }

    public CompletableFuture<ListApiKeysResponse> listApiKeysAsync() throws AlgoliaRuntimeException {
        return this.listApiKeysAsync(null);
    }

    public ListClustersResponse listClusters(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listClustersAsync(requestOptions));
    }

    public ListClustersResponse listClusters() throws AlgoliaRuntimeException {
        return this.listClusters(null);
    }

    public CompletableFuture<ListClustersResponse> listClustersAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/clusters").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListClustersResponse>(){});
    }

    public CompletableFuture<ListClustersResponse> listClustersAsync() throws AlgoliaRuntimeException {
        return this.listClustersAsync(null);
    }

    public ListIndicesResponse listIndices(Integer page, Integer hitsPerPage, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listIndicesAsync(page, hitsPerPage, requestOptions));
    }

    public ListIndicesResponse listIndices(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
        return this.listIndices(page, hitsPerPage, null);
    }

    public ListIndicesResponse listIndices(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listIndices(null, null, requestOptions);
    }

    public ListIndicesResponse listIndices() throws AlgoliaRuntimeException {
        return this.listIndices(null, null, null);
    }

    public CompletableFuture<ListIndicesResponse> listIndicesAsync(Integer page, Integer hitsPerPage, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes").setMethod("GET").addQueryParameter("page", page).addQueryParameter("hitsPerPage", hitsPerPage).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListIndicesResponse>(){});
    }

    public CompletableFuture<ListIndicesResponse> listIndicesAsync(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
        return this.listIndicesAsync(page, hitsPerPage, null);
    }

    public CompletableFuture<ListIndicesResponse> listIndicesAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listIndicesAsync(null, null, requestOptions);
    }

    public CompletableFuture<ListIndicesResponse> listIndicesAsync() throws AlgoliaRuntimeException {
        return this.listIndicesAsync(null, null, null);
    }

    public ListUserIdsResponse listUserIds(Integer page, Integer hitsPerPage, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listUserIdsAsync(page, hitsPerPage, requestOptions));
    }

    public ListUserIdsResponse listUserIds(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
        return this.listUserIds(page, hitsPerPage, null);
    }

    public ListUserIdsResponse listUserIds(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listUserIds(null, null, requestOptions);
    }

    public ListUserIdsResponse listUserIds() throws AlgoliaRuntimeException {
        return this.listUserIds(null, null, null);
    }

    public CompletableFuture<ListUserIdsResponse> listUserIdsAsync(Integer page, Integer hitsPerPage, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/clusters/mapping").setMethod("GET").addQueryParameter("page", page).addQueryParameter("hitsPerPage", hitsPerPage).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListUserIdsResponse>(){});
    }

    public CompletableFuture<ListUserIdsResponse> listUserIdsAsync(Integer page, Integer hitsPerPage) throws AlgoliaRuntimeException {
        return this.listUserIdsAsync(page, hitsPerPage, null);
    }

    public CompletableFuture<ListUserIdsResponse> listUserIdsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listUserIdsAsync(null, null, requestOptions);
    }

    public CompletableFuture<ListUserIdsResponse> listUserIdsAsync() throws AlgoliaRuntimeException {
        return this.listUserIdsAsync(null, null, null);
    }

    public MultipleBatchResponse multipleBatch(@Nonnull BatchParams batchParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.multipleBatchAsync(batchParams, requestOptions));
    }

    public MultipleBatchResponse multipleBatch(@Nonnull BatchParams batchParams) throws AlgoliaRuntimeException {
        return this.multipleBatch(batchParams, null);
    }

    public CompletableFuture<MultipleBatchResponse> multipleBatchAsync(@Nonnull BatchParams batchParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(batchParams, "Parameter `batchParams` is required when calling `multipleBatch`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/*/batch").setMethod("POST").setBody(batchParams).build();
        return this.executeAsync(request, requestOptions, new TypeReference<MultipleBatchResponse>(){});
    }

    public CompletableFuture<MultipleBatchResponse> multipleBatchAsync(@Nonnull BatchParams batchParams) throws AlgoliaRuntimeException {
        return this.multipleBatchAsync(batchParams, null);
    }

    public UpdatedAtResponse operationIndex(@Nonnull String indexName, @Nonnull OperationIndexParams operationIndexParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.operationIndexAsync(indexName, operationIndexParams, requestOptions));
    }

    public UpdatedAtResponse operationIndex(@Nonnull String indexName, @Nonnull OperationIndexParams operationIndexParams) throws AlgoliaRuntimeException {
        return this.operationIndex(indexName, operationIndexParams, null);
    }

    public CompletableFuture<UpdatedAtResponse> operationIndexAsync(@Nonnull String indexName, @Nonnull OperationIndexParams operationIndexParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `operationIndex`.");
        Parameters.requireNonNull(operationIndexParams, "Parameter `operationIndexParams` is required when calling `operationIndex`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/operation", indexName).setMethod("POST").setBody(operationIndexParams).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> operationIndexAsync(@Nonnull String indexName, @Nonnull OperationIndexParams operationIndexParams) throws AlgoliaRuntimeException {
        return this.operationIndexAsync(indexName, operationIndexParams, null);
    }

    public UpdatedAtWithObjectIdResponse partialUpdateObject(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Map<String, AttributeToUpdate> attributesToUpdate, Boolean createIfNotExists, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, createIfNotExists, requestOptions));
    }

    public UpdatedAtWithObjectIdResponse partialUpdateObject(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Map<String, AttributeToUpdate> attributesToUpdate, Boolean createIfNotExists) throws AlgoliaRuntimeException {
        return this.partialUpdateObject(indexName, objectID, attributesToUpdate, createIfNotExists, null);
    }

    public UpdatedAtWithObjectIdResponse partialUpdateObject(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Map<String, AttributeToUpdate> attributesToUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.partialUpdateObject(indexName, objectID, attributesToUpdate, null, requestOptions);
    }

    public UpdatedAtWithObjectIdResponse partialUpdateObject(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Map<String, AttributeToUpdate> attributesToUpdate) throws AlgoliaRuntimeException {
        return this.partialUpdateObject(indexName, objectID, attributesToUpdate, null, null);
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Map<String, AttributeToUpdate> attributesToUpdate, Boolean createIfNotExists, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `partialUpdateObject`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `partialUpdateObject`.");
        Parameters.requireNonNull(attributesToUpdate, "Parameter `attributesToUpdate` is required when calling `partialUpdateObject`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{objectID}/partial", indexName, objectID).setMethod("POST").setBody(attributesToUpdate).addQueryParameter("createIfNotExists", createIfNotExists).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtWithObjectIdResponse>(){});
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Map<String, AttributeToUpdate> attributesToUpdate, Boolean createIfNotExists) throws AlgoliaRuntimeException {
        return this.partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, createIfNotExists, null);
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Map<String, AttributeToUpdate> attributesToUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtWithObjectIdResponse> partialUpdateObjectAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Map<String, AttributeToUpdate> attributesToUpdate) throws AlgoliaRuntimeException {
        return this.partialUpdateObjectAsync(indexName, objectID, attributesToUpdate, null, null);
    }

    public RemoveUserIdResponse removeUserId(@Nonnull String userID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.removeUserIdAsync(userID, requestOptions));
    }

    public RemoveUserIdResponse removeUserId(@Nonnull String userID) throws AlgoliaRuntimeException {
        return this.removeUserId(userID, null);
    }

    public CompletableFuture<RemoveUserIdResponse> removeUserIdAsync(@Nonnull String userID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(userID, "Parameter `userID` is required when calling `removeUserId`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/clusters/mapping/{userID}", userID).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<RemoveUserIdResponse>(){});
    }

    public CompletableFuture<RemoveUserIdResponse> removeUserIdAsync(@Nonnull String userID) throws AlgoliaRuntimeException {
        return this.removeUserIdAsync(userID, null);
    }

    public ReplaceSourceResponse replaceSources(@Nonnull List<Source> source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.replaceSourcesAsync(source, requestOptions));
    }

    public ReplaceSourceResponse replaceSources(@Nonnull List<Source> source) throws AlgoliaRuntimeException {
        return this.replaceSources(source, null);
    }

    public CompletableFuture<ReplaceSourceResponse> replaceSourcesAsync(@Nonnull List<Source> source, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(source, "Parameter `source` is required when calling `replaceSources`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/security/sources").setMethod("PUT").setBody(source).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ReplaceSourceResponse>(){});
    }

    public CompletableFuture<ReplaceSourceResponse> replaceSourcesAsync(@Nonnull List<Source> source) throws AlgoliaRuntimeException {
        return this.replaceSourcesAsync(source, null);
    }

    public AddApiKeyResponse restoreApiKey(@Nonnull String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.restoreApiKeyAsync(key, requestOptions));
    }

    public AddApiKeyResponse restoreApiKey(@Nonnull String key) throws AlgoliaRuntimeException {
        return this.restoreApiKey(key, null);
    }

    public CompletableFuture<AddApiKeyResponse> restoreApiKeyAsync(@Nonnull String key, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(key, "Parameter `key` is required when calling `restoreApiKey`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/keys/{key}/restore", key).setMethod("POST").build();
        return this.executeAsync(request, requestOptions, new TypeReference<AddApiKeyResponse>(){});
    }

    public CompletableFuture<AddApiKeyResponse> restoreApiKeyAsync(@Nonnull String key) throws AlgoliaRuntimeException {
        return this.restoreApiKeyAsync(key, null);
    }

    public SaveObjectResponse saveObject(@Nonnull String indexName, @Nonnull Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.saveObjectAsync(indexName, body, requestOptions));
    }

    public SaveObjectResponse saveObject(@Nonnull String indexName, @Nonnull Object body) throws AlgoliaRuntimeException {
        return this.saveObject(indexName, body, null);
    }

    public CompletableFuture<SaveObjectResponse> saveObjectAsync(@Nonnull String indexName, @Nonnull Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `saveObject`.");
        Parameters.requireNonNull(body, "Parameter `body` is required when calling `saveObject`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}", indexName).setMethod("POST").setBody(body).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SaveObjectResponse>(){});
    }

    public CompletableFuture<SaveObjectResponse> saveObjectAsync(@Nonnull String indexName, @Nonnull Object body) throws AlgoliaRuntimeException {
        return this.saveObjectAsync(indexName, body, null);
    }

    public UpdatedRuleResponse saveRule(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Rule rule, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.saveRuleAsync(indexName, objectID, rule, forwardToReplicas, requestOptions));
    }

    public UpdatedRuleResponse saveRule(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Rule rule, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.saveRule(indexName, objectID, rule, forwardToReplicas, null);
    }

    public UpdatedRuleResponse saveRule(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Rule rule, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveRule(indexName, objectID, rule, null, requestOptions);
    }

    public UpdatedRuleResponse saveRule(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Rule rule) throws AlgoliaRuntimeException {
        return this.saveRule(indexName, objectID, rule, null, null);
    }

    public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Rule rule, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `saveRule`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `saveRule`.");
        Parameters.requireNonNull(rule, "Parameter `rule` is required when calling `saveRule`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/rules/{objectID}", indexName, objectID).setMethod("PUT").setBody(rule).addQueryParameter("forwardToReplicas", forwardToReplicas).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedRuleResponse>(){});
    }

    public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Rule rule, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.saveRuleAsync(indexName, objectID, rule, forwardToReplicas, null);
    }

    public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Rule rule, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveRuleAsync(indexName, objectID, rule, null, requestOptions);
    }

    public CompletableFuture<UpdatedRuleResponse> saveRuleAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull Rule rule) throws AlgoliaRuntimeException {
        return this.saveRuleAsync(indexName, objectID, rule, null, null);
    }

    public UpdatedAtResponse saveRules(@Nonnull String indexName, @Nonnull List<Rule> rules, Boolean forwardToReplicas, Boolean clearExistingRules, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.saveRulesAsync(indexName, rules, forwardToReplicas, clearExistingRules, requestOptions));
    }

    public UpdatedAtResponse saveRules(@Nonnull String indexName, @Nonnull List<Rule> rules, Boolean forwardToReplicas, Boolean clearExistingRules) throws AlgoliaRuntimeException {
        return this.saveRules(indexName, rules, forwardToReplicas, clearExistingRules, null);
    }

    public UpdatedAtResponse saveRules(@Nonnull String indexName, @Nonnull List<Rule> rules, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveRules(indexName, rules, null, null, requestOptions);
    }

    public UpdatedAtResponse saveRules(@Nonnull String indexName, @Nonnull List<Rule> rules) throws AlgoliaRuntimeException {
        return this.saveRules(indexName, rules, null, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> saveRulesAsync(@Nonnull String indexName, @Nonnull List<Rule> rules, Boolean forwardToReplicas, Boolean clearExistingRules, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `saveRules`.");
        Parameters.requireNonNull(rules, "Parameter `rules` is required when calling `saveRules`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/rules/batch", indexName).setMethod("POST").setBody(rules).addQueryParameter("forwardToReplicas", forwardToReplicas).addQueryParameter("clearExistingRules", clearExistingRules).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> saveRulesAsync(@Nonnull String indexName, @Nonnull List<Rule> rules, Boolean forwardToReplicas, Boolean clearExistingRules) throws AlgoliaRuntimeException {
        return this.saveRulesAsync(indexName, rules, forwardToReplicas, clearExistingRules, null);
    }

    public CompletableFuture<UpdatedAtResponse> saveRulesAsync(@Nonnull String indexName, @Nonnull List<Rule> rules, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveRulesAsync(indexName, rules, null, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> saveRulesAsync(@Nonnull String indexName, @Nonnull List<Rule> rules) throws AlgoliaRuntimeException {
        return this.saveRulesAsync(indexName, rules, null, null, null);
    }

    public SaveSynonymResponse saveSynonym(@Nonnull String indexName, @Nonnull String objectID, @Nonnull SynonymHit synonymHit, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.saveSynonymAsync(indexName, objectID, synonymHit, forwardToReplicas, requestOptions));
    }

    public SaveSynonymResponse saveSynonym(@Nonnull String indexName, @Nonnull String objectID, @Nonnull SynonymHit synonymHit, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.saveSynonym(indexName, objectID, synonymHit, forwardToReplicas, null);
    }

    public SaveSynonymResponse saveSynonym(@Nonnull String indexName, @Nonnull String objectID, @Nonnull SynonymHit synonymHit, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveSynonym(indexName, objectID, synonymHit, null, requestOptions);
    }

    public SaveSynonymResponse saveSynonym(@Nonnull String indexName, @Nonnull String objectID, @Nonnull SynonymHit synonymHit) throws AlgoliaRuntimeException {
        return this.saveSynonym(indexName, objectID, synonymHit, null, null);
    }

    public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull SynonymHit synonymHit, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `saveSynonym`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `saveSynonym`.");
        Parameters.requireNonNull(synonymHit, "Parameter `synonymHit` is required when calling `saveSynonym`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/synonyms/{objectID}", indexName, objectID).setMethod("PUT").setBody(synonymHit).addQueryParameter("forwardToReplicas", forwardToReplicas).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SaveSynonymResponse>(){});
    }

    public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull SynonymHit synonymHit, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.saveSynonymAsync(indexName, objectID, synonymHit, forwardToReplicas, null);
    }

    public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull SynonymHit synonymHit, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveSynonymAsync(indexName, objectID, synonymHit, null, requestOptions);
    }

    public CompletableFuture<SaveSynonymResponse> saveSynonymAsync(@Nonnull String indexName, @Nonnull String objectID, @Nonnull SynonymHit synonymHit) throws AlgoliaRuntimeException {
        return this.saveSynonymAsync(indexName, objectID, synonymHit, null, null);
    }

    public UpdatedAtResponse saveSynonyms(@Nonnull String indexName, @Nonnull List<SynonymHit> synonymHit, Boolean forwardToReplicas, Boolean replaceExistingSynonyms, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.saveSynonymsAsync(indexName, synonymHit, forwardToReplicas, replaceExistingSynonyms, requestOptions));
    }

    public UpdatedAtResponse saveSynonyms(@Nonnull String indexName, @Nonnull List<SynonymHit> synonymHit, Boolean forwardToReplicas, Boolean replaceExistingSynonyms) throws AlgoliaRuntimeException {
        return this.saveSynonyms(indexName, synonymHit, forwardToReplicas, replaceExistingSynonyms, null);
    }

    public UpdatedAtResponse saveSynonyms(@Nonnull String indexName, @Nonnull List<SynonymHit> synonymHit, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveSynonyms(indexName, synonymHit, null, null, requestOptions);
    }

    public UpdatedAtResponse saveSynonyms(@Nonnull String indexName, @Nonnull List<SynonymHit> synonymHit) throws AlgoliaRuntimeException {
        return this.saveSynonyms(indexName, synonymHit, null, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(@Nonnull String indexName, @Nonnull List<SynonymHit> synonymHit, Boolean forwardToReplicas, Boolean replaceExistingSynonyms, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `saveSynonyms`.");
        Parameters.requireNonNull(synonymHit, "Parameter `synonymHit` is required when calling `saveSynonyms`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/synonyms/batch", indexName).setMethod("POST").setBody(synonymHit).addQueryParameter("forwardToReplicas", forwardToReplicas).addQueryParameter("replaceExistingSynonyms", replaceExistingSynonyms).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(@Nonnull String indexName, @Nonnull List<SynonymHit> synonymHit, Boolean forwardToReplicas, Boolean replaceExistingSynonyms) throws AlgoliaRuntimeException {
        return this.saveSynonymsAsync(indexName, synonymHit, forwardToReplicas, replaceExistingSynonyms, null);
    }

    public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(@Nonnull String indexName, @Nonnull List<SynonymHit> synonymHit, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.saveSynonymsAsync(indexName, synonymHit, null, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> saveSynonymsAsync(@Nonnull String indexName, @Nonnull List<SynonymHit> synonymHit) throws AlgoliaRuntimeException {
        return this.saveSynonymsAsync(indexName, synonymHit, null, null, null);
    }

    public <T> SearchResponses<T> search(@Nonnull SearchMethodParams searchMethodParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchAsync(searchMethodParams, innerType, requestOptions));
    }

    public <T> SearchResponses<T> search(@Nonnull SearchMethodParams searchMethodParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.search(searchMethodParams, innerType, null);
    }

    public <T> CompletableFuture<SearchResponses<T>> searchAsync(@Nonnull SearchMethodParams searchMethodParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(searchMethodParams, "Parameter `searchMethodParams` is required when calling `search`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/*/queries").setMethod("POST").setBody(searchMethodParams).setRead(true).build();
        return this.executeAsync(request, requestOptions, SearchResponses.class, innerType);
    }

    public <T> CompletableFuture<SearchResponses<T>> searchAsync(@Nonnull SearchMethodParams searchMethodParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.searchAsync(searchMethodParams, innerType, null);
    }

    public SearchDictionaryEntriesResponse searchDictionaryEntries(@Nonnull DictionaryType dictionaryName, @Nonnull SearchDictionaryEntriesParams searchDictionaryEntriesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchDictionaryEntriesAsync(dictionaryName, searchDictionaryEntriesParams, requestOptions));
    }

    public SearchDictionaryEntriesResponse searchDictionaryEntries(@Nonnull DictionaryType dictionaryName, @Nonnull SearchDictionaryEntriesParams searchDictionaryEntriesParams) throws AlgoliaRuntimeException {
        return this.searchDictionaryEntries(dictionaryName, searchDictionaryEntriesParams, null);
    }

    public CompletableFuture<SearchDictionaryEntriesResponse> searchDictionaryEntriesAsync(@Nonnull DictionaryType dictionaryName, @Nonnull SearchDictionaryEntriesParams searchDictionaryEntriesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull((Object)dictionaryName, "Parameter `dictionaryName` is required when calling `searchDictionaryEntries`.");
        Parameters.requireNonNull(searchDictionaryEntriesParams, "Parameter `searchDictionaryEntriesParams` is required when calling `searchDictionaryEntries`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/dictionaries/{dictionaryName}/search", new Object[]{dictionaryName}).setMethod("POST").setBody(searchDictionaryEntriesParams).setRead(true).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SearchDictionaryEntriesResponse>(){});
    }

    public CompletableFuture<SearchDictionaryEntriesResponse> searchDictionaryEntriesAsync(@Nonnull DictionaryType dictionaryName, @Nonnull SearchDictionaryEntriesParams searchDictionaryEntriesParams) throws AlgoliaRuntimeException {
        return this.searchDictionaryEntriesAsync(dictionaryName, searchDictionaryEntriesParams, null);
    }

    public SearchForFacetValuesResponse searchForFacetValues(@Nonnull String indexName, @Nonnull String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchForFacetValuesAsync(indexName, facetName, searchForFacetValuesRequest, requestOptions));
    }

    public SearchForFacetValuesResponse searchForFacetValues(@Nonnull String indexName, @Nonnull String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest) throws AlgoliaRuntimeException {
        return this.searchForFacetValues(indexName, facetName, searchForFacetValuesRequest, null);
    }

    public SearchForFacetValuesResponse searchForFacetValues(@Nonnull String indexName, @Nonnull String facetName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchForFacetValues(indexName, facetName, null, requestOptions);
    }

    public SearchForFacetValuesResponse searchForFacetValues(@Nonnull String indexName, @Nonnull String facetName) throws AlgoliaRuntimeException {
        return this.searchForFacetValues(indexName, facetName, null, null);
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(@Nonnull String indexName, @Nonnull String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchForFacetValues`.");
        Parameters.requireNonNull(facetName, "Parameter `facetName` is required when calling `searchForFacetValues`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/facets/{facetName}/query", indexName, facetName).setMethod("POST").setBody(searchForFacetValuesRequest).setRead(true).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SearchForFacetValuesResponse>(){});
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(@Nonnull String indexName, @Nonnull String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest) throws AlgoliaRuntimeException {
        return this.searchForFacetValuesAsync(indexName, facetName, searchForFacetValuesRequest, null);
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(@Nonnull String indexName, @Nonnull String facetName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchForFacetValuesAsync(indexName, facetName, null, requestOptions);
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(@Nonnull String indexName, @Nonnull String facetName) throws AlgoliaRuntimeException {
        return this.searchForFacetValuesAsync(indexName, facetName, null, null);
    }

    public SearchRulesResponse searchRules(@Nonnull String indexName, SearchRulesParams searchRulesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchRulesAsync(indexName, searchRulesParams, requestOptions));
    }

    public SearchRulesResponse searchRules(@Nonnull String indexName, SearchRulesParams searchRulesParams) throws AlgoliaRuntimeException {
        return this.searchRules(indexName, searchRulesParams, null);
    }

    public SearchRulesResponse searchRules(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchRules(indexName, null, requestOptions);
    }

    public SearchRulesResponse searchRules(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.searchRules(indexName, null, null);
    }

    public CompletableFuture<SearchRulesResponse> searchRulesAsync(@Nonnull String indexName, SearchRulesParams searchRulesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchRules`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/rules/search", indexName).setMethod("POST").setBody(searchRulesParams).setRead(true).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SearchRulesResponse>(){});
    }

    public CompletableFuture<SearchRulesResponse> searchRulesAsync(@Nonnull String indexName, SearchRulesParams searchRulesParams) throws AlgoliaRuntimeException {
        return this.searchRulesAsync(indexName, searchRulesParams, null);
    }

    public CompletableFuture<SearchRulesResponse> searchRulesAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchRulesAsync(indexName, null, requestOptions);
    }

    public CompletableFuture<SearchRulesResponse> searchRulesAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.searchRulesAsync(indexName, null, null);
    }

    public <T> SearchResponse<T> searchSingleIndex(@Nonnull String indexName, SearchParams searchParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchSingleIndexAsync(indexName, searchParams, innerType, requestOptions));
    }

    public <T> SearchResponse<T> searchSingleIndex(@Nonnull String indexName, SearchParams searchParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.searchSingleIndex(indexName, searchParams, innerType, null);
    }

    public <T> SearchResponse<T> searchSingleIndex(@Nonnull String indexName, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchSingleIndex(indexName, null, innerType, requestOptions);
    }

    public <T> SearchResponse<T> searchSingleIndex(@Nonnull String indexName, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.searchSingleIndex(indexName, null, innerType, null);
    }

    public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(@Nonnull String indexName, SearchParams searchParams, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchSingleIndex`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/query", indexName).setMethod("POST").setBody(searchParams).setRead(true).build();
        return this.executeAsync(request, requestOptions, SearchResponse.class, innerType);
    }

    public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(@Nonnull String indexName, SearchParams searchParams, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.searchSingleIndexAsync(indexName, searchParams, innerType, null);
    }

    public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(@Nonnull String indexName, Class<T> innerType, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchSingleIndexAsync(indexName, null, innerType, requestOptions);
    }

    public <T> CompletableFuture<SearchResponse<T>> searchSingleIndexAsync(@Nonnull String indexName, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.searchSingleIndexAsync(indexName, null, innerType, null);
    }

    public SearchSynonymsResponse searchSynonyms(@Nonnull String indexName, SearchSynonymsParams searchSynonymsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchSynonymsAsync(indexName, searchSynonymsParams, requestOptions));
    }

    public SearchSynonymsResponse searchSynonyms(@Nonnull String indexName, SearchSynonymsParams searchSynonymsParams) throws AlgoliaRuntimeException {
        return this.searchSynonyms(indexName, searchSynonymsParams, null);
    }

    public SearchSynonymsResponse searchSynonyms(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchSynonyms(indexName, null, requestOptions);
    }

    public SearchSynonymsResponse searchSynonyms(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.searchSynonyms(indexName, null, null);
    }

    public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(@Nonnull String indexName, SearchSynonymsParams searchSynonymsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchSynonyms`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/synonyms/search", indexName).setMethod("POST").setBody(searchSynonymsParams).setRead(true).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SearchSynonymsResponse>(){});
    }

    public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(@Nonnull String indexName, SearchSynonymsParams searchSynonymsParams) throws AlgoliaRuntimeException {
        return this.searchSynonymsAsync(indexName, searchSynonymsParams, null);
    }

    public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchSynonymsAsync(indexName, null, requestOptions);
    }

    public CompletableFuture<SearchSynonymsResponse> searchSynonymsAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.searchSynonymsAsync(indexName, null, null);
    }

    public SearchUserIdsResponse searchUserIds(@Nonnull SearchUserIdsParams searchUserIdsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchUserIdsAsync(searchUserIdsParams, requestOptions));
    }

    public SearchUserIdsResponse searchUserIds(@Nonnull SearchUserIdsParams searchUserIdsParams) throws AlgoliaRuntimeException {
        return this.searchUserIds(searchUserIdsParams, null);
    }

    public CompletableFuture<SearchUserIdsResponse> searchUserIdsAsync(@Nonnull SearchUserIdsParams searchUserIdsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(searchUserIdsParams, "Parameter `searchUserIdsParams` is required when calling `searchUserIds`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/clusters/mapping/search").setMethod("POST").setBody(searchUserIdsParams).setRead(true).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SearchUserIdsResponse>(){});
    }

    public CompletableFuture<SearchUserIdsResponse> searchUserIdsAsync(@Nonnull SearchUserIdsParams searchUserIdsParams) throws AlgoliaRuntimeException {
        return this.searchUserIdsAsync(searchUserIdsParams, null);
    }

    public UpdatedAtResponse setDictionarySettings(@Nonnull DictionarySettingsParams dictionarySettingsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.setDictionarySettingsAsync(dictionarySettingsParams, requestOptions));
    }

    public UpdatedAtResponse setDictionarySettings(@Nonnull DictionarySettingsParams dictionarySettingsParams) throws AlgoliaRuntimeException {
        return this.setDictionarySettings(dictionarySettingsParams, null);
    }

    public CompletableFuture<UpdatedAtResponse> setDictionarySettingsAsync(@Nonnull DictionarySettingsParams dictionarySettingsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(dictionarySettingsParams, "Parameter `dictionarySettingsParams` is required when calling `setDictionarySettings`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/dictionaries/*/settings").setMethod("PUT").setBody(dictionarySettingsParams).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> setDictionarySettingsAsync(@Nonnull DictionarySettingsParams dictionarySettingsParams) throws AlgoliaRuntimeException {
        return this.setDictionarySettingsAsync(dictionarySettingsParams, null);
    }

    public UpdatedAtResponse setSettings(@Nonnull String indexName, @Nonnull IndexSettings indexSettings, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.setSettingsAsync(indexName, indexSettings, forwardToReplicas, requestOptions));
    }

    public UpdatedAtResponse setSettings(@Nonnull String indexName, @Nonnull IndexSettings indexSettings, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.setSettings(indexName, indexSettings, forwardToReplicas, null);
    }

    public UpdatedAtResponse setSettings(@Nonnull String indexName, @Nonnull IndexSettings indexSettings, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.setSettings(indexName, indexSettings, null, requestOptions);
    }

    public UpdatedAtResponse setSettings(@Nonnull String indexName, @Nonnull IndexSettings indexSettings) throws AlgoliaRuntimeException {
        return this.setSettings(indexName, indexSettings, null, null);
    }

    public CompletableFuture<UpdatedAtResponse> setSettingsAsync(@Nonnull String indexName, @Nonnull IndexSettings indexSettings, Boolean forwardToReplicas, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `setSettings`.");
        Parameters.requireNonNull(indexSettings, "Parameter `indexSettings` is required when calling `setSettings`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/settings", indexName).setMethod("PUT").setBody(indexSettings).addQueryParameter("forwardToReplicas", forwardToReplicas).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdatedAtResponse>(){});
    }

    public CompletableFuture<UpdatedAtResponse> setSettingsAsync(@Nonnull String indexName, @Nonnull IndexSettings indexSettings, Boolean forwardToReplicas) throws AlgoliaRuntimeException {
        return this.setSettingsAsync(indexName, indexSettings, forwardToReplicas, null);
    }

    public CompletableFuture<UpdatedAtResponse> setSettingsAsync(@Nonnull String indexName, @Nonnull IndexSettings indexSettings, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.setSettingsAsync(indexName, indexSettings, null, requestOptions);
    }

    public CompletableFuture<UpdatedAtResponse> setSettingsAsync(@Nonnull String indexName, @Nonnull IndexSettings indexSettings) throws AlgoliaRuntimeException {
        return this.setSettingsAsync(indexName, indexSettings, null, null);
    }

    public UpdateApiKeyResponse updateApiKey(@Nonnull String key, @Nonnull ApiKey apiKey, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.updateApiKeyAsync(key, apiKey, requestOptions));
    }

    public UpdateApiKeyResponse updateApiKey(@Nonnull String key, @Nonnull ApiKey apiKey) throws AlgoliaRuntimeException {
        return this.updateApiKey(key, apiKey, null);
    }

    public CompletableFuture<UpdateApiKeyResponse> updateApiKeyAsync(@Nonnull String key, @Nonnull ApiKey apiKey, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(key, "Parameter `key` is required when calling `updateApiKey`.");
        Parameters.requireNonNull(apiKey, "Parameter `apiKey` is required when calling `updateApiKey`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/keys/{key}", key).setMethod("PUT").setBody(apiKey).build();
        return this.executeAsync(request, requestOptions, new TypeReference<UpdateApiKeyResponse>(){});
    }

    public CompletableFuture<UpdateApiKeyResponse> updateApiKeyAsync(@Nonnull String key, @Nonnull ApiKey apiKey) throws AlgoliaRuntimeException {
        return this.updateApiKeyAsync(key, apiKey, null);
    }

    public void waitForTask(String indexName, Long taskID, int maxRetries, IntUnaryOperator timeout, RequestOptions requestOptions) {
        TaskUtils.retryUntil(() -> this.getTask(indexName, taskID, requestOptions), task -> task.getStatus() == TaskStatus.PUBLISHED, maxRetries, timeout);
    }

    public void waitForTask(String indexName, Long taskID, RequestOptions requestOptions) {
        this.waitForTask(indexName, taskID, 50, TaskUtils.DEFAULT_TIMEOUT, requestOptions);
    }

    public void waitForTask(String indexName, Long taskID, int maxRetries, IntUnaryOperator timeout) {
        this.waitForTask(indexName, taskID, maxRetries, timeout, null);
    }

    public void waitForTask(String indexName, Long taskID) {
        this.waitForTask(indexName, taskID, 50, TaskUtils.DEFAULT_TIMEOUT, null);
    }

    public void waitForAppTask(Long taskID, int maxRetries, IntUnaryOperator timeout, RequestOptions requestOptions) {
        TaskUtils.retryUntil(() -> this.getAppTask(taskID, requestOptions), task -> task.getStatus() == TaskStatus.PUBLISHED, maxRetries, timeout);
    }

    public void waitForAppTask(Long taskID, RequestOptions requestOptions) {
        this.waitForAppTask(taskID, 50, TaskUtils.DEFAULT_TIMEOUT, requestOptions);
    }

    public void waitForAppTask(Long taskID, int maxRetries, IntUnaryOperator timeout) {
        this.waitForAppTask(taskID, maxRetries, timeout, null);
    }

    public void waitForAppTask(Long taskID) {
        this.waitForAppTask(taskID, 50, TaskUtils.DEFAULT_TIMEOUT, null);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, ApiKey apiKey, int maxRetries, IntUnaryOperator timeout, RequestOptions requestOptions) {
        if (operation == ApiKeyOperation.UPDATE) {
            if (apiKey == null) {
                throw new AlgoliaRuntimeException("`apiKey` is required when waiting for an `update` operation.");
            }
            return TaskUtils.retryUntil(() -> this.getApiKey(key, requestOptions), respKey -> {
                ApiKey sameType = new ApiKey().setAcl(respKey.getAcl()).setDescription(respKey.getDescription()).setIndexes(respKey.getIndexes()).setMaxHitsPerQuery(respKey.getMaxHitsPerQuery()).setMaxQueriesPerIPPerHour(respKey.getMaxQueriesPerIPPerHour()).setQueryParameters(respKey.getQueryParameters()).setReferers(respKey.getReferers()).setValidity(respKey.getValidity());
                return apiKey.equals(sameType);
            }, maxRetries, timeout);
        }
        GetApiKeyResponse[] addedKey = new GetApiKeyResponse[]{null};
        TaskUtils.retryUntil(() -> {
            try {
                addedKey[0] = this.getApiKey(key, requestOptions);
                return -2;
            }
            catch (AlgoliaApiException e) {
                return e.getStatusCode();
            }
        }, status -> {
            switch (operation) {
                case ADD: {
                    return status == -2 || status != 404;
                }
                case DELETE: {
                    return status == 404;
                }
            }
            return false;
        }, maxRetries, timeout);
        return addedKey[0];
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, int maxRetries, IntUnaryOperator timeout, RequestOptions requestOptions) {
        return this.waitForApiKey(operation, key, null, maxRetries, timeout, requestOptions);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, ApiKey apiKey, RequestOptions requestOptions) {
        return this.waitForApiKey(operation, key, apiKey, 50, TaskUtils.DEFAULT_TIMEOUT, requestOptions);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, RequestOptions requestOptions) {
        return this.waitForApiKey(operation, key, null, 50, TaskUtils.DEFAULT_TIMEOUT, requestOptions);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, ApiKey apiKey, int maxRetries, IntUnaryOperator timeout) {
        return this.waitForApiKey(operation, key, apiKey, maxRetries, timeout, null);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, int maxRetries, IntUnaryOperator timeout) {
        return this.waitForApiKey(operation, key, null, maxRetries, timeout, null);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key, ApiKey apiKey) {
        return this.waitForApiKey(operation, key, apiKey, 50, TaskUtils.DEFAULT_TIMEOUT, null);
    }

    public GetApiKeyResponse waitForApiKey(ApiKeyOperation operation, String key) {
        return this.waitForApiKey(operation, key, null, 50, TaskUtils.DEFAULT_TIMEOUT, null);
    }

    public <T> Iterable<T> browseObjects(String indexName, BrowseParamsObject params, Class<T> innerType, RequestOptions requestOptions) {
        Holder currentCursor = new Holder();
        return AlgoliaIterableHelper.createIterable(() -> {
            BrowseResponse response = this.browse(indexName, params, innerType, requestOptions);
            params.setCursor(response.getCursor());
            currentCursor.value = response.getCursor();
            return response.getHits().iterator();
        }, () -> currentCursor.value != null);
    }

    public <T> Iterable<T> browseObjects(String indexName, BrowseParamsObject params, Class<T> innerType) {
        return this.browseObjects(indexName, params, innerType, null);
    }

    public Iterable<SynonymHit> browseSynonyms(String indexName, SearchSynonymsParams params, RequestOptions requestOptions) {
        Holder<Integer> currentPage = new Holder<Integer>(0);
        params.setPage(0);
        params.setHitsPerPage(1000);
        return AlgoliaIterableHelper.createIterable(() -> {
            SearchSynonymsResponse response = this.searchSynonyms(indexName, params, requestOptions);
            currentPage.value = response.getNbHits() < params.getHitsPerPage() ? null : Integer.valueOf((Integer)currentPage.value + 1);
            return response.getHits().iterator();
        }, () -> currentPage.value != null);
    }

    public Iterable<SynonymHit> browseSynonyms(String indexName, SearchSynonymsParams params) {
        return this.browseSynonyms(indexName, params, null);
    }

    public Iterable<SynonymHit> browseSynonyms(String indexName) {
        return this.browseSynonyms(indexName, null, null);
    }

    public Iterable<Rule> browseRules(String indexName, SearchRulesParams params, RequestOptions requestOptions) {
        Holder<Integer> currentPage = new Holder<Integer>(0);
        int hitsPerPage = 1000;
        params.setHitsPerPage(1000);
        return AlgoliaIterableHelper.createIterable(() -> {
            SearchRulesResponse response = this.searchRules(indexName, params.setPage((Integer)currentPage.value), requestOptions);
            currentPage.value = response.getNbHits() < 1000 ? null : Integer.valueOf((Integer)currentPage.value + 1);
            return response.getHits().iterator();
        }, () -> currentPage.value != null);
    }

    public Iterable<Rule> browseRules(String indexName, SearchRulesParams params) {
        return this.browseRules(indexName, params, null);
    }

    public Iterable<Rule> browseRules(String indexName) {
        return this.browseRules(indexName, new SearchRulesParams(), null);
    }

    public <T> List<SearchResponse<T>> searchForHits(@Nonnull List<SearchForHits> requests, Class<T> innerType) {
        return LaunderThrowable.await(this.searchForHitsAsync(requests, null, innerType, null));
    }

    public <T> List<SearchResponse<T>> searchForHits(@Nonnull List<SearchForHits> requests, SearchStrategy strategy, Class<T> innerType) {
        return LaunderThrowable.await(this.searchForHitsAsync(requests, strategy, innerType, null));
    }

    public <T> List<SearchResponse<T>> searchForHits(@Nonnull List<SearchForHits> requests, SearchStrategy strategy, Class<T> innerType, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.searchForHitsAsync(requests, strategy, innerType, requestOptions));
    }

    public <T> CompletableFuture<List<SearchResponse<T>>> searchForHitsAsync(@Nonnull List<SearchForHits> requests, Class<T> innerType) {
        return this.searchForHitsAsync(requests, null, innerType, null);
    }

    public <T> CompletableFuture<List<SearchResponse<T>>> searchForHitsAsync(@Nonnull List<SearchForHits> requests, SearchStrategy strategy, Class<T> innerType) {
        return this.searchForHitsAsync(requests, strategy, innerType, null);
    }

    public <T> CompletableFuture<List<SearchResponse<T>>> searchForHitsAsync(@Nonnull List<SearchForHits> requests, SearchStrategy strategy, Class<T> innerType, RequestOptions requestOptions) {
        ArrayList<SearchQuery> searchQueries = new ArrayList<SearchQuery>(requests);
        SearchMethodParams params = new SearchMethodParams().setRequests(searchQueries).setStrategy(strategy);
        return this.searchAsync(params, innerType).thenApply(searchResponses -> searchResponses.getResults().stream().map(res -> (SearchResponse)res).collect(Collectors.toList()));
    }

    public List<SearchForFacetValuesResponse> searchForFacets(@Nonnull List<SearchForFacets> requests) {
        return LaunderThrowable.await(this.searchForFacetsAsync(requests, null, null));
    }

    public List<SearchForFacetValuesResponse> searchForFacets(@Nonnull List<SearchForFacets> requests, SearchStrategy strategy) {
        return LaunderThrowable.await(this.searchForFacetsAsync(requests, strategy, null));
    }

    public List<SearchForFacetValuesResponse> searchForFacets(@Nonnull List<SearchForFacets> requests, SearchStrategy strategy, RequestOptions requestOptions) {
        return LaunderThrowable.await(this.searchForFacetsAsync(requests, strategy, requestOptions));
    }

    public CompletableFuture<List<SearchForFacetValuesResponse>> searchForFacetsAsync(@Nonnull List<SearchForFacets> requests) {
        return this.searchForFacetsAsync(requests, null, null);
    }

    public CompletableFuture<List<SearchForFacetValuesResponse>> searchForFacetsAsync(@Nonnull List<SearchForFacets> requests, SearchStrategy strategy) {
        return this.searchForFacetsAsync(requests, strategy, null);
    }

    public CompletableFuture<List<SearchForFacetValuesResponse>> searchForFacetsAsync(@Nonnull List<SearchForFacets> requests, SearchStrategy strategy, RequestOptions requestOptions) {
        ArrayList<SearchQuery> searchQueries = new ArrayList<SearchQuery>(requests);
        SearchMethodParams params = new SearchMethodParams().setRequests(searchQueries).setStrategy(strategy);
        return this.searchAsync(params, Hit.class).thenApply(searchResponses -> searchResponses.getResults().stream().map(res -> (SearchForFacetValuesResponse)res).collect(Collectors.toList()));
    }

    public <T> List<BatchResponse> chunkedBatch(String indexName, Iterable<T> objects, Action action, boolean waitForTasks, int batchSize, RequestOptions requestOptions) {
        ArrayList<BatchResponse> responses = new ArrayList<BatchResponse>();
        ArrayList<BatchRequest> requests = new ArrayList<BatchRequest>();
        for (T item : objects) {
            if (requests.size() == batchSize) {
                BatchResponse batch = this.batch(indexName, new BatchWriteParams().setRequests(requests), requestOptions);
                responses.add(batch);
                requests.clear();
            }
            requests.add(new BatchRequest().setAction(action).setBody(item));
        }
        if (requests.size() > 0) {
            BatchResponse batch = this.batch(indexName, new BatchWriteParams().setRequests(requests), requestOptions);
            responses.add(batch);
        }
        if (waitForTasks) {
            responses.forEach(response -> this.waitForTask(indexName, response.getTaskID(), requestOptions));
        }
        return responses;
    }

    public <T> List<BatchResponse> chunkedBatch(String indexName, Iterable<T> objects, Action action, boolean waitForTasks) {
        return this.chunkedBatch(indexName, objects, action, waitForTasks, 1000, null);
    }

    public <T> List<BatchResponse> chunkedBatch(String indexName, Iterable<T> objects, Action action, boolean waitForTasks, int batchSize) {
        return this.chunkedBatch(indexName, objects, action, waitForTasks, batchSize, null);
    }

    public <T> List<BatchResponse> chunkedBatch(String indexName, Iterable<T> objects, Action action, boolean waitForTasks, RequestOptions requestOptions) {
        return this.chunkedBatch(indexName, objects, action, waitForTasks, 1000, requestOptions);
    }

    public <T> ReplaceAllObjectsResponse replaceAllObjects(String indexName, Iterable<T> objects, int batchSize) {
        return this.replaceAllObjects(indexName, objects, batchSize, null);
    }

    public <T> List<BatchResponse> saveObjects(String indexName, Iterable<T> objects, RequestOptions requestOptions) {
        return this.chunkedBatch(indexName, objects, Action.ADD_OBJECT, false, 1000, requestOptions);
    }

    public List<BatchResponse> deleteObjects(String indexName, List<String> objectIDs, RequestOptions requestOptions) {
        ArrayList objects = new ArrayList();
        for (String id : objectIDs) {
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("objectID", id);
            objects.add(obj);
        }
        return this.chunkedBatch(indexName, objects, Action.DELETE_OBJECT, false, 1000, requestOptions);
    }

    public <T> List<BatchResponse> partialUpdateObjects(String indexName, Iterable<T> objects, boolean createIfNotExists, RequestOptions requestOptions) {
        return this.chunkedBatch(indexName, objects, createIfNotExists ? Action.PARTIAL_UPDATE_OBJECT : Action.PARTIAL_UPDATE_OBJECT_NO_CREATE, false, 1000, requestOptions);
    }

    public <T> ReplaceAllObjectsResponse replaceAllObjects(String indexName, Iterable<T> objects, int batchSize, RequestOptions requestOptions) {
        Random rnd = new Random();
        String tmpIndexName = indexName + "_tmp_" + rnd.nextInt(100);
        UpdatedAtResponse copyOperationResponse = this.operationIndex(indexName, new OperationIndexParams().setOperation(OperationType.COPY).setDestination(tmpIndexName).addScope(ScopeType.SETTINGS).addScope(ScopeType.RULES).addScope(ScopeType.SYNONYMS), requestOptions);
        List<BatchResponse> batchResponses = this.chunkedBatch(tmpIndexName, objects, Action.ADD_OBJECT, true, batchSize, requestOptions);
        this.waitForTask(tmpIndexName, copyOperationResponse.getTaskID(), requestOptions);
        copyOperationResponse = this.operationIndex(indexName, new OperationIndexParams().setOperation(OperationType.COPY).setDestination(tmpIndexName).addScope(ScopeType.SETTINGS).addScope(ScopeType.RULES).addScope(ScopeType.SYNONYMS), requestOptions);
        this.waitForTask(tmpIndexName, copyOperationResponse.getTaskID(), requestOptions);
        UpdatedAtResponse moveOperationResponse = this.operationIndex(tmpIndexName, new OperationIndexParams().setOperation(OperationType.MOVE).setDestination(indexName), requestOptions);
        this.waitForTask(tmpIndexName, moveOperationResponse.getTaskID(), requestOptions);
        return new ReplaceAllObjectsResponse().setCopyOperationResponse(copyOperationResponse).setBatchResponses(batchResponses).setMoveOperationResponse(moveOperationResponse);
    }

    public String generateSecuredApiKey(@Nonnull String parentApiKey, @Nonnull SecuredApiKeyRestrictions restrictions) throws Exception {
        HashMap<String, String> restrictionsMap = new HashMap<String, String>();
        if (restrictions.getFilters() != null) {
            restrictionsMap.put("filters", StringUtils.paramToString(restrictions.getFilters()));
        }
        if (restrictions.getValidUntil() != 0L) {
            restrictionsMap.put("validUntil", StringUtils.paramToString(restrictions.getValidUntil()));
        }
        if (restrictions.getRestrictIndices() != null) {
            restrictionsMap.put("restrictIndices", StringUtils.paramToString(restrictions.getRestrictIndices()));
        }
        if (restrictions.getRestrictSources() != null) {
            restrictionsMap.put("restrictSources", StringUtils.paramToString(restrictions.getRestrictSources()));
        }
        if (restrictions.getUserToken() != null) {
            restrictionsMap.put("userToken", StringUtils.paramToString(restrictions.getUserToken()));
        }
        if (restrictions.getSearchParams() != null) {
            Map searchParamsMap = (Map)JsonSerializer.getObjectMapper().convertValue((Object)restrictions.getSearchParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            searchParamsMap.forEach((key, value) -> restrictionsMap.put((String)key, StringUtils.paramToString(value)));
        }
        String queryStr = restrictionsMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        String key2 = this.hmac(parentApiKey, queryStr);
        return new String(Base64.getEncoder().encode(String.format("%s%s", key2, queryStr).getBytes(Charset.forName("UTF8"))));
    }

    private String hmac(String key, String msg) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmac = Mac.getInstance("HmacSHA256");
        hmac.init(new SecretKeySpec(key.getBytes(), "HmacSHA256"));
        byte[] rawHmac = hmac.doFinal(msg.getBytes());
        StringBuilder sb = new StringBuilder(rawHmac.length * 2);
        for (byte b : rawHmac) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public Duration getSecuredApiKeyRemainingValidity(@Nonnull String securedApiKey) {
        if (securedApiKey == null || securedApiKey.trim().isEmpty()) {
            throw new AlgoliaRuntimeException("securedAPIKey must not be empty, null or whitespaces");
        }
        byte[] decodedBytes = Base64.getDecoder().decode(securedApiKey);
        String decodedString = new String(decodedBytes);
        Pattern pattern = Pattern.compile("validUntil=\\d+");
        Matcher matcher = pattern.matcher(decodedString);
        if (!matcher.find()) {
            throw new AlgoliaRuntimeException("The Secured API Key doesn't have a validUntil parameter.");
        }
        String validUntilMatch = matcher.group(0);
        long timeStamp = Long.parseLong(validUntilMatch.replace("validUntil=", ""));
        return Duration.ofSeconds(timeStamp - Instant.now().getEpochSecond());
    }
}

