// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.search;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/** BaseIndexSettings */
public class BaseIndexSettings {

  @JsonProperty("attributesForFaceting")
  private List<String> attributesForFaceting;

  @JsonProperty("replicas")
  private List<String> replicas;

  @JsonProperty("paginationLimitedTo")
  private Integer paginationLimitedTo;

  @JsonProperty("unretrievableAttributes")
  private List<String> unretrievableAttributes;

  @JsonProperty("disableTypoToleranceOnWords")
  private List<String> disableTypoToleranceOnWords;

  @JsonProperty("attributesToTransliterate")
  private List<String> attributesToTransliterate;

  @JsonProperty("camelCaseAttributes")
  private List<String> camelCaseAttributes;

  @JsonProperty("decompoundedAttributes")
  private Object decompoundedAttributes;

  @JsonProperty("indexLanguages")
  private List<SupportedLanguage> indexLanguages;

  @JsonProperty("disablePrefixOnAttributes")
  private List<String> disablePrefixOnAttributes;

  @JsonProperty("allowCompressionOfIntegerArray")
  private Boolean allowCompressionOfIntegerArray;

  @JsonProperty("numericAttributesForFiltering")
  private List<String> numericAttributesForFiltering;

  @JsonProperty("separatorsToIndex")
  private String separatorsToIndex;

  @JsonProperty("searchableAttributes")
  private List<String> searchableAttributes;

  @JsonProperty("userData")
  private Object userData;

  @JsonProperty("customNormalization")
  private Map<String, Map<String, String>> customNormalization;

  @JsonProperty("attributeForDistinct")
  private String attributeForDistinct;

  public BaseIndexSettings setAttributesForFaceting(List<String> attributesForFaceting) {
    this.attributesForFaceting = attributesForFaceting;
    return this;
  }

  public BaseIndexSettings addAttributesForFaceting(String attributesForFacetingItem) {
    if (this.attributesForFaceting == null) {
      this.attributesForFaceting = new ArrayList<>();
    }
    this.attributesForFaceting.add(attributesForFacetingItem);
    return this;
  }

  /**
   * Attributes used for
   * [faceting](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/).
   * Facets are attributes that let you categorize search results. They can be used for filtering
   * search results. By default, no attribute is used for faceting. Attribute names are
   * case-sensitive. **Modifiers** - `filterOnly(\"ATTRIBUTE\")`. Allows using this attribute as a
   * filter, but doesn't evalue the facet values. - `searchable(\"ATTRIBUTE\")`. Allows searching
   * for facet values. - `afterDistinct(\"ATTRIBUTE\")`. Evaluates the facet count _after_
   * deduplication with `distinct`. This ensures accurate facet counts. You can apply this modifier
   * to searchable facets: `afterDistinct(searchable(ATTRIBUTE))`.
   */
  @javax.annotation.Nullable
  public List<String> getAttributesForFaceting() {
    return attributesForFaceting;
  }

  public BaseIndexSettings setReplicas(List<String> replicas) {
    this.replicas = replicas;
    return this;
  }

  public BaseIndexSettings addReplicas(String replicasItem) {
    if (this.replicas == null) {
      this.replicas = new ArrayList<>();
    }
    this.replicas.add(replicasItem);
    return this;
  }

  /**
   * Creates [replica
   * indices](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/in-depth/replicas/).
   * Replicas are copies of a primary index with the same records but different settings, synonyms,
   * or rules. If you want to offer a different ranking or sorting of your search results, you'll
   * use replica indices. All index operations on a primary index are automatically forwarded to its
   * replicas. To add a replica index, you must provide the complete set of replicas to this
   * parameter. If you omit a replica from this list, the replica turns into a regular, standalone
   * index that will no longer by synced with the primary index. **Modifier** -
   * `virtual(\"REPLICA\")`. Create a virtual replica, Virtual replicas don't increase the number of
   * records and are optimized for [Relevant
   * sorting](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/in-depth/relevant-sort/).
   */
  @javax.annotation.Nullable
  public List<String> getReplicas() {
    return replicas;
  }

  public BaseIndexSettings setPaginationLimitedTo(Integer paginationLimitedTo) {
    this.paginationLimitedTo = paginationLimitedTo;
    return this;
  }

  /**
   * Maximum number of search results that can be obtained through pagination. Higher pagination
   * limits might slow down your search. For pagination limits above 1,000, the sorting of results
   * beyond the 1,000th hit can't be guaranteed. maximum: 20000
   */
  @javax.annotation.Nullable
  public Integer getPaginationLimitedTo() {
    return paginationLimitedTo;
  }

  public BaseIndexSettings setUnretrievableAttributes(List<String> unretrievableAttributes) {
    this.unretrievableAttributes = unretrievableAttributes;
    return this;
  }

  public BaseIndexSettings addUnretrievableAttributes(String unretrievableAttributesItem) {
    if (this.unretrievableAttributes == null) {
      this.unretrievableAttributes = new ArrayList<>();
    }
    this.unretrievableAttributes.add(unretrievableAttributesItem);
    return this;
  }

  /**
   * Attributes that can't be retrieved at query time. This can be useful if you want to use an
   * attribute for ranking or to [restrict
   * access](https://www.algolia.com/doc/guides/security/api-keys/how-to/user-restricted-access-to-data/),
   * but don't want to include it in the search results. Attribute names are case-sensitive.
   */
  @javax.annotation.Nullable
  public List<String> getUnretrievableAttributes() {
    return unretrievableAttributes;
  }

  public BaseIndexSettings setDisableTypoToleranceOnWords(List<String> disableTypoToleranceOnWords) {
    this.disableTypoToleranceOnWords = disableTypoToleranceOnWords;
    return this;
  }

  public BaseIndexSettings addDisableTypoToleranceOnWords(String disableTypoToleranceOnWordsItem) {
    if (this.disableTypoToleranceOnWords == null) {
      this.disableTypoToleranceOnWords = new ArrayList<>();
    }
    this.disableTypoToleranceOnWords.add(disableTypoToleranceOnWordsItem);
    return this;
  }

  /**
   * Words for which you want to turn off [typo
   * tolerance](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/).
   * This also turns off [word splitting and
   * concatenation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/splitting-and-concatenation/)
   * for the specified words.
   */
  @javax.annotation.Nullable
  public List<String> getDisableTypoToleranceOnWords() {
    return disableTypoToleranceOnWords;
  }

  public BaseIndexSettings setAttributesToTransliterate(List<String> attributesToTransliterate) {
    this.attributesToTransliterate = attributesToTransliterate;
    return this;
  }

  public BaseIndexSettings addAttributesToTransliterate(String attributesToTransliterateItem) {
    if (this.attributesToTransliterate == null) {
      this.attributesToTransliterate = new ArrayList<>();
    }
    this.attributesToTransliterate.add(attributesToTransliterateItem);
    return this;
  }

  /**
   * Attributes, for which you want to support [Japanese
   * transliteration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/#japanese-transliteration-and-type-ahead).
   * Transliteration supports searching in any of the Japanese writing systems. To support
   * transliteration, you must set the indexing language to Japanese. Attribute names are
   * case-sensitive.
   */
  @javax.annotation.Nullable
  public List<String> getAttributesToTransliterate() {
    return attributesToTransliterate;
  }

  public BaseIndexSettings setCamelCaseAttributes(List<String> camelCaseAttributes) {
    this.camelCaseAttributes = camelCaseAttributes;
    return this;
  }

  public BaseIndexSettings addCamelCaseAttributes(String camelCaseAttributesItem) {
    if (this.camelCaseAttributes == null) {
      this.camelCaseAttributes = new ArrayList<>();
    }
    this.camelCaseAttributes.add(camelCaseAttributesItem);
    return this;
  }

  /**
   * Attributes for which to split [camel case](https://wikipedia.org/wiki/Camel_case) words.
   * Attribute names are case-sensitive.
   */
  @javax.annotation.Nullable
  public List<String> getCamelCaseAttributes() {
    return camelCaseAttributes;
  }

  public BaseIndexSettings setDecompoundedAttributes(Object decompoundedAttributes) {
    this.decompoundedAttributes = decompoundedAttributes;
    return this;
  }

  /**
   * Searchable attributes to which Algolia should apply [word
   * segmentation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/)
   * (decompounding). Attribute names are case-sensitive. Compound words are formed by combining two
   * or more individual words, and are particularly prevalent in Germanic languages—for example,
   * \"firefighter\". With decompounding, the individual components are indexed separately. You can
   * specify different lists for different languages. Decompounding is supported for these
   * languages: Dutch (`nl`), German (`de`), Finnish (`fi`), Danish (`da`), Swedish (`sv`), and
   * Norwegian (`no`).
   */
  @javax.annotation.Nullable
  public Object getDecompoundedAttributes() {
    return decompoundedAttributes;
  }

  public BaseIndexSettings setIndexLanguages(List<SupportedLanguage> indexLanguages) {
    this.indexLanguages = indexLanguages;
    return this;
  }

  public BaseIndexSettings addIndexLanguages(SupportedLanguage indexLanguagesItem) {
    if (this.indexLanguages == null) {
      this.indexLanguages = new ArrayList<>();
    }
    this.indexLanguages.add(indexLanguagesItem);
    return this;
  }

  /**
   * Languages for language-specific processing steps, such as word detection and dictionary
   * settings. **You should always specify an indexing language.** If you don't specify an indexing
   * language, the search engine uses all [supported
   * languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/),
   * or the languages you specified with the `ignorePlurals` or `removeStopWords` parameters. This
   * can lead to unexpected search results. For more information, see [Language-specific
   * configuration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/).
   */
  @javax.annotation.Nullable
  public List<SupportedLanguage> getIndexLanguages() {
    return indexLanguages;
  }

  public BaseIndexSettings setDisablePrefixOnAttributes(List<String> disablePrefixOnAttributes) {
    this.disablePrefixOnAttributes = disablePrefixOnAttributes;
    return this;
  }

  public BaseIndexSettings addDisablePrefixOnAttributes(String disablePrefixOnAttributesItem) {
    if (this.disablePrefixOnAttributes == null) {
      this.disablePrefixOnAttributes = new ArrayList<>();
    }
    this.disablePrefixOnAttributes.add(disablePrefixOnAttributesItem);
    return this;
  }

  /**
   * Searchable attributes for which you want to turn off [prefix
   * matching](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/override-search-engine-defaults/#adjusting-prefix-search).
   * Attribute names are case-sensitive.
   */
  @javax.annotation.Nullable
  public List<String> getDisablePrefixOnAttributes() {
    return disablePrefixOnAttributes;
  }

  public BaseIndexSettings setAllowCompressionOfIntegerArray(Boolean allowCompressionOfIntegerArray) {
    this.allowCompressionOfIntegerArray = allowCompressionOfIntegerArray;
    return this;
  }

  /**
   * Whether arrays with exclusively non-negative integers should be compressed for better
   * performance. If true, the compressed arrays may be reordered.
   */
  @javax.annotation.Nullable
  public Boolean getAllowCompressionOfIntegerArray() {
    return allowCompressionOfIntegerArray;
  }

  public BaseIndexSettings setNumericAttributesForFiltering(List<String> numericAttributesForFiltering) {
    this.numericAttributesForFiltering = numericAttributesForFiltering;
    return this;
  }

  public BaseIndexSettings addNumericAttributesForFiltering(String numericAttributesForFilteringItem) {
    if (this.numericAttributesForFiltering == null) {
      this.numericAttributesForFiltering = new ArrayList<>();
    }
    this.numericAttributesForFiltering.add(numericAttributesForFilteringItem);
    return this;
  }

  /**
   * Numeric attributes that can be used as [numerical
   * filters](https://www.algolia.com/doc/guides/managing-results/rules/detecting-intent/how-to/applying-a-custom-filter-for-a-specific-query/#numerical-filters).
   * Attribute names are case-sensitive. By default, all numeric attributes are available as
   * numerical filters. For faster indexing, reduce the number of numeric attributes. If you want to
   * turn off filtering for all numeric attributes, specifiy an attribute that doesn't exist in your
   * index, such as `NO_NUMERIC_FILTERING`. **Modifier** - `equalOnly(\"ATTRIBUTE\")`. Support only
   * filtering based on equality comparisons `=` and `!=`.
   */
  @javax.annotation.Nullable
  public List<String> getNumericAttributesForFiltering() {
    return numericAttributesForFiltering;
  }

  public BaseIndexSettings setSeparatorsToIndex(String separatorsToIndex) {
    this.separatorsToIndex = separatorsToIndex;
    return this;
  }

  /**
   * Controls which separators are indexed. Separators are all non-letter characters except spaces
   * and currency characters, such as $€£¥. By default, separator characters aren't indexed. With
   * `separatorsToIndex`, Algolia treats separator characters as separate words. For example, a
   * search for `C#` would report two matches.
   */
  @javax.annotation.Nullable
  public String getSeparatorsToIndex() {
    return separatorsToIndex;
  }

  public BaseIndexSettings setSearchableAttributes(List<String> searchableAttributes) {
    this.searchableAttributes = searchableAttributes;
    return this;
  }

  public BaseIndexSettings addSearchableAttributes(String searchableAttributesItem) {
    if (this.searchableAttributes == null) {
      this.searchableAttributes = new ArrayList<>();
    }
    this.searchableAttributes.add(searchableAttributesItem);
    return this;
  }

  /**
   * Attributes used for searching. Attribute names are case-sensitive. By default, all attributes
   * are searchable and the
   * [Attribute](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#attribute)
   * ranking criterion is turned off. With a non-empty list, Algolia only returns results with
   * matches in the selected attributes. In addition, the Attribute ranking criterion is turned on:
   * matches in attributes that are higher in the list of `searchableAttributes` rank first. To make
   * matches in two attributes rank equally, include them in a comma-separated string, such as
   * `\"title,alternate_title\"`. Attributes with the same priority are always unordered. For more
   * information, see [Searchable
   * attributes](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/setting-searchable-attributes/).
   * **Modifier** - `unordered(\"ATTRIBUTE\")`. Ignore the position of a match within the attribute.
   * Without modifier, matches at the beginning of an attribute rank higer than matches at the end.
   */
  @javax.annotation.Nullable
  public List<String> getSearchableAttributes() {
    return searchableAttributes;
  }

  public BaseIndexSettings setUserData(Object userData) {
    this.userData = userData;
    return this;
  }

  /** An object with custom data. You can store up to 32kB as custom data. */
  @javax.annotation.Nullable
  public Object getUserData() {
    return userData;
  }

  public BaseIndexSettings setCustomNormalization(Map<String, Map<String, String>> customNormalization) {
    this.customNormalization = customNormalization;
    return this;
  }

  public BaseIndexSettings putCustomNormalization(String key, Map<String, String> customNormalizationItem) {
    if (this.customNormalization == null) {
      this.customNormalization = new HashMap<>();
    }
    this.customNormalization.put(key, customNormalizationItem);
    return this;
  }

  /**
   * Characters and their normalized replacements. This overrides Algolia's default
   * [normalization](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/normalization/).
   */
  @javax.annotation.Nullable
  public Map<String, Map<String, String>> getCustomNormalization() {
    return customNormalization;
  }

  public BaseIndexSettings setAttributeForDistinct(String attributeForDistinct) {
    this.attributeForDistinct = attributeForDistinct;
    return this;
  }

  /**
   * Attribute that should be used to establish groups of results. Attribute names are
   * case-sensitive. All records with the same value for this attribute are considered a group. You
   * can combine `attributeForDistinct` with the `distinct` search parameter to control how many
   * items per group are included in the search results. If you want to use the same attribute also
   * for faceting, use the `afterDistinct` modifier of the `attributesForFaceting` setting. This
   * applies faceting _after_ deduplication, which will result in accurate facet counts.
   */
  @javax.annotation.Nullable
  public String getAttributeForDistinct() {
    return attributeForDistinct;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BaseIndexSettings baseIndexSettings = (BaseIndexSettings) o;
    return (
      Objects.equals(this.attributesForFaceting, baseIndexSettings.attributesForFaceting) &&
      Objects.equals(this.replicas, baseIndexSettings.replicas) &&
      Objects.equals(this.paginationLimitedTo, baseIndexSettings.paginationLimitedTo) &&
      Objects.equals(this.unretrievableAttributes, baseIndexSettings.unretrievableAttributes) &&
      Objects.equals(this.disableTypoToleranceOnWords, baseIndexSettings.disableTypoToleranceOnWords) &&
      Objects.equals(this.attributesToTransliterate, baseIndexSettings.attributesToTransliterate) &&
      Objects.equals(this.camelCaseAttributes, baseIndexSettings.camelCaseAttributes) &&
      Objects.equals(this.decompoundedAttributes, baseIndexSettings.decompoundedAttributes) &&
      Objects.equals(this.indexLanguages, baseIndexSettings.indexLanguages) &&
      Objects.equals(this.disablePrefixOnAttributes, baseIndexSettings.disablePrefixOnAttributes) &&
      Objects.equals(this.allowCompressionOfIntegerArray, baseIndexSettings.allowCompressionOfIntegerArray) &&
      Objects.equals(this.numericAttributesForFiltering, baseIndexSettings.numericAttributesForFiltering) &&
      Objects.equals(this.separatorsToIndex, baseIndexSettings.separatorsToIndex) &&
      Objects.equals(this.searchableAttributes, baseIndexSettings.searchableAttributes) &&
      Objects.equals(this.userData, baseIndexSettings.userData) &&
      Objects.equals(this.customNormalization, baseIndexSettings.customNormalization) &&
      Objects.equals(this.attributeForDistinct, baseIndexSettings.attributeForDistinct)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(
      attributesForFaceting,
      replicas,
      paginationLimitedTo,
      unretrievableAttributes,
      disableTypoToleranceOnWords,
      attributesToTransliterate,
      camelCaseAttributes,
      decompoundedAttributes,
      indexLanguages,
      disablePrefixOnAttributes,
      allowCompressionOfIntegerArray,
      numericAttributesForFiltering,
      separatorsToIndex,
      searchableAttributes,
      userData,
      customNormalization,
      attributeForDistinct
    );
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BaseIndexSettings {\n");
    sb.append("    attributesForFaceting: ").append(toIndentedString(attributesForFaceting)).append("\n");
    sb.append("    replicas: ").append(toIndentedString(replicas)).append("\n");
    sb.append("    paginationLimitedTo: ").append(toIndentedString(paginationLimitedTo)).append("\n");
    sb.append("    unretrievableAttributes: ").append(toIndentedString(unretrievableAttributes)).append("\n");
    sb.append("    disableTypoToleranceOnWords: ").append(toIndentedString(disableTypoToleranceOnWords)).append("\n");
    sb.append("    attributesToTransliterate: ").append(toIndentedString(attributesToTransliterate)).append("\n");
    sb.append("    camelCaseAttributes: ").append(toIndentedString(camelCaseAttributes)).append("\n");
    sb.append("    decompoundedAttributes: ").append(toIndentedString(decompoundedAttributes)).append("\n");
    sb.append("    indexLanguages: ").append(toIndentedString(indexLanguages)).append("\n");
    sb.append("    disablePrefixOnAttributes: ").append(toIndentedString(disablePrefixOnAttributes)).append("\n");
    sb.append("    allowCompressionOfIntegerArray: ").append(toIndentedString(allowCompressionOfIntegerArray)).append("\n");
    sb.append("    numericAttributesForFiltering: ").append(toIndentedString(numericAttributesForFiltering)).append("\n");
    sb.append("    separatorsToIndex: ").append(toIndentedString(separatorsToIndex)).append("\n");
    sb.append("    searchableAttributes: ").append(toIndentedString(searchableAttributes)).append("\n");
    sb.append("    userData: ").append(toIndentedString(userData)).append("\n");
    sb.append("    customNormalization: ").append(toIndentedString(customNormalization)).append("\n");
    sb.append("    attributeForDistinct: ").append(toIndentedString(attributeForDistinct)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
