/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.querysuggestions;

import com.algolia.model.querysuggestions.Languages;
import com.algolia.model.querysuggestions.SourceIndex;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Configuration {
    @JsonProperty(value="sourceIndices")
    private List<SourceIndex> sourceIndices = new ArrayList<SourceIndex>();
    @JsonProperty(value="languages")
    private Languages languages;
    @JsonProperty(value="exclude")
    private List<String> exclude;
    @JsonProperty(value="enablePersonalization")
    private Boolean enablePersonalization;
    @JsonProperty(value="allowSpecialCharacters")
    private Boolean allowSpecialCharacters;

    public Configuration setSourceIndices(List<SourceIndex> sourceIndices) {
        this.sourceIndices = sourceIndices;
        return this;
    }

    public Configuration addSourceIndices(SourceIndex sourceIndicesItem) {
        this.sourceIndices.add(sourceIndicesItem);
        return this;
    }

    @Nonnull
    public List<SourceIndex> getSourceIndices() {
        return this.sourceIndices;
    }

    public Configuration setLanguages(Languages languages) {
        this.languages = languages;
        return this;
    }

    @Nullable
    public Languages getLanguages() {
        return this.languages;
    }

    public Configuration setExclude(List<String> exclude) {
        this.exclude = exclude;
        return this;
    }

    public Configuration addExclude(String excludeItem) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<String>();
        }
        this.exclude.add(excludeItem);
        return this;
    }

    @Nullable
    public List<String> getExclude() {
        return this.exclude;
    }

    public Configuration setEnablePersonalization(Boolean enablePersonalization) {
        this.enablePersonalization = enablePersonalization;
        return this;
    }

    @Nullable
    public Boolean getEnablePersonalization() {
        return this.enablePersonalization;
    }

    public Configuration setAllowSpecialCharacters(Boolean allowSpecialCharacters) {
        this.allowSpecialCharacters = allowSpecialCharacters;
        return this;
    }

    @Nullable
    public Boolean getAllowSpecialCharacters() {
        return this.allowSpecialCharacters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration configuration = (Configuration)o;
        return Objects.equals(this.sourceIndices, configuration.sourceIndices) && Objects.equals(this.languages, configuration.languages) && Objects.equals(this.exclude, configuration.exclude) && Objects.equals(this.enablePersonalization, configuration.enablePersonalization) && Objects.equals(this.allowSpecialCharacters, configuration.allowSpecialCharacters);
    }

    public int hashCode() {
        return Objects.hash(this.sourceIndices, this.languages, this.exclude, this.enablePersonalization, this.allowSpecialCharacters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Configuration {\n");
        sb.append("    sourceIndices: ").append(this.toIndentedString(this.sourceIndices)).append("\n");
        sb.append("    languages: ").append(this.toIndentedString(this.languages)).append("\n");
        sb.append("    exclude: ").append(this.toIndentedString(this.exclude)).append("\n");
        sb.append("    enablePersonalization: ").append(this.toIndentedString(this.enablePersonalization)).append("\n");
        sb.append("    allowSpecialCharacters: ").append(this.toIndentedString(this.allowSpecialCharacters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

