/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.model.search.DictionaryEntryState;
import com.algolia.model.search.SupportedLanguage;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DictionaryEntry {
    @JsonProperty(value="objectID")
    private String objectID;
    @JsonProperty(value="language")
    private SupportedLanguage language;
    @JsonProperty(value="word")
    private String word;
    @JsonProperty(value="words")
    private List<String> words;
    @JsonProperty(value="decomposition")
    private List<String> decomposition;
    @JsonProperty(value="state")
    private DictionaryEntryState state;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public DictionaryEntry setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public DictionaryEntry setObjectID(String objectID) {
        this.objectID = objectID;
        return this;
    }

    @Nonnull
    public String getObjectID() {
        return this.objectID;
    }

    public DictionaryEntry setLanguage(SupportedLanguage language) {
        this.language = language;
        return this;
    }

    @Nonnull
    public SupportedLanguage getLanguage() {
        return this.language;
    }

    public DictionaryEntry setWord(String word) {
        this.word = word;
        return this;
    }

    @Nullable
    public String getWord() {
        return this.word;
    }

    public DictionaryEntry setWords(List<String> words) {
        this.words = words;
        return this;
    }

    public DictionaryEntry addWords(String wordsItem) {
        if (this.words == null) {
            this.words = new ArrayList<String>();
        }
        this.words.add(wordsItem);
        return this;
    }

    @Nullable
    public List<String> getWords() {
        return this.words;
    }

    public DictionaryEntry setDecomposition(List<String> decomposition) {
        this.decomposition = decomposition;
        return this;
    }

    public DictionaryEntry addDecomposition(String decompositionItem) {
        if (this.decomposition == null) {
            this.decomposition = new ArrayList<String>();
        }
        this.decomposition.add(decompositionItem);
        return this;
    }

    @Nullable
    public List<String> getDecomposition() {
        return this.decomposition;
    }

    public DictionaryEntry setState(DictionaryEntryState state) {
        this.state = state;
        return this;
    }

    @Nullable
    public DictionaryEntryState getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DictionaryEntry dictionaryEntry = (DictionaryEntry)o;
        return Objects.equals(this.objectID, dictionaryEntry.objectID) && Objects.equals((Object)this.language, (Object)dictionaryEntry.language) && Objects.equals(this.word, dictionaryEntry.word) && Objects.equals(this.words, dictionaryEntry.words) && Objects.equals(this.decomposition, dictionaryEntry.decomposition) && Objects.equals((Object)this.state, (Object)dictionaryEntry.state) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.objectID, this.language, this.word, this.words, this.decomposition, this.state, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DictionaryEntry {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    objectID: ").append(this.toIndentedString(this.objectID)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    word: ").append(this.toIndentedString(this.word)).append("\n");
        sb.append("    words: ").append(this.toIndentedString(this.words)).append("\n");
        sb.append("    decomposition: ").append(this.toIndentedString(this.decomposition)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

