// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.monitoring.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MonitoringClient extends ApiClient {

  public MonitoringClient(String appId, String apiKey) {
    this(appId, apiKey, null);
  }

  public MonitoringClient(String appId, String apiKey, ClientOptions options) {
    super(appId, apiKey, "Monitoring", options, getDefaultHosts(appId));
  }

  private static List<Host> getDefaultHosts(String appId) {
    List<Host> hosts = new ArrayList<>();
    hosts.add(new Host(appId + "-dsn.algolia.net", EnumSet.of(CallType.READ)));
    hosts.add(new Host(appId + ".algolia.net", EnumSet.of(CallType.WRITE)));

    List<Host> commonHosts = new ArrayList<>();
    hosts.add(new Host(appId + "-1.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
    hosts.add(new Host(appId + "-2.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
    hosts.add(new Host(appId + "-3.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));

    Collections.shuffle(commonHosts, new Random());

    return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(delAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.del(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.del(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(String path) throws AlgoliaRuntimeException {
    return this.del(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (path == null) {
      throw new AlgoliaRuntimeException("Parameter `path` is required when calling `del`.");
    }

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.delAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.delAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(String path) throws AlgoliaRuntimeException {
    return this.delAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.get(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.get(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(String path) throws AlgoliaRuntimeException {
    return this.get(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (path == null) {
      throw new AlgoliaRuntimeException("Parameter `path` is required when calling `get`.");
    }

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.getAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(String path) throws AlgoliaRuntimeException {
    return this.getAsync(path, null, null);
  }

  /**
   * List known incidents for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IncidentsResponse getClusterIncidents(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getClusterIncidentsAsync(clusters, requestOptions));
  }

  /**
   * List known incidents for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IncidentsResponse getClusterIncidents(String clusters) throws AlgoliaRuntimeException {
    return this.getClusterIncidents(clusters, null);
  }

  /**
   * (asynchronously) List known incidents for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IncidentsResponse> getClusterIncidentsAsync(String clusters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (clusters == null) {
      throw new AlgoliaRuntimeException("Parameter `clusters` is required when calling `getClusterIncidents`.");
    }

    HttpRequest request = HttpRequest.builder().setPath("/1/incidents/{clusters}", clusters).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<IncidentsResponse>() {});
  }

  /**
   * (asynchronously) List known incidents for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IncidentsResponse> getClusterIncidentsAsync(String clusters) throws AlgoliaRuntimeException {
    return this.getClusterIncidentsAsync(clusters, null);
  }

  /**
   * Report whether a cluster is operational.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public StatusResponse getClusterStatus(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getClusterStatusAsync(clusters, requestOptions));
  }

  /**
   * Report whether a cluster is operational.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public StatusResponse getClusterStatus(String clusters) throws AlgoliaRuntimeException {
    return this.getClusterStatus(clusters, null);
  }

  /**
   * (asynchronously) Report whether a cluster is operational.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<StatusResponse> getClusterStatusAsync(String clusters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (clusters == null) {
      throw new AlgoliaRuntimeException("Parameter `clusters` is required when calling `getClusterStatus`.");
    }

    HttpRequest request = HttpRequest.builder().setPath("/1/status/{clusters}", clusters).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<StatusResponse>() {});
  }

  /**
   * (asynchronously) Report whether a cluster is operational.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<StatusResponse> getClusterStatusAsync(String clusters) throws AlgoliaRuntimeException {
    return this.getClusterStatusAsync(clusters, null);
  }

  /**
   * List known incidents for all clusters.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IncidentsResponse getIncidents(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getIncidentsAsync(requestOptions));
  }

  /**
   * List known incidents for all clusters.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IncidentsResponse getIncidents() throws AlgoliaRuntimeException {
    return this.getIncidents(null);
  }

  /**
   * (asynchronously) List known incidents for all clusters.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IncidentsResponse> getIncidentsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/incidents").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<IncidentsResponse>() {});
  }

  /**
   * (asynchronously) List known incidents for all clusters.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IncidentsResponse> getIncidentsAsync() throws AlgoliaRuntimeException {
    return this.getIncidentsAsync(null);
  }

  /**
   * List the average times for indexing operations for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexingTimeResponse getIndexingTime(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getIndexingTimeAsync(clusters, requestOptions));
  }

  /**
   * List the average times for indexing operations for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexingTimeResponse getIndexingTime(String clusters) throws AlgoliaRuntimeException {
    return this.getIndexingTime(clusters, null);
  }

  /**
   * (asynchronously) List the average times for indexing operations for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexingTimeResponse> getIndexingTimeAsync(String clusters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (clusters == null) {
      throw new AlgoliaRuntimeException("Parameter `clusters` is required when calling `getIndexingTime`.");
    }

    HttpRequest request = HttpRequest.builder().setPath("/1/indexing/{clusters}", clusters).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<IndexingTimeResponse>() {});
  }

  /**
   * (asynchronously) List the average times for indexing operations for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexingTimeResponse> getIndexingTimeAsync(String clusters) throws AlgoliaRuntimeException {
    return this.getIndexingTimeAsync(clusters, null);
  }

  /**
   * List the servers belonging to clusters. The response depends on whether you authenticate your
   * API request: - With authentication, the response lists the servers assigned to your Algolia
   * application's cluster. - Without authentication, the response lists the servers for all Algolia
   * clusters.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public InventoryResponse getInventory(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getInventoryAsync(requestOptions));
  }

  /**
   * List the servers belonging to clusters. The response depends on whether you authenticate your
   * API request: - With authentication, the response lists the servers assigned to your Algolia
   * application's cluster. - Without authentication, the response lists the servers for all Algolia
   * clusters.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public InventoryResponse getInventory() throws AlgoliaRuntimeException {
    return this.getInventory(null);
  }

  /**
   * (asynchronously) List the servers belonging to clusters. The response depends on whether you
   * authenticate your API request: - With authentication, the response lists the servers assigned
   * to your Algolia application&#39;s cluster. - Without authentication, the response lists the
   * servers for all Algolia clusters.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<InventoryResponse> getInventoryAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/inventory/servers").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<InventoryResponse>() {});
  }

  /**
   * (asynchronously) List the servers belonging to clusters. The response depends on whether you
   * authenticate your API request: - With authentication, the response lists the servers assigned
   * to your Algolia application&#39;s cluster. - Without authentication, the response lists the
   * servers for all Algolia clusters.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<InventoryResponse> getInventoryAsync() throws AlgoliaRuntimeException {
    return this.getInventoryAsync(null);
  }

  /**
   * List the average latency for search requests for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public LatencyResponse getLatency(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getLatencyAsync(clusters, requestOptions));
  }

  /**
   * List the average latency for search requests for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public LatencyResponse getLatency(String clusters) throws AlgoliaRuntimeException {
    return this.getLatency(clusters, null);
  }

  /**
   * (asynchronously) List the average latency for search requests for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<LatencyResponse> getLatencyAsync(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    if (clusters == null) {
      throw new AlgoliaRuntimeException("Parameter `clusters` is required when calling `getLatency`.");
    }

    HttpRequest request = HttpRequest.builder().setPath("/1/latency/{clusters}", clusters).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<LatencyResponse>() {});
  }

  /**
   * (asynchronously) List the average latency for search requests for selected clusters.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<LatencyResponse> getLatencyAsync(String clusters) throws AlgoliaRuntimeException {
    return this.getLatencyAsync(clusters, null);
  }

  /**
   * Report the aggregate value of a metric for a selected period of time.
   *
   * @param metric Metric to report. For more information about the individual metrics, see the
   *     response. To include all metrics, use `*` as the parameter. (required)
   * @param period Period over which to aggregate the metrics: - `minute`. Aggregate the last
   *     minute. 1 data point per 10 seconds. - `hour`. Aggregate the last hour. 1 data point per
   *     minute. - `day`. Aggregate the last day. 1 data point per 10 minutes. - `week`. Aggregate
   *     the last week. 1 data point per hour. - `month`. Aggregate the last month. 1 data point per
   *     day. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public InfrastructureResponse getMetrics(Metric metric, Period period, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getMetricsAsync(metric, period, requestOptions));
  }

  /**
   * Report the aggregate value of a metric for a selected period of time.
   *
   * @param metric Metric to report. For more information about the individual metrics, see the
   *     response. To include all metrics, use `*` as the parameter. (required)
   * @param period Period over which to aggregate the metrics: - `minute`. Aggregate the last
   *     minute. 1 data point per 10 seconds. - `hour`. Aggregate the last hour. 1 data point per
   *     minute. - `day`. Aggregate the last day. 1 data point per 10 minutes. - `week`. Aggregate
   *     the last week. 1 data point per hour. - `month`. Aggregate the last month. 1 data point per
   *     day. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public InfrastructureResponse getMetrics(Metric metric, Period period) throws AlgoliaRuntimeException {
    return this.getMetrics(metric, period, null);
  }

  /**
   * (asynchronously) Report the aggregate value of a metric for a selected period of time.
   *
   * @param metric Metric to report. For more information about the individual metrics, see the
   *     response. To include all metrics, use `*` as the parameter. (required)
   * @param period Period over which to aggregate the metrics: - `minute`. Aggregate the last
   *     minute. 1 data point per 10 seconds. - `hour`. Aggregate the last hour. 1 data point per
   *     minute. - `day`. Aggregate the last day. 1 data point per 10 minutes. - `week`. Aggregate
   *     the last week. 1 data point per hour. - `month`. Aggregate the last month. 1 data point per
   *     day. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<InfrastructureResponse> getMetricsAsync(Metric metric, Period period, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (metric == null) {
      throw new AlgoliaRuntimeException("Parameter `metric` is required when calling `getMetrics`.");
    }

    if (period == null) {
      throw new AlgoliaRuntimeException("Parameter `period` is required when calling `getMetrics`.");
    }

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/infrastructure/{metric}/period/{period}", metric, period)
      .setMethod("GET")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<InfrastructureResponse>() {});
  }

  /**
   * (asynchronously) Report the aggregate value of a metric for a selected period of time.
   *
   * @param metric Metric to report. For more information about the individual metrics, see the
   *     response. To include all metrics, use `*` as the parameter. (required)
   * @param period Period over which to aggregate the metrics: - `minute`. Aggregate the last
   *     minute. 1 data point per 10 seconds. - `hour`. Aggregate the last hour. 1 data point per
   *     minute. - `day`. Aggregate the last day. 1 data point per 10 minutes. - `week`. Aggregate
   *     the last week. 1 data point per hour. - `month`. Aggregate the last month. 1 data point per
   *     day. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<InfrastructureResponse> getMetricsAsync(Metric metric, Period period) throws AlgoliaRuntimeException {
    return this.getMetricsAsync(metric, period, null);
  }

  /**
   * Test whether clusters are reachable or not.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Map<String, Map<String, Boolean>> getReachability(String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getReachabilityAsync(clusters, requestOptions));
  }

  /**
   * Test whether clusters are reachable or not.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Map<String, Map<String, Boolean>> getReachability(String clusters) throws AlgoliaRuntimeException {
    return this.getReachability(clusters, null);
  }

  /**
   * (asynchronously) Test whether clusters are reachable or not.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Map<String, Map<String, Boolean>>> getReachabilityAsync(String clusters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (clusters == null) {
      throw new AlgoliaRuntimeException("Parameter `clusters` is required when calling `getReachability`.");
    }

    HttpRequest request = HttpRequest.builder().setPath("/1/reachability/{clusters}/probes", clusters).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<Map<String, Map<String, Boolean>>>() {});
  }

  /**
   * (asynchronously) Test whether clusters are reachable or not.
   *
   * @param clusters Subset of clusters, separated by comma. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Map<String, Map<String, Boolean>>> getReachabilityAsync(String clusters) throws AlgoliaRuntimeException {
    return this.getReachabilityAsync(clusters, null);
  }

  /**
   * Report whether clusters are operational. The response depends on whether you authenticate your
   * API request. - With authentication, the response includes the status of the cluster assigned to
   * your Algolia application. - Without authentication, the response lists the statuses of all
   * public Algolia clusters.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public StatusResponse getStatus(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getStatusAsync(requestOptions));
  }

  /**
   * Report whether clusters are operational. The response depends on whether you authenticate your
   * API request. - With authentication, the response includes the status of the cluster assigned to
   * your Algolia application. - Without authentication, the response lists the statuses of all
   * public Algolia clusters.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public StatusResponse getStatus() throws AlgoliaRuntimeException {
    return this.getStatus(null);
  }

  /**
   * (asynchronously) Report whether clusters are operational. The response depends on whether you
   * authenticate your API request. - With authentication, the response includes the status of the
   * cluster assigned to your Algolia application. - Without authentication, the response lists the
   * statuses of all public Algolia clusters.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<StatusResponse> getStatusAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/status").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<StatusResponse>() {});
  }

  /**
   * (asynchronously) Report whether clusters are operational. The response depends on whether you
   * authenticate your API request. - With authentication, the response includes the status of the
   * cluster assigned to your Algolia application. - Without authentication, the response lists the
   * statuses of all public Algolia clusters.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<StatusResponse> getStatusAsync() throws AlgoliaRuntimeException {
    return this.getStatusAsync(null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(postAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.post(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.post(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(String path) throws AlgoliaRuntimeException {
    return this.post(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (path == null) {
      throw new AlgoliaRuntimeException("Parameter `path` is required when calling `post`.");
    }

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.postAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.postAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(String path) throws AlgoliaRuntimeException {
    return this.postAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(putAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.put(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.put(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(String path) throws AlgoliaRuntimeException {
    return this.put(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    if (path == null) {
      throw new AlgoliaRuntimeException("Parameter `path` is required when calling `put`.");
    }

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.putAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.putAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(String path) throws AlgoliaRuntimeException {
    return this.putAsync(path, null, null, null);
  }
}
