// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.querysuggestions;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/**
 * Set the language for deduplicating singular and plural suggestions. If specified, only the more
 * popular form is included.
 */
@JsonDeserialize(using = Languages.Deserializer.class)
@JsonSerialize(using = Languages.Serializer.class)
public interface Languages<T> extends CompoundType<T> {
  static Languages<Boolean> of(Boolean inside) {
    return new LanguagesBoolean(inside);
  }

  static Languages<List<String>> of(List<String> inside) {
    return new LanguagesListOfString(inside);
  }

  class Serializer extends StdSerializer<Languages> {

    public Serializer(Class<Languages> t) {
      super(t);
    }

    public Serializer() {
      this(null);
    }

    @Override
    public void serialize(Languages value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
      jgen.writeObject(value.get());
    }
  }

  class Deserializer extends StdDeserializer<Languages> {

    private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

    public Deserializer() {
      this(Languages.class);
    }

    public Deserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public Languages deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();

      // deserialize Boolean
      if (tree.isValueNode()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Boolean value = parser.readValueAs(new TypeReference<Boolean>() {});
          return Languages.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Boolean (error: " + e.getMessage() + ") (type: Boolean)");
        }
      }

      // deserialize List<String>
      if (tree.isArray()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          List<String> value = parser.readValueAs(new TypeReference<List<String>>() {});
          return Languages.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf List<String> (error: " + e.getMessage() + ") (type: List<String>)");
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public Languages getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "Languages cannot be null");
    }
  }
}

class LanguagesBoolean implements Languages<Boolean> {

  private final Boolean value;

  LanguagesBoolean(Boolean value) {
    this.value = value;
  }

  @Override
  public Boolean get() {
    return value;
  }
}

class LanguagesListOfString implements Languages<List<String>> {

  private final List<String> value;

  LanguagesListOfString(List<String> value) {
    this.value = value;
  }

  @Override
  public List<String> get() {
    return value;
  }
}
