// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.logging.Logger;

/**
 * Enables [deduplication or grouping of results (Algolia's _distinct_
 * feature](https://www.algolia.com/doc/guides/managing-results/refine-results/grouping/#introducing-algolias-distinct-feature)).
 */
@JsonDeserialize(using = Distinct.Deserializer.class)
@JsonSerialize(using = Distinct.Serializer.class)
public interface Distinct<T> extends CompoundType<T> {
  static Distinct<Boolean> of(Boolean inside) {
    return new DistinctBoolean(inside);
  }

  static Distinct<Integer> of(Integer inside) {
    return new DistinctInteger(inside);
  }

  class Serializer extends StdSerializer<Distinct> {

    public Serializer(Class<Distinct> t) {
      super(t);
    }

    public Serializer() {
      this(null);
    }

    @Override
    public void serialize(Distinct value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
      jgen.writeObject(value.get());
    }
  }

  class Deserializer extends StdDeserializer<Distinct> {

    private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

    public Deserializer() {
      this(Distinct.class);
    }

    public Deserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public Distinct deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();

      // deserialize Boolean
      if (tree.isValueNode()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Boolean value = parser.readValueAs(new TypeReference<Boolean>() {});
          return Distinct.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Boolean (error: " + e.getMessage() + ") (type: Boolean)");
        }
      }

      // deserialize Integer
      if (tree.isValueNode()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Integer value = parser.readValueAs(new TypeReference<Integer>() {});
          return Distinct.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Integer (error: " + e.getMessage() + ") (type: Integer)");
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public Distinct getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "Distinct cannot be null");
    }
  }
}

class DistinctBoolean implements Distinct<Boolean> {

  private final Boolean value;

  DistinctBoolean(Boolean value) {
    this.value = value;
  }

  @Override
  public Boolean get() {
    return value;
  }
}

class DistinctInteger implements Distinct<Integer> {

  private final Integer value;

  DistinctInteger(Integer value) {
    this.value = value;
  }

  @Override
  public Integer get() {
    return value;
  }
}
