// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/**
 * Create filters to boost or demote records. Records that match the filter are ranked higher for
 * positive and lower for negative optional filters. In contrast to regular filters, records that
 * don't match the optional filter are still included in the results, only their ranking is
 * affected.
 */
@JsonDeserialize(using = OptionalFilters.Deserializer.class)
@JsonSerialize(using = OptionalFilters.Serializer.class)
public interface OptionalFilters<T> extends CompoundType<T> {
  static OptionalFilters<List<MixedSearchFilters>> of(List<MixedSearchFilters> inside) {
    return new OptionalFiltersListOfMixedSearchFilters(inside);
  }

  static OptionalFilters<String> of(String inside) {
    return new OptionalFiltersString(inside);
  }

  class Serializer extends StdSerializer<OptionalFilters> {

    public Serializer(Class<OptionalFilters> t) {
      super(t);
    }

    public Serializer() {
      this(null);
    }

    @Override
    public void serialize(OptionalFilters value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
      jgen.writeObject(value.get());
    }
  }

  class Deserializer extends StdDeserializer<OptionalFilters> {

    private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

    public Deserializer() {
      this(OptionalFilters.class);
    }

    public Deserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public OptionalFilters deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();

      // deserialize List<MixedSearchFilters>
      if (tree.isArray()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          List<MixedSearchFilters> value = parser.readValueAs(new TypeReference<List<MixedSearchFilters>>() {});
          return OptionalFilters.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest(
            "Failed to deserialize oneOf List<MixedSearchFilters> (error: " + e.getMessage() + ") (type: List<MixedSearchFilters>)"
          );
        }
      }

      // deserialize String
      if (tree.isValueNode()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          String value = parser.readValueAs(new TypeReference<String>() {});
          return OptionalFilters.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf String (error: " + e.getMessage() + ") (type: String)");
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public OptionalFilters getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "OptionalFilters cannot be null");
    }
  }
}

class OptionalFiltersListOfMixedSearchFilters implements OptionalFilters<List<MixedSearchFilters>> {

  private final List<MixedSearchFilters> value;

  OptionalFiltersListOfMixedSearchFilters(List<MixedSearchFilters> value) {
    this.value = value;
  }

  @Override
  public List<MixedSearchFilters> get() {
    return value;
  }
}

class OptionalFiltersString implements OptionalFilters<String> {

  private final String value;

  OptionalFiltersString(String value) {
    this.value = value;
  }

  @Override
  public String get() {
    return value;
  }
}
