// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.utils.CompoundType;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/**
 * Precision of a geographical search (in meters), to [group results that are more or less the same
 * distance from a central
 * point](https://www.algolia.com/doc/guides/managing-results/refine-results/geolocation/in-depth/geo-ranking-precision/).
 */
@JsonDeserialize(using = AroundPrecision.Deserializer.class)
@JsonSerialize(using = AroundPrecision.Serializer.class)
public interface AroundPrecision<T> extends CompoundType<T> {
  static AroundPrecision<Integer> of(Integer inside) {
    return new AroundPrecisionInteger(inside);
  }

  static AroundPrecision<List<AroundPrecisionFromValueInner>> of(List<AroundPrecisionFromValueInner> inside) {
    return new AroundPrecisionListOfAroundPrecisionFromValueInner(inside);
  }

  class Serializer extends StdSerializer<AroundPrecision> {

    public Serializer(Class<AroundPrecision> t) {
      super(t);
    }

    public Serializer() {
      this(null);
    }

    @Override
    public void serialize(AroundPrecision value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
      jgen.writeObject(value.get());
    }
  }

  class Deserializer extends StdDeserializer<AroundPrecision> {

    private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

    public Deserializer() {
      this(AroundPrecision.class);
    }

    public Deserializer(Class<?> vc) {
      super(vc);
    }

    @Override
    public AroundPrecision deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();

      // deserialize Integer
      if (tree.isValueNode()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          Integer value = parser.readValueAs(new TypeReference<Integer>() {});
          return AroundPrecision.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf Integer (error: " + e.getMessage() + ") (type: Integer)");
        }
      }

      // deserialize List<AroundPrecisionFromValueInner>
      if (tree.isArray()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          List<AroundPrecisionFromValueInner> value = parser.readValueAs(new TypeReference<List<AroundPrecisionFromValueInner>>() {});
          return AroundPrecision.of(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest(
            "Failed to deserialize oneOf List<AroundPrecisionFromValueInner> (error: " +
            e.getMessage() +
            ") (type: List<AroundPrecisionFromValueInner>)"
          );
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public AroundPrecision getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "AroundPrecision cannot be null");
    }
  }
}

class AroundPrecisionInteger implements AroundPrecision<Integer> {

  private final Integer value;

  AroundPrecisionInteger(Integer value) {
    this.value = value;
  }

  @Override
  public Integer get() {
    return value;
  }
}

class AroundPrecisionListOfAroundPrecisionFromValueInner implements AroundPrecision<List<AroundPrecisionFromValueInner>> {

  private final List<AroundPrecisionFromValueInner> value;

  AroundPrecisionListOfAroundPrecisionFromValueInner(List<AroundPrecisionFromValueInner> value) {
    this.value = value;
  }

  @Override
  public List<AroundPrecisionFromValueInner> get() {
    return value;
  }
}
