// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.usage.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class UsageClient extends ApiClient {

  public UsageClient(String appId, String apiKey) {
    this(appId, apiKey, null);
  }

  public UsageClient(String appId, String apiKey, ClientOptions options) {
    super(appId, apiKey, "Usage", options, getDefaultHosts(appId));
  }

  private static List<Host> getDefaultHosts(String appId) {
    List<Host> hosts = new ArrayList<>();
    hosts.add(new Host(appId + "-dsn.algolia.net", EnumSet.of(CallType.READ)));
    hosts.add(new Host(appId + ".algolia.net", EnumSet.of(CallType.WRITE)));

    List<Host> commonHosts = new ArrayList<>();
    hosts.add(new Host(appId + "-1.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
    hosts.add(new Host(appId + "-2.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
    hosts.add(new Host(appId + "-3.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));

    Collections.shuffle(commonHosts, new Random());

    return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customDeleteAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDelete(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customGetAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGet(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGet(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGet(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPostAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPost(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");

    HttpRequest request = HttpRequest.builder()
      .setPathEncoded("/{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPostAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPutAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPut(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");

    HttpRequest request = HttpRequest.builder()
      .setPathEncoded("/{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPutAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, null);
  }

  /**
   * Retrieves the selected usage statistics for one index.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param granularity Granularity of the aggregated metrics. - `hourly`: the maximum time range
   *     for hourly metrics is 7 days. - `daily`: the maximum time range for daily metrics is 365
   *     days. (optional, default to daily)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexUsage getIndexUsage(
    @Nonnull Statistic statistic,
    @Nonnull String indexName,
    @Nonnull String startDate,
    @Nonnull String endDate,
    Granularity granularity,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getIndexUsageAsync(statistic, indexName, startDate, endDate, granularity, requestOptions));
  }

  /**
   * Retrieves the selected usage statistics for one index.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param granularity Granularity of the aggregated metrics. - `hourly`: the maximum time range
   *     for hourly metrics is 7 days. - `daily`: the maximum time range for daily metrics is 365
   *     days. (optional, default to daily)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexUsage getIndexUsage(
    @Nonnull Statistic statistic,
    @Nonnull String indexName,
    @Nonnull String startDate,
    @Nonnull String endDate,
    Granularity granularity
  ) throws AlgoliaRuntimeException {
    return this.getIndexUsage(statistic, indexName, startDate, endDate, granularity, null);
  }

  /**
   * Retrieves the selected usage statistics for one index.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexUsage getIndexUsage(
    @Nonnull Statistic statistic,
    @Nonnull String indexName,
    @Nonnull String startDate,
    @Nonnull String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getIndexUsage(statistic, indexName, startDate, endDate, null, requestOptions);
  }

  /**
   * Retrieves the selected usage statistics for one index.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexUsage getIndexUsage(
    @Nonnull Statistic statistic,
    @Nonnull String indexName,
    @Nonnull String startDate,
    @Nonnull String endDate
  ) throws AlgoliaRuntimeException {
    return this.getIndexUsage(statistic, indexName, startDate, endDate, null, null);
  }

  /**
   * (asynchronously) Retrieves the selected usage statistics for one index.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param granularity Granularity of the aggregated metrics. - `hourly`: the maximum time range
   *     for hourly metrics is 7 days. - `daily`: the maximum time range for daily metrics is 365
   *     days. (optional, default to daily)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexUsage> getIndexUsageAsync(
    @Nonnull Statistic statistic,
    @Nonnull String indexName,
    @Nonnull String startDate,
    @Nonnull String endDate,
    Granularity granularity,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(statistic, "Parameter `statistic` is required when calling `getIndexUsage`.");

    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getIndexUsage`.");

    Parameters.requireNonNull(startDate, "Parameter `startDate` is required when calling `getIndexUsage`.");

    Parameters.requireNonNull(endDate, "Parameter `endDate` is required when calling `getIndexUsage`.");

    HttpRequest request = HttpRequest.builder()
      .setPath("/1/usage/{statistic}/{indexName}", statistic, indexName)
      .setMethod("GET")
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("granularity", granularity)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<IndexUsage>() {});
  }

  /**
   * (asynchronously) Retrieves the selected usage statistics for one index.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param granularity Granularity of the aggregated metrics. - `hourly`: the maximum time range
   *     for hourly metrics is 7 days. - `daily`: the maximum time range for daily metrics is 365
   *     days. (optional, default to daily)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexUsage> getIndexUsageAsync(
    @Nonnull Statistic statistic,
    @Nonnull String indexName,
    @Nonnull String startDate,
    @Nonnull String endDate,
    Granularity granularity
  ) throws AlgoliaRuntimeException {
    return this.getIndexUsageAsync(statistic, indexName, startDate, endDate, granularity, null);
  }

  /**
   * (asynchronously) Retrieves the selected usage statistics for one index.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexUsage> getIndexUsageAsync(
    @Nonnull Statistic statistic,
    @Nonnull String indexName,
    @Nonnull String startDate,
    @Nonnull String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getIndexUsageAsync(statistic, indexName, startDate, endDate, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves the selected usage statistics for one index.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexUsage> getIndexUsageAsync(
    @Nonnull Statistic statistic,
    @Nonnull String indexName,
    @Nonnull String startDate,
    @Nonnull String endDate
  ) throws AlgoliaRuntimeException {
    return this.getIndexUsageAsync(statistic, indexName, startDate, endDate, null, null);
  }

  /**
   * Retrieves usage statistics evaluated over a specified period.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param granularity Granularity of the aggregated metrics. - `hourly`: the maximum time range
   *     for hourly metrics is 7 days. - `daily`: the maximum time range for daily metrics is 365
   *     days. (optional, default to daily)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexUsage getUsage(
    @Nonnull Statistic statistic,
    @Nonnull String startDate,
    @Nonnull String endDate,
    Granularity granularity,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getUsageAsync(statistic, startDate, endDate, granularity, requestOptions));
  }

  /**
   * Retrieves usage statistics evaluated over a specified period.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param granularity Granularity of the aggregated metrics. - `hourly`: the maximum time range
   *     for hourly metrics is 7 days. - `daily`: the maximum time range for daily metrics is 365
   *     days. (optional, default to daily)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexUsage getUsage(@Nonnull Statistic statistic, @Nonnull String startDate, @Nonnull String endDate, Granularity granularity)
    throws AlgoliaRuntimeException {
    return this.getUsage(statistic, startDate, endDate, granularity, null);
  }

  /**
   * Retrieves usage statistics evaluated over a specified period.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexUsage getUsage(
    @Nonnull Statistic statistic,
    @Nonnull String startDate,
    @Nonnull String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getUsage(statistic, startDate, endDate, null, requestOptions);
  }

  /**
   * Retrieves usage statistics evaluated over a specified period.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public IndexUsage getUsage(@Nonnull Statistic statistic, @Nonnull String startDate, @Nonnull String endDate)
    throws AlgoliaRuntimeException {
    return this.getUsage(statistic, startDate, endDate, null, null);
  }

  /**
   * (asynchronously) Retrieves usage statistics evaluated over a specified period.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param granularity Granularity of the aggregated metrics. - `hourly`: the maximum time range
   *     for hourly metrics is 7 days. - `daily`: the maximum time range for daily metrics is 365
   *     days. (optional, default to daily)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexUsage> getUsageAsync(
    @Nonnull Statistic statistic,
    @Nonnull String startDate,
    @Nonnull String endDate,
    Granularity granularity,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(statistic, "Parameter `statistic` is required when calling `getUsage`.");

    Parameters.requireNonNull(startDate, "Parameter `startDate` is required when calling `getUsage`.");

    Parameters.requireNonNull(endDate, "Parameter `endDate` is required when calling `getUsage`.");

    HttpRequest request = HttpRequest.builder()
      .setPath("/1/usage/{statistic}", statistic)
      .setMethod("GET")
      .addQueryParameter("startDate", startDate)
      .addQueryParameter("endDate", endDate)
      .addQueryParameter("granularity", granularity)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<IndexUsage>() {});
  }

  /**
   * (asynchronously) Retrieves usage statistics evaluated over a specified period.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param granularity Granularity of the aggregated metrics. - `hourly`: the maximum time range
   *     for hourly metrics is 7 days. - `daily`: the maximum time range for daily metrics is 365
   *     days. (optional, default to daily)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexUsage> getUsageAsync(
    @Nonnull Statistic statistic,
    @Nonnull String startDate,
    @Nonnull String endDate,
    Granularity granularity
  ) throws AlgoliaRuntimeException {
    return this.getUsageAsync(statistic, startDate, endDate, granularity, null);
  }

  /**
   * (asynchronously) Retrieves usage statistics evaluated over a specified period.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexUsage> getUsageAsync(
    @Nonnull Statistic statistic,
    @Nonnull String startDate,
    @Nonnull String endDate,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.getUsageAsync(statistic, startDate, endDate, null, requestOptions);
  }

  /**
   * (asynchronously) Retrieves usage statistics evaluated over a specified period.
   *
   * @param statistic Usage statistics to retrieve. Use `*` to retrieve all usage metrics, otherwise
   *     add one or more of the following metrics, separated by a comma. **Search operations** -
   *     `search_operations`. All search operations. - `total_search_operations`: Sum of all search
   *     operations. - `total_search_requests`: Sum of all [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     The number of billed search requests is equal to this value minus
   *     `querysuggestions_total_search_requests`. - `queries_operations`. Number of [single index
   *     search](/specs/search#tag/Search/operation/searchSingleIndex) operations. -
   *     `multi_queries_operations`. Number of [multi-index
   *     search](/specs/search#tag/Search/operation/search) operations. **ACL operations** -
   *     `acl_operations`. All ACL operations. - `total_acl_operations`. Sum of all ACL operations.
   *     - `get_api_keys_operations`. Number of [list API
   *     keys](/specs/search#tag/Api-Keys/operation/listApiKeys) operations. -
   *     `get_api_key_operations`. Number of [get API key
   *     permission](/specs/search#tag/Api-Keys/operation/getApiKey) operations. -
   *     `add_api_key_operations`. Number of [create API
   *     key](/specs/search#tag/Api-Keys/operation/addApiKey) operations. -
   *     `update_api_key_operations`. Number of [update API
   *     key](/specs/search#tag/Api-Keys/operation/updateApiKey) operations. -
   *     `delete_api_key_operations`. Number of [delete API
   *     key](/specs/search#tag/Api-Keys/operation/deleteApiKey) operations. -
   *     `list_api_key_operations`. Number of list index API keys operations. **Indexing
   *     operations** - `indexing_operations`. All indexing operations. -
   *     `total_indexing_operations`. Sum of all indexing operations. - `browse_operations`. Number
   *     of [browse index](/specs/search#tag/Search/operation/browse) operations. -
   *     `clear_index_operations`. Number of [clear
   *     records](/specs/search#tag/Records/operation/clearObjects) operations. -
   *     `copy_move_operations`. Number of [copy or move
   *     index](/specs/search#tag/Indices/operation/operationIndex) operations. -
   *     `delete_index_operations`. Number of [delete
   *     index](/specs/search#tag/Indices/operation/deleteIndex) operations. - `get_log_operations`.
   *     Number of [get logs](/specs/search#tag/Advanced/operation/getLogs) operations. -
   *     `get_settings_operations`. Number of [get settings](/specs/search#operation/getIndexUsage)
   *     operations. - `set_settings_operations`. Number of [set
   *     settings](/specs/search#tag/Indices/operation/setSettings) operations. -
   *     `list_indices_operations`. Number of [list
   *     indices](/specs/search#tag/Indices/operation/listIndices) operations. -
   *     `wait_task_operations`. Number of [wait](/specs/search#tag/Indices/operation/getTask)
   *     operations. **Record operations** - `record_operations`. All record operations. -
   *     `total_records_operations`. Sum of all record operations. - `add_record_operations`. Number
   *     of [add or replace record](/specs/search#tag/Records/operation/saveObject) operations. -
   *     `batch_operations`. Number of [batch
   *     indexing](/specs/search#tag/Records/operation/multipleBatch) operations. -
   *     `delete_by_query_operations`. Number of [delete by
   *     query](/specs/search#tag/Records/operation/deleteBy) operations. -
   *     `delete_record_operations`. Number of [delete
   *     record](/specs/search#tag/Records/operation/deleteObject) operations. -
   *     `get_record_operations`. Number of [get
   *     record](/specs/search#tag/Records/operation/getObject) operations. -
   *     `partial_update_record_operations`. Number of [partially update
   *     records](/specs/search#tag/Records/operation/partialUpdateObject) operations. -
   *     `update_record_operations`. Number of [add or replace record by
   *     objectID](/specs/search#tag/Records/operation/addOrUpdateObject) operations. **Synonym
   *     operations** - `synonym_operations`. All synonym operations. - `total_synonym_operations`.
   *     Sum of all synonym operations. - `batch_synonym_operations`. Number of [save all
   *     synonyms](/specs/search#tag/Synonyms/operation/saveSynonyms) operations. -
   *     `clear_synonym_operations`. Number of [clear
   *     synonyms](/specs/search#tag/Synonyms/operation/clearSynonyms) operations. -
   *     `delete_synonym_operations`. Number of [delete
   *     synonym](/specs/search#tag/Synonyms/operation/deleteSynonym) operations. -
   *     `get_synonym_operations`. Number of [get
   *     synonym](/specs/search#tag/Synonyms/operation/getSynonym) operations. -
   *     `query_synonym_operations`. Number of [search
   *     synonyms](/specs/search#tag/Synonyms/operation/searchSynonyms) operations. -
   *     `update_synonym_operations`. Number of [save a
   *     synonym](/specs/search#tag/Synonyms/operation/saveSynonym) operations. **Rule operations**
   *     - `rule_operations`. All rule operations. - `total_rules_operations`. Sum of all rule
   *     operations. - `batch_rules_operations`. Number of [batch
   *     rules](/specs/search#tag/Rules/operation/saveRules) operations. - `clear_rules_operations`.
   *     Number of [delete rule](/specs/search#tag/Rules/operation/deleteRule) operations. -
   *     `delete_rules_operations`. Number of [clear
   *     rules](/specs/search#tag/Rules/operation/clearRules) operations. - `get_rules_operations`.
   *     Number of [get rule](/specs/search#tag/Rules/operation/getRule) operations. -
   *     `save_rules_operations`. Number of [save rule](/specs/search#operation/getIndexUsage)
   *     operations. - `search_rules_operations`. Number of [search
   *     rules](/specs/search#tag/Rules/operation/searchRules) operations. **Total operations** -
   *     `total_recommend_requests`. Number of [Recommend
   *     requests](https://www.algolia.com/doc/guides/algolia-ai/recommend/) -
   *     `total_write_operations`. Number of Write operations - `total_read_operations`. Number of
   *     read operations - `total_operations`. Sum of all operations **Total Query Suggestions
   *     operations** Query Suggestions operations are a subset of `total_search_operations`. -
   *     `querysuggestions_total_search_operations`. Number of Query Suggestions search operations.
   *     - `querysuggestions_total_search_requests`. Number of Query Suggestions [search
   *     requests](https://support.algolia.com/hc/en-us/articles/4406981829777-How-does-Algolia-count-records-and-operations-).
   *     - `querysuggestions_total_acl_operations`. Sum of all Query Suggestions [ACL
   *     operations](#acl-operations). - `querysuggestions_total_indexing_operations`. Number of
   *     Query Suggestions [indexing operations](#indexing-operations). -
   *     `querysuggestions_total_records_operations`. Number of Query Suggestions [record
   *     operations](#record-operations). - `querysuggestions_total_synonym_operations`. Number of
   *     Query Suggestions [synonym operations](#synonym-operations). -
   *     `querysuggestions_total_rules_operations`. Number of Query Suggestions [Rule
   *     operations](#rule-operations). - `querysuggestions_total_write_operations`. Number of Query
   *     Suggestions Write operations. - `querysuggestions_total_read_operations`. Number of Query
   *     Suggestions Read operations. - `querysuggestions_total_operations`. Sum of all Query
   *     Suggestions operations. **Processing time** - `avg_processing_time`. Average processing
   *     time (in milliseconds). - `90p_processing_time`. 90th percentile of processing time (in
   *     milliseconds). - `99p_processing_time`. 99th percentile of processing time (in
   *     milliseconds). - `queries_above_last_ms_processing_time`. Number of queries that take one
   *     or more seconds to process. **Indices** - `records`. Number of records. - `data_size`. The
   *     size of the records (in bytes). - `file_size`. The size of the records _and_ index metadata
   *     (in bytes). **Maximum queries per second** - `max_qps`. [Maximum queries per
   *     second](https://support.algolia.com/hc/en-us/articles/4406975224721) per server. -
   *     `region_max_qps`. Maximum queries per second per region. - `total_max_qps`. Maximum queries
   *     per second across all servers. **Used search capacity** The following capacities are
   *     reported in percent: - `used_search_capacity`. Maximum search capacity used per server. -
   *     `avg_used_search_capacity`. Average search capacity used per server. -
   *     `region_used_search_capacity`. Maximum search capacity used per region. -
   *     `region_avg_used_search_capacity`. Average search capacity used per region. -
   *     `total_used_search_capacity`. Maximum search capacity used for all servers. -
   *     `total_avg_used_search_capacity`. Average used search capacity for all servers. **Degraded
   *     queries** Check the impact of [degraded
   *     queries](https://support.algolia.com/hc/en-us/articles/4406981934481). -
   *     `degraded_queries_ssd_used_queries_impacted`. Percentage of degraded queries due to the
   *     Algolia search engine having to read from the server's SSD. -
   *     `degraded_queries_ssd_used_seconds_impacted`. Percentage of seconds affected by `ssd_used`
   *     degraded queries. - `degraded_queries_max_capacity_queries_impacted`. Percentage of
   *     degraded queries due to all search threads being used. -
   *     `degraded_queries_max_capacity_seconds_impacted`. Percentage of seconds affected by
   *     `max_capacity` degraded queries. (required)
   * @param startDate Start date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @param endDate End date of the period to analyze, in `YYYY-MM-DD` format. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<IndexUsage> getUsageAsync(@Nonnull Statistic statistic, @Nonnull String startDate, @Nonnull String endDate)
    throws AlgoliaRuntimeException {
    return this.getUsageAsync(statistic, startDate, endDate, null, null);
  }
}
