// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/**
 * Filter by numeric facets. **Prefer using the `filters` parameter, which supports all filter types
 * and combinations with boolean operators.** You can use numeric comparison operators: `<`, `<=`,
 * `=`, `!=`, `>`, `>=`. Comparsions are precise up to 3 decimals. You can also provide ranges:
 * `facet:<lower> TO <upper>`. The range includes the lower and upper boundaries. The same
 * combination rules apply as for `facetFilters`.
 */
@JsonDeserialize(using = NumericFilters.Deserializer.class)
public interface NumericFilters {
  // NumericFilters as List<NumericFilters> wrapper.
  static NumericFilters of(List<NumericFilters> value) {
    return new ListOfNumericFiltersWrapper(value);
  }

  // NumericFilters as String wrapper.
  static NumericFilters of(String value) {
    return new StringWrapper(value);
  }

  // NumericFilters as List<NumericFilters> wrapper.
  @JsonSerialize(using = ListOfNumericFiltersWrapper.Serializer.class)
  class ListOfNumericFiltersWrapper implements NumericFilters {

    private final List<NumericFilters> value;

    ListOfNumericFiltersWrapper(List<NumericFilters> value) {
      this.value = value;
    }

    public List<NumericFilters> getValue() {
      return value;
    }

    static class Serializer extends JsonSerializer<ListOfNumericFiltersWrapper> {

      @Override
      public void serialize(ListOfNumericFiltersWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeObject(value.getValue());
      }
    }
  }

  // NumericFilters as String wrapper.
  @JsonSerialize(using = StringWrapper.Serializer.class)
  class StringWrapper implements NumericFilters {

    private final String value;

    StringWrapper(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    static class Serializer extends JsonSerializer<StringWrapper> {

      @Override
      public void serialize(StringWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeObject(value.getValue());
      }
    }
  }

  class Deserializer extends JsonDeserializer<NumericFilters> {

    private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

    @Override
    public NumericFilters deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
      JsonNode tree = jp.readValueAsTree();
      // deserialize List<NumericFilters>
      if (tree.isArray()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          List<NumericFilters> value = parser.readValueAs(new TypeReference<List<NumericFilters>>() {});
          return new NumericFilters.ListOfNumericFiltersWrapper(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf List<NumericFilters> (error: " + e.getMessage() + ") (type: List<NumericFilters>)");
        }
      }
      // deserialize String
      if (tree.isTextual()) {
        try (JsonParser parser = tree.traverse(jp.getCodec())) {
          String value = parser.readValueAs(String.class);
          return new NumericFilters.StringWrapper(value);
        } catch (Exception e) {
          // deserialization failed, continue
          LOGGER.finest("Failed to deserialize oneOf String (error: " + e.getMessage() + ") (type: String)");
        }
      }
      throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
    }

    /** Handle deserialization of the 'null' value. */
    @Override
    public NumericFilters getNullValue(DeserializationContext ctxt) throws JsonMappingException {
      throw new JsonMappingException(ctxt.getParser(), "NumericFilters cannot be null");
    }
  }
}
