// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.recommend.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class RecommendClient extends ApiClient {

  public RecommendClient(String appId, String apiKey) {
    this(appId, apiKey, null);
  }

  public RecommendClient(String appId, String apiKey, ClientOptions options) {
    super(appId, apiKey, "Recommend", options, getDefaultHosts(appId));
  }

  private static List<Host> getDefaultHosts(String appId) {
    List<Host> hosts = new ArrayList<>();
    hosts.add(new Host(appId + "-dsn.algolia.net", EnumSet.of(CallType.READ)));
    hosts.add(new Host(appId + ".algolia.net", EnumSet.of(CallType.WRITE)));

    List<Host> commonHosts = new ArrayList<>();
    hosts.add(new Host(appId + "-1.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
    hosts.add(new Host(appId + "-2.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
    hosts.add(new Host(appId + "-3.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));

    Collections.shuffle(commonHosts, new Random());

    return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(delAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.del(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.del(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.del(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `del`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.delAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.delAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.delAsync(path, null, null);
  }

  /**
   * Delete a [Recommend rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteRecommendRule(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteRecommendRuleAsync(indexName, model, objectID, requestOptions));
  }

  /**
   * Delete a [Recommend rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID)
    throws AlgoliaRuntimeException {
    return this.deleteRecommendRule(indexName, model, objectID, null);
  }

  /**
   * (asynchronously) Delete a [Recommend
   * rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteRecommendRule`.");

    Parameters.requireNonNull(model, "Parameter `model` is required when calling `deleteRecommendRule`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `deleteRecommendRule`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/{model}/recommend/rules/{objectID}", indexName, model, objectID)
      .setMethod("DELETE")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>() {});
  }

  /**
   * (asynchronously) Delete a [Recommend
   * rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID
  ) throws AlgoliaRuntimeException {
    return this.deleteRecommendRuleAsync(indexName, model, objectID, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.get(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.get(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.get(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `get`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.getAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.getAsync(path, null, null);
  }

  /**
   * Return a [Recommend rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RuleResponse getRecommendRule(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRecommendRuleAsync(indexName, model, objectID, requestOptions));
  }

  /**
   * Return a [Recommend rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RuleResponse getRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID)
    throws AlgoliaRuntimeException {
    return this.getRecommendRule(indexName, model, objectID, null);
  }

  /**
   * (asynchronously) Return a [Recommend
   * rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RuleResponse> getRecommendRuleAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getRecommendRule`.");

    Parameters.requireNonNull(model, "Parameter `model` is required when calling `getRecommendRule`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `getRecommendRule`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/{model}/recommend/rules/{objectID}", indexName, model, objectID)
      .setMethod("GET")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<RuleResponse>() {});
  }

  /**
   * (asynchronously) Return a [Recommend
   * rule](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record (object) identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RuleResponse> getRecommendRuleAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID
  ) throws AlgoliaRuntimeException {
    return this.getRecommendRuleAsync(indexName, model, objectID, null);
  }

  /**
   * Some operations, such as deleting a Recommend rule, will respond with a `taskID` value. Use
   * this value here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique identifier of a task. Numeric value (up to 64bits). (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendTaskResponse getRecommendStatus(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull Long taskID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRecommendStatusAsync(indexName, model, taskID, requestOptions));
  }

  /**
   * Some operations, such as deleting a Recommend rule, will respond with a `taskID` value. Use
   * this value here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique identifier of a task. Numeric value (up to 64bits). (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendTaskResponse getRecommendStatus(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull Long taskID)
    throws AlgoliaRuntimeException {
    return this.getRecommendStatus(indexName, model, taskID, null);
  }

  /**
   * (asynchronously) Some operations, such as deleting a Recommend rule, will respond with a
   * &#x60;taskID&#x60; value. Use this value here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique identifier of a task. Numeric value (up to 64bits). (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull Long taskID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getRecommendStatus`.");

    Parameters.requireNonNull(model, "Parameter `model` is required when calling `getRecommendStatus`.");

    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `getRecommendStatus`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/{model}/task/{taskID}", indexName, model, taskID)
      .setMethod("GET")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetRecommendTaskResponse>() {});
  }

  /**
   * (asynchronously) Some operations, such as deleting a Recommend rule, will respond with a
   * &#x60;taskID&#x60; value. Use this value here to check the status of that task.
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique identifier of a task. Numeric value (up to 64bits). (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull Long taskID
  ) throws AlgoliaRuntimeException {
    return this.getRecommendStatusAsync(indexName, model, taskID, null);
  }

  /**
   * Returns results from either recommendation or trending models: - **Recommendations** are
   * provided by the [Related
   * Products](https://www.algolia.com/doc/guides/algolia-recommend/overview/#related-products-and-related-content)
   * and [Frequently Bought
   * Together](https://www.algolia.com/doc/guides/algolia-recommend/overview/#frequently-bought-together)
   * models - **Trending** models are [Trending Items and Trending Facet
   * Values](https://www.algolia.com/doc/guides/algolia-recommend/overview/#trending-items-and-trending-facet-values).
   *
   * @param getRecommendationsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendationsResponse getRecommendations(
    @Nonnull GetRecommendationsParams getRecommendationsParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRecommendationsAsync(getRecommendationsParams, requestOptions));
  }

  /**
   * Returns results from either recommendation or trending models: - **Recommendations** are
   * provided by the [Related
   * Products](https://www.algolia.com/doc/guides/algolia-recommend/overview/#related-products-and-related-content)
   * and [Frequently Bought
   * Together](https://www.algolia.com/doc/guides/algolia-recommend/overview/#frequently-bought-together)
   * models - **Trending** models are [Trending Items and Trending Facet
   * Values](https://www.algolia.com/doc/guides/algolia-recommend/overview/#trending-items-and-trending-facet-values).
   *
   * @param getRecommendationsParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendationsResponse getRecommendations(@Nonnull GetRecommendationsParams getRecommendationsParams)
    throws AlgoliaRuntimeException {
    return this.getRecommendations(getRecommendationsParams, null);
  }

  /**
   * (asynchronously) Returns results from either recommendation or trending models: -
   * **Recommendations** are provided by the [Related
   * Products](https://www.algolia.com/doc/guides/algolia-recommend/overview/#related-products-and-related-content)
   * and [Frequently Bought
   * Together](https://www.algolia.com/doc/guides/algolia-recommend/overview/#frequently-bought-together)
   * models - **Trending** models are [Trending Items and Trending Facet
   * Values](https://www.algolia.com/doc/guides/algolia-recommend/overview/#trending-items-and-trending-facet-values).
   *
   * @param getRecommendationsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(
    @Nonnull GetRecommendationsParams getRecommendationsParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(
      getRecommendationsParams,
      "Parameter `getRecommendationsParams` is required when calling `getRecommendations`."
    );

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/*/recommendations")
      .setMethod("POST")
      .setBody(getRecommendationsParams)
      .setRead(true)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetRecommendationsResponse>() {});
  }

  /**
   * (asynchronously) Returns results from either recommendation or trending models: -
   * **Recommendations** are provided by the [Related
   * Products](https://www.algolia.com/doc/guides/algolia-recommend/overview/#related-products-and-related-content)
   * and [Frequently Bought
   * Together](https://www.algolia.com/doc/guides/algolia-recommend/overview/#frequently-bought-together)
   * models - **Trending** models are [Trending Items and Trending Facet
   * Values](https://www.algolia.com/doc/guides/algolia-recommend/overview/#trending-items-and-trending-facet-values).
   *
   * @param getRecommendationsParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(@Nonnull GetRecommendationsParams getRecommendationsParams)
    throws AlgoliaRuntimeException {
    return this.getRecommendationsAsync(getRecommendationsParams, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(postAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.post(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.post(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.post(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `post`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.postAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.postAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.postAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(putAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.put(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.put(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.put(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `put`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.putAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.putAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.putAsync(path, null, null, null);
  }

  /**
   * List [Recommend rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, requestOptions));
  }

  /**
   * List [Recommend rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRules(indexName, model, searchRecommendRulesParams, null);
  }

  /**
   * List [Recommend rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRules(indexName, model, null, requestOptions);
  }

  /**
   * List [Recommend rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(@Nonnull String indexName, @Nonnull RecommendModels model)
    throws AlgoliaRuntimeException {
    return this.searchRecommendRules(indexName, model, null, null);
  }

  /**
   * (asynchronously) List [Recommend
   * rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchRecommendRules`.");

    Parameters.requireNonNull(model, "Parameter `model` is required when calling `searchRecommendRules`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/indexes/{indexName}/{model}/recommend/rules/search", indexName, model)
      .setMethod("POST")
      .setBody(searchRecommendRulesParams)
      .setRead(true)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<SearchRecommendRulesResponse>() {});
  }

  /**
   * (asynchronously) List [Recommend
   * rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, null);
  }

  /**
   * (asynchronously) List [Recommend
   * rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRulesAsync(indexName, model, null, requestOptions);
  }

  /**
   * (asynchronously) List [Recommend
   * rules](https://www.algolia.com/doc/guides/algolia-recommend/how-to/rules/).
   *
   * @param indexName Index on which to perform the request. (required)
   * @param model [Recommend
   *     models](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRulesAsync(indexName, model, null, null);
  }
}
