/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.monitoring.IncidentsResponse;
import com.algolia.model.monitoring.IndexingTimeResponse;
import com.algolia.model.monitoring.InfrastructureResponse;
import com.algolia.model.monitoring.InventoryResponse;
import com.algolia.model.monitoring.LatencyResponse;
import com.algolia.model.monitoring.Metric;
import com.algolia.model.monitoring.Period;
import com.algolia.model.monitoring.StatusResponse;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class MonitoringClient
extends ApiClient {
    public MonitoringClient(String appId, String apiKey) {
        this(appId, apiKey, null);
    }

    public MonitoringClient(String appId, String apiKey, ClientOptions options) {
        super(appId, apiKey, "Monitoring", options, MonitoringClient.getDefaultHosts(appId));
    }

    private static List<Host> getDefaultHosts(String appId) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        hosts.add(new Host(appId + "-dsn.algolia.net", EnumSet.of(CallType.READ)));
        hosts.add(new Host(appId + ".algolia.net", EnumSet.of(CallType.WRITE)));
        ArrayList commonHosts = new ArrayList();
        hosts.add(new Host(appId + "-1.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new Host(appId + "-2.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new Host(appId + "-3.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        Collections.shuffle(commonHosts, new Random());
        return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
    }

    public Object del(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.delAsync(path, parameters, requestOptions));
    }

    public Object del(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.del(path, parameters, null);
    }

    public Object del(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.del(path, null, requestOptions);
    }

    public Object del(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.del(path, null, null);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `del`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.delAsync(path, parameters, null);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> delAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.delAsync(path, null, null);
    }

    public Object get(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAsync(path, parameters, requestOptions));
    }

    public Object get(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.get(path, parameters, null);
    }

    public Object get(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.get(path, null, requestOptions);
    }

    public Object get(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.get(path, null, null);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `get`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.getAsync(path, parameters, null);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> getAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.getAsync(path, null, null);
    }

    public IncidentsResponse getClusterIncidents(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getClusterIncidentsAsync(clusters, requestOptions));
    }

    public IncidentsResponse getClusterIncidents(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getClusterIncidents(clusters, null);
    }

    public CompletableFuture<IncidentsResponse> getClusterIncidentsAsync(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getClusterIncidents`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/incidents/{clusters}", clusters).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<IncidentsResponse>(){});
    }

    public CompletableFuture<IncidentsResponse> getClusterIncidentsAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getClusterIncidentsAsync(clusters, null);
    }

    public StatusResponse getClusterStatus(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getClusterStatusAsync(clusters, requestOptions));
    }

    public StatusResponse getClusterStatus(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getClusterStatus(clusters, null);
    }

    public CompletableFuture<StatusResponse> getClusterStatusAsync(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getClusterStatus`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/status/{clusters}", clusters).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<StatusResponse>(){});
    }

    public CompletableFuture<StatusResponse> getClusterStatusAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getClusterStatusAsync(clusters, null);
    }

    public IncidentsResponse getIncidents(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getIncidentsAsync(requestOptions));
    }

    public IncidentsResponse getIncidents() throws AlgoliaRuntimeException {
        return this.getIncidents(null);
    }

    public CompletableFuture<IncidentsResponse> getIncidentsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/incidents").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<IncidentsResponse>(){});
    }

    public CompletableFuture<IncidentsResponse> getIncidentsAsync() throws AlgoliaRuntimeException {
        return this.getIncidentsAsync(null);
    }

    public IndexingTimeResponse getIndexingTime(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getIndexingTimeAsync(clusters, requestOptions));
    }

    public IndexingTimeResponse getIndexingTime(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getIndexingTime(clusters, null);
    }

    public CompletableFuture<IndexingTimeResponse> getIndexingTimeAsync(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getIndexingTime`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexing/{clusters}", clusters).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<IndexingTimeResponse>(){});
    }

    public CompletableFuture<IndexingTimeResponse> getIndexingTimeAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getIndexingTimeAsync(clusters, null);
    }

    public InventoryResponse getInventory(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getInventoryAsync(requestOptions));
    }

    public InventoryResponse getInventory() throws AlgoliaRuntimeException {
        return this.getInventory(null);
    }

    public CompletableFuture<InventoryResponse> getInventoryAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/inventory/servers").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<InventoryResponse>(){});
    }

    public CompletableFuture<InventoryResponse> getInventoryAsync() throws AlgoliaRuntimeException {
        return this.getInventoryAsync(null);
    }

    public LatencyResponse getLatency(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getLatencyAsync(clusters, requestOptions));
    }

    public LatencyResponse getLatency(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getLatency(clusters, null);
    }

    public CompletableFuture<LatencyResponse> getLatencyAsync(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getLatency`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/latency/{clusters}", clusters).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<LatencyResponse>(){});
    }

    public CompletableFuture<LatencyResponse> getLatencyAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getLatencyAsync(clusters, null);
    }

    public InfrastructureResponse getMetrics(@Nonnull Metric metric, @Nonnull Period period, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getMetricsAsync(metric, period, requestOptions));
    }

    public InfrastructureResponse getMetrics(@Nonnull Metric metric, @Nonnull Period period) throws AlgoliaRuntimeException {
        return this.getMetrics(metric, period, null);
    }

    public CompletableFuture<InfrastructureResponse> getMetricsAsync(@Nonnull Metric metric, @Nonnull Period period, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull((Object)metric, "Parameter `metric` is required when calling `getMetrics`.");
        Parameters.requireNonNull((Object)period, "Parameter `period` is required when calling `getMetrics`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/infrastructure/{metric}/period/{period}", new Object[]{metric, period}).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<InfrastructureResponse>(){});
    }

    public CompletableFuture<InfrastructureResponse> getMetricsAsync(@Nonnull Metric metric, @Nonnull Period period) throws AlgoliaRuntimeException {
        return this.getMetricsAsync(metric, period, null);
    }

    public Map<String, Map<String, Boolean>> getReachability(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getReachabilityAsync(clusters, requestOptions));
    }

    public Map<String, Map<String, Boolean>> getReachability(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getReachability(clusters, null);
    }

    public CompletableFuture<Map<String, Map<String, Boolean>>> getReachabilityAsync(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getReachability`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/reachability/{clusters}/probes", clusters).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<Map<String, Map<String, Boolean>>>(){});
    }

    public CompletableFuture<Map<String, Map<String, Boolean>>> getReachabilityAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getReachabilityAsync(clusters, null);
    }

    public StatusResponse getStatus(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getStatusAsync(requestOptions));
    }

    public StatusResponse getStatus() throws AlgoliaRuntimeException {
        return this.getStatus(null);
    }

    public CompletableFuture<StatusResponse> getStatusAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/status").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<StatusResponse>(){});
    }

    public CompletableFuture<StatusResponse> getStatusAsync() throws AlgoliaRuntimeException {
        return this.getStatusAsync(null);
    }

    public Object post(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.postAsync(path, parameters, body, requestOptions));
    }

    public Object post(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.post(path, parameters, body, null);
    }

    public Object post(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.post(path, null, null, requestOptions);
    }

    public Object post(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.post(path, null, null, null);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `post`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.postAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> postAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.postAsync(path, null, null, null);
    }

    public Object put(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.putAsync(path, parameters, body, requestOptions));
    }

    public Object put(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.put(path, parameters, body, null);
    }

    public Object put(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.put(path, null, null, requestOptions);
    }

    public Object put(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.put(path, null, null, null);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `put`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.putAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> putAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.putAsync(path, null, null, null);
    }
}

