/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.internal;

import com.algolia.config.ClientConfig;
import com.algolia.config.CompressionType;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.config.Requester;
import com.algolia.exceptions.AlgoliaApiException;
import com.algolia.exceptions.AlgoliaClientException;
import com.algolia.internal.JsonSerializer;
import com.algolia.internal.interceptors.GzipRequestInterceptor;
import com.algolia.internal.interceptors.HeaderInterceptor;
import com.algolia.internal.interceptors.LogInterceptor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;

public final class HttpRequester
implements Requester {
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json");
    private final OkHttpClient httpClient;
    private final JsonSerializer serializer;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    private HttpRequester(Builder builder, ClientConfig config) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectTimeout(config.getConnectTimeout()).readTimeout(config.getReadTimeout()).writeTimeout(config.getWriteTimeout()).addInterceptor((Interceptor)new HeaderInterceptor(config.getDefaultHeaders())).addNetworkInterceptor((Interceptor)new LogInterceptor(config.getLogger(), config.getLogLevel()));
        builder.interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)clientBuilder).addInterceptor(arg_0));
        builder.networkInterceptors.forEach(arg_0 -> ((OkHttpClient.Builder)clientBuilder).addNetworkInterceptor(arg_0));
        if (config.getCompressionType() == CompressionType.GZIP) {
            clientBuilder.addInterceptor((Interceptor)new GzipRequestInterceptor());
        }
        if (builder.clientConfig != null) {
            builder.clientConfig.accept(clientBuilder);
        }
        this.httpClient = clientBuilder.build();
        this.serializer = builder.serializer;
    }

    @Override
    public <T> T execute(HttpRequest httpRequest, RequestOptions requestOptions, Class<?> returnType, Class<?> innerType) {
        return this.execute(httpRequest, requestOptions, this.serializer.getJavaType(returnType, innerType));
    }

    @Override
    public <T> T execute(HttpRequest httpRequest, RequestOptions requestOptions, TypeReference<?> returnType) {
        return this.execute(httpRequest, requestOptions, this.serializer.getJavaType(returnType));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(@Nonnull HttpRequest httpRequest, RequestOptions requestOptions, JavaType returnType) {
        if (this.isClosed.get()) {
            throw new IllegalStateException("HttpRequester is closed");
        }
        HttpUrl url = HttpRequester.createHttpUrl(httpRequest, requestOptions);
        Headers headers = this.createHeaders(httpRequest, requestOptions);
        RequestBody requestBody = this.createRequestBody(httpRequest);
        Request request = new Request.Builder().url(url).headers(headers).method(httpRequest.getMethod(), requestBody).build();
        OkHttpClient client = this.getOkHttpClient(requestOptions);
        Call call = client.newCall(request);
        try (Response response = call.execute();){
            if (!response.isSuccessful()) {
                throw new AlgoliaApiException(response.message(), response.code());
            }
            if (returnType == null || response.body() == null || response.body().contentLength() == 0L) {
                T t = null;
                return t;
            }
            Object t = this.serializer.deserialize(response.body().byteStream(), returnType);
            return t;
        }
        catch (IOException exception) {
            throw new AlgoliaClientException(exception);
        }
    }

    @Nonnull
    private static HttpUrl createHttpUrl(@Nonnull HttpRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host("algolia.com").encodedPath(request.getPath());
        request.getQueryParameters().forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        if (requestOptions != null) {
            requestOptions.getQueryParameters().forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        }
        return urlBuilder.build();
    }

    private RequestBody createRequestBody(HttpRequest httpRequest) {
        String method = httpRequest.getMethod();
        Object body = httpRequest.getBody();
        if (!HttpMethod.permitsRequestBody((String)method) || method.equals("DELETE") && body == null) {
            return null;
        }
        if (body == null) {
            body = HttpMethod.requiresRequestBody((String)method) ? Collections.emptyMap() : "";
        }
        return this.buildRequestBody(body);
    }

    @Nonnull
    private RequestBody buildRequestBody(final Object requestBody) {
        return new RequestBody(){

            public MediaType contentType() {
                return JSON_MEDIA_TYPE;
            }

            public void writeTo(@Nonnull BufferedSink bufferedSink) {
                HttpRequester.this.serializer.serialize(bufferedSink.outputStream(), requestBody);
            }
        };
    }

    @Nonnull
    private Headers createHeaders(@Nonnull HttpRequest request, RequestOptions requestOptions) {
        Headers.Builder builder = new Headers.Builder();
        request.getHeaders().forEach((arg_0, arg_1) -> ((Headers.Builder)builder).add(arg_0, arg_1));
        if (requestOptions != null) {
            requestOptions.getHeaders().forEach((arg_0, arg_1) -> ((Headers.Builder)builder).add(arg_0, arg_1));
        }
        return builder.build();
    }

    @Nonnull
    private OkHttpClient getOkHttpClient(RequestOptions requestOptions) {
        if (requestOptions == null) {
            return this.httpClient;
        }
        OkHttpClient.Builder builder = this.httpClient.newBuilder();
        if (requestOptions.getReadTimeout() != null) {
            builder.readTimeout(requestOptions.getReadTimeout());
        }
        if (requestOptions.getWriteTimeout() != null) {
            builder.writeTimeout(requestOptions.getWriteTimeout());
        }
        return builder.build();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed.get()) {
            return;
        }
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
        if (this.httpClient.cache() != null) {
            this.httpClient.cache().close();
        }
        this.isClosed.set(true);
    }

    public static class Builder {
        private final List<Interceptor> interceptors = new ArrayList<Interceptor>();
        private final List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();
        private Consumer<OkHttpClient.Builder> clientConfig;
        private final JsonSerializer serializer;

        public Builder(JsonSerializer serializer) {
            this.serializer = serializer;
        }

        public Builder addInterceptor(Interceptor interceptor) {
            this.interceptors.add(interceptor);
            return this;
        }

        public Builder addNetworkInterceptor(Interceptor interceptor) {
            this.networkInterceptors.add(interceptor);
            return this;
        }

        public Builder setHttpClientConfig(Consumer<OkHttpClient.Builder> config) {
            this.clientConfig = config;
            return this;
        }

        public HttpRequester build(ClientConfig config) {
            return new HttpRequester(this, config);
        }
    }
}

