// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.search;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * [Consequences](https://www.algolia.com/doc/guides/managing-results/rules/rules-overview/#consequences)
 * of a rule.
 */
public class Consequence {

  @JsonProperty("params")
  private ConsequenceParams params;

  @JsonProperty("promote")
  private List<Promote> promote;

  @JsonProperty("filterPromotes")
  private Boolean filterPromotes;

  @JsonProperty("hide")
  private List<ConsequenceHide> hide;

  @JsonProperty("userData")
  private Object userData;

  public Consequence setParams(ConsequenceParams params) {
    this.params = params;
    return this;
  }

  /** Get params */
  @javax.annotation.Nullable
  public ConsequenceParams getParams() {
    return params;
  }

  public Consequence setPromote(List<Promote> promote) {
    this.promote = promote;
    return this;
  }

  public Consequence addPromote(Promote promoteItem) {
    if (this.promote == null) {
      this.promote = new ArrayList<>();
    }
    this.promote.add(promoteItem);
    return this;
  }

  /** Records to promote. */
  @javax.annotation.Nullable
  public List<Promote> getPromote() {
    return promote;
  }

  public Consequence setFilterPromotes(Boolean filterPromotes) {
    this.filterPromotes = filterPromotes;
    return this;
  }

  /**
   * Only use in combination with the `promote` consequence. When `true`, promoted results will be
   * restricted to match the filters of the current search. When `false`, the promoted results will
   * show up regardless of the filters.
   */
  @javax.annotation.Nullable
  public Boolean getFilterPromotes() {
    return filterPromotes;
  }

  public Consequence setHide(List<ConsequenceHide> hide) {
    this.hide = hide;
    return this;
  }

  public Consequence addHide(ConsequenceHide hideItem) {
    if (this.hide == null) {
      this.hide = new ArrayList<>();
    }
    this.hide.add(hideItem);
    return this;
  }

  /** Records to hide. By default, you can hide up to 50 records per rule. */
  @javax.annotation.Nullable
  public List<ConsequenceHide> getHide() {
    return hide;
  }

  public Consequence setUserData(Object userData) {
    this.userData = userData;
    return this;
  }

  /**
   * Custom JSON object that will be appended to the userData array in the response. This object
   * isn't interpreted by the API. It's limited to 1kB of minified JSON.
   */
  @javax.annotation.Nullable
  public Object getUserData() {
    return userData;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Consequence consequence = (Consequence) o;
    return (
      Objects.equals(this.params, consequence.params) &&
      Objects.equals(this.promote, consequence.promote) &&
      Objects.equals(this.filterPromotes, consequence.filterPromotes) &&
      Objects.equals(this.hide, consequence.hide) &&
      Objects.equals(this.userData, consequence.userData)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(params, promote, filterPromotes, hide, userData);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Consequence {\n");
    sb.append("    params: ").append(toIndentedString(params)).append("\n");
    sb.append("    promote: ").append(toIndentedString(promote)).append("\n");
    sb.append("    filterPromotes: ").append(toIndentedString(filterPromotes)).append("\n");
    sb.append("    hide: ").append(toIndentedString(hide)).append("\n");
    sb.append("    userData: ").append(toIndentedString(userData)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
