/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class StringUtils {
    private StringUtils() {
    }

    public static String escape(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String pathFormat(String template, boolean escapeValues, Object ... values) {
        int i;
        for (i = 0; template.contains("{") && i < values.length; ++i) {
            String value = String.valueOf(values[i]);
            String string = escapeValues ? StringUtils.escape(value) : value;
            template = template.replaceFirst("\\{[^}]+}", string);
        }
        if (template.contains("{")) {
            throw new IllegalArgumentException("Not enough replacement values for all placeholders.");
        }
        if (i < values.length) {
            throw new IllegalArgumentException("More replacement values provided than placeholders.");
        }
        return template;
    }

    public static String paramToString(Object value) {
        if (value instanceof Date || value instanceof OffsetDateTime || value instanceof LocalDate) {
            throw new UnsupportedOperationException("Date must come as string (already serialized)");
        }
        if (value instanceof Collection) {
            List strings = ((Collection)value).stream().map(String::valueOf).collect(Collectors.toList());
            return String.join((CharSequence)",", strings);
        }
        return String.valueOf(value);
    }
}

