// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.querysuggestions.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class QuerySuggestionsClient extends ApiClient {

  private static final String[] allowedRegions = { "eu", "us" };

  public QuerySuggestionsClient(String appId, String apiKey, String region) {
    this(appId, apiKey, region, null);
  }

  public QuerySuggestionsClient(String appId, String apiKey, String region, ClientOptions options) {
    super(appId, apiKey, "QuerySuggestions", options, getDefaultHosts(region));
  }

  private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
    List<Host> hosts = new ArrayList<>();

    boolean found = false;
    if (region != null) {
      for (String allowed : allowedRegions) {
        if (allowed.equals(region)) {
          found = true;
          break;
        }
      }
    }

    if (region == null || !found) {
      throw new AlgoliaRuntimeException("`region` is required and must be one of the following: eu, us");
    }

    String url = "query-suggestions.{region}.algolia.com".replace("{region}", region);

    hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
    return hosts;
  }

  /**
   * Create a new Query Suggestions configuration. You can have up to 100 configurations per Algolia
   * application.
   *
   * @param querySuggestionsConfigurationWithIndex (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse createConfig(
    @Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(createConfigAsync(querySuggestionsConfigurationWithIndex, requestOptions));
  }

  /**
   * Create a new Query Suggestions configuration. You can have up to 100 configurations per Algolia
   * application.
   *
   * @param querySuggestionsConfigurationWithIndex (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse createConfig(@Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex)
    throws AlgoliaRuntimeException {
    return this.createConfig(querySuggestionsConfigurationWithIndex, null);
  }

  /**
   * (asynchronously) Create a new Query Suggestions configuration. You can have up to 100
   * configurations per Algolia application.
   *
   * @param querySuggestionsConfigurationWithIndex (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> createConfigAsync(
    @Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(
      querySuggestionsConfigurationWithIndex,
      "Parameter `querySuggestionsConfigurationWithIndex` is required when calling" + " `createConfig`."
    );

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/configs")
      .setMethod("POST")
      .setBody(querySuggestionsConfigurationWithIndex)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<BaseResponse>() {});
  }

  /**
   * (asynchronously) Create a new Query Suggestions configuration. You can have up to 100
   * configurations per Algolia application.
   *
   * @param querySuggestionsConfigurationWithIndex (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> createConfigAsync(
    @Nonnull QuerySuggestionsConfigurationWithIndex querySuggestionsConfigurationWithIndex
  ) throws AlgoliaRuntimeException {
    return this.createConfigAsync(querySuggestionsConfigurationWithIndex, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(delAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.del(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.del(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object del(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.del(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `del`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.delAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.delAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> delAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.delAsync(path, null, null);
  }

  /**
   * Delete a Query Suggestions configuration. Deleting only removes the configuration and stops
   * updates to the Query Suggestions index. The Query Suggestions index itself is not deleted.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse deleteConfig(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteConfigAsync(indexName, requestOptions));
  }

  /**
   * Delete a Query Suggestions configuration. Deleting only removes the configuration and stops
   * updates to the Query Suggestions index. The Query Suggestions index itself is not deleted.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse deleteConfig(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.deleteConfig(indexName, null);
  }

  /**
   * (asynchronously) Delete a Query Suggestions configuration. Deleting only removes the
   * configuration and stops updates to the Query Suggestions index. The Query Suggestions index
   * itself is not deleted.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> deleteConfigAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteConfig`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}", indexName).setMethod("DELETE").build();
    return executeAsync(request, requestOptions, new TypeReference<BaseResponse>() {});
  }

  /**
   * (asynchronously) Delete a Query Suggestions configuration. Deleting only removes the
   * configuration and stops updates to the Query Suggestions index. The Query Suggestions index
   * itself is not deleted.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> deleteConfigAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.deleteConfigAsync(indexName, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.get(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.get(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object get(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.get(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `get`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/1{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.getAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.getAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> getAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.getAsync(path, null, null);
  }

  /**
   * List all Query Suggestions configurations of your Algolia application.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<QuerySuggestionsConfigurationResponse> getAllConfigs(RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getAllConfigsAsync(requestOptions));
  }

  /**
   * List all Query Suggestions configurations of your Algolia application.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public List<QuerySuggestionsConfigurationResponse> getAllConfigs() throws AlgoliaRuntimeException {
    return this.getAllConfigs(null);
  }

  /**
   * (asynchronously) List all Query Suggestions configurations of your Algolia application.
   *
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<QuerySuggestionsConfigurationResponse>> getAllConfigsAsync(RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    HttpRequest request = HttpRequest.builder().setPath("/1/configs").setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<List<QuerySuggestionsConfigurationResponse>>() {});
  }

  /**
   * (asynchronously) List all Query Suggestions configurations of your Algolia application.
   *
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<List<QuerySuggestionsConfigurationResponse>> getAllConfigsAsync() throws AlgoliaRuntimeException {
    return this.getAllConfigsAsync(null);
  }

  /**
   * Get a single Query Suggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public QuerySuggestionsConfigurationResponse getConfig(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getConfigAsync(indexName, requestOptions));
  }

  /**
   * Get a single Query Suggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public QuerySuggestionsConfigurationResponse getConfig(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getConfig(indexName, null);
  }

  /**
   * (asynchronously) Get a single Query Suggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<QuerySuggestionsConfigurationResponse> getConfigAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getConfig`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}", indexName).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<QuerySuggestionsConfigurationResponse>() {});
  }

  /**
   * (asynchronously) Get a single Query Suggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<QuerySuggestionsConfigurationResponse> getConfigAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getConfigAsync(indexName, null);
  }

  /**
   * Report the status of a Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConfigStatus200Response getConfigStatus(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getConfigStatusAsync(indexName, requestOptions));
  }

  /**
   * Report the status of a Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetConfigStatus200Response getConfigStatus(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getConfigStatus(indexName, null);
  }

  /**
   * (asynchronously) Report the status of a Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConfigStatus200Response> getConfigStatusAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getConfigStatus`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}/status", indexName).setMethod("GET").build();
    return executeAsync(request, requestOptions, new TypeReference<GetConfigStatus200Response>() {});
  }

  /**
   * (asynchronously) Report the status of a Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetConfigStatus200Response> getConfigStatusAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getConfigStatusAsync(indexName, null);
  }

  /**
   * Get the logs for a single Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetLogFile200Response getLogFile(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getLogFileAsync(indexName, requestOptions));
  }

  /**
   * Get the logs for a single Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetLogFile200Response getLogFile(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getLogFile(indexName, null);
  }

  /**
   * (asynchronously) Get the logs for a single Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetLogFile200Response> getLogFileAsync(@Nonnull String indexName, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getLogFile`.");

    HttpRequest request = HttpRequest.builder().setPath("/1/logs/{indexName}", indexName).setMethod("GET").build();

    return executeAsync(request, requestOptions, new TypeReference<GetLogFile200Response>() {});
  }

  /**
   * (asynchronously) Get the logs for a single Query Suggestions index.
   *
   * @param indexName Query Suggestions index name. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetLogFile200Response> getLogFileAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
    return this.getLogFileAsync(indexName, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(postAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.post(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.post(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object post(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.post(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `post`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.postAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.postAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> postAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.postAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(putAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.put(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.put(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object put(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.put(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `put`.");

    HttpRequest request = HttpRequest
      .builder()
      .setPathEncoded("/1{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.putAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.putAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> putAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.putAsync(path, null, null, null);
  }

  /**
   * Update a QuerySuggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param querySuggestionsConfiguration (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse updateConfig(
    @Nonnull String indexName,
    @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(updateConfigAsync(indexName, querySuggestionsConfiguration, requestOptions));
  }

  /**
   * Update a QuerySuggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param querySuggestionsConfiguration (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public BaseResponse updateConfig(@Nonnull String indexName, @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration)
    throws AlgoliaRuntimeException {
    return this.updateConfig(indexName, querySuggestionsConfiguration, null);
  }

  /**
   * (asynchronously) Update a QuerySuggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param querySuggestionsConfiguration (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> updateConfigAsync(
    @Nonnull String indexName,
    @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `updateConfig`.");

    Parameters.requireNonNull(
      querySuggestionsConfiguration,
      "Parameter `querySuggestionsConfiguration` is required when calling `updateConfig`."
    );

    HttpRequest request = HttpRequest
      .builder()
      .setPath("/1/configs/{indexName}", indexName)
      .setMethod("PUT")
      .setBody(querySuggestionsConfiguration)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<BaseResponse>() {});
  }

  /**
   * (asynchronously) Update a QuerySuggestions configuration.
   *
   * @param indexName Query Suggestions index name. (required)
   * @param querySuggestionsConfiguration (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<BaseResponse> updateConfigAsync(
    @Nonnull String indexName,
    @Nonnull QuerySuggestionsConfiguration querySuggestionsConfiguration
  ) throws AlgoliaRuntimeException {
    return this.updateConfigAsync(indexName, querySuggestionsConfiguration, null);
  }
}
