/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.composition.RequestBody;
import com.algolia.model.composition.SearchForFacetValuesRequest;
import com.algolia.model.composition.SearchForFacetValuesResponse;
import com.algolia.model.composition.SearchResponse;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CompositionClient
extends ApiClient {
    public CompositionClient(String appId, String apiKey) {
        this(appId, apiKey, null);
    }

    public CompositionClient(String appId, String apiKey, ClientOptions options) {
        super(appId, apiKey, "Composition", options, CompositionClient.getDefaultHosts(appId), Duration.ofMillis(2000L), Duration.ofMillis(5000L), Duration.ofMillis(30000L));
    }

    private static List<Host> getDefaultHosts(String appId) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        hosts.add(new Host(appId + "-dsn.algolia.net", EnumSet.of(CallType.READ)));
        hosts.add(new Host(appId + ".algolia.net", EnumSet.of(CallType.WRITE)));
        ArrayList<Host> commonHosts = new ArrayList<Host>();
        commonHosts.add(new Host(appId + "-1.algolianet.com", EnumSet.of(CallType.READ, CallType.WRITE)));
        commonHosts.add(new Host(appId + "-2.algolianet.com", EnumSet.of(CallType.READ, CallType.WRITE)));
        commonHosts.add(new Host(appId + "-3.algolianet.com", EnumSet.of(CallType.READ, CallType.WRITE)));
        Collections.shuffle(commonHosts, new Random());
        return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
    }

    public <T> SearchResponse<T> search(@Nonnull String compositionID, @Nonnull RequestBody requestBody, Class<T> innerType, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchAsync(compositionID, requestBody, innerType, requestOptions));
    }

    public <T> SearchResponse<T> search(@Nonnull String compositionID, @Nonnull RequestBody requestBody, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.search(compositionID, requestBody, innerType, null);
    }

    public <T> CompletableFuture<SearchResponse<T>> searchAsync(@Nonnull String compositionID, @Nonnull RequestBody requestBody, Class<T> innerType, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(compositionID, "Parameter `compositionID` is required when calling `search`.");
        Parameters.requireNonNull(requestBody, "Parameter `requestBody` is required when calling `search`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/compositions/{compositionID}/run", compositionID).setMethod("POST").setBody(requestBody).setRead(true).build();
        return this.executeAsync(request, requestOptions, SearchResponse.class, innerType);
    }

    public <T> CompletableFuture<SearchResponse<T>> searchAsync(@Nonnull String compositionID, @Nonnull RequestBody requestBody, Class<T> innerType) throws AlgoliaRuntimeException {
        return this.searchAsync(compositionID, requestBody, innerType, null);
    }

    public SearchForFacetValuesResponse searchForFacetValues(@Nonnull String compositionID, @Nonnull String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchForFacetValuesAsync(compositionID, facetName, searchForFacetValuesRequest, requestOptions));
    }

    public SearchForFacetValuesResponse searchForFacetValues(@Nonnull String compositionID, @Nonnull String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest) throws AlgoliaRuntimeException {
        return this.searchForFacetValues(compositionID, facetName, searchForFacetValuesRequest, null);
    }

    public SearchForFacetValuesResponse searchForFacetValues(@Nonnull String compositionID, @Nonnull String facetName, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchForFacetValues(compositionID, facetName, null, requestOptions);
    }

    public SearchForFacetValuesResponse searchForFacetValues(@Nonnull String compositionID, @Nonnull String facetName) throws AlgoliaRuntimeException {
        return this.searchForFacetValues(compositionID, facetName, null, null);
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(@Nonnull String compositionID, @Nonnull String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(compositionID, "Parameter `compositionID` is required when calling `searchForFacetValues`.");
        Parameters.requireNonNull(facetName, "Parameter `facetName` is required when calling `searchForFacetValues`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/compositions/{compositionID}/facets/{facetName}/query", compositionID, facetName).setMethod("POST").setBody(searchForFacetValuesRequest).setRead(true).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SearchForFacetValuesResponse>(){});
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(@Nonnull String compositionID, @Nonnull String facetName, SearchForFacetValuesRequest searchForFacetValuesRequest) throws AlgoliaRuntimeException {
        return this.searchForFacetValuesAsync(compositionID, facetName, searchForFacetValuesRequest, null);
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(@Nonnull String compositionID, @Nonnull String facetName, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchForFacetValuesAsync(compositionID, facetName, null, requestOptions);
    }

    public CompletableFuture<SearchForFacetValuesResponse> searchForFacetValuesAsync(@Nonnull String compositionID, @Nonnull String facetName) throws AlgoliaRuntimeException {
        return this.searchForFacetValuesAsync(compositionID, facetName, null, null);
    }
}

