/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.personalization.DeleteUserProfileResponse;
import com.algolia.model.personalization.GetUserTokenResponse;
import com.algolia.model.personalization.PersonalizationStrategyParams;
import com.algolia.model.personalization.SetPersonalizationStrategyResponse;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PersonalizationClient
extends ApiClient {
    private static final String[] allowedRegions = new String[]{"eu", "us"};

    public PersonalizationClient(String appId, String apiKey, String region) {
        this(appId, apiKey, region, null);
    }

    public PersonalizationClient(String appId, String apiKey, String region, ClientOptions options) {
        super(appId, apiKey, "Personalization", options, PersonalizationClient.getDefaultHosts(region), Duration.ofMillis(2000L), Duration.ofMillis(5000L), Duration.ofMillis(30000L));
    }

    private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
        ArrayList<Host> hosts = new ArrayList<Host>();
        boolean found = false;
        if (region != null) {
            for (String allowed : allowedRegions) {
                if (!allowed.equals(region)) continue;
                found = true;
                break;
            }
        }
        if (region == null || !found) {
            throw new AlgoliaRuntimeException("`region` is required and must be one of the following: eu, us");
        }
        String url = "personalization.{region}.algolia.com".replace("{region}", region);
        hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customDeleteAsync(path, parameters, requestOptions));
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDelete(path, parameters, null);
    }

    public Object customDelete(@Nonnull String path, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, requestOptions);
    }

    public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, null);
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customGetAsync(path, parameters, requestOptions));
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGet(path, parameters, null);
    }

    public Object customGet(@Nonnull String path, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGet(path, null, requestOptions);
    }

    public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGet(path, null, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, null);
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPostAsync(path, parameters, body, requestOptions));
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPost(path, parameters, body, null);
    }

    public Object customPost(@Nonnull String path, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, requestOptions);
    }

    public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, null);
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPutAsync(path, parameters, body, requestOptions));
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPut(path, parameters, body, null);
    }

    public Object customPut(@Nonnull String path, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, requestOptions);
    }

    public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, null);
    }

    public DeleteUserProfileResponse deleteUserProfile(@Nonnull String userToken, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteUserProfileAsync(userToken, requestOptions));
    }

    public DeleteUserProfileResponse deleteUserProfile(@Nonnull String userToken) throws AlgoliaRuntimeException {
        return this.deleteUserProfile(userToken, null);
    }

    public CompletableFuture<DeleteUserProfileResponse> deleteUserProfileAsync(@Nonnull String userToken, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(userToken, "Parameter `userToken` is required when calling `deleteUserProfile`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/profiles/{userToken}", userToken).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeleteUserProfileResponse>(){});
    }

    public CompletableFuture<DeleteUserProfileResponse> deleteUserProfileAsync(@Nonnull String userToken) throws AlgoliaRuntimeException {
        return this.deleteUserProfileAsync(userToken, null);
    }

    public PersonalizationStrategyParams getPersonalizationStrategy(@Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getPersonalizationStrategyAsync(requestOptions));
    }

    public PersonalizationStrategyParams getPersonalizationStrategy() throws AlgoliaRuntimeException {
        return this.getPersonalizationStrategy(null);
    }

    public CompletableFuture<PersonalizationStrategyParams> getPersonalizationStrategyAsync(@Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/strategies/personalization").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<PersonalizationStrategyParams>(){});
    }

    public CompletableFuture<PersonalizationStrategyParams> getPersonalizationStrategyAsync() throws AlgoliaRuntimeException {
        return this.getPersonalizationStrategyAsync(null);
    }

    public GetUserTokenResponse getUserTokenProfile(@Nonnull String userToken, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getUserTokenProfileAsync(userToken, requestOptions));
    }

    public GetUserTokenResponse getUserTokenProfile(@Nonnull String userToken) throws AlgoliaRuntimeException {
        return this.getUserTokenProfile(userToken, null);
    }

    public CompletableFuture<GetUserTokenResponse> getUserTokenProfileAsync(@Nonnull String userToken, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(userToken, "Parameter `userToken` is required when calling `getUserTokenProfile`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/profiles/personalization/{userToken}", userToken).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetUserTokenResponse>(){});
    }

    public CompletableFuture<GetUserTokenResponse> getUserTokenProfileAsync(@Nonnull String userToken) throws AlgoliaRuntimeException {
        return this.getUserTokenProfileAsync(userToken, null);
    }

    public SetPersonalizationStrategyResponse setPersonalizationStrategy(@Nonnull PersonalizationStrategyParams personalizationStrategyParams, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.setPersonalizationStrategyAsync(personalizationStrategyParams, requestOptions));
    }

    public SetPersonalizationStrategyResponse setPersonalizationStrategy(@Nonnull PersonalizationStrategyParams personalizationStrategyParams) throws AlgoliaRuntimeException {
        return this.setPersonalizationStrategy(personalizationStrategyParams, null);
    }

    public CompletableFuture<SetPersonalizationStrategyResponse> setPersonalizationStrategyAsync(@Nonnull PersonalizationStrategyParams personalizationStrategyParams, @Nullable RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(personalizationStrategyParams, "Parameter `personalizationStrategyParams` is required when calling `setPersonalizationStrategy`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/strategies/personalization").setMethod("POST").setBody(personalizationStrategyParams).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SetPersonalizationStrategyResponse>(){});
    }

    public CompletableFuture<SetPersonalizationStrategyResponse> setPersonalizationStrategyAsync(@Nonnull PersonalizationStrategyParams personalizationStrategyParams) throws AlgoliaRuntimeException {
        return this.setPersonalizationStrategyAsync(personalizationStrategyParams, null);
    }
}

