/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.config;

import com.algolia.utils.StringUtils;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class RequestOptions {
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private Duration readTimeout;
    private Duration writeTimeout;
    private Duration connectTimeout;

    public RequestOptions addExtraHeader(String key, Object value) {
        if (value == null) {
            return this;
        }
        this.headers.put(key.toLowerCase(), String.valueOf(value));
        return this;
    }

    public RequestOptions addExtraQueryParameters(String key, Object value) {
        if (value == null) {
            return this;
        }
        this.queryParameters.put(key, StringUtils.paramToString(value));
        return this;
    }

    public Map<String, String> getExtraHeaders() {
        return this.headers;
    }

    public Map<String, String> getExtraQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public RequestOptions setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    public RequestOptions setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public RequestOptions setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public RequestOptions mergeRight(@Nullable RequestOptions other) {
        if (other == null) {
            return this;
        }
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.headers.putAll(this.headers);
        requestOptions.headers.putAll(other.headers);
        requestOptions.queryParameters.putAll(this.queryParameters);
        requestOptions.queryParameters.putAll(other.queryParameters);
        requestOptions.readTimeout = other.readTimeout != null ? other.readTimeout : this.readTimeout;
        requestOptions.writeTimeout = other.writeTimeout != null ? other.writeTimeout : this.writeTimeout;
        requestOptions.connectTimeout = other.connectTimeout != null ? other.connectTimeout : this.connectTimeout;
        return requestOptions;
    }

    public String toString() {
        return "RequestOptions{headers=" + this.headers + ", queryParameters=" + this.queryParameters + ", readTimeout=" + this.readTimeout + ", writeTimeout=" + this.writeTimeout + ", connectTimeout=" + this.connectTimeout + '}';
    }
}

