/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.composition;

import com.algolia.model.composition.HighlightResult;
import com.algolia.model.composition.MatchLevel;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonDeserialize(as=HighlightResultOption.class)
public class HighlightResultOption
implements HighlightResult {
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="matchLevel")
    private MatchLevel matchLevel;
    @JsonProperty(value="matchedWords")
    private List<String> matchedWords = new ArrayList<String>();
    @JsonProperty(value="fullyHighlighted")
    private Boolean fullyHighlighted;

    public HighlightResultOption setValue(String value) {
        this.value = value;
        return this;
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    public HighlightResultOption setMatchLevel(MatchLevel matchLevel) {
        this.matchLevel = matchLevel;
        return this;
    }

    @Nonnull
    public MatchLevel getMatchLevel() {
        return this.matchLevel;
    }

    public HighlightResultOption setMatchedWords(List<String> matchedWords) {
        this.matchedWords = matchedWords;
        return this;
    }

    public HighlightResultOption addMatchedWords(String matchedWordsItem) {
        this.matchedWords.add(matchedWordsItem);
        return this;
    }

    @Nonnull
    public List<String> getMatchedWords() {
        return this.matchedWords;
    }

    public HighlightResultOption setFullyHighlighted(Boolean fullyHighlighted) {
        this.fullyHighlighted = fullyHighlighted;
        return this;
    }

    @Nullable
    public Boolean getFullyHighlighted() {
        return this.fullyHighlighted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HighlightResultOption highlightResultOption = (HighlightResultOption)o;
        return Objects.equals(this.value, highlightResultOption.value) && Objects.equals((Object)this.matchLevel, (Object)highlightResultOption.matchLevel) && Objects.equals(this.matchedWords, highlightResultOption.matchedWords) && Objects.equals(this.fullyHighlighted, highlightResultOption.fullyHighlighted);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.matchLevel, this.matchedWords, this.fullyHighlighted});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HighlightResultOption {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    matchLevel: ").append(this.toIndentedString((Object)this.matchLevel)).append("\n");
        sb.append("    matchedWords: ").append(this.toIndentedString(this.matchedWords)).append("\n");
        sb.append("    fullyHighlighted: ").append(this.toIndentedString(this.fullyHighlighted)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

