/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.ingestion;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.ingestion.AuthAPIKey;
import com.algolia.model.ingestion.AuthAlgolia;
import com.algolia.model.ingestion.AuthAlgoliaInsights;
import com.algolia.model.ingestion.AuthBasic;
import com.algolia.model.ingestion.AuthGoogleServiceAccount;
import com.algolia.model.ingestion.AuthOAuth;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface AuthInput {
    public static AuthInput of(Map<String, String> value) {
        return new MapOfStringStringWrapper(value);
    }

    @JsonSerialize(using=Serializer.class)
    public static class MapOfStringStringWrapper
    implements AuthInput {
        private final Map<String, String> value;

        MapOfStringStringWrapper(Map<String, String> value) {
            this.value = value;
        }

        public Map<String, String> getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<MapOfStringStringWrapper> {
            Serializer() {
            }

            public void serialize(MapOfStringStringWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject(value.getValue());
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<AuthInput> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public AuthInput deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonParser parser;
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isObject() && tree.has("url") && tree.has("client_id") && tree.has("client_secret")) {
                AuthInput authInput;
                block63: {
                    JsonParser parser2 = tree.traverse(jp.getCodec());
                    try {
                        authInput = (AuthInput)parser2.readValueAs(AuthOAuth.class);
                        if (parser2 == null) break block63;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser2 != null) {
                                try {
                                    parser2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf AuthOAuth (error: " + e.getMessage() + ") (type: AuthOAuth)");
                        }
                    }
                    parser2.close();
                }
                return authInput;
            }
            if (tree.isObject() && tree.has("clientEmail") && tree.has("privateKey")) {
                AuthInput authInput;
                block64: {
                    JsonParser parser3 = tree.traverse(jp.getCodec());
                    try {
                        authInput = (AuthInput)parser3.readValueAs(AuthGoogleServiceAccount.class);
                        if (parser3 == null) break block64;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser3 != null) {
                                try {
                                    parser3.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf AuthGoogleServiceAccount (error: " + e.getMessage() + ") (type: AuthGoogleServiceAccount)");
                        }
                    }
                    parser3.close();
                }
                return authInput;
            }
            if (tree.isObject() && tree.has("username") && tree.has("password")) {
                AuthInput authInput;
                block65: {
                    parser = tree.traverse(jp.getCodec());
                    try {
                        authInput = (AuthInput)parser.readValueAs(AuthBasic.class);
                        if (parser == null) break block65;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf AuthBasic (error: " + e.getMessage() + ") (type: AuthBasic)");
                        }
                    }
                    parser.close();
                }
                return authInput;
            }
            if (tree.isObject() && tree.has("key")) {
                AuthInput authInput;
                block66: {
                    parser = tree.traverse(jp.getCodec());
                    try {
                        authInput = (AuthInput)parser.readValueAs(AuthAPIKey.class);
                        if (parser == null) break block66;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf AuthAPIKey (error: " + e.getMessage() + ") (type: AuthAPIKey)");
                        }
                    }
                    parser.close();
                }
                return authInput;
            }
            if (tree.isObject()) {
                AuthInput authInput;
                block67: {
                    parser = tree.traverse(jp.getCodec());
                    try {
                        authInput = (AuthInput)parser.readValueAs(AuthAlgolia.class);
                        if (parser == null) break block67;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf AuthAlgolia (error: " + e.getMessage() + ") (type: AuthAlgolia)");
                        }
                    }
                    parser.close();
                }
                return authInput;
            }
            if (tree.isObject()) {
                AuthInput authInput;
                block68: {
                    parser = tree.traverse(jp.getCodec());
                    try {
                        authInput = (AuthInput)parser.readValueAs(AuthAlgoliaInsights.class);
                        if (parser == null) break block68;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf AuthAlgoliaInsights (error: " + e.getMessage() + ") (type: AuthAlgoliaInsights)");
                        }
                    }
                    parser.close();
                }
                return authInput;
            }
            if (tree.isObject()) {
                MapOfStringStringWrapper mapOfStringStringWrapper;
                block69: {
                    parser = tree.traverse(jp.getCodec());
                    try {
                        Map value = (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
                        mapOfStringStringWrapper = new MapOfStringStringWrapper(value);
                        if (parser == null) break block69;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Map<String, String> (error: " + e.getMessage() + ") (type: Map<String, String>)");
                        }
                    }
                    parser.close();
                }
                return mapOfStringStringWrapper;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public AuthInput getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "AuthInput cannot be null");
        }
    }
}

