/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.recommend.SnippetResultOption;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface SnippetResult {
    public static SnippetResult of(Map<String, SnippetResult> value) {
        return new MapOfStringSnippetResultWrapper(value);
    }

    public static SnippetResult of(List<SnippetResult> value) {
        return new ListOfSnippetResultWrapper(value);
    }

    @JsonSerialize(using=Serializer.class)
    public static class MapOfStringSnippetResultWrapper
    implements SnippetResult {
        private final Map<String, SnippetResult> value;

        MapOfStringSnippetResultWrapper(Map<String, SnippetResult> value) {
            this.value = value;
        }

        public Map<String, SnippetResult> getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<MapOfStringSnippetResultWrapper> {
            Serializer() {
            }

            public void serialize(MapOfStringSnippetResultWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject(value.getValue());
            }
        }
    }

    @JsonSerialize(using=Serializer.class)
    public static class ListOfSnippetResultWrapper
    implements SnippetResult {
        private final List<SnippetResult> value;

        ListOfSnippetResultWrapper(List<SnippetResult> value) {
            this.value = value;
        }

        public List<SnippetResult> getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<ListOfSnippetResultWrapper> {
            Serializer() {
            }

            public void serialize(ListOfSnippetResultWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject(value.getValue());
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<SnippetResult> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public SnippetResult deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isObject() && tree.has("matchLevel")) {
                SnippetResult snippetResult;
                block27: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        snippetResult = (SnippetResult)parser.readValueAs(SnippetResultOption.class);
                        if (parser == null) break block27;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf SnippetResultOption (error: " + e.getMessage() + ") (type: SnippetResultOption)");
                        }
                    }
                    parser.close();
                }
                return snippetResult;
            }
            if (tree.isObject()) {
                MapOfStringSnippetResultWrapper mapOfStringSnippetResultWrapper;
                block28: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        Map value = (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, SnippetResult>>(){});
                        mapOfStringSnippetResultWrapper = new MapOfStringSnippetResultWrapper(value);
                        if (parser == null) break block28;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Map<String, SnippetResult> (error: " + e.getMessage() + ") (type: Map<String, SnippetResult>)");
                        }
                    }
                    parser.close();
                }
                return mapOfStringSnippetResultWrapper;
            }
            if (tree.isArray()) {
                ListOfSnippetResultWrapper listOfSnippetResultWrapper;
                block29: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        List value = (List)parser.readValueAs((TypeReference)new TypeReference<List<SnippetResult>>(){});
                        listOfSnippetResultWrapper = new ListOfSnippetResultWrapper(value);
                        if (parser == null) break block29;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf List<SnippetResult> (error: " + e.getMessage() + ") (type: List<SnippetResult>)");
                        }
                    }
                    parser.close();
                }
                return listOfSnippetResultWrapper;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public SnippetResult getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "SnippetResult cannot be null");
        }
    }
}

