/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface BuiltInOperationValue {
    public static BuiltInOperationValue of(String value) {
        return new StringWrapper(value);
    }

    public static BuiltInOperationValue of(Integer value) {
        return new IntegerWrapper(value);
    }

    @JsonSerialize(using=Serializer.class)
    public static class StringWrapper
    implements BuiltInOperationValue {
        private final String value;

        StringWrapper(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<StringWrapper> {
            Serializer() {
            }

            public void serialize(StringWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject((Object)value.getValue());
            }
        }
    }

    @JsonSerialize(using=Serializer.class)
    public static class IntegerWrapper
    implements BuiltInOperationValue {
        private final Integer value;

        IntegerWrapper(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<IntegerWrapper> {
            Serializer() {
            }

            public void serialize(IntegerWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject((Object)value.getValue());
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<BuiltInOperationValue> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public BuiltInOperationValue deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isTextual()) {
                StringWrapper stringWrapper;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        String value = (String)parser.readValueAs(String.class);
                        stringWrapper = new StringWrapper(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf String (error: " + e.getMessage() + ") (type: String)");
                        }
                    }
                    parser.close();
                }
                return stringWrapper;
            }
            if (tree.isInt()) {
                IntegerWrapper integerWrapper;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        Integer value = (Integer)parser.readValueAs(Integer.class);
                        integerWrapper = new IntegerWrapper(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Integer (error: " + e.getMessage() + ") (type: Integer)");
                        }
                    }
                    parser.close();
                }
                return integerWrapper;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public BuiltInOperationValue getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "BuiltInOperationValue cannot be null");
        }
    }
}

