/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface InsideBoundingBox {
    public static InsideBoundingBox of(String value) {
        return new StringWrapper(value);
    }

    public static InsideBoundingBox of(List<List<Double>> value) {
        return new ListOfListOfDoubleWrapper(value);
    }

    @JsonSerialize(using=Serializer.class)
    public static class StringWrapper
    implements InsideBoundingBox {
        private final String value;

        StringWrapper(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<StringWrapper> {
            Serializer() {
            }

            public void serialize(StringWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject((Object)value.getValue());
            }
        }
    }

    @JsonSerialize(using=Serializer.class)
    public static class ListOfListOfDoubleWrapper
    implements InsideBoundingBox {
        private final List<List<Double>> value;

        ListOfListOfDoubleWrapper(List<List<Double>> value) {
            this.value = value;
        }

        public List<List<Double>> getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<ListOfListOfDoubleWrapper> {
            Serializer() {
            }

            public void serialize(ListOfListOfDoubleWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject(value.getValue());
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<InsideBoundingBox> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public InsideBoundingBox deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isTextual()) {
                StringWrapper stringWrapper;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        String value = (String)parser.readValueAs(String.class);
                        stringWrapper = new StringWrapper(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf String (error: " + e.getMessage() + ") (type: String)");
                        }
                    }
                    parser.close();
                }
                return stringWrapper;
            }
            if (tree.isArray()) {
                ListOfListOfDoubleWrapper listOfListOfDoubleWrapper;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        List value = (List)parser.readValueAs((TypeReference)new TypeReference<List<List<Double>>>(){});
                        listOfListOfDoubleWrapper = new ListOfListOfDoubleWrapper(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf List<List<Double>> (error: " + e.getMessage() + ") (type: List<List<Double>>)");
                        }
                    }
                    parser.close();
                }
                return listOfListOfDoubleWrapper;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public InsideBoundingBox getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            return null;
        }
    }
}

