/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.model.search.Condition;
import com.algolia.model.search.Consequence;
import com.algolia.model.search.TimeRange;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Rule {
    @JsonProperty(value="objectID")
    private String objectID;
    @JsonProperty(value="conditions")
    private List<Condition> conditions;
    @JsonProperty(value="consequence")
    private Consequence consequence;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="validity")
    private List<TimeRange> validity;

    public Rule setObjectID(String objectID) {
        this.objectID = objectID;
        return this;
    }

    @Nonnull
    public String getObjectID() {
        return this.objectID;
    }

    public Rule setConditions(List<Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public Rule addConditions(Condition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Rule setConsequence(Consequence consequence) {
        this.consequence = consequence;
        return this;
    }

    @Nonnull
    public Consequence getConsequence() {
        return this.consequence;
    }

    public Rule setDescription(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Rule setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    public Rule setValidity(List<TimeRange> validity) {
        this.validity = validity;
        return this;
    }

    public Rule addValidity(TimeRange validityItem) {
        if (this.validity == null) {
            this.validity = new ArrayList<TimeRange>();
        }
        this.validity.add(validityItem);
        return this;
    }

    @Nullable
    public List<TimeRange> getValidity() {
        return this.validity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals(this.objectID, rule.objectID) && Objects.equals(this.conditions, rule.conditions) && Objects.equals(this.consequence, rule.consequence) && Objects.equals(this.description, rule.description) && Objects.equals(this.enabled, rule.enabled) && Objects.equals(this.validity, rule.validity);
    }

    public int hashCode() {
        return Objects.hash(this.objectID, this.conditions, this.consequence, this.description, this.enabled, this.validity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Rule {\n");
        sb.append("    objectID: ").append(this.toIndentedString(this.objectID)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    consequence: ").append(this.toIndentedString(this.consequence)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    validity: ").append(this.toIndentedString(this.validity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

