/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.search;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.search.SearchForFacetValuesResponse;
import com.algolia.model.search.SearchResponse;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface SearchResult<T> {

    public static class Deserializer<T>
    extends JsonDeserializer<SearchResult<T>>
    implements ContextualDeserializer {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());
        private JavaType returnType;

        public Deserializer() {
        }

        private Deserializer(JavaType returnType) {
            this.returnType = returnType;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            JavaType contextualType = ctxt.getContextualType().containedType(0);
            return new Deserializer<T>(contextualType);
        }

        public SearchResult<T> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isObject() && tree.has("facetHits")) {
                SearchResult searchResult;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        searchResult = (SearchResult)parser.readValueAs(SearchForFacetValuesResponse.class);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf SearchForFacetValuesResponse (error: " + e.getMessage() + ") (type: SearchForFacetValuesResponse)");
                        }
                    }
                    parser.close();
                }
                return searchResult;
            }
            if (tree.isObject()) {
                SearchResult searchResult;
                block20: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        JavaType innerType = ctxt.getTypeFactory().constructParametricType(SearchResponse.class, new JavaType[]{this.returnType});
                        if (parser.getCurrentToken() == null) {
                            parser.nextToken();
                        }
                        searchResult = (SearchResult)ctxt.readValue(parser, innerType);
                        if (parser == null) break block20;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf SearchResponse (error: " + e.getMessage() + ") (type: SearchResponse)");
                        }
                    }
                    parser.close();
                }
                return searchResult;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public SearchResult<T> getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "SearchResult cannot be null");
        }
    }
}

