/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.abtesting.ABTest;
import com.algolia.model.abtesting.ABTestResponse;
import com.algolia.model.abtesting.AddABTestsRequest;
import com.algolia.model.abtesting.ListABTestsResponse;
import com.algolia.model.abtesting.ScheduleABTestResponse;
import com.algolia.model.abtesting.ScheduleABTestsRequest;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class AbtestingClient
extends ApiClient {
    private static final String[] allowedRegions = new String[]{"de", "us"};

    public AbtestingClient(String appId, String apiKey) {
        this(appId, apiKey, null, null);
    }

    public AbtestingClient(String appId, String apiKey, ClientOptions options) {
        this(appId, apiKey, null, options);
    }

    public AbtestingClient(String appId, String apiKey, String region) {
        this(appId, apiKey, region, null);
    }

    public AbtestingClient(String appId, String apiKey, String region, ClientOptions options) {
        super(appId, apiKey, "Abtesting", options, AbtestingClient.getDefaultHosts(region));
    }

    private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
        boolean found;
        ArrayList<Host> hosts = new ArrayList<Host>();
        boolean bl = found = region == null;
        if (region != null) {
            for (String allowed : allowedRegions) {
                if (!allowed.equals(region)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new AlgoliaRuntimeException("`region` must be one of the following: de, us");
        }
        String url = region == null ? "analytics.algolia.com" : "analytics.{region}.algolia.com".replace("{region}", region);
        hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public ABTestResponse addABTests(@Nonnull AddABTestsRequest addABTestsRequest, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.addABTestsAsync(addABTestsRequest, requestOptions));
    }

    public ABTestResponse addABTests(@Nonnull AddABTestsRequest addABTestsRequest) throws AlgoliaRuntimeException {
        return this.addABTests(addABTestsRequest, null);
    }

    public CompletableFuture<ABTestResponse> addABTestsAsync(@Nonnull AddABTestsRequest addABTestsRequest, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(addABTestsRequest, "Parameter `addABTestsRequest` is required when calling `addABTests`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/abtests").setMethod("POST").setBody(addABTestsRequest).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ABTestResponse>(){});
    }

    public CompletableFuture<ABTestResponse> addABTestsAsync(@Nonnull AddABTestsRequest addABTestsRequest) throws AlgoliaRuntimeException {
        return this.addABTestsAsync(addABTestsRequest, null);
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customDeleteAsync(path, parameters, requestOptions));
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDelete(path, parameters, null);
    }

    public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, requestOptions);
    }

    public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, null);
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customGetAsync(path, parameters, requestOptions));
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGet(path, parameters, null);
    }

    public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGet(path, null, requestOptions);
    }

    public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGet(path, null, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, null);
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPostAsync(path, parameters, body, requestOptions));
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPost(path, parameters, body, null);
    }

    public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, requestOptions);
    }

    public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, null);
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPutAsync(path, parameters, body, requestOptions));
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPut(path, parameters, body, null);
    }

    public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, requestOptions);
    }

    public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, null);
    }

    public ABTestResponse deleteABTest(@Nonnull Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteABTestAsync(id, requestOptions));
    }

    public ABTestResponse deleteABTest(@Nonnull Integer id) throws AlgoliaRuntimeException {
        return this.deleteABTest(id, null);
    }

    public CompletableFuture<ABTestResponse> deleteABTestAsync(@Nonnull Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(id, "Parameter `id` is required when calling `deleteABTest`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/abtests/{id}", id).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<ABTestResponse>(){});
    }

    public CompletableFuture<ABTestResponse> deleteABTestAsync(@Nonnull Integer id) throws AlgoliaRuntimeException {
        return this.deleteABTestAsync(id, null);
    }

    public ABTest getABTest(@Nonnull Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getABTestAsync(id, requestOptions));
    }

    public ABTest getABTest(@Nonnull Integer id) throws AlgoliaRuntimeException {
        return this.getABTest(id, null);
    }

    public CompletableFuture<ABTest> getABTestAsync(@Nonnull Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(id, "Parameter `id` is required when calling `getABTest`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/abtests/{id}", id).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<ABTest>(){});
    }

    public CompletableFuture<ABTest> getABTestAsync(@Nonnull Integer id) throws AlgoliaRuntimeException {
        return this.getABTestAsync(id, null);
    }

    public ListABTestsResponse listABTests(Integer offset, Integer limit, String indexPrefix, String indexSuffix, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listABTestsAsync(offset, limit, indexPrefix, indexSuffix, requestOptions));
    }

    public ListABTestsResponse listABTests(Integer offset, Integer limit, String indexPrefix, String indexSuffix) throws AlgoliaRuntimeException {
        return this.listABTests(offset, limit, indexPrefix, indexSuffix, null);
    }

    public ListABTestsResponse listABTests(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listABTests(null, null, null, null, requestOptions);
    }

    public ListABTestsResponse listABTests() throws AlgoliaRuntimeException {
        return this.listABTests(null, null, null, null, null);
    }

    public CompletableFuture<ListABTestsResponse> listABTestsAsync(Integer offset, Integer limit, String indexPrefix, String indexSuffix, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/2/abtests").setMethod("GET").addQueryParameter("offset", offset).addQueryParameter("limit", limit).addQueryParameter("indexPrefix", indexPrefix).addQueryParameter("indexSuffix", indexSuffix).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListABTestsResponse>(){});
    }

    public CompletableFuture<ListABTestsResponse> listABTestsAsync(Integer offset, Integer limit, String indexPrefix, String indexSuffix) throws AlgoliaRuntimeException {
        return this.listABTestsAsync(offset, limit, indexPrefix, indexSuffix, null);
    }

    public CompletableFuture<ListABTestsResponse> listABTestsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listABTestsAsync(null, null, null, null, requestOptions);
    }

    public CompletableFuture<ListABTestsResponse> listABTestsAsync() throws AlgoliaRuntimeException {
        return this.listABTestsAsync(null, null, null, null, null);
    }

    public ScheduleABTestResponse scheduleABTest(@Nonnull ScheduleABTestsRequest scheduleABTestsRequest, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.scheduleABTestAsync(scheduleABTestsRequest, requestOptions));
    }

    public ScheduleABTestResponse scheduleABTest(@Nonnull ScheduleABTestsRequest scheduleABTestsRequest) throws AlgoliaRuntimeException {
        return this.scheduleABTest(scheduleABTestsRequest, null);
    }

    public CompletableFuture<ScheduleABTestResponse> scheduleABTestAsync(@Nonnull ScheduleABTestsRequest scheduleABTestsRequest, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(scheduleABTestsRequest, "Parameter `scheduleABTestsRequest` is required when calling `scheduleABTest`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/abtests/schedule").setMethod("POST").setBody(scheduleABTestsRequest).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ScheduleABTestResponse>(){});
    }

    public CompletableFuture<ScheduleABTestResponse> scheduleABTestAsync(@Nonnull ScheduleABTestsRequest scheduleABTestsRequest) throws AlgoliaRuntimeException {
        return this.scheduleABTestAsync(scheduleABTestsRequest, null);
    }

    public ABTestResponse stopABTest(@Nonnull Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.stopABTestAsync(id, requestOptions));
    }

    public ABTestResponse stopABTest(@Nonnull Integer id) throws AlgoliaRuntimeException {
        return this.stopABTest(id, null);
    }

    public CompletableFuture<ABTestResponse> stopABTestAsync(@Nonnull Integer id, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(id, "Parameter `id` is required when calling `stopABTest`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/abtests/{id}/stop", id).setMethod("POST").build();
        return this.executeAsync(request, requestOptions, new TypeReference<ABTestResponse>(){});
    }

    public CompletableFuture<ABTestResponse> stopABTestAsync(@Nonnull Integer id) throws AlgoliaRuntimeException {
        return this.stopABTestAsync(id, null);
    }
}

