/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.usage.Granularity;
import com.algolia.model.usage.IndexUsage;
import com.algolia.model.usage.Statistic;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class UsageClient
extends ApiClient {
    public UsageClient(String appId, String apiKey) {
        this(appId, apiKey, null);
    }

    public UsageClient(String appId, String apiKey, ClientOptions options) {
        super(appId, apiKey, "Usage", options, UsageClient.getDefaultHosts(appId));
    }

    private static List<Host> getDefaultHosts(String appId) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        hosts.add(new Host(appId + "-dsn.algolia.net", EnumSet.of(CallType.READ)));
        hosts.add(new Host(appId + ".algolia.net", EnumSet.of(CallType.WRITE)));
        ArrayList commonHosts = new ArrayList();
        hosts.add(new Host(appId + "-1.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new Host(appId + "-2.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        hosts.add(new Host(appId + "-3.algolianet.net", EnumSet.of(CallType.READ, CallType.WRITE)));
        Collections.shuffle(commonHosts, new Random());
        return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customDeleteAsync(path, parameters, requestOptions));
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDelete(path, parameters, null);
    }

    public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, requestOptions);
    }

    public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, null);
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customGetAsync(path, parameters, requestOptions));
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGet(path, parameters, null);
    }

    public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGet(path, null, requestOptions);
    }

    public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGet(path, null, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, null);
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPostAsync(path, parameters, body, requestOptions));
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPost(path, parameters, body, null);
    }

    public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, requestOptions);
    }

    public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, null);
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPutAsync(path, parameters, body, requestOptions));
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPut(path, parameters, body, null);
    }

    public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, requestOptions);
    }

    public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, null);
    }

    public IndexUsage getIndexUsage(@Nonnull Statistic statistic, @Nonnull String indexName, @Nonnull String startDate, @Nonnull String endDate, Granularity granularity, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getIndexUsageAsync(statistic, indexName, startDate, endDate, granularity, requestOptions));
    }

    public IndexUsage getIndexUsage(@Nonnull Statistic statistic, @Nonnull String indexName, @Nonnull String startDate, @Nonnull String endDate, Granularity granularity) throws AlgoliaRuntimeException {
        return this.getIndexUsage(statistic, indexName, startDate, endDate, granularity, null);
    }

    public IndexUsage getIndexUsage(@Nonnull Statistic statistic, @Nonnull String indexName, @Nonnull String startDate, @Nonnull String endDate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getIndexUsage(statistic, indexName, startDate, endDate, null, requestOptions);
    }

    public IndexUsage getIndexUsage(@Nonnull Statistic statistic, @Nonnull String indexName, @Nonnull String startDate, @Nonnull String endDate) throws AlgoliaRuntimeException {
        return this.getIndexUsage(statistic, indexName, startDate, endDate, null, null);
    }

    public CompletableFuture<IndexUsage> getIndexUsageAsync(@Nonnull Statistic statistic, @Nonnull String indexName, @Nonnull String startDate, @Nonnull String endDate, Granularity granularity, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull((Object)statistic, "Parameter `statistic` is required when calling `getIndexUsage`.");
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getIndexUsage`.");
        Parameters.requireNonNull(startDate, "Parameter `startDate` is required when calling `getIndexUsage`.");
        Parameters.requireNonNull(endDate, "Parameter `endDate` is required when calling `getIndexUsage`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/usage/{statistic}/{indexName}", new Object[]{statistic, indexName}).setMethod("GET").addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("granularity", (Object)granularity).build();
        return this.executeAsync(request, requestOptions, new TypeReference<IndexUsage>(){});
    }

    public CompletableFuture<IndexUsage> getIndexUsageAsync(@Nonnull Statistic statistic, @Nonnull String indexName, @Nonnull String startDate, @Nonnull String endDate, Granularity granularity) throws AlgoliaRuntimeException {
        return this.getIndexUsageAsync(statistic, indexName, startDate, endDate, granularity, null);
    }

    public CompletableFuture<IndexUsage> getIndexUsageAsync(@Nonnull Statistic statistic, @Nonnull String indexName, @Nonnull String startDate, @Nonnull String endDate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getIndexUsageAsync(statistic, indexName, startDate, endDate, null, requestOptions);
    }

    public CompletableFuture<IndexUsage> getIndexUsageAsync(@Nonnull Statistic statistic, @Nonnull String indexName, @Nonnull String startDate, @Nonnull String endDate) throws AlgoliaRuntimeException {
        return this.getIndexUsageAsync(statistic, indexName, startDate, endDate, null, null);
    }

    public IndexUsage getUsage(@Nonnull Statistic statistic, @Nonnull String startDate, @Nonnull String endDate, Granularity granularity, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getUsageAsync(statistic, startDate, endDate, granularity, requestOptions));
    }

    public IndexUsage getUsage(@Nonnull Statistic statistic, @Nonnull String startDate, @Nonnull String endDate, Granularity granularity) throws AlgoliaRuntimeException {
        return this.getUsage(statistic, startDate, endDate, granularity, null);
    }

    public IndexUsage getUsage(@Nonnull Statistic statistic, @Nonnull String startDate, @Nonnull String endDate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getUsage(statistic, startDate, endDate, null, requestOptions);
    }

    public IndexUsage getUsage(@Nonnull Statistic statistic, @Nonnull String startDate, @Nonnull String endDate) throws AlgoliaRuntimeException {
        return this.getUsage(statistic, startDate, endDate, null, null);
    }

    public CompletableFuture<IndexUsage> getUsageAsync(@Nonnull Statistic statistic, @Nonnull String startDate, @Nonnull String endDate, Granularity granularity, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull((Object)statistic, "Parameter `statistic` is required when calling `getUsage`.");
        Parameters.requireNonNull(startDate, "Parameter `startDate` is required when calling `getUsage`.");
        Parameters.requireNonNull(endDate, "Parameter `endDate` is required when calling `getUsage`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/usage/{statistic}", new Object[]{statistic}).setMethod("GET").addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).addQueryParameter("granularity", (Object)granularity).build();
        return this.executeAsync(request, requestOptions, new TypeReference<IndexUsage>(){});
    }

    public CompletableFuture<IndexUsage> getUsageAsync(@Nonnull Statistic statistic, @Nonnull String startDate, @Nonnull String endDate, Granularity granularity) throws AlgoliaRuntimeException {
        return this.getUsageAsync(statistic, startDate, endDate, granularity, null);
    }

    public CompletableFuture<IndexUsage> getUsageAsync(@Nonnull Statistic statistic, @Nonnull String startDate, @Nonnull String endDate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.getUsageAsync(statistic, startDate, endDate, null, requestOptions);
    }

    public CompletableFuture<IndexUsage> getUsageAsync(@Nonnull Statistic statistic, @Nonnull String startDate, @Nonnull String endDate) throws AlgoliaRuntimeException {
        return this.getUsageAsync(statistic, startDate, endDate, null, null);
    }
}

