/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.ingestion;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.ingestion.DockerStreamsInput;
import com.algolia.model.ingestion.ShopifyInput;
import com.algolia.model.ingestion.StreamingInput;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface TaskInput {

    public static class Deserializer
    extends JsonDeserializer<TaskInput> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public TaskInput deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isObject() && tree.has("mapping")) {
                TaskInput taskInput;
                block27: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        taskInput = (TaskInput)parser.readValueAs(StreamingInput.class);
                        if (parser == null) break block27;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf StreamingInput (error: " + e.getMessage() + ") (type: StreamingInput)");
                        }
                    }
                    parser.close();
                }
                return taskInput;
            }
            if (tree.isObject() && tree.has("streams")) {
                TaskInput taskInput;
                block28: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        taskInput = (TaskInput)parser.readValueAs(DockerStreamsInput.class);
                        if (parser == null) break block28;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf DockerStreamsInput (error: " + e.getMessage() + ") (type: DockerStreamsInput)");
                        }
                    }
                    parser.close();
                }
                return taskInput;
            }
            if (tree.isObject()) {
                TaskInput taskInput;
                block29: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        taskInput = (TaskInput)parser.readValueAs(ShopifyInput.class);
                        if (parser == null) break block29;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf ShopifyInput (error: " + e.getMessage() + ") (type: ShopifyInput)");
                        }
                    }
                    parser.close();
                }
                return taskInput;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public TaskInput getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "TaskInput cannot be null");
        }
    }
}

