// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.*;
import com.algolia.config.ClientOptions;
import com.algolia.exceptions.*;
import com.algolia.model.recommend.*;
import com.algolia.utils.*;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class RecommendClient extends ApiClient {

  public RecommendClient(String appId, String apiKey) {
    this(appId, apiKey, null);
  }

  public RecommendClient(String appId, String apiKey, ClientOptions options) {
    super(appId, apiKey, "Recommend", options, getDefaultHosts(appId));
  }

  private static List<Host> getDefaultHosts(String appId) {
    List<Host> hosts = new ArrayList<>();
    hosts.add(new Host(appId + "-dsn.algolia.net", EnumSet.of(CallType.READ)));
    hosts.add(new Host(appId + ".algolia.net", EnumSet.of(CallType.WRITE)));

    List<Host> commonHosts = new ArrayList<>();
    commonHosts.add(new Host(appId + "-1.algolianet.com", EnumSet.of(CallType.READ, CallType.WRITE)));
    commonHosts.add(new Host(appId + "-2.algolianet.com", EnumSet.of(CallType.READ, CallType.WRITE)));
    commonHosts.add(new Host(appId + "-3.algolianet.com", EnumSet.of(CallType.READ, CallType.WRITE)));

    Collections.shuffle(commonHosts, new Random());

    return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customDeleteAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDelete(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDelete(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customDeleteAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customGetAsync(path, parameters, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGet(path, parameters, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGet(path, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGet(path, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");

    HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, parameters, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customGetAsync(path, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPostAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPost(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPost(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");

    HttpRequest request = HttpRequest.builder()
      .setPathEncoded("/{path}", path)
      .setMethod("POST")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPostAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPostAsync(path, null, null, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions)
    throws AlgoliaRuntimeException {
    return LaunderThrowable.await(customPutAsync(path, parameters, body, requestOptions));
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
    return this.customPut(path, parameters, body, null);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, requestOptions);
  }

  /**
   * This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPut(path, null, null, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(
    @Nonnull String path,
    Map<String, Object> parameters,
    Object body,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");

    HttpRequest request = HttpRequest.builder()
      .setPathEncoded("/{path}", path)
      .setMethod("PUT")
      .setBody(body)
      .addQueryParameters(parameters)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<Object>() {});
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param parameters Query parameters to apply to the current query. (optional)
   * @param body Parameters to send with the custom request. (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body)
    throws AlgoliaRuntimeException {
    return this.customPutAsync(path, parameters, body, null);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, requestOptions);
  }

  /**
   * (asynchronously) This method allow you to send requests to the Algolia REST API.
   *
   * @param path Path of the endpoint, anything after \"/1\" must be specified. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
    return this.customPutAsync(path, null, null, null);
  }

  /**
   * Deletes a Recommend rule from a recommendation scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteRecommendRule(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(deleteRecommendRuleAsync(indexName, model, objectID, requestOptions));
  }

  /**
   * Deletes a Recommend rule from a recommendation scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public DeletedAtResponse deleteRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID)
    throws AlgoliaRuntimeException {
    return this.deleteRecommendRule(indexName, model, objectID, null);
  }

  /**
   * (asynchronously) Deletes a Recommend rule from a recommendation scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteRecommendRule`.");

    Parameters.requireNonNull(model, "Parameter `model` is required when calling `deleteRecommendRule`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `deleteRecommendRule`.");

    HttpRequest request = HttpRequest.builder()
      .setPath("/1/indexes/{indexName}/{model}/recommend/rules/{objectID}", indexName, model, objectID)
      .setMethod("DELETE")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>() {});
  }

  /**
   * (asynchronously) Deletes a Recommend rule from a recommendation scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID
  ) throws AlgoliaRuntimeException {
    return this.deleteRecommendRuleAsync(indexName, model, objectID, null);
  }

  /**
   * Retrieves a Recommend rule that you previously created in the Algolia dashboard.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RecommendRule getRecommendRule(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRecommendRuleAsync(indexName, model, objectID, requestOptions));
  }

  /**
   * Retrieves a Recommend rule that you previously created in the Algolia dashboard.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public RecommendRule getRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID)
    throws AlgoliaRuntimeException {
    return this.getRecommendRule(indexName, model, objectID, null);
  }

  /**
   * (asynchronously) Retrieves a Recommend rule that you previously created in the Algolia
   * dashboard.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RecommendRule> getRecommendRuleAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getRecommendRule`.");

    Parameters.requireNonNull(model, "Parameter `model` is required when calling `getRecommendRule`.");

    Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `getRecommendRule`.");

    HttpRequest request = HttpRequest.builder()
      .setPath("/1/indexes/{indexName}/{model}/recommend/rules/{objectID}", indexName, model, objectID)
      .setMethod("GET")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<RecommendRule>() {});
  }

  /**
   * (asynchronously) Retrieves a Recommend rule that you previously created in the Algolia
   * dashboard.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param objectID Unique record identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<RecommendRule> getRecommendRuleAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull String objectID
  ) throws AlgoliaRuntimeException {
    return this.getRecommendRuleAsync(indexName, model, objectID, null);
  }

  /**
   * Checks the status of a given task. Deleting a Recommend rule is asynchronous. When you delete a
   * rule, a task is created on a queue and completed depending on the load on the server. The API
   * response includes a task ID that you can use to check the status.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique task identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendTaskResponse getRecommendStatus(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull Long taskID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRecommendStatusAsync(indexName, model, taskID, requestOptions));
  }

  /**
   * Checks the status of a given task. Deleting a Recommend rule is asynchronous. When you delete a
   * rule, a task is created on a queue and completed depending on the load on the server. The API
   * response includes a task ID that you can use to check the status.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique task identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendTaskResponse getRecommendStatus(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull Long taskID)
    throws AlgoliaRuntimeException {
    return this.getRecommendStatus(indexName, model, taskID, null);
  }

  /**
   * (asynchronously) Checks the status of a given task. Deleting a Recommend rule is asynchronous.
   * When you delete a rule, a task is created on a queue and completed depending on the load on the
   * server. The API response includes a task ID that you can use to check the status.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique task identifier. (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull Long taskID,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getRecommendStatus`.");

    Parameters.requireNonNull(model, "Parameter `model` is required when calling `getRecommendStatus`.");

    Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `getRecommendStatus`.");

    HttpRequest request = HttpRequest.builder()
      .setPath("/1/indexes/{indexName}/{model}/task/{taskID}", indexName, model, taskID)
      .setMethod("GET")
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetRecommendTaskResponse>() {});
  }

  /**
   * (asynchronously) Checks the status of a given task. Deleting a Recommend rule is asynchronous.
   * When you delete a rule, a task is created on a queue and completed depending on the load on the
   * server. The API response includes a task ID that you can use to check the status.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param taskID Unique task identifier. (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    @Nonnull Long taskID
  ) throws AlgoliaRuntimeException {
    return this.getRecommendStatusAsync(indexName, model, taskID, null);
  }

  /**
   * Retrieves recommendations from selected AI models.
   *
   * @param getRecommendationsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendationsResponse getRecommendations(
    @Nonnull GetRecommendationsParams getRecommendationsParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(getRecommendationsAsync(getRecommendationsParams, requestOptions));
  }

  /**
   * Retrieves recommendations from selected AI models.
   *
   * @param getRecommendationsParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public GetRecommendationsResponse getRecommendations(@Nonnull GetRecommendationsParams getRecommendationsParams)
    throws AlgoliaRuntimeException {
    return this.getRecommendations(getRecommendationsParams, null);
  }

  /**
   * (asynchronously) Retrieves recommendations from selected AI models.
   *
   * @param getRecommendationsParams (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(
    @Nonnull GetRecommendationsParams getRecommendationsParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(
      getRecommendationsParams,
      "Parameter `getRecommendationsParams` is required when calling `getRecommendations`."
    );

    HttpRequest request = HttpRequest.builder()
      .setPath("/1/indexes/*/recommendations")
      .setMethod("POST")
      .setBody(getRecommendationsParams)
      .setRead(true)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<GetRecommendationsResponse>() {});
  }

  /**
   * (asynchronously) Retrieves recommendations from selected AI models.
   *
   * @param getRecommendationsParams (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(@Nonnull GetRecommendationsParams getRecommendationsParams)
    throws AlgoliaRuntimeException {
    return this.getRecommendationsAsync(getRecommendationsParams, null);
  }

  /**
   * Searches for Recommend rules. Use an empty query to list all rules for this recommendation
   * scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return LaunderThrowable.await(searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, requestOptions));
  }

  /**
   * Searches for Recommend rules. Use an empty query to list all rules for this recommendation
   * scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRules(indexName, model, searchRecommendRulesParams, null);
  }

  /**
   * Searches for Recommend rules. Use an empty query to list all rules for this recommendation
   * scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRules(indexName, model, null, requestOptions);
  }

  /**
   * Searches for Recommend rules. Use an empty query to list all rules for this recommendation
   * scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public SearchRecommendRulesResponse searchRecommendRules(@Nonnull String indexName, @Nonnull RecommendModels model)
    throws AlgoliaRuntimeException {
    return this.searchRecommendRules(indexName, model, null, null);
  }

  /**
   * (asynchronously) Searches for Recommend rules. Use an empty query to list all rules for this
   * recommendation scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchRecommendRules`.");

    Parameters.requireNonNull(model, "Parameter `model` is required when calling `searchRecommendRules`.");

    HttpRequest request = HttpRequest.builder()
      .setPath("/1/indexes/{indexName}/{model}/recommend/rules/search", indexName, model)
      .setMethod("POST")
      .setBody(searchRecommendRulesParams)
      .setRead(true)
      .build();
    return executeAsync(request, requestOptions, new TypeReference<SearchRecommendRulesResponse>() {});
  }

  /**
   * (asynchronously) Searches for Recommend rules. Use an empty query to list all rules for this
   * recommendation scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param searchRecommendRulesParams (optional)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    SearchRecommendRulesParams searchRecommendRulesParams
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, null);
  }

  /**
   * (asynchronously) Searches for Recommend rules. Use an empty query to list all rules for this
   * recommendation scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @param requestOptions The requestOptions to send along with the query, they will be merged with
   *     the transporter requestOptions.
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model,
    RequestOptions requestOptions
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRulesAsync(indexName, model, null, requestOptions);
  }

  /**
   * (asynchronously) Searches for Recommend rules. Use an empty query to list all rules for this
   * recommendation scenario.
   *
   * @param indexName Name of the index on which to perform the operation. (required)
   * @param model [Recommend
   *     model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).
   *     (required)
   * @throws AlgoliaRuntimeException If it fails to process the API call
   */
  public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(
    @Nonnull String indexName,
    @Nonnull RecommendModels model
  ) throws AlgoliaRuntimeException {
    return this.searchRecommendRulesAsync(indexName, model, null, null);
  }
}
