// Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost
// - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.

package com.algolia.model.search;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/** SettingsResponse */
public class SettingsResponse {

  @JsonProperty("attributesForFaceting")
  private List<String> attributesForFaceting;

  @JsonProperty("replicas")
  private List<String> replicas;

  @JsonProperty("paginationLimitedTo")
  private Integer paginationLimitedTo;

  @JsonProperty("unretrievableAttributes")
  private List<String> unretrievableAttributes;

  @JsonProperty("disableTypoToleranceOnWords")
  private List<String> disableTypoToleranceOnWords;

  @JsonProperty("attributesToTransliterate")
  private List<String> attributesToTransliterate;

  @JsonProperty("camelCaseAttributes")
  private List<String> camelCaseAttributes;

  @JsonProperty("decompoundedAttributes")
  private Object decompoundedAttributes;

  @JsonProperty("indexLanguages")
  private List<SupportedLanguage> indexLanguages;

  @JsonProperty("disablePrefixOnAttributes")
  private List<String> disablePrefixOnAttributes;

  @JsonProperty("allowCompressionOfIntegerArray")
  private Boolean allowCompressionOfIntegerArray;

  @JsonProperty("numericAttributesForFiltering")
  private List<String> numericAttributesForFiltering;

  @JsonProperty("separatorsToIndex")
  private String separatorsToIndex;

  @JsonProperty("searchableAttributes")
  private List<String> searchableAttributes;

  @JsonProperty("userData")
  private Object userData;

  @JsonProperty("customNormalization")
  private Map<String, Map<String, String>> customNormalization;

  @JsonProperty("attributeForDistinct")
  private String attributeForDistinct;

  @JsonProperty("attributesToRetrieve")
  private List<String> attributesToRetrieve;

  @JsonProperty("ranking")
  private List<String> ranking;

  @JsonProperty("customRanking")
  private List<String> customRanking;

  @JsonProperty("relevancyStrictness")
  private Integer relevancyStrictness;

  @JsonProperty("attributesToHighlight")
  private List<String> attributesToHighlight;

  @JsonProperty("attributesToSnippet")
  private List<String> attributesToSnippet;

  @JsonProperty("highlightPreTag")
  private String highlightPreTag;

  @JsonProperty("highlightPostTag")
  private String highlightPostTag;

  @JsonProperty("snippetEllipsisText")
  private String snippetEllipsisText;

  @JsonProperty("restrictHighlightAndSnippetArrays")
  private Boolean restrictHighlightAndSnippetArrays;

  @JsonProperty("hitsPerPage")
  private Integer hitsPerPage;

  @JsonProperty("minWordSizefor1Typo")
  private Integer minWordSizefor1Typo;

  @JsonProperty("minWordSizefor2Typos")
  private Integer minWordSizefor2Typos;

  @JsonProperty("typoTolerance")
  private TypoTolerance typoTolerance;

  @JsonProperty("allowTyposOnNumericTokens")
  private Boolean allowTyposOnNumericTokens;

  @JsonProperty("disableTypoToleranceOnAttributes")
  private List<String> disableTypoToleranceOnAttributes;

  @JsonProperty("ignorePlurals")
  private IgnorePlurals ignorePlurals;

  @JsonProperty("removeStopWords")
  private RemoveStopWords removeStopWords;

  @JsonProperty("keepDiacriticsOnCharacters")
  private String keepDiacriticsOnCharacters;

  @JsonProperty("queryLanguages")
  private List<SupportedLanguage> queryLanguages;

  @JsonProperty("decompoundQuery")
  private Boolean decompoundQuery;

  @JsonProperty("enableRules")
  private Boolean enableRules;

  @JsonProperty("enablePersonalization")
  private Boolean enablePersonalization;

  @JsonProperty("queryType")
  private QueryType queryType;

  @JsonProperty("removeWordsIfNoResults")
  private RemoveWordsIfNoResults removeWordsIfNoResults;

  @JsonProperty("mode")
  private Mode mode;

  @JsonProperty("semanticSearch")
  private SemanticSearch semanticSearch;

  @JsonProperty("advancedSyntax")
  private Boolean advancedSyntax;

  @JsonProperty("optionalWords")
  private List<String> optionalWords;

  @JsonProperty("disableExactOnAttributes")
  private List<String> disableExactOnAttributes;

  @JsonProperty("exactOnSingleWordQuery")
  private ExactOnSingleWordQuery exactOnSingleWordQuery;

  @JsonProperty("alternativesAsExact")
  private List<AlternativesAsExact> alternativesAsExact;

  @JsonProperty("advancedSyntaxFeatures")
  private List<AdvancedSyntaxFeatures> advancedSyntaxFeatures;

  @JsonProperty("distinct")
  private Distinct distinct;

  @JsonProperty("replaceSynonymsInHighlight")
  private Boolean replaceSynonymsInHighlight;

  @JsonProperty("minProximity")
  private Integer minProximity;

  @JsonProperty("responseFields")
  private List<String> responseFields;

  @JsonProperty("maxFacetHits")
  private Integer maxFacetHits;

  @JsonProperty("maxValuesPerFacet")
  private Integer maxValuesPerFacet;

  @JsonProperty("sortFacetValuesBy")
  private String sortFacetValuesBy;

  @JsonProperty("attributeCriteriaComputedByMinProximity")
  private Boolean attributeCriteriaComputedByMinProximity;

  @JsonProperty("renderingContent")
  private RenderingContent renderingContent;

  @JsonProperty("enableReRanking")
  private Boolean enableReRanking;

  @JsonProperty("reRankingApplyFilter")
  private ReRankingApplyFilter reRankingApplyFilter;

  @JsonProperty("primary")
  private String primary;

  public SettingsResponse setAttributesForFaceting(List<String> attributesForFaceting) {
    this.attributesForFaceting = attributesForFaceting;
    return this;
  }

  public SettingsResponse addAttributesForFaceting(String attributesForFacetingItem) {
    if (this.attributesForFaceting == null) {
      this.attributesForFaceting = new ArrayList<>();
    }
    this.attributesForFaceting.add(attributesForFacetingItem);
    return this;
  }

  /**
   * Attributes used for
   * [faceting](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/).
   * Facets are attributes that let you categorize search results. They can be used for filtering
   * search results. By default, no attribute is used for faceting. Attribute names are
   * case-sensitive. **Modifiers** - `filterOnly(\"ATTRIBUTE\")`. Allows using this attribute as a
   * filter, but doesn't evalue the facet values. - `searchable(\"ATTRIBUTE\")`. Allows searching
   * for facet values. - `afterDistinct(\"ATTRIBUTE\")`. Evaluates the facet count _after_
   * deduplication with `distinct`. This ensures accurate facet counts. You can apply this modifier
   * to searchable facets: `afterDistinct(searchable(ATTRIBUTE))`.
   */
  @javax.annotation.Nullable
  public List<String> getAttributesForFaceting() {
    return attributesForFaceting;
  }

  public SettingsResponse setReplicas(List<String> replicas) {
    this.replicas = replicas;
    return this;
  }

  public SettingsResponse addReplicas(String replicasItem) {
    if (this.replicas == null) {
      this.replicas = new ArrayList<>();
    }
    this.replicas.add(replicasItem);
    return this;
  }

  /**
   * Creates [replica
   * indices](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/in-depth/replicas/).
   * Replicas are copies of a primary index with the same records but different settings, synonyms,
   * or rules. If you want to offer a different ranking or sorting of your search results, you'll
   * use replica indices. All index operations on a primary index are automatically forwarded to its
   * replicas. To add a replica index, you must provide the complete set of replicas to this
   * parameter. If you omit a replica from this list, the replica turns into a regular, standalone
   * index that will no longer by synced with the primary index. **Modifier** -
   * `virtual(\"REPLICA\")`. Create a virtual replica, Virtual replicas don't increase the number of
   * records and are optimized for [Relevant
   * sorting](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/in-depth/relevant-sort/).
   */
  @javax.annotation.Nullable
  public List<String> getReplicas() {
    return replicas;
  }

  public SettingsResponse setPaginationLimitedTo(Integer paginationLimitedTo) {
    this.paginationLimitedTo = paginationLimitedTo;
    return this;
  }

  /**
   * Maximum number of search results that can be obtained through pagination. Higher pagination
   * limits might slow down your search. For pagination limits above 1,000, the sorting of results
   * beyond the 1,000th hit can't be guaranteed. maximum: 20000
   */
  @javax.annotation.Nullable
  public Integer getPaginationLimitedTo() {
    return paginationLimitedTo;
  }

  public SettingsResponse setUnretrievableAttributes(List<String> unretrievableAttributes) {
    this.unretrievableAttributes = unretrievableAttributes;
    return this;
  }

  public SettingsResponse addUnretrievableAttributes(String unretrievableAttributesItem) {
    if (this.unretrievableAttributes == null) {
      this.unretrievableAttributes = new ArrayList<>();
    }
    this.unretrievableAttributes.add(unretrievableAttributesItem);
    return this;
  }

  /**
   * Attributes that can't be retrieved at query time. This can be useful if you want to use an
   * attribute for ranking or to [restrict
   * access](https://www.algolia.com/doc/guides/security/api-keys/how-to/user-restricted-access-to-data/),
   * but don't want to include it in the search results. Attribute names are case-sensitive.
   */
  @javax.annotation.Nullable
  public List<String> getUnretrievableAttributes() {
    return unretrievableAttributes;
  }

  public SettingsResponse setDisableTypoToleranceOnWords(List<String> disableTypoToleranceOnWords) {
    this.disableTypoToleranceOnWords = disableTypoToleranceOnWords;
    return this;
  }

  public SettingsResponse addDisableTypoToleranceOnWords(String disableTypoToleranceOnWordsItem) {
    if (this.disableTypoToleranceOnWords == null) {
      this.disableTypoToleranceOnWords = new ArrayList<>();
    }
    this.disableTypoToleranceOnWords.add(disableTypoToleranceOnWordsItem);
    return this;
  }

  /**
   * Words for which you want to turn off [typo
   * tolerance](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/).
   * This also turns off [word splitting and
   * concatenation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/splitting-and-concatenation/)
   * for the specified words.
   */
  @javax.annotation.Nullable
  public List<String> getDisableTypoToleranceOnWords() {
    return disableTypoToleranceOnWords;
  }

  public SettingsResponse setAttributesToTransliterate(List<String> attributesToTransliterate) {
    this.attributesToTransliterate = attributesToTransliterate;
    return this;
  }

  public SettingsResponse addAttributesToTransliterate(String attributesToTransliterateItem) {
    if (this.attributesToTransliterate == null) {
      this.attributesToTransliterate = new ArrayList<>();
    }
    this.attributesToTransliterate.add(attributesToTransliterateItem);
    return this;
  }

  /**
   * Attributes, for which you want to support [Japanese
   * transliteration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/#japanese-transliteration-and-type-ahead).
   * Transliteration supports searching in any of the Japanese writing systems. To support
   * transliteration, you must set the indexing language to Japanese. Attribute names are
   * case-sensitive.
   */
  @javax.annotation.Nullable
  public List<String> getAttributesToTransliterate() {
    return attributesToTransliterate;
  }

  public SettingsResponse setCamelCaseAttributes(List<String> camelCaseAttributes) {
    this.camelCaseAttributes = camelCaseAttributes;
    return this;
  }

  public SettingsResponse addCamelCaseAttributes(String camelCaseAttributesItem) {
    if (this.camelCaseAttributes == null) {
      this.camelCaseAttributes = new ArrayList<>();
    }
    this.camelCaseAttributes.add(camelCaseAttributesItem);
    return this;
  }

  /**
   * Attributes for which to split [camel case](https://wikipedia.org/wiki/Camel_case) words.
   * Attribute names are case-sensitive.
   */
  @javax.annotation.Nullable
  public List<String> getCamelCaseAttributes() {
    return camelCaseAttributes;
  }

  public SettingsResponse setDecompoundedAttributes(Object decompoundedAttributes) {
    this.decompoundedAttributes = decompoundedAttributes;
    return this;
  }

  /**
   * Searchable attributes to which Algolia should apply [word
   * segmentation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/how-to/customize-segmentation/)
   * (decompounding). Attribute names are case-sensitive. Compound words are formed by combining two
   * or more individual words, and are particularly prevalent in Germanic languages—for example,
   * \"firefighter\". With decompounding, the individual components are indexed separately. You can
   * specify different lists for different languages. Decompounding is supported for these
   * languages: Dutch (`nl`), German (`de`), Finnish (`fi`), Danish (`da`), Swedish (`sv`), and
   * Norwegian (`no`). Decompounding doesn't work for words with [non-spacing mark Unicode
   * characters](https://www.charactercodes.net/category/non-spacing_mark). For example,
   * `Gartenstühle` won't be decompounded if the `ü` consists of `u` (U+0075) and `◌̈` (U+0308).
   */
  @javax.annotation.Nullable
  public Object getDecompoundedAttributes() {
    return decompoundedAttributes;
  }

  public SettingsResponse setIndexLanguages(List<SupportedLanguage> indexLanguages) {
    this.indexLanguages = indexLanguages;
    return this;
  }

  public SettingsResponse addIndexLanguages(SupportedLanguage indexLanguagesItem) {
    if (this.indexLanguages == null) {
      this.indexLanguages = new ArrayList<>();
    }
    this.indexLanguages.add(indexLanguagesItem);
    return this;
  }

  /**
   * Languages for language-specific processing steps, such as word detection and dictionary
   * settings. **You should always specify an indexing language.** If you don't specify an indexing
   * language, the search engine uses all [supported
   * languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/),
   * or the languages you specified with the `ignorePlurals` or `removeStopWords` parameters. This
   * can lead to unexpected search results. For more information, see [Language-specific
   * configuration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/).
   */
  @javax.annotation.Nullable
  public List<SupportedLanguage> getIndexLanguages() {
    return indexLanguages;
  }

  public SettingsResponse setDisablePrefixOnAttributes(List<String> disablePrefixOnAttributes) {
    this.disablePrefixOnAttributes = disablePrefixOnAttributes;
    return this;
  }

  public SettingsResponse addDisablePrefixOnAttributes(String disablePrefixOnAttributesItem) {
    if (this.disablePrefixOnAttributes == null) {
      this.disablePrefixOnAttributes = new ArrayList<>();
    }
    this.disablePrefixOnAttributes.add(disablePrefixOnAttributesItem);
    return this;
  }

  /**
   * Searchable attributes for which you want to turn off [prefix
   * matching](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/override-search-engine-defaults/#adjusting-prefix-search).
   * Attribute names are case-sensitive.
   */
  @javax.annotation.Nullable
  public List<String> getDisablePrefixOnAttributes() {
    return disablePrefixOnAttributes;
  }

  public SettingsResponse setAllowCompressionOfIntegerArray(Boolean allowCompressionOfIntegerArray) {
    this.allowCompressionOfIntegerArray = allowCompressionOfIntegerArray;
    return this;
  }

  /**
   * Whether arrays with exclusively non-negative integers should be compressed for better
   * performance. If true, the compressed arrays may be reordered.
   */
  @javax.annotation.Nullable
  public Boolean getAllowCompressionOfIntegerArray() {
    return allowCompressionOfIntegerArray;
  }

  public SettingsResponse setNumericAttributesForFiltering(List<String> numericAttributesForFiltering) {
    this.numericAttributesForFiltering = numericAttributesForFiltering;
    return this;
  }

  public SettingsResponse addNumericAttributesForFiltering(String numericAttributesForFilteringItem) {
    if (this.numericAttributesForFiltering == null) {
      this.numericAttributesForFiltering = new ArrayList<>();
    }
    this.numericAttributesForFiltering.add(numericAttributesForFilteringItem);
    return this;
  }

  /**
   * Numeric attributes that can be used as [numerical
   * filters](https://www.algolia.com/doc/guides/managing-results/rules/detecting-intent/how-to/applying-a-custom-filter-for-a-specific-query/#numerical-filters).
   * Attribute names are case-sensitive. By default, all numeric attributes are available as
   * numerical filters. For faster indexing, reduce the number of numeric attributes. If you want to
   * turn off filtering for all numeric attributes, specifiy an attribute that doesn't exist in your
   * index, such as `NO_NUMERIC_FILTERING`. **Modifier** - `equalOnly(\"ATTRIBUTE\")`. Support only
   * filtering based on equality comparisons `=` and `!=`.
   */
  @javax.annotation.Nullable
  public List<String> getNumericAttributesForFiltering() {
    return numericAttributesForFiltering;
  }

  public SettingsResponse setSeparatorsToIndex(String separatorsToIndex) {
    this.separatorsToIndex = separatorsToIndex;
    return this;
  }

  /**
   * Controls which separators are indexed. Separators are all non-letter characters except spaces
   * and currency characters, such as $€£¥. By default, separator characters aren't indexed. With
   * `separatorsToIndex`, Algolia treats separator characters as separate words. For example, a
   * search for `C#` would report two matches.
   */
  @javax.annotation.Nullable
  public String getSeparatorsToIndex() {
    return separatorsToIndex;
  }

  public SettingsResponse setSearchableAttributes(List<String> searchableAttributes) {
    this.searchableAttributes = searchableAttributes;
    return this;
  }

  public SettingsResponse addSearchableAttributes(String searchableAttributesItem) {
    if (this.searchableAttributes == null) {
      this.searchableAttributes = new ArrayList<>();
    }
    this.searchableAttributes.add(searchableAttributesItem);
    return this;
  }

  /**
   * Attributes used for searching. Attribute names are case-sensitive. By default, all attributes
   * are searchable and the
   * [Attribute](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#attribute)
   * ranking criterion is turned off. With a non-empty list, Algolia only returns results with
   * matches in the selected attributes. In addition, the Attribute ranking criterion is turned on:
   * matches in attributes that are higher in the list of `searchableAttributes` rank first. To make
   * matches in two attributes rank equally, include them in a comma-separated string, such as
   * `\"title,alternate_title\"`. Attributes with the same priority are always unordered. For more
   * information, see [Searchable
   * attributes](https://www.algolia.com/doc/guides/sending-and-managing-data/prepare-your-data/how-to/setting-searchable-attributes/).
   * **Modifier** - `unordered(\"ATTRIBUTE\")`. Ignore the position of a match within the attribute.
   * Without modifier, matches at the beginning of an attribute rank higer than matches at the end.
   */
  @javax.annotation.Nullable
  public List<String> getSearchableAttributes() {
    return searchableAttributes;
  }

  public SettingsResponse setUserData(Object userData) {
    this.userData = userData;
    return this;
  }

  /** An object with custom data. You can store up to 32kB as custom data. */
  @javax.annotation.Nullable
  public Object getUserData() {
    return userData;
  }

  public SettingsResponse setCustomNormalization(Map<String, Map<String, String>> customNormalization) {
    this.customNormalization = customNormalization;
    return this;
  }

  public SettingsResponse putCustomNormalization(String key, Map<String, String> customNormalizationItem) {
    if (this.customNormalization == null) {
      this.customNormalization = new HashMap<>();
    }
    this.customNormalization.put(key, customNormalizationItem);
    return this;
  }

  /**
   * Characters and their normalized replacements. This overrides Algolia's default
   * [normalization](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/normalization/).
   */
  @javax.annotation.Nullable
  public Map<String, Map<String, String>> getCustomNormalization() {
    return customNormalization;
  }

  public SettingsResponse setAttributeForDistinct(String attributeForDistinct) {
    this.attributeForDistinct = attributeForDistinct;
    return this;
  }

  /**
   * Attribute that should be used to establish groups of results. Attribute names are
   * case-sensitive. All records with the same value for this attribute are considered a group. You
   * can combine `attributeForDistinct` with the `distinct` search parameter to control how many
   * items per group are included in the search results. If you want to use the same attribute also
   * for faceting, use the `afterDistinct` modifier of the `attributesForFaceting` setting. This
   * applies faceting _after_ deduplication, which will result in accurate facet counts.
   */
  @javax.annotation.Nullable
  public String getAttributeForDistinct() {
    return attributeForDistinct;
  }

  public SettingsResponse setAttributesToRetrieve(List<String> attributesToRetrieve) {
    this.attributesToRetrieve = attributesToRetrieve;
    return this;
  }

  public SettingsResponse addAttributesToRetrieve(String attributesToRetrieveItem) {
    if (this.attributesToRetrieve == null) {
      this.attributesToRetrieve = new ArrayList<>();
    }
    this.attributesToRetrieve.add(attributesToRetrieveItem);
    return this;
  }

  /**
   * Attributes to include in the API response. To reduce the size of your response, you can
   * retrieve only some of the attributes. Attribute names are case-sensitive. - `*` retrieves all
   * attributes, except attributes included in the `customRanking` and `unretrievableAttributes`
   * settings. - To retrieve all attributes except a specific one, prefix the attribute with a dash
   * and combine it with the `*`: `[\"*\", \"-ATTRIBUTE\"]`. - The `objectID` attribute is always
   * included.
   */
  @javax.annotation.Nullable
  public List<String> getAttributesToRetrieve() {
    return attributesToRetrieve;
  }

  public SettingsResponse setRanking(List<String> ranking) {
    this.ranking = ranking;
    return this;
  }

  public SettingsResponse addRanking(String rankingItem) {
    if (this.ranking == null) {
      this.ranking = new ArrayList<>();
    }
    this.ranking.add(rankingItem);
    return this;
  }

  /**
   * Determines the order in which Algolia returns your results. By default, each entry corresponds
   * to a [ranking
   * criteria](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/).
   * The tie-breaking algorithm sequentially applies each criterion in the order they're specified.
   * If you configure a replica index for [sorting by an
   * attribute](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/how-to/sort-by-attribute/),
   * you put the sorting attribute at the top of the list. **Modifiers** - `asc(\"ATTRIBUTE\")`.
   * Sort the index by the values of an attribute, in ascending order. - `desc(\"ATTRIBUTE\")`. Sort
   * the index by the values of an attribute, in descending order. Before you modify the default
   * setting, you should test your changes in the dashboard, and by [A/B
   * testing](https://www.algolia.com/doc/guides/ab-testing/what-is-ab-testing/).
   */
  @javax.annotation.Nullable
  public List<String> getRanking() {
    return ranking;
  }

  public SettingsResponse setCustomRanking(List<String> customRanking) {
    this.customRanking = customRanking;
    return this;
  }

  public SettingsResponse addCustomRanking(String customRankingItem) {
    if (this.customRanking == null) {
      this.customRanking = new ArrayList<>();
    }
    this.customRanking.add(customRankingItem);
    return this;
  }

  /**
   * Attributes to use as [custom
   * ranking](https://www.algolia.com/doc/guides/managing-results/must-do/custom-ranking/).
   * Attribute names are case-sensitive. The custom ranking attributes decide which items are shown
   * first if the other ranking criteria are equal. Records with missing values for your selected
   * custom ranking attributes are always sorted last. Boolean attributes are sorted based on their
   * alphabetical order. **Modifiers** - `asc(\"ATTRIBUTE\")`. Sort the index by the values of an
   * attribute, in ascending order. - `desc(\"ATTRIBUTE\")`. Sort the index by the values of an
   * attribute, in descending order. If you use two or more custom ranking attributes, [reduce the
   * precision](https://www.algolia.com/doc/guides/managing-results/must-do/custom-ranking/how-to/controlling-custom-ranking-metrics-precision/)
   * of your first attributes, or the other attributes will never be applied.
   */
  @javax.annotation.Nullable
  public List<String> getCustomRanking() {
    return customRanking;
  }

  public SettingsResponse setRelevancyStrictness(Integer relevancyStrictness) {
    this.relevancyStrictness = relevancyStrictness;
    return this;
  }

  /**
   * Relevancy threshold below which less relevant results aren't included in the results. You can
   * only set `relevancyStrictness` on [virtual replica
   * indices](https://www.algolia.com/doc/guides/managing-results/refine-results/sorting/in-depth/replicas/#what-are-virtual-replicas).
   * Use this setting to strike a balance between the relevance and number of returned results.
   */
  @javax.annotation.Nullable
  public Integer getRelevancyStrictness() {
    return relevancyStrictness;
  }

  public SettingsResponse setAttributesToHighlight(List<String> attributesToHighlight) {
    this.attributesToHighlight = attributesToHighlight;
    return this;
  }

  public SettingsResponse addAttributesToHighlight(String attributesToHighlightItem) {
    if (this.attributesToHighlight == null) {
      this.attributesToHighlight = new ArrayList<>();
    }
    this.attributesToHighlight.add(attributesToHighlightItem);
    return this;
  }

  /**
   * Attributes to highlight. By default, all searchable attributes are highlighted. Use `*` to
   * highlight all attributes or use an empty array `[]` to turn off highlighting. Attribute names
   * are case-sensitive. With highlighting, strings that match the search query are surrounded by
   * HTML tags defined by `highlightPreTag` and `highlightPostTag`. You can use this to visually
   * highlight matching parts of a search query in your UI. For more information, see [Highlighting
   * and
   * snippeting](https://www.algolia.com/doc/guides/building-search-ui/ui-and-ux-patterns/highlighting-snippeting/js/).
   */
  @javax.annotation.Nullable
  public List<String> getAttributesToHighlight() {
    return attributesToHighlight;
  }

  public SettingsResponse setAttributesToSnippet(List<String> attributesToSnippet) {
    this.attributesToSnippet = attributesToSnippet;
    return this;
  }

  public SettingsResponse addAttributesToSnippet(String attributesToSnippetItem) {
    if (this.attributesToSnippet == null) {
      this.attributesToSnippet = new ArrayList<>();
    }
    this.attributesToSnippet.add(attributesToSnippetItem);
    return this;
  }

  /**
   * Attributes for which to enable snippets. Attribute names are case-sensitive. Snippets provide
   * additional context to matched words. If you enable snippets, they include 10 words, including
   * the matched word. The matched word will also be wrapped by HTML tags for highlighting. You can
   * adjust the number of words with the following notation: `ATTRIBUTE:NUMBER`, where `NUMBER` is
   * the number of words to be extracted.
   */
  @javax.annotation.Nullable
  public List<String> getAttributesToSnippet() {
    return attributesToSnippet;
  }

  public SettingsResponse setHighlightPreTag(String highlightPreTag) {
    this.highlightPreTag = highlightPreTag;
    return this;
  }

  /** HTML tag to insert before the highlighted parts in all highlighted results and snippets. */
  @javax.annotation.Nullable
  public String getHighlightPreTag() {
    return highlightPreTag;
  }

  public SettingsResponse setHighlightPostTag(String highlightPostTag) {
    this.highlightPostTag = highlightPostTag;
    return this;
  }

  /** HTML tag to insert after the highlighted parts in all highlighted results and snippets. */
  @javax.annotation.Nullable
  public String getHighlightPostTag() {
    return highlightPostTag;
  }

  public SettingsResponse setSnippetEllipsisText(String snippetEllipsisText) {
    this.snippetEllipsisText = snippetEllipsisText;
    return this;
  }

  /** String used as an ellipsis indicator when a snippet is truncated. */
  @javax.annotation.Nullable
  public String getSnippetEllipsisText() {
    return snippetEllipsisText;
  }

  public SettingsResponse setRestrictHighlightAndSnippetArrays(Boolean restrictHighlightAndSnippetArrays) {
    this.restrictHighlightAndSnippetArrays = restrictHighlightAndSnippetArrays;
    return this;
  }

  /**
   * Whether to restrict highlighting and snippeting to items that at least partially matched the
   * search query. By default, all items are highlighted and snippeted.
   */
  @javax.annotation.Nullable
  public Boolean getRestrictHighlightAndSnippetArrays() {
    return restrictHighlightAndSnippetArrays;
  }

  public SettingsResponse setHitsPerPage(Integer hitsPerPage) {
    this.hitsPerPage = hitsPerPage;
    return this;
  }

  /** Number of hits per page. minimum: 1 maximum: 1000 */
  @javax.annotation.Nullable
  public Integer getHitsPerPage() {
    return hitsPerPage;
  }

  public SettingsResponse setMinWordSizefor1Typo(Integer minWordSizefor1Typo) {
    this.minWordSizefor1Typo = minWordSizefor1Typo;
    return this;
  }

  /**
   * Minimum number of characters a word in the search query must contain to accept matches with
   * [one
   * typo](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#configuring-word-length-for-typos).
   */
  @javax.annotation.Nullable
  public Integer getMinWordSizefor1Typo() {
    return minWordSizefor1Typo;
  }

  public SettingsResponse setMinWordSizefor2Typos(Integer minWordSizefor2Typos) {
    this.minWordSizefor2Typos = minWordSizefor2Typos;
    return this;
  }

  /**
   * Minimum number of characters a word in the search query must contain to accept matches with
   * [two
   * typos](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/in-depth/configuring-typo-tolerance/#configuring-word-length-for-typos).
   */
  @javax.annotation.Nullable
  public Integer getMinWordSizefor2Typos() {
    return minWordSizefor2Typos;
  }

  public SettingsResponse setTypoTolerance(TypoTolerance typoTolerance) {
    this.typoTolerance = typoTolerance;
    return this;
  }

  /** Get typoTolerance */
  @javax.annotation.Nullable
  public TypoTolerance getTypoTolerance() {
    return typoTolerance;
  }

  public SettingsResponse setAllowTyposOnNumericTokens(Boolean allowTyposOnNumericTokens) {
    this.allowTyposOnNumericTokens = allowTyposOnNumericTokens;
    return this;
  }

  /**
   * Whether to allow typos on numbers in the search query. Turn off this setting to reduce the
   * number of irrelevant matches when searching in large sets of similar numbers.
   */
  @javax.annotation.Nullable
  public Boolean getAllowTyposOnNumericTokens() {
    return allowTyposOnNumericTokens;
  }

  public SettingsResponse setDisableTypoToleranceOnAttributes(List<String> disableTypoToleranceOnAttributes) {
    this.disableTypoToleranceOnAttributes = disableTypoToleranceOnAttributes;
    return this;
  }

  public SettingsResponse addDisableTypoToleranceOnAttributes(String disableTypoToleranceOnAttributesItem) {
    if (this.disableTypoToleranceOnAttributes == null) {
      this.disableTypoToleranceOnAttributes = new ArrayList<>();
    }
    this.disableTypoToleranceOnAttributes.add(disableTypoToleranceOnAttributesItem);
    return this;
  }

  /**
   * Attributes for which you want to turn off [typo
   * tolerance](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/).
   * Attribute names are case-sensitive. Returning only exact matches can help when: - [Searching in
   * hyphenated
   * attributes](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/typo-tolerance/how-to/how-to-search-in-hyphenated-attributes/).
   * - Reducing the number of matches when you have too many. This can happen with attributes that
   * are long blocks of text, such as product descriptions. Consider alternatives such as
   * `disableTypoToleranceOnWords` or adding synonyms if your attributes have intentional unusual
   * spellings that might look like typos.
   */
  @javax.annotation.Nullable
  public List<String> getDisableTypoToleranceOnAttributes() {
    return disableTypoToleranceOnAttributes;
  }

  public SettingsResponse setIgnorePlurals(IgnorePlurals ignorePlurals) {
    this.ignorePlurals = ignorePlurals;
    return this;
  }

  /** Get ignorePlurals */
  @javax.annotation.Nullable
  public IgnorePlurals getIgnorePlurals() {
    return ignorePlurals;
  }

  public SettingsResponse setRemoveStopWords(RemoveStopWords removeStopWords) {
    this.removeStopWords = removeStopWords;
    return this;
  }

  /** Get removeStopWords */
  @javax.annotation.Nullable
  public RemoveStopWords getRemoveStopWords() {
    return removeStopWords;
  }

  public SettingsResponse setKeepDiacriticsOnCharacters(String keepDiacriticsOnCharacters) {
    this.keepDiacriticsOnCharacters = keepDiacriticsOnCharacters;
    return this;
  }

  /**
   * Characters for which diacritics should be preserved. By default, Algolia removes diacritics
   * from letters. For example, `é` becomes `e`. If this causes issues in your search, you can
   * specify characters that should keep their diacritics.
   */
  @javax.annotation.Nullable
  public String getKeepDiacriticsOnCharacters() {
    return keepDiacriticsOnCharacters;
  }

  public SettingsResponse setQueryLanguages(List<SupportedLanguage> queryLanguages) {
    this.queryLanguages = queryLanguages;
    return this;
  }

  public SettingsResponse addQueryLanguages(SupportedLanguage queryLanguagesItem) {
    if (this.queryLanguages == null) {
      this.queryLanguages = new ArrayList<>();
    }
    this.queryLanguages.add(queryLanguagesItem);
    return this;
  }

  /**
   * Languages for language-specific query processing steps such as plurals, stop-word removal, and
   * word-detection dictionaries. This setting sets a default list of languages used by the
   * `removeStopWords` and `ignorePlurals` settings. This setting also sets a dictionary for word
   * detection in the logogram-based
   * [CJK](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/normalization/#normalization-for-logogram-based-languages-cjk)
   * languages. To support this, you must place the CJK language **first**. **You should always
   * specify a query language.** If you don't specify an indexing language, the search engine uses
   * all [supported
   * languages](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/supported-languages/),
   * or the languages you specified with the `ignorePlurals` or `removeStopWords` parameters. This
   * can lead to unexpected search results. For more information, see [Language-specific
   * configuration](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/).
   */
  @javax.annotation.Nullable
  public List<SupportedLanguage> getQueryLanguages() {
    return queryLanguages;
  }

  public SettingsResponse setDecompoundQuery(Boolean decompoundQuery) {
    this.decompoundQuery = decompoundQuery;
    return this;
  }

  /**
   * Whether to split compound words in the query into their building blocks. For more information,
   * see [Word
   * segmentation](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/handling-natural-languages-nlp/in-depth/language-specific-configurations/#splitting-compound-words).
   * Word segmentation is supported for these languages: German, Dutch, Finnish, Swedish, and
   * Norwegian. Decompounding doesn't work for words with [non-spacing mark Unicode
   * characters](https://www.charactercodes.net/category/non-spacing_mark). For example,
   * `Gartenstühle` won't be decompounded if the `ü` consists of `u` (U+0075) and `◌̈` (U+0308).
   */
  @javax.annotation.Nullable
  public Boolean getDecompoundQuery() {
    return decompoundQuery;
  }

  public SettingsResponse setEnableRules(Boolean enableRules) {
    this.enableRules = enableRules;
    return this;
  }

  /** Whether to enable rules. */
  @javax.annotation.Nullable
  public Boolean getEnableRules() {
    return enableRules;
  }

  public SettingsResponse setEnablePersonalization(Boolean enablePersonalization) {
    this.enablePersonalization = enablePersonalization;
    return this;
  }

  /** Whether to enable Personalization. */
  @javax.annotation.Nullable
  public Boolean getEnablePersonalization() {
    return enablePersonalization;
  }

  public SettingsResponse setQueryType(QueryType queryType) {
    this.queryType = queryType;
    return this;
  }

  /** Get queryType */
  @javax.annotation.Nullable
  public QueryType getQueryType() {
    return queryType;
  }

  public SettingsResponse setRemoveWordsIfNoResults(RemoveWordsIfNoResults removeWordsIfNoResults) {
    this.removeWordsIfNoResults = removeWordsIfNoResults;
    return this;
  }

  /** Get removeWordsIfNoResults */
  @javax.annotation.Nullable
  public RemoveWordsIfNoResults getRemoveWordsIfNoResults() {
    return removeWordsIfNoResults;
  }

  public SettingsResponse setMode(Mode mode) {
    this.mode = mode;
    return this;
  }

  /** Get mode */
  @javax.annotation.Nullable
  public Mode getMode() {
    return mode;
  }

  public SettingsResponse setSemanticSearch(SemanticSearch semanticSearch) {
    this.semanticSearch = semanticSearch;
    return this;
  }

  /** Get semanticSearch */
  @javax.annotation.Nullable
  public SemanticSearch getSemanticSearch() {
    return semanticSearch;
  }

  public SettingsResponse setAdvancedSyntax(Boolean advancedSyntax) {
    this.advancedSyntax = advancedSyntax;
    return this;
  }

  /**
   * Whether to support phrase matching and excluding words from search queries. Use the
   * `advancedSyntaxFeatures` parameter to control which feature is supported.
   */
  @javax.annotation.Nullable
  public Boolean getAdvancedSyntax() {
    return advancedSyntax;
  }

  public SettingsResponse setOptionalWords(List<String> optionalWords) {
    this.optionalWords = optionalWords;
    return this;
  }

  public SettingsResponse addOptionalWords(String optionalWordsItem) {
    if (this.optionalWords == null) {
      this.optionalWords = new ArrayList<>();
    }
    this.optionalWords.add(optionalWordsItem);
    return this;
  }

  /**
   * Words that should be considered optional when found in the query. By default, records must
   * match all words in the search query to be included in the search results. Adding optional words
   * can help to increase the number of search results by running an additional search query that
   * doesn't include the optional words. For example, if the search query is \"action video\" and
   * \"video\" is an optional word, the search engine runs two queries. One for \"action video\" and
   * one for \"action\". Records that match all words are ranked higher. For a search query with 4
   * or more words **and** all its words are optional, the number of matched words required for a
   * record to be included in the search results increases for every 1,000 records: - If
   * `optionalWords` has less than 10 words, the required number of matched words increases by 1:
   * results 1 to 1,000 require 1 matched word, results 1,001 to 2000 need 2 matched words. - If
   * `optionalWords` has 10 or more words, the number of required matched words increases by the
   * number of optional words dividied by 5 (rounded down). For example, with 18 optional words:
   * results 1 to 1,000 require 1 matched word, results 1,001 to 2000 need 4 matched words. For more
   * information, see [Optional
   * words](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/empty-or-insufficient-results/#creating-a-list-of-optional-words).
   */
  @javax.annotation.Nullable
  public List<String> getOptionalWords() {
    return optionalWords;
  }

  public SettingsResponse setDisableExactOnAttributes(List<String> disableExactOnAttributes) {
    this.disableExactOnAttributes = disableExactOnAttributes;
    return this;
  }

  public SettingsResponse addDisableExactOnAttributes(String disableExactOnAttributesItem) {
    if (this.disableExactOnAttributes == null) {
      this.disableExactOnAttributes = new ArrayList<>();
    }
    this.disableExactOnAttributes.add(disableExactOnAttributesItem);
    return this;
  }

  /**
   * Searchable attributes for which you want to [turn off the Exact ranking
   * criterion](https://www.algolia.com/doc/guides/managing-results/optimize-search-results/override-search-engine-defaults/in-depth/adjust-exact-settings/#turn-off-exact-for-some-attributes).
   * Attribute names are case-sensitive. This can be useful for attributes with long values, where
   * the likelyhood of an exact match is high, such as product descriptions. Turning off the Exact
   * ranking criterion for these attributes favors exact matching on other attributes. This reduces
   * the impact of individual attributes with a lot of content on ranking.
   */
  @javax.annotation.Nullable
  public List<String> getDisableExactOnAttributes() {
    return disableExactOnAttributes;
  }

  public SettingsResponse setExactOnSingleWordQuery(ExactOnSingleWordQuery exactOnSingleWordQuery) {
    this.exactOnSingleWordQuery = exactOnSingleWordQuery;
    return this;
  }

  /** Get exactOnSingleWordQuery */
  @javax.annotation.Nullable
  public ExactOnSingleWordQuery getExactOnSingleWordQuery() {
    return exactOnSingleWordQuery;
  }

  public SettingsResponse setAlternativesAsExact(List<AlternativesAsExact> alternativesAsExact) {
    this.alternativesAsExact = alternativesAsExact;
    return this;
  }

  public SettingsResponse addAlternativesAsExact(AlternativesAsExact alternativesAsExactItem) {
    if (this.alternativesAsExact == null) {
      this.alternativesAsExact = new ArrayList<>();
    }
    this.alternativesAsExact.add(alternativesAsExactItem);
    return this;
  }

  /**
   * Alternatives of query words that should be considered as exact matches by the Exact ranking
   * criterion. - `ignorePlurals`. Plurals and similar declensions added by the `ignorePlurals`
   * setting are considered exact matches. - `singleWordSynonym`. Single-word synonyms, such as
   * \"NY/NYC\" are considered exact matches. - `multiWordsSynonym`. Multi-word synonyms, such as
   * \"NY/New York\" are considered exact matches.
   */
  @javax.annotation.Nullable
  public List<AlternativesAsExact> getAlternativesAsExact() {
    return alternativesAsExact;
  }

  public SettingsResponse setAdvancedSyntaxFeatures(List<AdvancedSyntaxFeatures> advancedSyntaxFeatures) {
    this.advancedSyntaxFeatures = advancedSyntaxFeatures;
    return this;
  }

  public SettingsResponse addAdvancedSyntaxFeatures(AdvancedSyntaxFeatures advancedSyntaxFeaturesItem) {
    if (this.advancedSyntaxFeatures == null) {
      this.advancedSyntaxFeatures = new ArrayList<>();
    }
    this.advancedSyntaxFeatures.add(advancedSyntaxFeaturesItem);
    return this;
  }

  /**
   * Advanced search syntax features you want to support. - `exactPhrase`. Phrases in quotes must
   * match exactly. For example, `sparkly blue \"iPhone case\"` only returns records with the exact
   * string \"iPhone case\". - `excludeWords`. Query words prefixed with a `-` must not occur in a
   * record. For example, `search -engine` matches records that contain \"search\" but not
   * \"engine\". This setting only has an effect if `advancedSyntax` is true.
   */
  @javax.annotation.Nullable
  public List<AdvancedSyntaxFeatures> getAdvancedSyntaxFeatures() {
    return advancedSyntaxFeatures;
  }

  public SettingsResponse setDistinct(Distinct distinct) {
    this.distinct = distinct;
    return this;
  }

  /** Get distinct */
  @javax.annotation.Nullable
  public Distinct getDistinct() {
    return distinct;
  }

  public SettingsResponse setReplaceSynonymsInHighlight(Boolean replaceSynonymsInHighlight) {
    this.replaceSynonymsInHighlight = replaceSynonymsInHighlight;
    return this;
  }

  /**
   * Whether to replace a highlighted word with the matched synonym. By default, the original words
   * are highlighted even if a synonym matches. For example, with `home` as a synonym for `house`
   * and a search for `home`, records matching either \"home\" or \"house\" are included in the
   * search results, and either \"home\" or \"house\" are highlighted. With
   * `replaceSynonymsInHighlight` set to `true`, a search for `home` still matches the same records,
   * but all occurences of \"house\" are replaced by \"home\" in the highlighted response.
   */
  @javax.annotation.Nullable
  public Boolean getReplaceSynonymsInHighlight() {
    return replaceSynonymsInHighlight;
  }

  public SettingsResponse setMinProximity(Integer minProximity) {
    this.minProximity = minProximity;
    return this;
  }

  /**
   * Minimum proximity score for two matching words. This adjusts the [Proximity ranking
   * criterion](https://www.algolia.com/doc/guides/managing-results/relevance-overview/in-depth/ranking-criteria/#proximity)
   * by equally scoring matches that are farther apart. For example, if `minProximity` is 2,
   * neighboring matches and matches with one word between them would have the same score. minimum:
   * 1 maximum: 7
   */
  @javax.annotation.Nullable
  public Integer getMinProximity() {
    return minProximity;
  }

  public SettingsResponse setResponseFields(List<String> responseFields) {
    this.responseFields = responseFields;
    return this;
  }

  public SettingsResponse addResponseFields(String responseFieldsItem) {
    if (this.responseFields == null) {
      this.responseFields = new ArrayList<>();
    }
    this.responseFields.add(responseFieldsItem);
    return this;
  }

  /**
   * Properties to include in the API response of `search` and `browse` requests. By default, all
   * response properties are included. To reduce the response size, you can select, which attributes
   * should be included. You can't exclude these properties: `message`, `warning`, `cursor`,
   * `serverUsed`, `indexUsed`, `abTestVariantID`, `parsedQuery`, or any property triggered by the
   * `getRankingInfo` parameter. Don't exclude properties that you might need in your search UI.
   */
  @javax.annotation.Nullable
  public List<String> getResponseFields() {
    return responseFields;
  }

  public SettingsResponse setMaxFacetHits(Integer maxFacetHits) {
    this.maxFacetHits = maxFacetHits;
    return this;
  }

  /**
   * Maximum number of facet values to return when [searching for facet
   * values](https://www.algolia.com/doc/guides/managing-results/refine-results/faceting/#search-for-facet-values).
   * maximum: 100
   */
  @javax.annotation.Nullable
  public Integer getMaxFacetHits() {
    return maxFacetHits;
  }

  public SettingsResponse setMaxValuesPerFacet(Integer maxValuesPerFacet) {
    this.maxValuesPerFacet = maxValuesPerFacet;
    return this;
  }

  /** Maximum number of facet values to return for each facet. maximum: 1000 */
  @javax.annotation.Nullable
  public Integer getMaxValuesPerFacet() {
    return maxValuesPerFacet;
  }

  public SettingsResponse setSortFacetValuesBy(String sortFacetValuesBy) {
    this.sortFacetValuesBy = sortFacetValuesBy;
    return this;
  }

  /**
   * Order in which to retrieve facet values. - `count`. Facet values are retrieved by decreasing
   * count. The count is the number of matching records containing this facet value. - `alpha`.
   * Retrieve facet values alphabetically. This setting doesn't influence how facet values are
   * displayed in your UI (see `renderingContent`). For more information, see [facet value
   * display](https://www.algolia.com/doc/guides/building-search-ui/ui-and-ux-patterns/facet-display/js/).
   */
  @javax.annotation.Nullable
  public String getSortFacetValuesBy() {
    return sortFacetValuesBy;
  }

  public SettingsResponse setAttributeCriteriaComputedByMinProximity(Boolean attributeCriteriaComputedByMinProximity) {
    this.attributeCriteriaComputedByMinProximity = attributeCriteriaComputedByMinProximity;
    return this;
  }

  /**
   * Whether the best matching attribute should be determined by minimum proximity. This setting
   * only affects ranking if the Attribute ranking criterion comes before Proximity in the `ranking`
   * setting. If true, the best matching attribute is selected based on the minimum proximity of
   * multiple matches. Otherwise, the best matching attribute is determined by the order in the
   * `searchableAttributes` setting.
   */
  @javax.annotation.Nullable
  public Boolean getAttributeCriteriaComputedByMinProximity() {
    return attributeCriteriaComputedByMinProximity;
  }

  public SettingsResponse setRenderingContent(RenderingContent renderingContent) {
    this.renderingContent = renderingContent;
    return this;
  }

  /** Get renderingContent */
  @javax.annotation.Nullable
  public RenderingContent getRenderingContent() {
    return renderingContent;
  }

  public SettingsResponse setEnableReRanking(Boolean enableReRanking) {
    this.enableReRanking = enableReRanking;
    return this;
  }

  /**
   * Whether this search will use [Dynamic
   * Re-Ranking](https://www.algolia.com/doc/guides/algolia-ai/re-ranking/). This setting only has
   * an effect if you activated Dynamic Re-Ranking for this index in the Algolia dashboard.
   */
  @javax.annotation.Nullable
  public Boolean getEnableReRanking() {
    return enableReRanking;
  }

  public SettingsResponse setReRankingApplyFilter(ReRankingApplyFilter reRankingApplyFilter) {
    this.reRankingApplyFilter = reRankingApplyFilter;
    return this;
  }

  /** Get reRankingApplyFilter */
  @javax.annotation.Nullable
  public ReRankingApplyFilter getReRankingApplyFilter() {
    return reRankingApplyFilter;
  }

  public SettingsResponse setPrimary(String primary) {
    this.primary = primary;
    return this;
  }

  /** Replica indices only: the name of the primary index for this replica. */
  @javax.annotation.Nullable
  public String getPrimary() {
    return primary;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SettingsResponse settingsResponse = (SettingsResponse) o;
    return (
      Objects.equals(this.attributesForFaceting, settingsResponse.attributesForFaceting) &&
      Objects.equals(this.replicas, settingsResponse.replicas) &&
      Objects.equals(this.paginationLimitedTo, settingsResponse.paginationLimitedTo) &&
      Objects.equals(this.unretrievableAttributes, settingsResponse.unretrievableAttributes) &&
      Objects.equals(this.disableTypoToleranceOnWords, settingsResponse.disableTypoToleranceOnWords) &&
      Objects.equals(this.attributesToTransliterate, settingsResponse.attributesToTransliterate) &&
      Objects.equals(this.camelCaseAttributes, settingsResponse.camelCaseAttributes) &&
      Objects.equals(this.decompoundedAttributes, settingsResponse.decompoundedAttributes) &&
      Objects.equals(this.indexLanguages, settingsResponse.indexLanguages) &&
      Objects.equals(this.disablePrefixOnAttributes, settingsResponse.disablePrefixOnAttributes) &&
      Objects.equals(this.allowCompressionOfIntegerArray, settingsResponse.allowCompressionOfIntegerArray) &&
      Objects.equals(this.numericAttributesForFiltering, settingsResponse.numericAttributesForFiltering) &&
      Objects.equals(this.separatorsToIndex, settingsResponse.separatorsToIndex) &&
      Objects.equals(this.searchableAttributes, settingsResponse.searchableAttributes) &&
      Objects.equals(this.userData, settingsResponse.userData) &&
      Objects.equals(this.customNormalization, settingsResponse.customNormalization) &&
      Objects.equals(this.attributeForDistinct, settingsResponse.attributeForDistinct) &&
      Objects.equals(this.attributesToRetrieve, settingsResponse.attributesToRetrieve) &&
      Objects.equals(this.ranking, settingsResponse.ranking) &&
      Objects.equals(this.customRanking, settingsResponse.customRanking) &&
      Objects.equals(this.relevancyStrictness, settingsResponse.relevancyStrictness) &&
      Objects.equals(this.attributesToHighlight, settingsResponse.attributesToHighlight) &&
      Objects.equals(this.attributesToSnippet, settingsResponse.attributesToSnippet) &&
      Objects.equals(this.highlightPreTag, settingsResponse.highlightPreTag) &&
      Objects.equals(this.highlightPostTag, settingsResponse.highlightPostTag) &&
      Objects.equals(this.snippetEllipsisText, settingsResponse.snippetEllipsisText) &&
      Objects.equals(this.restrictHighlightAndSnippetArrays, settingsResponse.restrictHighlightAndSnippetArrays) &&
      Objects.equals(this.hitsPerPage, settingsResponse.hitsPerPage) &&
      Objects.equals(this.minWordSizefor1Typo, settingsResponse.minWordSizefor1Typo) &&
      Objects.equals(this.minWordSizefor2Typos, settingsResponse.minWordSizefor2Typos) &&
      Objects.equals(this.typoTolerance, settingsResponse.typoTolerance) &&
      Objects.equals(this.allowTyposOnNumericTokens, settingsResponse.allowTyposOnNumericTokens) &&
      Objects.equals(this.disableTypoToleranceOnAttributes, settingsResponse.disableTypoToleranceOnAttributes) &&
      Objects.equals(this.ignorePlurals, settingsResponse.ignorePlurals) &&
      Objects.equals(this.removeStopWords, settingsResponse.removeStopWords) &&
      Objects.equals(this.keepDiacriticsOnCharacters, settingsResponse.keepDiacriticsOnCharacters) &&
      Objects.equals(this.queryLanguages, settingsResponse.queryLanguages) &&
      Objects.equals(this.decompoundQuery, settingsResponse.decompoundQuery) &&
      Objects.equals(this.enableRules, settingsResponse.enableRules) &&
      Objects.equals(this.enablePersonalization, settingsResponse.enablePersonalization) &&
      Objects.equals(this.queryType, settingsResponse.queryType) &&
      Objects.equals(this.removeWordsIfNoResults, settingsResponse.removeWordsIfNoResults) &&
      Objects.equals(this.mode, settingsResponse.mode) &&
      Objects.equals(this.semanticSearch, settingsResponse.semanticSearch) &&
      Objects.equals(this.advancedSyntax, settingsResponse.advancedSyntax) &&
      Objects.equals(this.optionalWords, settingsResponse.optionalWords) &&
      Objects.equals(this.disableExactOnAttributes, settingsResponse.disableExactOnAttributes) &&
      Objects.equals(this.exactOnSingleWordQuery, settingsResponse.exactOnSingleWordQuery) &&
      Objects.equals(this.alternativesAsExact, settingsResponse.alternativesAsExact) &&
      Objects.equals(this.advancedSyntaxFeatures, settingsResponse.advancedSyntaxFeatures) &&
      Objects.equals(this.distinct, settingsResponse.distinct) &&
      Objects.equals(this.replaceSynonymsInHighlight, settingsResponse.replaceSynonymsInHighlight) &&
      Objects.equals(this.minProximity, settingsResponse.minProximity) &&
      Objects.equals(this.responseFields, settingsResponse.responseFields) &&
      Objects.equals(this.maxFacetHits, settingsResponse.maxFacetHits) &&
      Objects.equals(this.maxValuesPerFacet, settingsResponse.maxValuesPerFacet) &&
      Objects.equals(this.sortFacetValuesBy, settingsResponse.sortFacetValuesBy) &&
      Objects.equals(this.attributeCriteriaComputedByMinProximity, settingsResponse.attributeCriteriaComputedByMinProximity) &&
      Objects.equals(this.renderingContent, settingsResponse.renderingContent) &&
      Objects.equals(this.enableReRanking, settingsResponse.enableReRanking) &&
      Objects.equals(this.reRankingApplyFilter, settingsResponse.reRankingApplyFilter) &&
      Objects.equals(this.primary, settingsResponse.primary)
    );
  }

  @Override
  public int hashCode() {
    return Objects.hash(
      attributesForFaceting,
      replicas,
      paginationLimitedTo,
      unretrievableAttributes,
      disableTypoToleranceOnWords,
      attributesToTransliterate,
      camelCaseAttributes,
      decompoundedAttributes,
      indexLanguages,
      disablePrefixOnAttributes,
      allowCompressionOfIntegerArray,
      numericAttributesForFiltering,
      separatorsToIndex,
      searchableAttributes,
      userData,
      customNormalization,
      attributeForDistinct,
      attributesToRetrieve,
      ranking,
      customRanking,
      relevancyStrictness,
      attributesToHighlight,
      attributesToSnippet,
      highlightPreTag,
      highlightPostTag,
      snippetEllipsisText,
      restrictHighlightAndSnippetArrays,
      hitsPerPage,
      minWordSizefor1Typo,
      minWordSizefor2Typos,
      typoTolerance,
      allowTyposOnNumericTokens,
      disableTypoToleranceOnAttributes,
      ignorePlurals,
      removeStopWords,
      keepDiacriticsOnCharacters,
      queryLanguages,
      decompoundQuery,
      enableRules,
      enablePersonalization,
      queryType,
      removeWordsIfNoResults,
      mode,
      semanticSearch,
      advancedSyntax,
      optionalWords,
      disableExactOnAttributes,
      exactOnSingleWordQuery,
      alternativesAsExact,
      advancedSyntaxFeatures,
      distinct,
      replaceSynonymsInHighlight,
      minProximity,
      responseFields,
      maxFacetHits,
      maxValuesPerFacet,
      sortFacetValuesBy,
      attributeCriteriaComputedByMinProximity,
      renderingContent,
      enableReRanking,
      reRankingApplyFilter,
      primary
    );
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SettingsResponse {\n");
    sb.append("    attributesForFaceting: ").append(toIndentedString(attributesForFaceting)).append("\n");
    sb.append("    replicas: ").append(toIndentedString(replicas)).append("\n");
    sb.append("    paginationLimitedTo: ").append(toIndentedString(paginationLimitedTo)).append("\n");
    sb.append("    unretrievableAttributes: ").append(toIndentedString(unretrievableAttributes)).append("\n");
    sb.append("    disableTypoToleranceOnWords: ").append(toIndentedString(disableTypoToleranceOnWords)).append("\n");
    sb.append("    attributesToTransliterate: ").append(toIndentedString(attributesToTransliterate)).append("\n");
    sb.append("    camelCaseAttributes: ").append(toIndentedString(camelCaseAttributes)).append("\n");
    sb.append("    decompoundedAttributes: ").append(toIndentedString(decompoundedAttributes)).append("\n");
    sb.append("    indexLanguages: ").append(toIndentedString(indexLanguages)).append("\n");
    sb.append("    disablePrefixOnAttributes: ").append(toIndentedString(disablePrefixOnAttributes)).append("\n");
    sb.append("    allowCompressionOfIntegerArray: ").append(toIndentedString(allowCompressionOfIntegerArray)).append("\n");
    sb.append("    numericAttributesForFiltering: ").append(toIndentedString(numericAttributesForFiltering)).append("\n");
    sb.append("    separatorsToIndex: ").append(toIndentedString(separatorsToIndex)).append("\n");
    sb.append("    searchableAttributes: ").append(toIndentedString(searchableAttributes)).append("\n");
    sb.append("    userData: ").append(toIndentedString(userData)).append("\n");
    sb.append("    customNormalization: ").append(toIndentedString(customNormalization)).append("\n");
    sb.append("    attributeForDistinct: ").append(toIndentedString(attributeForDistinct)).append("\n");
    sb.append("    attributesToRetrieve: ").append(toIndentedString(attributesToRetrieve)).append("\n");
    sb.append("    ranking: ").append(toIndentedString(ranking)).append("\n");
    sb.append("    customRanking: ").append(toIndentedString(customRanking)).append("\n");
    sb.append("    relevancyStrictness: ").append(toIndentedString(relevancyStrictness)).append("\n");
    sb.append("    attributesToHighlight: ").append(toIndentedString(attributesToHighlight)).append("\n");
    sb.append("    attributesToSnippet: ").append(toIndentedString(attributesToSnippet)).append("\n");
    sb.append("    highlightPreTag: ").append(toIndentedString(highlightPreTag)).append("\n");
    sb.append("    highlightPostTag: ").append(toIndentedString(highlightPostTag)).append("\n");
    sb.append("    snippetEllipsisText: ").append(toIndentedString(snippetEllipsisText)).append("\n");
    sb.append("    restrictHighlightAndSnippetArrays: ").append(toIndentedString(restrictHighlightAndSnippetArrays)).append("\n");
    sb.append("    hitsPerPage: ").append(toIndentedString(hitsPerPage)).append("\n");
    sb.append("    minWordSizefor1Typo: ").append(toIndentedString(minWordSizefor1Typo)).append("\n");
    sb.append("    minWordSizefor2Typos: ").append(toIndentedString(minWordSizefor2Typos)).append("\n");
    sb.append("    typoTolerance: ").append(toIndentedString(typoTolerance)).append("\n");
    sb.append("    allowTyposOnNumericTokens: ").append(toIndentedString(allowTyposOnNumericTokens)).append("\n");
    sb.append("    disableTypoToleranceOnAttributes: ").append(toIndentedString(disableTypoToleranceOnAttributes)).append("\n");
    sb.append("    ignorePlurals: ").append(toIndentedString(ignorePlurals)).append("\n");
    sb.append("    removeStopWords: ").append(toIndentedString(removeStopWords)).append("\n");
    sb.append("    keepDiacriticsOnCharacters: ").append(toIndentedString(keepDiacriticsOnCharacters)).append("\n");
    sb.append("    queryLanguages: ").append(toIndentedString(queryLanguages)).append("\n");
    sb.append("    decompoundQuery: ").append(toIndentedString(decompoundQuery)).append("\n");
    sb.append("    enableRules: ").append(toIndentedString(enableRules)).append("\n");
    sb.append("    enablePersonalization: ").append(toIndentedString(enablePersonalization)).append("\n");
    sb.append("    queryType: ").append(toIndentedString(queryType)).append("\n");
    sb.append("    removeWordsIfNoResults: ").append(toIndentedString(removeWordsIfNoResults)).append("\n");
    sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
    sb.append("    semanticSearch: ").append(toIndentedString(semanticSearch)).append("\n");
    sb.append("    advancedSyntax: ").append(toIndentedString(advancedSyntax)).append("\n");
    sb.append("    optionalWords: ").append(toIndentedString(optionalWords)).append("\n");
    sb.append("    disableExactOnAttributes: ").append(toIndentedString(disableExactOnAttributes)).append("\n");
    sb.append("    exactOnSingleWordQuery: ").append(toIndentedString(exactOnSingleWordQuery)).append("\n");
    sb.append("    alternativesAsExact: ").append(toIndentedString(alternativesAsExact)).append("\n");
    sb.append("    advancedSyntaxFeatures: ").append(toIndentedString(advancedSyntaxFeatures)).append("\n");
    sb.append("    distinct: ").append(toIndentedString(distinct)).append("\n");
    sb.append("    replaceSynonymsInHighlight: ").append(toIndentedString(replaceSynonymsInHighlight)).append("\n");
    sb.append("    minProximity: ").append(toIndentedString(minProximity)).append("\n");
    sb.append("    responseFields: ").append(toIndentedString(responseFields)).append("\n");
    sb.append("    maxFacetHits: ").append(toIndentedString(maxFacetHits)).append("\n");
    sb.append("    maxValuesPerFacet: ").append(toIndentedString(maxValuesPerFacet)).append("\n");
    sb.append("    sortFacetValuesBy: ").append(toIndentedString(sortFacetValuesBy)).append("\n");
    sb
      .append("    attributeCriteriaComputedByMinProximity: ")
      .append(toIndentedString(attributeCriteriaComputedByMinProximity))
      .append("\n");
    sb.append("    renderingContent: ").append(toIndentedString(renderingContent)).append("\n");
    sb.append("    enableReRanking: ").append(toIndentedString(enableReRanking)).append("\n");
    sb.append("    reRankingApplyFilter: ").append(toIndentedString(reRankingApplyFilter)).append("\n");
    sb.append("    primary: ").append(toIndentedString(primary)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
