/*
 * Decompiled with CFR 0.152.
 */
package com.algolia;

import com.algolia.config.AlgoliaAgent;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.config.Requester;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.internal.HttpRequester;
import com.algolia.internal.JsonSerializer;
import com.algolia.internal.StatefulHost;
import com.algolia.internal.interceptors.AuthInterceptor;
import com.algolia.internal.interceptors.RetryStrategy;
import com.algolia.internal.interceptors.UserAgentInterceptor;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Nullable;

public abstract class ApiClient
implements Closeable {
    private final Requester requester;
    private final ExecutorService executor;
    private AuthInterceptor authInterceptor;

    protected ApiClient(String appId, String apiKey, String clientName, @Nullable ClientOptions options, List<Host> defaultHosts) {
        if (appId == null || appId.isEmpty()) {
            throw new AlgoliaRuntimeException("`appId` is missing.");
        }
        if (apiKey == null || apiKey.isEmpty()) {
            throw new AlgoliaRuntimeException("`apiKey` is missing.");
        }
        ClientOptions clientOptions = options != null ? options : new ClientOptions();
        this.executor = clientOptions.getExecutor();
        this.requester = clientOptions.getCustomRequester() != null ? clientOptions.getCustomRequester() : this.defaultRequester(appId, apiKey, clientName, clientOptions, defaultHosts);
    }

    private Requester defaultRequester(String appId, String apiKey, String clientName, ClientOptions options, List<Host> defaultHosts) {
        AlgoliaAgent algoliaAgent = new AlgoliaAgent("4.3.5").addSegment(new AlgoliaAgent.Segment(clientName, "4.3.5")).addSegments(options.getAlgoliaAgentSegments());
        List<Host> hosts = options.getHosts() != null && !options.getHosts().isEmpty() ? options.getHosts() : defaultHosts;
        List<StatefulHost> statefulHosts = hosts.stream().map(StatefulHost::new).collect(Collectors.toList());
        JsonSerializer serializer = JsonSerializer.builder().setCustomConfig(options.getMapperConfig()).build();
        this.authInterceptor = new AuthInterceptor(appId, apiKey);
        HttpRequester.Builder builder = new HttpRequester.Builder(serializer).addInterceptor(this.authInterceptor).addInterceptor(new UserAgentInterceptor(algoliaAgent)).addInterceptor(new RetryStrategy(statefulHosts));
        if (options.getRequesterConfig() != null) {
            options.getRequesterConfig().accept(builder);
        }
        return builder.build(options);
    }

    public void setClientApiKey(@Nonnull String apiKey) {
        this.authInterceptor.setApiKey(apiKey);
    }

    protected <T> CompletableFuture<T> executeAsync(HttpRequest httpRequest, RequestOptions requestOptions, TypeReference<T> returnType) {
        return CompletableFuture.supplyAsync(() -> this.requester.execute(httpRequest, requestOptions, returnType), this.executor);
    }

    protected <T> CompletableFuture<T> executeAsync(HttpRequest httpRequest, RequestOptions requestOptions, Class<?> returnType, Class<?> innerType) {
        return CompletableFuture.supplyAsync(() -> this.requester.execute(httpRequest, requestOptions, returnType, innerType), this.executor);
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        this.requester.close();
    }
}

