/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.ingestion.ActionType;
import com.algolia.model.ingestion.Authentication;
import com.algolia.model.ingestion.AuthenticationCreate;
import com.algolia.model.ingestion.AuthenticationCreateResponse;
import com.algolia.model.ingestion.AuthenticationSearch;
import com.algolia.model.ingestion.AuthenticationSortKeys;
import com.algolia.model.ingestion.AuthenticationType;
import com.algolia.model.ingestion.AuthenticationUpdate;
import com.algolia.model.ingestion.AuthenticationUpdateResponse;
import com.algolia.model.ingestion.DeleteResponse;
import com.algolia.model.ingestion.Destination;
import com.algolia.model.ingestion.DestinationCreate;
import com.algolia.model.ingestion.DestinationCreateResponse;
import com.algolia.model.ingestion.DestinationSearch;
import com.algolia.model.ingestion.DestinationSortKeys;
import com.algolia.model.ingestion.DestinationType;
import com.algolia.model.ingestion.DestinationUpdate;
import com.algolia.model.ingestion.DestinationUpdateResponse;
import com.algolia.model.ingestion.Event;
import com.algolia.model.ingestion.EventSortKeys;
import com.algolia.model.ingestion.EventStatus;
import com.algolia.model.ingestion.EventType;
import com.algolia.model.ingestion.ListAuthenticationsResponse;
import com.algolia.model.ingestion.ListDestinationsResponse;
import com.algolia.model.ingestion.ListEventsResponse;
import com.algolia.model.ingestion.ListSourcesResponse;
import com.algolia.model.ingestion.ListTasksResponse;
import com.algolia.model.ingestion.ListTasksResponseV1;
import com.algolia.model.ingestion.ListTransformationsResponse;
import com.algolia.model.ingestion.OrderKeys;
import com.algolia.model.ingestion.PlatformWithNone;
import com.algolia.model.ingestion.PushTaskPayload;
import com.algolia.model.ingestion.Run;
import com.algolia.model.ingestion.RunListResponse;
import com.algolia.model.ingestion.RunResponse;
import com.algolia.model.ingestion.RunSortKeys;
import com.algolia.model.ingestion.RunSourcePayload;
import com.algolia.model.ingestion.RunSourceResponse;
import com.algolia.model.ingestion.RunStatus;
import com.algolia.model.ingestion.RunType;
import com.algolia.model.ingestion.SortKeys;
import com.algolia.model.ingestion.Source;
import com.algolia.model.ingestion.SourceCreate;
import com.algolia.model.ingestion.SourceCreateResponse;
import com.algolia.model.ingestion.SourceSearch;
import com.algolia.model.ingestion.SourceSortKeys;
import com.algolia.model.ingestion.SourceType;
import com.algolia.model.ingestion.SourceUpdate;
import com.algolia.model.ingestion.SourceUpdateResponse;
import com.algolia.model.ingestion.SourceWatchResponse;
import com.algolia.model.ingestion.Task;
import com.algolia.model.ingestion.TaskCreate;
import com.algolia.model.ingestion.TaskCreateResponse;
import com.algolia.model.ingestion.TaskCreateV1;
import com.algolia.model.ingestion.TaskSearch;
import com.algolia.model.ingestion.TaskSortKeys;
import com.algolia.model.ingestion.TaskUpdate;
import com.algolia.model.ingestion.TaskUpdateResponse;
import com.algolia.model.ingestion.TaskUpdateV1;
import com.algolia.model.ingestion.TaskV1;
import com.algolia.model.ingestion.Transformation;
import com.algolia.model.ingestion.TransformationCreate;
import com.algolia.model.ingestion.TransformationCreateResponse;
import com.algolia.model.ingestion.TransformationSearch;
import com.algolia.model.ingestion.TransformationTry;
import com.algolia.model.ingestion.TransformationTryResponse;
import com.algolia.model.ingestion.TransformationUpdateResponse;
import com.algolia.model.ingestion.TriggerType;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class IngestionClient
extends ApiClient {
    private static final String[] allowedRegions = new String[]{"eu", "us"};

    public IngestionClient(String appId, String apiKey, String region) {
        this(appId, apiKey, region, null);
    }

    public IngestionClient(String appId, String apiKey, String region, ClientOptions options) {
        super(appId, apiKey, "Ingestion", options, IngestionClient.getDefaultHosts(region));
    }

    private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
        ArrayList<Host> hosts = new ArrayList<Host>();
        boolean found = false;
        if (region != null) {
            for (String allowed : allowedRegions) {
                if (!allowed.equals(region)) continue;
                found = true;
                break;
            }
        }
        if (region == null || !found) {
            throw new AlgoliaRuntimeException("`region` is required and must be one of the following: eu, us");
        }
        String url = "data.{region}.algolia.com".replace("{region}", region);
        hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public AuthenticationCreateResponse createAuthentication(@Nonnull AuthenticationCreate authenticationCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.createAuthenticationAsync(authenticationCreate, requestOptions));
    }

    public AuthenticationCreateResponse createAuthentication(@Nonnull AuthenticationCreate authenticationCreate) throws AlgoliaRuntimeException {
        return this.createAuthentication(authenticationCreate, null);
    }

    public CompletableFuture<AuthenticationCreateResponse> createAuthenticationAsync(@Nonnull AuthenticationCreate authenticationCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(authenticationCreate, "Parameter `authenticationCreate` is required when calling `createAuthentication`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/authentications").setMethod("POST").setBody(authenticationCreate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<AuthenticationCreateResponse>(){});
    }

    public CompletableFuture<AuthenticationCreateResponse> createAuthenticationAsync(@Nonnull AuthenticationCreate authenticationCreate) throws AlgoliaRuntimeException {
        return this.createAuthenticationAsync(authenticationCreate, null);
    }

    public DestinationCreateResponse createDestination(@Nonnull DestinationCreate destinationCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.createDestinationAsync(destinationCreate, requestOptions));
    }

    public DestinationCreateResponse createDestination(@Nonnull DestinationCreate destinationCreate) throws AlgoliaRuntimeException {
        return this.createDestination(destinationCreate, null);
    }

    public CompletableFuture<DestinationCreateResponse> createDestinationAsync(@Nonnull DestinationCreate destinationCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(destinationCreate, "Parameter `destinationCreate` is required when calling `createDestination`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/destinations").setMethod("POST").setBody(destinationCreate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<DestinationCreateResponse>(){});
    }

    public CompletableFuture<DestinationCreateResponse> createDestinationAsync(@Nonnull DestinationCreate destinationCreate) throws AlgoliaRuntimeException {
        return this.createDestinationAsync(destinationCreate, null);
    }

    public SourceCreateResponse createSource(@Nonnull SourceCreate sourceCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.createSourceAsync(sourceCreate, requestOptions));
    }

    public SourceCreateResponse createSource(@Nonnull SourceCreate sourceCreate) throws AlgoliaRuntimeException {
        return this.createSource(sourceCreate, null);
    }

    public CompletableFuture<SourceCreateResponse> createSourceAsync(@Nonnull SourceCreate sourceCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(sourceCreate, "Parameter `sourceCreate` is required when calling `createSource`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/sources").setMethod("POST").setBody(sourceCreate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SourceCreateResponse>(){});
    }

    public CompletableFuture<SourceCreateResponse> createSourceAsync(@Nonnull SourceCreate sourceCreate) throws AlgoliaRuntimeException {
        return this.createSourceAsync(sourceCreate, null);
    }

    public TaskCreateResponse createTask(@Nonnull TaskCreate taskCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.createTaskAsync(taskCreate, requestOptions));
    }

    public TaskCreateResponse createTask(@Nonnull TaskCreate taskCreate) throws AlgoliaRuntimeException {
        return this.createTask(taskCreate, null);
    }

    public CompletableFuture<TaskCreateResponse> createTaskAsync(@Nonnull TaskCreate taskCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskCreate, "Parameter `taskCreate` is required when calling `createTask`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/tasks").setMethod("POST").setBody(taskCreate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<TaskCreateResponse>(){});
    }

    public CompletableFuture<TaskCreateResponse> createTaskAsync(@Nonnull TaskCreate taskCreate) throws AlgoliaRuntimeException {
        return this.createTaskAsync(taskCreate, null);
    }

    public TaskCreateResponse createTaskV1(@Nonnull TaskCreateV1 taskCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.createTaskV1Async(taskCreate, requestOptions));
    }

    public TaskCreateResponse createTaskV1(@Nonnull TaskCreateV1 taskCreate) throws AlgoliaRuntimeException {
        return this.createTaskV1(taskCreate, null);
    }

    public CompletableFuture<TaskCreateResponse> createTaskV1Async(@Nonnull TaskCreateV1 taskCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskCreate, "Parameter `taskCreate` is required when calling `createTaskV1`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/tasks").setMethod("POST").setBody(taskCreate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<TaskCreateResponse>(){});
    }

    public CompletableFuture<TaskCreateResponse> createTaskV1Async(@Nonnull TaskCreateV1 taskCreate) throws AlgoliaRuntimeException {
        return this.createTaskV1Async(taskCreate, null);
    }

    public TransformationCreateResponse createTransformation(@Nonnull TransformationCreate transformationCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.createTransformationAsync(transformationCreate, requestOptions));
    }

    public TransformationCreateResponse createTransformation(@Nonnull TransformationCreate transformationCreate) throws AlgoliaRuntimeException {
        return this.createTransformation(transformationCreate, null);
    }

    public CompletableFuture<TransformationCreateResponse> createTransformationAsync(@Nonnull TransformationCreate transformationCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(transformationCreate, "Parameter `transformationCreate` is required when calling `createTransformation`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/transformations").setMethod("POST").setBody(transformationCreate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<TransformationCreateResponse>(){});
    }

    public CompletableFuture<TransformationCreateResponse> createTransformationAsync(@Nonnull TransformationCreate transformationCreate) throws AlgoliaRuntimeException {
        return this.createTransformationAsync(transformationCreate, null);
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customDeleteAsync(path, parameters, requestOptions));
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDelete(path, parameters, null);
    }

    public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, requestOptions);
    }

    public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, null);
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customGetAsync(path, parameters, requestOptions));
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGet(path, parameters, null);
    }

    public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGet(path, null, requestOptions);
    }

    public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGet(path, null, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, null);
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPostAsync(path, parameters, body, requestOptions));
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPost(path, parameters, body, null);
    }

    public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, requestOptions);
    }

    public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, null);
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPutAsync(path, parameters, body, requestOptions));
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPut(path, parameters, body, null);
    }

    public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, requestOptions);
    }

    public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, null);
    }

    public DeleteResponse deleteAuthentication(@Nonnull String authenticationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteAuthenticationAsync(authenticationID, requestOptions));
    }

    public DeleteResponse deleteAuthentication(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
        return this.deleteAuthentication(authenticationID, null);
    }

    public CompletableFuture<DeleteResponse> deleteAuthenticationAsync(@Nonnull String authenticationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(authenticationID, "Parameter `authenticationID` is required when calling `deleteAuthentication`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/authentications/{authenticationID}", authenticationID).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeleteResponse>(){});
    }

    public CompletableFuture<DeleteResponse> deleteAuthenticationAsync(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
        return this.deleteAuthenticationAsync(authenticationID, null);
    }

    public DeleteResponse deleteDestination(@Nonnull String destinationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteDestinationAsync(destinationID, requestOptions));
    }

    public DeleteResponse deleteDestination(@Nonnull String destinationID) throws AlgoliaRuntimeException {
        return this.deleteDestination(destinationID, null);
    }

    public CompletableFuture<DeleteResponse> deleteDestinationAsync(@Nonnull String destinationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(destinationID, "Parameter `destinationID` is required when calling `deleteDestination`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/destinations/{destinationID}", destinationID).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeleteResponse>(){});
    }

    public CompletableFuture<DeleteResponse> deleteDestinationAsync(@Nonnull String destinationID) throws AlgoliaRuntimeException {
        return this.deleteDestinationAsync(destinationID, null);
    }

    public DeleteResponse deleteSource(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteSourceAsync(sourceID, requestOptions));
    }

    public DeleteResponse deleteSource(@Nonnull String sourceID) throws AlgoliaRuntimeException {
        return this.deleteSource(sourceID, null);
    }

    public CompletableFuture<DeleteResponse> deleteSourceAsync(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `deleteSource`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}", sourceID).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeleteResponse>(){});
    }

    public CompletableFuture<DeleteResponse> deleteSourceAsync(@Nonnull String sourceID) throws AlgoliaRuntimeException {
        return this.deleteSourceAsync(sourceID, null);
    }

    public DeleteResponse deleteTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteTaskAsync(taskID, requestOptions));
    }

    public DeleteResponse deleteTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.deleteTask(taskID, null);
    }

    public CompletableFuture<DeleteResponse> deleteTaskAsync(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `deleteTask`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/tasks/{taskID}", taskID).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeleteResponse>(){});
    }

    public CompletableFuture<DeleteResponse> deleteTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.deleteTaskAsync(taskID, null);
    }

    public DeleteResponse deleteTaskV1(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteTaskV1Async(taskID, requestOptions));
    }

    public DeleteResponse deleteTaskV1(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.deleteTaskV1(taskID, null);
    }

    public CompletableFuture<DeleteResponse> deleteTaskV1Async(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `deleteTaskV1`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}", taskID).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeleteResponse>(){});
    }

    public CompletableFuture<DeleteResponse> deleteTaskV1Async(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.deleteTaskV1Async(taskID, null);
    }

    public DeleteResponse deleteTransformation(@Nonnull String transformationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteTransformationAsync(transformationID, requestOptions));
    }

    public DeleteResponse deleteTransformation(@Nonnull String transformationID) throws AlgoliaRuntimeException {
        return this.deleteTransformation(transformationID, null);
    }

    public CompletableFuture<DeleteResponse> deleteTransformationAsync(@Nonnull String transformationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(transformationID, "Parameter `transformationID` is required when calling `deleteTransformation`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/transformations/{transformationID}", transformationID).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeleteResponse>(){});
    }

    public CompletableFuture<DeleteResponse> deleteTransformationAsync(@Nonnull String transformationID) throws AlgoliaRuntimeException {
        return this.deleteTransformationAsync(transformationID, null);
    }

    public TaskUpdateResponse disableTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.disableTaskAsync(taskID, requestOptions));
    }

    public TaskUpdateResponse disableTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.disableTask(taskID, null);
    }

    public CompletableFuture<TaskUpdateResponse> disableTaskAsync(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `disableTask`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/tasks/{taskID}/disable", taskID).setMethod("PUT").build();
        return this.executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>(){});
    }

    public CompletableFuture<TaskUpdateResponse> disableTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.disableTaskAsync(taskID, null);
    }

    @Deprecated
    public TaskUpdateResponse disableTaskV1(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.disableTaskV1Async(taskID, requestOptions));
    }

    @Deprecated
    public TaskUpdateResponse disableTaskV1(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.disableTaskV1(taskID, null);
    }

    @Deprecated
    public CompletableFuture<TaskUpdateResponse> disableTaskV1Async(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `disableTaskV1`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}/disable", taskID).setMethod("PUT").build();
        return this.executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>(){});
    }

    @Deprecated
    public CompletableFuture<TaskUpdateResponse> disableTaskV1Async(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.disableTaskV1Async(taskID, null);
    }

    public TaskUpdateResponse enableTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.enableTaskAsync(taskID, requestOptions));
    }

    public TaskUpdateResponse enableTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.enableTask(taskID, null);
    }

    public CompletableFuture<TaskUpdateResponse> enableTaskAsync(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `enableTask`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/tasks/{taskID}/enable", taskID).setMethod("PUT").build();
        return this.executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>(){});
    }

    public CompletableFuture<TaskUpdateResponse> enableTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.enableTaskAsync(taskID, null);
    }

    public TaskUpdateResponse enableTaskV1(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.enableTaskV1Async(taskID, requestOptions));
    }

    public TaskUpdateResponse enableTaskV1(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.enableTaskV1(taskID, null);
    }

    public CompletableFuture<TaskUpdateResponse> enableTaskV1Async(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `enableTaskV1`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}/enable", taskID).setMethod("PUT").build();
        return this.executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>(){});
    }

    public CompletableFuture<TaskUpdateResponse> enableTaskV1Async(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.enableTaskV1Async(taskID, null);
    }

    public Authentication getAuthentication(@Nonnull String authenticationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAuthenticationAsync(authenticationID, requestOptions));
    }

    public Authentication getAuthentication(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
        return this.getAuthentication(authenticationID, null);
    }

    public CompletableFuture<Authentication> getAuthenticationAsync(@Nonnull String authenticationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(authenticationID, "Parameter `authenticationID` is required when calling `getAuthentication`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/authentications/{authenticationID}", authenticationID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<Authentication>(){});
    }

    public CompletableFuture<Authentication> getAuthenticationAsync(@Nonnull String authenticationID) throws AlgoliaRuntimeException {
        return this.getAuthenticationAsync(authenticationID, null);
    }

    public Destination getDestination(@Nonnull String destinationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getDestinationAsync(destinationID, requestOptions));
    }

    public Destination getDestination(@Nonnull String destinationID) throws AlgoliaRuntimeException {
        return this.getDestination(destinationID, null);
    }

    public CompletableFuture<Destination> getDestinationAsync(@Nonnull String destinationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(destinationID, "Parameter `destinationID` is required when calling `getDestination`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/destinations/{destinationID}", destinationID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<Destination>(){});
    }

    public CompletableFuture<Destination> getDestinationAsync(@Nonnull String destinationID) throws AlgoliaRuntimeException {
        return this.getDestinationAsync(destinationID, null);
    }

    public Event getEvent(@Nonnull String runID, @Nonnull String eventID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getEventAsync(runID, eventID, requestOptions));
    }

    public Event getEvent(@Nonnull String runID, @Nonnull String eventID) throws AlgoliaRuntimeException {
        return this.getEvent(runID, eventID, null);
    }

    public CompletableFuture<Event> getEventAsync(@Nonnull String runID, @Nonnull String eventID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(runID, "Parameter `runID` is required when calling `getEvent`.");
        Parameters.requireNonNull(eventID, "Parameter `eventID` is required when calling `getEvent`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/runs/{runID}/events/{eventID}", runID, eventID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<Event>(){});
    }

    public CompletableFuture<Event> getEventAsync(@Nonnull String runID, @Nonnull String eventID) throws AlgoliaRuntimeException {
        return this.getEventAsync(runID, eventID, null);
    }

    public Run getRun(@Nonnull String runID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRunAsync(runID, requestOptions));
    }

    public Run getRun(@Nonnull String runID) throws AlgoliaRuntimeException {
        return this.getRun(runID, null);
    }

    public CompletableFuture<Run> getRunAsync(@Nonnull String runID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(runID, "Parameter `runID` is required when calling `getRun`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/runs/{runID}", runID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<Run>(){});
    }

    public CompletableFuture<Run> getRunAsync(@Nonnull String runID) throws AlgoliaRuntimeException {
        return this.getRunAsync(runID, null);
    }

    public Source getSource(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getSourceAsync(sourceID, requestOptions));
    }

    public Source getSource(@Nonnull String sourceID) throws AlgoliaRuntimeException {
        return this.getSource(sourceID, null);
    }

    public CompletableFuture<Source> getSourceAsync(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `getSource`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}", sourceID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<Source>(){});
    }

    public CompletableFuture<Source> getSourceAsync(@Nonnull String sourceID) throws AlgoliaRuntimeException {
        return this.getSourceAsync(sourceID, null);
    }

    public Task getTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTaskAsync(taskID, requestOptions));
    }

    public Task getTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.getTask(taskID, null);
    }

    public CompletableFuture<Task> getTaskAsync(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `getTask`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/tasks/{taskID}", taskID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<Task>(){});
    }

    public CompletableFuture<Task> getTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.getTaskAsync(taskID, null);
    }

    public TaskV1 getTaskV1(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTaskV1Async(taskID, requestOptions));
    }

    public TaskV1 getTaskV1(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.getTaskV1(taskID, null);
    }

    public CompletableFuture<TaskV1> getTaskV1Async(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `getTaskV1`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}", taskID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<TaskV1>(){});
    }

    public CompletableFuture<TaskV1> getTaskV1Async(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.getTaskV1Async(taskID, null);
    }

    public Transformation getTransformation(@Nonnull String transformationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getTransformationAsync(transformationID, requestOptions));
    }

    public Transformation getTransformation(@Nonnull String transformationID) throws AlgoliaRuntimeException {
        return this.getTransformation(transformationID, null);
    }

    public CompletableFuture<Transformation> getTransformationAsync(@Nonnull String transformationID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(transformationID, "Parameter `transformationID` is required when calling `getTransformation`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/transformations/{transformationID}", transformationID).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<Transformation>(){});
    }

    public CompletableFuture<Transformation> getTransformationAsync(@Nonnull String transformationID) throws AlgoliaRuntimeException {
        return this.getTransformationAsync(transformationID, null);
    }

    public ListAuthenticationsResponse listAuthentications(Integer itemsPerPage, Integer page, List<AuthenticationType> type, List<PlatformWithNone> platform, AuthenticationSortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listAuthenticationsAsync(itemsPerPage, page, type, platform, sort, order, requestOptions));
    }

    public ListAuthenticationsResponse listAuthentications(Integer itemsPerPage, Integer page, List<AuthenticationType> type, List<PlatformWithNone> platform, AuthenticationSortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listAuthentications(itemsPerPage, page, type, platform, sort, order, null);
    }

    public ListAuthenticationsResponse listAuthentications(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listAuthentications(null, null, null, null, null, null, requestOptions);
    }

    public ListAuthenticationsResponse listAuthentications() throws AlgoliaRuntimeException {
        return this.listAuthentications(null, null, null, null, null, null, null);
    }

    public CompletableFuture<ListAuthenticationsResponse> listAuthenticationsAsync(Integer itemsPerPage, Integer page, List<AuthenticationType> type, List<PlatformWithNone> platform, AuthenticationSortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/authentications").setMethod("GET").addQueryParameter("itemsPerPage", itemsPerPage).addQueryParameter("page", page).addQueryParameter("type", type).addQueryParameter("platform", platform).addQueryParameter("sort", (Object)sort).addQueryParameter("order", (Object)order).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListAuthenticationsResponse>(){});
    }

    public CompletableFuture<ListAuthenticationsResponse> listAuthenticationsAsync(Integer itemsPerPage, Integer page, List<AuthenticationType> type, List<PlatformWithNone> platform, AuthenticationSortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listAuthenticationsAsync(itemsPerPage, page, type, platform, sort, order, null);
    }

    public CompletableFuture<ListAuthenticationsResponse> listAuthenticationsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listAuthenticationsAsync(null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<ListAuthenticationsResponse> listAuthenticationsAsync() throws AlgoliaRuntimeException {
        return this.listAuthenticationsAsync(null, null, null, null, null, null, null);
    }

    public ListDestinationsResponse listDestinations(Integer itemsPerPage, Integer page, List<DestinationType> type, List<String> authenticationID, DestinationSortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listDestinationsAsync(itemsPerPage, page, type, authenticationID, sort, order, requestOptions));
    }

    public ListDestinationsResponse listDestinations(Integer itemsPerPage, Integer page, List<DestinationType> type, List<String> authenticationID, DestinationSortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listDestinations(itemsPerPage, page, type, authenticationID, sort, order, null);
    }

    public ListDestinationsResponse listDestinations(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listDestinations(null, null, null, null, null, null, requestOptions);
    }

    public ListDestinationsResponse listDestinations() throws AlgoliaRuntimeException {
        return this.listDestinations(null, null, null, null, null, null, null);
    }

    public CompletableFuture<ListDestinationsResponse> listDestinationsAsync(Integer itemsPerPage, Integer page, List<DestinationType> type, List<String> authenticationID, DestinationSortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/destinations").setMethod("GET").addQueryParameter("itemsPerPage", itemsPerPage).addQueryParameter("page", page).addQueryParameter("type", type).addQueryParameter("authenticationID", authenticationID).addQueryParameter("sort", (Object)sort).addQueryParameter("order", (Object)order).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListDestinationsResponse>(){});
    }

    public CompletableFuture<ListDestinationsResponse> listDestinationsAsync(Integer itemsPerPage, Integer page, List<DestinationType> type, List<String> authenticationID, DestinationSortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listDestinationsAsync(itemsPerPage, page, type, authenticationID, sort, order, null);
    }

    public CompletableFuture<ListDestinationsResponse> listDestinationsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listDestinationsAsync(null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<ListDestinationsResponse> listDestinationsAsync() throws AlgoliaRuntimeException {
        return this.listDestinationsAsync(null, null, null, null, null, null, null);
    }

    public ListEventsResponse listEvents(@Nonnull String runID, Integer itemsPerPage, Integer page, List<EventStatus> status, List<EventType> type, EventSortKeys sort, OrderKeys order, String startDate, String endDate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listEventsAsync(runID, itemsPerPage, page, status, type, sort, order, startDate, endDate, requestOptions));
    }

    public ListEventsResponse listEvents(@Nonnull String runID, Integer itemsPerPage, Integer page, List<EventStatus> status, List<EventType> type, EventSortKeys sort, OrderKeys order, String startDate, String endDate) throws AlgoliaRuntimeException {
        return this.listEvents(runID, itemsPerPage, page, status, type, sort, order, startDate, endDate, null);
    }

    public ListEventsResponse listEvents(@Nonnull String runID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listEvents(runID, null, null, null, null, null, null, null, null, requestOptions);
    }

    public ListEventsResponse listEvents(@Nonnull String runID) throws AlgoliaRuntimeException {
        return this.listEvents(runID, null, null, null, null, null, null, null, null, null);
    }

    public CompletableFuture<ListEventsResponse> listEventsAsync(@Nonnull String runID, Integer itemsPerPage, Integer page, List<EventStatus> status, List<EventType> type, EventSortKeys sort, OrderKeys order, String startDate, String endDate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(runID, "Parameter `runID` is required when calling `listEvents`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/runs/{runID}/events", runID).setMethod("GET").addQueryParameter("itemsPerPage", itemsPerPage).addQueryParameter("page", page).addQueryParameter("status", status).addQueryParameter("type", type).addQueryParameter("sort", (Object)sort).addQueryParameter("order", (Object)order).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListEventsResponse>(){});
    }

    public CompletableFuture<ListEventsResponse> listEventsAsync(@Nonnull String runID, Integer itemsPerPage, Integer page, List<EventStatus> status, List<EventType> type, EventSortKeys sort, OrderKeys order, String startDate, String endDate) throws AlgoliaRuntimeException {
        return this.listEventsAsync(runID, itemsPerPage, page, status, type, sort, order, startDate, endDate, null);
    }

    public CompletableFuture<ListEventsResponse> listEventsAsync(@Nonnull String runID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listEventsAsync(runID, null, null, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<ListEventsResponse> listEventsAsync(@Nonnull String runID) throws AlgoliaRuntimeException {
        return this.listEventsAsync(runID, null, null, null, null, null, null, null, null, null);
    }

    public RunListResponse listRuns(Integer itemsPerPage, Integer page, List<RunStatus> status, List<RunType> type, String taskID, RunSortKeys sort, OrderKeys order, String startDate, String endDate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listRunsAsync(itemsPerPage, page, status, type, taskID, sort, order, startDate, endDate, requestOptions));
    }

    public RunListResponse listRuns(Integer itemsPerPage, Integer page, List<RunStatus> status, List<RunType> type, String taskID, RunSortKeys sort, OrderKeys order, String startDate, String endDate) throws AlgoliaRuntimeException {
        return this.listRuns(itemsPerPage, page, status, type, taskID, sort, order, startDate, endDate, null);
    }

    public RunListResponse listRuns(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listRuns(null, null, null, null, null, null, null, null, null, requestOptions);
    }

    public RunListResponse listRuns() throws AlgoliaRuntimeException {
        return this.listRuns(null, null, null, null, null, null, null, null, null, null);
    }

    public CompletableFuture<RunListResponse> listRunsAsync(Integer itemsPerPage, Integer page, List<RunStatus> status, List<RunType> type, String taskID, RunSortKeys sort, OrderKeys order, String startDate, String endDate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/runs").setMethod("GET").addQueryParameter("itemsPerPage", itemsPerPage).addQueryParameter("page", page).addQueryParameter("status", status).addQueryParameter("type", type).addQueryParameter("taskID", taskID).addQueryParameter("sort", (Object)sort).addQueryParameter("order", (Object)order).addQueryParameter("startDate", startDate).addQueryParameter("endDate", endDate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<RunListResponse>(){});
    }

    public CompletableFuture<RunListResponse> listRunsAsync(Integer itemsPerPage, Integer page, List<RunStatus> status, List<RunType> type, String taskID, RunSortKeys sort, OrderKeys order, String startDate, String endDate) throws AlgoliaRuntimeException {
        return this.listRunsAsync(itemsPerPage, page, status, type, taskID, sort, order, startDate, endDate, null);
    }

    public CompletableFuture<RunListResponse> listRunsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listRunsAsync(null, null, null, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<RunListResponse> listRunsAsync() throws AlgoliaRuntimeException {
        return this.listRunsAsync(null, null, null, null, null, null, null, null, null, null);
    }

    public ListSourcesResponse listSources(Integer itemsPerPage, Integer page, List<SourceType> type, List<String> authenticationID, SourceSortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listSourcesAsync(itemsPerPage, page, type, authenticationID, sort, order, requestOptions));
    }

    public ListSourcesResponse listSources(Integer itemsPerPage, Integer page, List<SourceType> type, List<String> authenticationID, SourceSortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listSources(itemsPerPage, page, type, authenticationID, sort, order, null);
    }

    public ListSourcesResponse listSources(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listSources(null, null, null, null, null, null, requestOptions);
    }

    public ListSourcesResponse listSources() throws AlgoliaRuntimeException {
        return this.listSources(null, null, null, null, null, null, null);
    }

    public CompletableFuture<ListSourcesResponse> listSourcesAsync(Integer itemsPerPage, Integer page, List<SourceType> type, List<String> authenticationID, SourceSortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/sources").setMethod("GET").addQueryParameter("itemsPerPage", itemsPerPage).addQueryParameter("page", page).addQueryParameter("type", type).addQueryParameter("authenticationID", authenticationID).addQueryParameter("sort", (Object)sort).addQueryParameter("order", (Object)order).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListSourcesResponse>(){});
    }

    public CompletableFuture<ListSourcesResponse> listSourcesAsync(Integer itemsPerPage, Integer page, List<SourceType> type, List<String> authenticationID, SourceSortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listSourcesAsync(itemsPerPage, page, type, authenticationID, sort, order, null);
    }

    public CompletableFuture<ListSourcesResponse> listSourcesAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listSourcesAsync(null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<ListSourcesResponse> listSourcesAsync() throws AlgoliaRuntimeException {
        return this.listSourcesAsync(null, null, null, null, null, null, null);
    }

    public ListTasksResponse listTasks(Integer itemsPerPage, Integer page, List<ActionType> action, Boolean enabled, List<String> sourceID, List<String> destinationID, List<TriggerType> triggerType, TaskSortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listTasksAsync(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, requestOptions));
    }

    public ListTasksResponse listTasks(Integer itemsPerPage, Integer page, List<ActionType> action, Boolean enabled, List<String> sourceID, List<String> destinationID, List<TriggerType> triggerType, TaskSortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listTasks(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, null);
    }

    public ListTasksResponse listTasks(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listTasks(null, null, null, null, null, null, null, null, null, requestOptions);
    }

    public ListTasksResponse listTasks() throws AlgoliaRuntimeException {
        return this.listTasks(null, null, null, null, null, null, null, null, null, null);
    }

    public CompletableFuture<ListTasksResponse> listTasksAsync(Integer itemsPerPage, Integer page, List<ActionType> action, Boolean enabled, List<String> sourceID, List<String> destinationID, List<TriggerType> triggerType, TaskSortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/2/tasks").setMethod("GET").addQueryParameter("itemsPerPage", itemsPerPage).addQueryParameter("page", page).addQueryParameter("action", action).addQueryParameter("enabled", enabled).addQueryParameter("sourceID", sourceID).addQueryParameter("destinationID", destinationID).addQueryParameter("triggerType", triggerType).addQueryParameter("sort", (Object)sort).addQueryParameter("order", (Object)order).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListTasksResponse>(){});
    }

    public CompletableFuture<ListTasksResponse> listTasksAsync(Integer itemsPerPage, Integer page, List<ActionType> action, Boolean enabled, List<String> sourceID, List<String> destinationID, List<TriggerType> triggerType, TaskSortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listTasksAsync(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, null);
    }

    public CompletableFuture<ListTasksResponse> listTasksAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listTasksAsync(null, null, null, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<ListTasksResponse> listTasksAsync() throws AlgoliaRuntimeException {
        return this.listTasksAsync(null, null, null, null, null, null, null, null, null, null);
    }

    public ListTasksResponseV1 listTasksV1(Integer itemsPerPage, Integer page, List<ActionType> action, Boolean enabled, List<String> sourceID, List<String> destinationID, List<TriggerType> triggerType, TaskSortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listTasksV1Async(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, requestOptions));
    }

    public ListTasksResponseV1 listTasksV1(Integer itemsPerPage, Integer page, List<ActionType> action, Boolean enabled, List<String> sourceID, List<String> destinationID, List<TriggerType> triggerType, TaskSortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listTasksV1(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, null);
    }

    public ListTasksResponseV1 listTasksV1(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listTasksV1(null, null, null, null, null, null, null, null, null, requestOptions);
    }

    public ListTasksResponseV1 listTasksV1() throws AlgoliaRuntimeException {
        return this.listTasksV1(null, null, null, null, null, null, null, null, null, null);
    }

    public CompletableFuture<ListTasksResponseV1> listTasksV1Async(Integer itemsPerPage, Integer page, List<ActionType> action, Boolean enabled, List<String> sourceID, List<String> destinationID, List<TriggerType> triggerType, TaskSortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/tasks").setMethod("GET").addQueryParameter("itemsPerPage", itemsPerPage).addQueryParameter("page", page).addQueryParameter("action", action).addQueryParameter("enabled", enabled).addQueryParameter("sourceID", sourceID).addQueryParameter("destinationID", destinationID).addQueryParameter("triggerType", triggerType).addQueryParameter("sort", (Object)sort).addQueryParameter("order", (Object)order).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListTasksResponseV1>(){});
    }

    public CompletableFuture<ListTasksResponseV1> listTasksV1Async(Integer itemsPerPage, Integer page, List<ActionType> action, Boolean enabled, List<String> sourceID, List<String> destinationID, List<TriggerType> triggerType, TaskSortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listTasksV1Async(itemsPerPage, page, action, enabled, sourceID, destinationID, triggerType, sort, order, null);
    }

    public CompletableFuture<ListTasksResponseV1> listTasksV1Async(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listTasksV1Async(null, null, null, null, null, null, null, null, null, requestOptions);
    }

    public CompletableFuture<ListTasksResponseV1> listTasksV1Async() throws AlgoliaRuntimeException {
        return this.listTasksV1Async(null, null, null, null, null, null, null, null, null, null);
    }

    public ListTransformationsResponse listTransformations(Integer itemsPerPage, Integer page, SortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.listTransformationsAsync(itemsPerPage, page, sort, order, requestOptions));
    }

    public ListTransformationsResponse listTransformations(Integer itemsPerPage, Integer page, SortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listTransformations(itemsPerPage, page, sort, order, null);
    }

    public ListTransformationsResponse listTransformations(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listTransformations(null, null, null, null, requestOptions);
    }

    public ListTransformationsResponse listTransformations() throws AlgoliaRuntimeException {
        return this.listTransformations(null, null, null, null, null);
    }

    public CompletableFuture<ListTransformationsResponse> listTransformationsAsync(Integer itemsPerPage, Integer page, SortKeys sort, OrderKeys order, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/transformations").setMethod("GET").addQueryParameter("itemsPerPage", itemsPerPage).addQueryParameter("page", page).addQueryParameter("sort", (Object)sort).addQueryParameter("order", (Object)order).build();
        return this.executeAsync(request, requestOptions, new TypeReference<ListTransformationsResponse>(){});
    }

    public CompletableFuture<ListTransformationsResponse> listTransformationsAsync(Integer itemsPerPage, Integer page, SortKeys sort, OrderKeys order) throws AlgoliaRuntimeException {
        return this.listTransformationsAsync(itemsPerPage, page, sort, order, null);
    }

    public CompletableFuture<ListTransformationsResponse> listTransformationsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.listTransformationsAsync(null, null, null, null, requestOptions);
    }

    public CompletableFuture<ListTransformationsResponse> listTransformationsAsync() throws AlgoliaRuntimeException {
        return this.listTransformationsAsync(null, null, null, null, null);
    }

    public RunResponse pushTask(@Nonnull String taskID, @Nonnull PushTaskPayload pushTaskPayload, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.pushTaskAsync(taskID, pushTaskPayload, requestOptions));
    }

    public RunResponse pushTask(@Nonnull String taskID, @Nonnull PushTaskPayload pushTaskPayload) throws AlgoliaRuntimeException {
        return this.pushTask(taskID, pushTaskPayload, null);
    }

    public CompletableFuture<RunResponse> pushTaskAsync(@Nonnull String taskID, @Nonnull PushTaskPayload pushTaskPayload, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `pushTask`.");
        Parameters.requireNonNull(pushTaskPayload, "Parameter `pushTaskPayload` is required when calling `pushTask`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/tasks/{taskID}/push", taskID).setMethod("POST").setBody(pushTaskPayload).build();
        return this.executeAsync(request, requestOptions, new TypeReference<RunResponse>(){});
    }

    public CompletableFuture<RunResponse> pushTaskAsync(@Nonnull String taskID, @Nonnull PushTaskPayload pushTaskPayload) throws AlgoliaRuntimeException {
        return this.pushTaskAsync(taskID, pushTaskPayload, null);
    }

    public RunSourceResponse runSource(@Nonnull String sourceID, RunSourcePayload runSourcePayload, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.runSourceAsync(sourceID, runSourcePayload, requestOptions));
    }

    public RunSourceResponse runSource(@Nonnull String sourceID, RunSourcePayload runSourcePayload) throws AlgoliaRuntimeException {
        return this.runSource(sourceID, runSourcePayload, null);
    }

    public RunSourceResponse runSource(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.runSource(sourceID, null, requestOptions);
    }

    public RunSourceResponse runSource(@Nonnull String sourceID) throws AlgoliaRuntimeException {
        return this.runSource(sourceID, null, null);
    }

    public CompletableFuture<RunSourceResponse> runSourceAsync(@Nonnull String sourceID, RunSourcePayload runSourcePayload, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `runSource`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}/run", sourceID).setMethod("POST").setBody(runSourcePayload).build();
        return this.executeAsync(request, requestOptions, new TypeReference<RunSourceResponse>(){});
    }

    public CompletableFuture<RunSourceResponse> runSourceAsync(@Nonnull String sourceID, RunSourcePayload runSourcePayload) throws AlgoliaRuntimeException {
        return this.runSourceAsync(sourceID, runSourcePayload, null);
    }

    public CompletableFuture<RunSourceResponse> runSourceAsync(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.runSourceAsync(sourceID, null, requestOptions);
    }

    public CompletableFuture<RunSourceResponse> runSourceAsync(@Nonnull String sourceID) throws AlgoliaRuntimeException {
        return this.runSourceAsync(sourceID, null, null);
    }

    public RunResponse runTask(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.runTaskAsync(taskID, requestOptions));
    }

    public RunResponse runTask(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.runTask(taskID, null);
    }

    public CompletableFuture<RunResponse> runTaskAsync(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `runTask`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/tasks/{taskID}/run", taskID).setMethod("POST").build();
        return this.executeAsync(request, requestOptions, new TypeReference<RunResponse>(){});
    }

    public CompletableFuture<RunResponse> runTaskAsync(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.runTaskAsync(taskID, null);
    }

    public RunResponse runTaskV1(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.runTaskV1Async(taskID, requestOptions));
    }

    public RunResponse runTaskV1(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.runTaskV1(taskID, null);
    }

    public CompletableFuture<RunResponse> runTaskV1Async(@Nonnull String taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `runTaskV1`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}/run", taskID).setMethod("POST").build();
        return this.executeAsync(request, requestOptions, new TypeReference<RunResponse>(){});
    }

    public CompletableFuture<RunResponse> runTaskV1Async(@Nonnull String taskID) throws AlgoliaRuntimeException {
        return this.runTaskV1Async(taskID, null);
    }

    public List<Authentication> searchAuthentications(@Nonnull AuthenticationSearch authenticationSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchAuthenticationsAsync(authenticationSearch, requestOptions));
    }

    public List<Authentication> searchAuthentications(@Nonnull AuthenticationSearch authenticationSearch) throws AlgoliaRuntimeException {
        return this.searchAuthentications(authenticationSearch, null);
    }

    public CompletableFuture<List<Authentication>> searchAuthenticationsAsync(@Nonnull AuthenticationSearch authenticationSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(authenticationSearch, "Parameter `authenticationSearch` is required when calling `searchAuthentications`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/authentications/search").setMethod("POST").setBody(authenticationSearch).build();
        return this.executeAsync(request, requestOptions, new TypeReference<List<Authentication>>(){});
    }

    public CompletableFuture<List<Authentication>> searchAuthenticationsAsync(@Nonnull AuthenticationSearch authenticationSearch) throws AlgoliaRuntimeException {
        return this.searchAuthenticationsAsync(authenticationSearch, null);
    }

    public List<Destination> searchDestinations(@Nonnull DestinationSearch destinationSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchDestinationsAsync(destinationSearch, requestOptions));
    }

    public List<Destination> searchDestinations(@Nonnull DestinationSearch destinationSearch) throws AlgoliaRuntimeException {
        return this.searchDestinations(destinationSearch, null);
    }

    public CompletableFuture<List<Destination>> searchDestinationsAsync(@Nonnull DestinationSearch destinationSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(destinationSearch, "Parameter `destinationSearch` is required when calling `searchDestinations`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/destinations/search").setMethod("POST").setBody(destinationSearch).build();
        return this.executeAsync(request, requestOptions, new TypeReference<List<Destination>>(){});
    }

    public CompletableFuture<List<Destination>> searchDestinationsAsync(@Nonnull DestinationSearch destinationSearch) throws AlgoliaRuntimeException {
        return this.searchDestinationsAsync(destinationSearch, null);
    }

    public List<Source> searchSources(@Nonnull SourceSearch sourceSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchSourcesAsync(sourceSearch, requestOptions));
    }

    public List<Source> searchSources(@Nonnull SourceSearch sourceSearch) throws AlgoliaRuntimeException {
        return this.searchSources(sourceSearch, null);
    }

    public CompletableFuture<List<Source>> searchSourcesAsync(@Nonnull SourceSearch sourceSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(sourceSearch, "Parameter `sourceSearch` is required when calling `searchSources`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/sources/search").setMethod("POST").setBody(sourceSearch).build();
        return this.executeAsync(request, requestOptions, new TypeReference<List<Source>>(){});
    }

    public CompletableFuture<List<Source>> searchSourcesAsync(@Nonnull SourceSearch sourceSearch) throws AlgoliaRuntimeException {
        return this.searchSourcesAsync(sourceSearch, null);
    }

    public List<Task> searchTasks(@Nonnull TaskSearch taskSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchTasksAsync(taskSearch, requestOptions));
    }

    public List<Task> searchTasks(@Nonnull TaskSearch taskSearch) throws AlgoliaRuntimeException {
        return this.searchTasks(taskSearch, null);
    }

    public CompletableFuture<List<Task>> searchTasksAsync(@Nonnull TaskSearch taskSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskSearch, "Parameter `taskSearch` is required when calling `searchTasks`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/tasks/search").setMethod("POST").setBody(taskSearch).build();
        return this.executeAsync(request, requestOptions, new TypeReference<List<Task>>(){});
    }

    public CompletableFuture<List<Task>> searchTasksAsync(@Nonnull TaskSearch taskSearch) throws AlgoliaRuntimeException {
        return this.searchTasksAsync(taskSearch, null);
    }

    public List<TaskV1> searchTasksV1(@Nonnull TaskSearch taskSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchTasksV1Async(taskSearch, requestOptions));
    }

    public List<TaskV1> searchTasksV1(@Nonnull TaskSearch taskSearch) throws AlgoliaRuntimeException {
        return this.searchTasksV1(taskSearch, null);
    }

    public CompletableFuture<List<TaskV1>> searchTasksV1Async(@Nonnull TaskSearch taskSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskSearch, "Parameter `taskSearch` is required when calling `searchTasksV1`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/tasks/search").setMethod("POST").setBody(taskSearch).build();
        return this.executeAsync(request, requestOptions, new TypeReference<List<TaskV1>>(){});
    }

    public CompletableFuture<List<TaskV1>> searchTasksV1Async(@Nonnull TaskSearch taskSearch) throws AlgoliaRuntimeException {
        return this.searchTasksV1Async(taskSearch, null);
    }

    public List<Transformation> searchTransformations(@Nonnull TransformationSearch transformationSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchTransformationsAsync(transformationSearch, requestOptions));
    }

    public List<Transformation> searchTransformations(@Nonnull TransformationSearch transformationSearch) throws AlgoliaRuntimeException {
        return this.searchTransformations(transformationSearch, null);
    }

    public CompletableFuture<List<Transformation>> searchTransformationsAsync(@Nonnull TransformationSearch transformationSearch, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(transformationSearch, "Parameter `transformationSearch` is required when calling `searchTransformations`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/transformations/search").setMethod("POST").setBody(transformationSearch).build();
        return this.executeAsync(request, requestOptions, new TypeReference<List<Transformation>>(){});
    }

    public CompletableFuture<List<Transformation>> searchTransformationsAsync(@Nonnull TransformationSearch transformationSearch) throws AlgoliaRuntimeException {
        return this.searchTransformationsAsync(transformationSearch, null);
    }

    public SourceWatchResponse triggerDockerSourceDiscover(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.triggerDockerSourceDiscoverAsync(sourceID, requestOptions));
    }

    public SourceWatchResponse triggerDockerSourceDiscover(@Nonnull String sourceID) throws AlgoliaRuntimeException {
        return this.triggerDockerSourceDiscover(sourceID, null);
    }

    public CompletableFuture<SourceWatchResponse> triggerDockerSourceDiscoverAsync(@Nonnull String sourceID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `triggerDockerSourceDiscover`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}/discover", sourceID).setMethod("POST").build();
        return this.executeAsync(request, requestOptions, new TypeReference<SourceWatchResponse>(){});
    }

    public CompletableFuture<SourceWatchResponse> triggerDockerSourceDiscoverAsync(@Nonnull String sourceID) throws AlgoliaRuntimeException {
        return this.triggerDockerSourceDiscoverAsync(sourceID, null);
    }

    public TransformationTryResponse tryTransformation(@Nonnull TransformationTry transformationTry, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.tryTransformationAsync(transformationTry, requestOptions));
    }

    public TransformationTryResponse tryTransformation(@Nonnull TransformationTry transformationTry) throws AlgoliaRuntimeException {
        return this.tryTransformation(transformationTry, null);
    }

    public CompletableFuture<TransformationTryResponse> tryTransformationAsync(@Nonnull TransformationTry transformationTry, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(transformationTry, "Parameter `transformationTry` is required when calling `tryTransformation`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/transformations/try").setMethod("POST").setBody(transformationTry).build();
        return this.executeAsync(request, requestOptions, new TypeReference<TransformationTryResponse>(){});
    }

    public CompletableFuture<TransformationTryResponse> tryTransformationAsync(@Nonnull TransformationTry transformationTry) throws AlgoliaRuntimeException {
        return this.tryTransformationAsync(transformationTry, null);
    }

    public TransformationTryResponse tryTransformationBeforeUpdate(@Nonnull String transformationID, @Nonnull TransformationTry transformationTry, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.tryTransformationBeforeUpdateAsync(transformationID, transformationTry, requestOptions));
    }

    public TransformationTryResponse tryTransformationBeforeUpdate(@Nonnull String transformationID, @Nonnull TransformationTry transformationTry) throws AlgoliaRuntimeException {
        return this.tryTransformationBeforeUpdate(transformationID, transformationTry, null);
    }

    public CompletableFuture<TransformationTryResponse> tryTransformationBeforeUpdateAsync(@Nonnull String transformationID, @Nonnull TransformationTry transformationTry, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(transformationID, "Parameter `transformationID` is required when calling `tryTransformationBeforeUpdate`.");
        Parameters.requireNonNull(transformationTry, "Parameter `transformationTry` is required when calling `tryTransformationBeforeUpdate`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/transformations/{transformationID}/try", transformationID).setMethod("POST").setBody(transformationTry).build();
        return this.executeAsync(request, requestOptions, new TypeReference<TransformationTryResponse>(){});
    }

    public CompletableFuture<TransformationTryResponse> tryTransformationBeforeUpdateAsync(@Nonnull String transformationID, @Nonnull TransformationTry transformationTry) throws AlgoliaRuntimeException {
        return this.tryTransformationBeforeUpdateAsync(transformationID, transformationTry, null);
    }

    public AuthenticationUpdateResponse updateAuthentication(@Nonnull String authenticationID, @Nonnull AuthenticationUpdate authenticationUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.updateAuthenticationAsync(authenticationID, authenticationUpdate, requestOptions));
    }

    public AuthenticationUpdateResponse updateAuthentication(@Nonnull String authenticationID, @Nonnull AuthenticationUpdate authenticationUpdate) throws AlgoliaRuntimeException {
        return this.updateAuthentication(authenticationID, authenticationUpdate, null);
    }

    public CompletableFuture<AuthenticationUpdateResponse> updateAuthenticationAsync(@Nonnull String authenticationID, @Nonnull AuthenticationUpdate authenticationUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(authenticationID, "Parameter `authenticationID` is required when calling `updateAuthentication`.");
        Parameters.requireNonNull(authenticationUpdate, "Parameter `authenticationUpdate` is required when calling `updateAuthentication`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/authentications/{authenticationID}", authenticationID).setMethod("PATCH").setBody(authenticationUpdate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<AuthenticationUpdateResponse>(){});
    }

    public CompletableFuture<AuthenticationUpdateResponse> updateAuthenticationAsync(@Nonnull String authenticationID, @Nonnull AuthenticationUpdate authenticationUpdate) throws AlgoliaRuntimeException {
        return this.updateAuthenticationAsync(authenticationID, authenticationUpdate, null);
    }

    public DestinationUpdateResponse updateDestination(@Nonnull String destinationID, @Nonnull DestinationUpdate destinationUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.updateDestinationAsync(destinationID, destinationUpdate, requestOptions));
    }

    public DestinationUpdateResponse updateDestination(@Nonnull String destinationID, @Nonnull DestinationUpdate destinationUpdate) throws AlgoliaRuntimeException {
        return this.updateDestination(destinationID, destinationUpdate, null);
    }

    public CompletableFuture<DestinationUpdateResponse> updateDestinationAsync(@Nonnull String destinationID, @Nonnull DestinationUpdate destinationUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(destinationID, "Parameter `destinationID` is required when calling `updateDestination`.");
        Parameters.requireNonNull(destinationUpdate, "Parameter `destinationUpdate` is required when calling `updateDestination`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/destinations/{destinationID}", destinationID).setMethod("PATCH").setBody(destinationUpdate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<DestinationUpdateResponse>(){});
    }

    public CompletableFuture<DestinationUpdateResponse> updateDestinationAsync(@Nonnull String destinationID, @Nonnull DestinationUpdate destinationUpdate) throws AlgoliaRuntimeException {
        return this.updateDestinationAsync(destinationID, destinationUpdate, null);
    }

    public SourceUpdateResponse updateSource(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.updateSourceAsync(sourceID, sourceUpdate, requestOptions));
    }

    public SourceUpdateResponse updateSource(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate) throws AlgoliaRuntimeException {
        return this.updateSource(sourceID, sourceUpdate, null);
    }

    public CompletableFuture<SourceUpdateResponse> updateSourceAsync(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `updateSource`.");
        Parameters.requireNonNull(sourceUpdate, "Parameter `sourceUpdate` is required when calling `updateSource`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}", sourceID).setMethod("PATCH").setBody(sourceUpdate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SourceUpdateResponse>(){});
    }

    public CompletableFuture<SourceUpdateResponse> updateSourceAsync(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate) throws AlgoliaRuntimeException {
        return this.updateSourceAsync(sourceID, sourceUpdate, null);
    }

    public TaskUpdateResponse updateTask(@Nonnull String taskID, @Nonnull TaskUpdate taskUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.updateTaskAsync(taskID, taskUpdate, requestOptions));
    }

    public TaskUpdateResponse updateTask(@Nonnull String taskID, @Nonnull TaskUpdate taskUpdate) throws AlgoliaRuntimeException {
        return this.updateTask(taskID, taskUpdate, null);
    }

    public CompletableFuture<TaskUpdateResponse> updateTaskAsync(@Nonnull String taskID, @Nonnull TaskUpdate taskUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `updateTask`.");
        Parameters.requireNonNull(taskUpdate, "Parameter `taskUpdate` is required when calling `updateTask`.");
        HttpRequest request = HttpRequest.builder().setPath("/2/tasks/{taskID}", taskID).setMethod("PATCH").setBody(taskUpdate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>(){});
    }

    public CompletableFuture<TaskUpdateResponse> updateTaskAsync(@Nonnull String taskID, @Nonnull TaskUpdate taskUpdate) throws AlgoliaRuntimeException {
        return this.updateTaskAsync(taskID, taskUpdate, null);
    }

    public TaskUpdateResponse updateTaskV1(@Nonnull String taskID, @Nonnull TaskUpdateV1 taskUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.updateTaskV1Async(taskID, taskUpdate, requestOptions));
    }

    public TaskUpdateResponse updateTaskV1(@Nonnull String taskID, @Nonnull TaskUpdateV1 taskUpdate) throws AlgoliaRuntimeException {
        return this.updateTaskV1(taskID, taskUpdate, null);
    }

    public CompletableFuture<TaskUpdateResponse> updateTaskV1Async(@Nonnull String taskID, @Nonnull TaskUpdateV1 taskUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `updateTaskV1`.");
        Parameters.requireNonNull(taskUpdate, "Parameter `taskUpdate` is required when calling `updateTaskV1`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/tasks/{taskID}", taskID).setMethod("PATCH").setBody(taskUpdate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<TaskUpdateResponse>(){});
    }

    public CompletableFuture<TaskUpdateResponse> updateTaskV1Async(@Nonnull String taskID, @Nonnull TaskUpdateV1 taskUpdate) throws AlgoliaRuntimeException {
        return this.updateTaskV1Async(taskID, taskUpdate, null);
    }

    public TransformationUpdateResponse updateTransformation(@Nonnull String transformationID, @Nonnull TransformationCreate transformationCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.updateTransformationAsync(transformationID, transformationCreate, requestOptions));
    }

    public TransformationUpdateResponse updateTransformation(@Nonnull String transformationID, @Nonnull TransformationCreate transformationCreate) throws AlgoliaRuntimeException {
        return this.updateTransformation(transformationID, transformationCreate, null);
    }

    public CompletableFuture<TransformationUpdateResponse> updateTransformationAsync(@Nonnull String transformationID, @Nonnull TransformationCreate transformationCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(transformationID, "Parameter `transformationID` is required when calling `updateTransformation`.");
        Parameters.requireNonNull(transformationCreate, "Parameter `transformationCreate` is required when calling `updateTransformation`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/transformations/{transformationID}", transformationID).setMethod("PUT").setBody(transformationCreate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<TransformationUpdateResponse>(){});
    }

    public CompletableFuture<TransformationUpdateResponse> updateTransformationAsync(@Nonnull String transformationID, @Nonnull TransformationCreate transformationCreate) throws AlgoliaRuntimeException {
        return this.updateTransformationAsync(transformationID, transformationCreate, null);
    }

    public SourceWatchResponse validateSource(SourceCreate sourceCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.validateSourceAsync(sourceCreate, requestOptions));
    }

    public SourceWatchResponse validateSource(SourceCreate sourceCreate) throws AlgoliaRuntimeException {
        return this.validateSource(sourceCreate, null);
    }

    public SourceWatchResponse validateSource(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.validateSource(null, requestOptions);
    }

    public SourceWatchResponse validateSource() throws AlgoliaRuntimeException {
        return this.validateSource(null, null);
    }

    public CompletableFuture<SourceWatchResponse> validateSourceAsync(SourceCreate sourceCreate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/sources/validate").setMethod("POST").setBody(sourceCreate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SourceWatchResponse>(){});
    }

    public CompletableFuture<SourceWatchResponse> validateSourceAsync(SourceCreate sourceCreate) throws AlgoliaRuntimeException {
        return this.validateSourceAsync(sourceCreate, null);
    }

    public CompletableFuture<SourceWatchResponse> validateSourceAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.validateSourceAsync(null, requestOptions);
    }

    public CompletableFuture<SourceWatchResponse> validateSourceAsync() throws AlgoliaRuntimeException {
        return this.validateSourceAsync(null, null);
    }

    public SourceWatchResponse validateSourceBeforeUpdate(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.validateSourceBeforeUpdateAsync(sourceID, sourceUpdate, requestOptions));
    }

    public SourceWatchResponse validateSourceBeforeUpdate(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate) throws AlgoliaRuntimeException {
        return this.validateSourceBeforeUpdate(sourceID, sourceUpdate, null);
    }

    public CompletableFuture<SourceWatchResponse> validateSourceBeforeUpdateAsync(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(sourceID, "Parameter `sourceID` is required when calling `validateSourceBeforeUpdate`.");
        Parameters.requireNonNull(sourceUpdate, "Parameter `sourceUpdate` is required when calling `validateSourceBeforeUpdate`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/sources/{sourceID}/validate", sourceID).setMethod("POST").setBody(sourceUpdate).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SourceWatchResponse>(){});
    }

    public CompletableFuture<SourceWatchResponse> validateSourceBeforeUpdateAsync(@Nonnull String sourceID, @Nonnull SourceUpdate sourceUpdate) throws AlgoliaRuntimeException {
        return this.validateSourceBeforeUpdateAsync(sourceID, sourceUpdate, null);
    }
}

