/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.monitoring.IncidentsResponse;
import com.algolia.model.monitoring.IndexingTimeResponse;
import com.algolia.model.monitoring.InfrastructureResponse;
import com.algolia.model.monitoring.InventoryResponse;
import com.algolia.model.monitoring.LatencyResponse;
import com.algolia.model.monitoring.Metric;
import com.algolia.model.monitoring.Period;
import com.algolia.model.monitoring.StatusResponse;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class MonitoringClient
extends ApiClient {
    public MonitoringClient(String appId, String apiKey) {
        this(appId, apiKey, null);
    }

    public MonitoringClient(String appId, String apiKey, ClientOptions options) {
        super(appId, apiKey, "Monitoring", options, MonitoringClient.getDefaultHosts());
    }

    private static List<Host> getDefaultHosts() {
        ArrayList<Host> hosts = new ArrayList<Host>();
        hosts.add(new Host("status.algolia.com", EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customDeleteAsync(path, parameters, requestOptions));
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDelete(path, parameters, null);
    }

    public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, requestOptions);
    }

    public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, null);
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customGetAsync(path, parameters, requestOptions));
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGet(path, parameters, null);
    }

    public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGet(path, null, requestOptions);
    }

    public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGet(path, null, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, null);
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPostAsync(path, parameters, body, requestOptions));
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPost(path, parameters, body, null);
    }

    public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, requestOptions);
    }

    public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, null);
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPutAsync(path, parameters, body, requestOptions));
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPut(path, parameters, body, null);
    }

    public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, requestOptions);
    }

    public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, null);
    }

    public IncidentsResponse getClusterIncidents(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getClusterIncidentsAsync(clusters, requestOptions));
    }

    public IncidentsResponse getClusterIncidents(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getClusterIncidents(clusters, null);
    }

    public CompletableFuture<IncidentsResponse> getClusterIncidentsAsync(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getClusterIncidents`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/incidents/{clusters}", clusters).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<IncidentsResponse>(){});
    }

    public CompletableFuture<IncidentsResponse> getClusterIncidentsAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getClusterIncidentsAsync(clusters, null);
    }

    public StatusResponse getClusterStatus(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getClusterStatusAsync(clusters, requestOptions));
    }

    public StatusResponse getClusterStatus(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getClusterStatus(clusters, null);
    }

    public CompletableFuture<StatusResponse> getClusterStatusAsync(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getClusterStatus`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/status/{clusters}", clusters).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<StatusResponse>(){});
    }

    public CompletableFuture<StatusResponse> getClusterStatusAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getClusterStatusAsync(clusters, null);
    }

    public IncidentsResponse getIncidents(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getIncidentsAsync(requestOptions));
    }

    public IncidentsResponse getIncidents() throws AlgoliaRuntimeException {
        return this.getIncidents(null);
    }

    public CompletableFuture<IncidentsResponse> getIncidentsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/incidents").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<IncidentsResponse>(){});
    }

    public CompletableFuture<IncidentsResponse> getIncidentsAsync() throws AlgoliaRuntimeException {
        return this.getIncidentsAsync(null);
    }

    public IndexingTimeResponse getIndexingTime(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getIndexingTimeAsync(clusters, requestOptions));
    }

    public IndexingTimeResponse getIndexingTime(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getIndexingTime(clusters, null);
    }

    public CompletableFuture<IndexingTimeResponse> getIndexingTimeAsync(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getIndexingTime`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexing/{clusters}", clusters).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<IndexingTimeResponse>(){});
    }

    public CompletableFuture<IndexingTimeResponse> getIndexingTimeAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getIndexingTimeAsync(clusters, null);
    }

    public LatencyResponse getLatency(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getLatencyAsync(clusters, requestOptions));
    }

    public LatencyResponse getLatency(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getLatency(clusters, null);
    }

    public CompletableFuture<LatencyResponse> getLatencyAsync(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getLatency`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/latency/{clusters}", clusters).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<LatencyResponse>(){});
    }

    public CompletableFuture<LatencyResponse> getLatencyAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getLatencyAsync(clusters, null);
    }

    public InfrastructureResponse getMetrics(@Nonnull Metric metric, @Nonnull Period period, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getMetricsAsync(metric, period, requestOptions));
    }

    public InfrastructureResponse getMetrics(@Nonnull Metric metric, @Nonnull Period period) throws AlgoliaRuntimeException {
        return this.getMetrics(metric, period, null);
    }

    public CompletableFuture<InfrastructureResponse> getMetricsAsync(@Nonnull Metric metric, @Nonnull Period period, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull((Object)metric, "Parameter `metric` is required when calling `getMetrics`.");
        Parameters.requireNonNull((Object)period, "Parameter `period` is required when calling `getMetrics`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/infrastructure/{metric}/period/{period}", new Object[]{metric, period}).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<InfrastructureResponse>(){});
    }

    public CompletableFuture<InfrastructureResponse> getMetricsAsync(@Nonnull Metric metric, @Nonnull Period period) throws AlgoliaRuntimeException {
        return this.getMetricsAsync(metric, period, null);
    }

    public Map<String, Map<String, Boolean>> getReachability(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getReachabilityAsync(clusters, requestOptions));
    }

    public Map<String, Map<String, Boolean>> getReachability(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getReachability(clusters, null);
    }

    public CompletableFuture<Map<String, Map<String, Boolean>>> getReachabilityAsync(@Nonnull String clusters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(clusters, "Parameter `clusters` is required when calling `getReachability`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/reachability/{clusters}/probes", clusters).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<Map<String, Map<String, Boolean>>>(){});
    }

    public CompletableFuture<Map<String, Map<String, Boolean>>> getReachabilityAsync(@Nonnull String clusters) throws AlgoliaRuntimeException {
        return this.getReachabilityAsync(clusters, null);
    }

    public InventoryResponse getServers(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getServersAsync(requestOptions));
    }

    public InventoryResponse getServers() throws AlgoliaRuntimeException {
        return this.getServers(null);
    }

    public CompletableFuture<InventoryResponse> getServersAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/inventory/servers").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<InventoryResponse>(){});
    }

    public CompletableFuture<InventoryResponse> getServersAsync() throws AlgoliaRuntimeException {
        return this.getServersAsync(null);
    }

    public StatusResponse getStatus(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getStatusAsync(requestOptions));
    }

    public StatusResponse getStatus() throws AlgoliaRuntimeException {
        return this.getStatus(null);
    }

    public CompletableFuture<StatusResponse> getStatusAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/status").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<StatusResponse>(){});
    }

    public CompletableFuture<StatusResponse> getStatusAsync() throws AlgoliaRuntimeException {
        return this.getStatusAsync(null);
    }
}

