/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.querysuggestions.BaseResponse;
import com.algolia.model.querysuggestions.ConfigStatus;
import com.algolia.model.querysuggestions.Configuration;
import com.algolia.model.querysuggestions.ConfigurationResponse;
import com.algolia.model.querysuggestions.ConfigurationWithIndex;
import com.algolia.model.querysuggestions.LogFile;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class QuerySuggestionsClient
extends ApiClient {
    private static final String[] allowedRegions = new String[]{"eu", "us"};

    public QuerySuggestionsClient(String appId, String apiKey, String region) {
        this(appId, apiKey, region, null);
    }

    public QuerySuggestionsClient(String appId, String apiKey, String region, ClientOptions options) {
        super(appId, apiKey, "QuerySuggestions", options, QuerySuggestionsClient.getDefaultHosts(region));
    }

    private static List<Host> getDefaultHosts(String region) throws AlgoliaRuntimeException {
        ArrayList<Host> hosts = new ArrayList<Host>();
        boolean found = false;
        if (region != null) {
            for (String allowed : allowedRegions) {
                if (!allowed.equals(region)) continue;
                found = true;
                break;
            }
        }
        if (region == null || !found) {
            throw new AlgoliaRuntimeException("`region` is required and must be one of the following: eu, us");
        }
        String url = "query-suggestions.{region}.algolia.com".replace("{region}", region);
        hosts.add(new Host(url, EnumSet.of(CallType.READ, CallType.WRITE)));
        return hosts;
    }

    public BaseResponse createConfig(@Nonnull ConfigurationWithIndex configurationWithIndex, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.createConfigAsync(configurationWithIndex, requestOptions));
    }

    public BaseResponse createConfig(@Nonnull ConfigurationWithIndex configurationWithIndex) throws AlgoliaRuntimeException {
        return this.createConfig(configurationWithIndex, null);
    }

    public CompletableFuture<BaseResponse> createConfigAsync(@Nonnull ConfigurationWithIndex configurationWithIndex, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(configurationWithIndex, "Parameter `configurationWithIndex` is required when calling `createConfig`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/configs").setMethod("POST").setBody(configurationWithIndex).build();
        return this.executeAsync(request, requestOptions, new TypeReference<BaseResponse>(){});
    }

    public CompletableFuture<BaseResponse> createConfigAsync(@Nonnull ConfigurationWithIndex configurationWithIndex) throws AlgoliaRuntimeException {
        return this.createConfigAsync(configurationWithIndex, null);
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customDeleteAsync(path, parameters, requestOptions));
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDelete(path, parameters, null);
    }

    public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, requestOptions);
    }

    public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, null);
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customGetAsync(path, parameters, requestOptions));
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGet(path, parameters, null);
    }

    public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGet(path, null, requestOptions);
    }

    public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGet(path, null, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, null);
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPostAsync(path, parameters, body, requestOptions));
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPost(path, parameters, body, null);
    }

    public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, requestOptions);
    }

    public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, null);
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPutAsync(path, parameters, body, requestOptions));
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPut(path, parameters, body, null);
    }

    public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, requestOptions);
    }

    public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, null);
    }

    public BaseResponse deleteConfig(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteConfigAsync(indexName, requestOptions));
    }

    public BaseResponse deleteConfig(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.deleteConfig(indexName, null);
    }

    public CompletableFuture<BaseResponse> deleteConfigAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteConfig`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}", indexName).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<BaseResponse>(){});
    }

    public CompletableFuture<BaseResponse> deleteConfigAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.deleteConfigAsync(indexName, null);
    }

    public List<ConfigurationResponse> getAllConfigs(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getAllConfigsAsync(requestOptions));
    }

    public List<ConfigurationResponse> getAllConfigs() throws AlgoliaRuntimeException {
        return this.getAllConfigs(null);
    }

    public CompletableFuture<List<ConfigurationResponse>> getAllConfigsAsync(RequestOptions requestOptions) throws AlgoliaRuntimeException {
        HttpRequest request = HttpRequest.builder().setPath("/1/configs").setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<List<ConfigurationResponse>>(){});
    }

    public CompletableFuture<List<ConfigurationResponse>> getAllConfigsAsync() throws AlgoliaRuntimeException {
        return this.getAllConfigsAsync(null);
    }

    public ConfigurationResponse getConfig(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getConfigAsync(indexName, requestOptions));
    }

    public ConfigurationResponse getConfig(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getConfig(indexName, null);
    }

    public CompletableFuture<ConfigurationResponse> getConfigAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getConfig`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}", indexName).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<ConfigurationResponse>(){});
    }

    public CompletableFuture<ConfigurationResponse> getConfigAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getConfigAsync(indexName, null);
    }

    public ConfigStatus getConfigStatus(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getConfigStatusAsync(indexName, requestOptions));
    }

    public ConfigStatus getConfigStatus(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getConfigStatus(indexName, null);
    }

    public CompletableFuture<ConfigStatus> getConfigStatusAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getConfigStatus`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}/status", indexName).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<ConfigStatus>(){});
    }

    public CompletableFuture<ConfigStatus> getConfigStatusAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getConfigStatusAsync(indexName, null);
    }

    public LogFile getLogFile(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getLogFileAsync(indexName, requestOptions));
    }

    public LogFile getLogFile(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getLogFile(indexName, null);
    }

    public CompletableFuture<LogFile> getLogFileAsync(@Nonnull String indexName, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getLogFile`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/logs/{indexName}", indexName).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<LogFile>(){});
    }

    public CompletableFuture<LogFile> getLogFileAsync(@Nonnull String indexName) throws AlgoliaRuntimeException {
        return this.getLogFileAsync(indexName, null);
    }

    public BaseResponse updateConfig(@Nonnull String indexName, @Nonnull Configuration configuration, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.updateConfigAsync(indexName, configuration, requestOptions));
    }

    public BaseResponse updateConfig(@Nonnull String indexName, @Nonnull Configuration configuration) throws AlgoliaRuntimeException {
        return this.updateConfig(indexName, configuration, null);
    }

    public CompletableFuture<BaseResponse> updateConfigAsync(@Nonnull String indexName, @Nonnull Configuration configuration, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `updateConfig`.");
        Parameters.requireNonNull(configuration, "Parameter `configuration` is required when calling `updateConfig`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/configs/{indexName}", indexName).setMethod("PUT").setBody(configuration).build();
        return this.executeAsync(request, requestOptions, new TypeReference<BaseResponse>(){});
    }

    public CompletableFuture<BaseResponse> updateConfigAsync(@Nonnull String indexName, @Nonnull Configuration configuration) throws AlgoliaRuntimeException {
        return this.updateConfigAsync(indexName, configuration, null);
    }
}

