/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.api;

import com.algolia.ApiClient;
import com.algolia.config.CallType;
import com.algolia.config.ClientOptions;
import com.algolia.config.Host;
import com.algolia.config.HttpRequest;
import com.algolia.config.RequestOptions;
import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.exceptions.LaunderThrowable;
import com.algolia.model.recommend.DeletedAtResponse;
import com.algolia.model.recommend.GetRecommendTaskResponse;
import com.algolia.model.recommend.GetRecommendationsParams;
import com.algolia.model.recommend.GetRecommendationsResponse;
import com.algolia.model.recommend.RecommendModels;
import com.algolia.model.recommend.RecommendRule;
import com.algolia.model.recommend.SearchRecommendRulesParams;
import com.algolia.model.recommend.SearchRecommendRulesResponse;
import com.algolia.utils.Parameters;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class RecommendClient
extends ApiClient {
    public RecommendClient(String appId, String apiKey) {
        this(appId, apiKey, null);
    }

    public RecommendClient(String appId, String apiKey, ClientOptions options) {
        super(appId, apiKey, "Recommend", options, RecommendClient.getDefaultHosts(appId));
    }

    private static List<Host> getDefaultHosts(String appId) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        hosts.add(new Host(appId + "-dsn.algolia.net", EnumSet.of(CallType.READ)));
        hosts.add(new Host(appId + ".algolia.net", EnumSet.of(CallType.WRITE)));
        ArrayList<Host> commonHosts = new ArrayList<Host>();
        commonHosts.add(new Host(appId + "-1.algolianet.com", EnumSet.of(CallType.READ, CallType.WRITE)));
        commonHosts.add(new Host(appId + "-2.algolianet.com", EnumSet.of(CallType.READ, CallType.WRITE)));
        commonHosts.add(new Host(appId + "-3.algolianet.com", EnumSet.of(CallType.READ, CallType.WRITE)));
        Collections.shuffle(commonHosts, new Random());
        return Stream.concat(hosts.stream(), commonHosts.stream()).collect(Collectors.toList());
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customDeleteAsync(path, parameters, requestOptions));
    }

    public Object customDelete(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDelete(path, parameters, null);
    }

    public Object customDelete(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, requestOptions);
    }

    public Object customDelete(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDelete(path, null, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customDelete`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("DELETE").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customDeleteAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customDeleteAsync(path, null, null);
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customGetAsync(path, parameters, requestOptions));
    }

    public Object customGet(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGet(path, parameters, null);
    }

    public Object customGet(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGet(path, null, requestOptions);
    }

    public Object customGet(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGet(path, null, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customGet`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("GET").addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, Map<String, Object> parameters) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, parameters, null);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, requestOptions);
    }

    public CompletableFuture<Object> customGetAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customGetAsync(path, null, null);
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPostAsync(path, parameters, body, requestOptions));
    }

    public Object customPost(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPost(path, parameters, body, null);
    }

    public Object customPost(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, requestOptions);
    }

    public Object customPost(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPost(path, null, null, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPost`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("POST").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPostAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPostAsync(path, null, null, null);
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.customPutAsync(path, parameters, body, requestOptions));
    }

    public Object customPut(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPut(path, parameters, body, null);
    }

    public Object customPut(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, requestOptions);
    }

    public Object customPut(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPut(path, null, null, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(path, "Parameter `path` is required when calling `customPut`.");
        HttpRequest request = HttpRequest.builder().setPathEncoded("/{path}", path).setMethod("PUT").setBody(body).addQueryParameters(parameters).build();
        return this.executeAsync(request, requestOptions, new TypeReference<Object>(){});
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, Map<String, Object> parameters, Object body) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, parameters, body, null);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, requestOptions);
    }

    public CompletableFuture<Object> customPutAsync(@Nonnull String path) throws AlgoliaRuntimeException {
        return this.customPutAsync(path, null, null, null);
    }

    public DeletedAtResponse deleteRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.deleteRecommendRuleAsync(indexName, model, objectID, requestOptions));
    }

    public DeletedAtResponse deleteRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.deleteRecommendRule(indexName, model, objectID, null);
    }

    public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `deleteRecommendRule`.");
        Parameters.requireNonNull((Object)model, "Parameter `model` is required when calling `deleteRecommendRule`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `deleteRecommendRule`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{model}/recommend/rules/{objectID}", new Object[]{indexName, model, objectID}).setMethod("DELETE").build();
        return this.executeAsync(request, requestOptions, new TypeReference<DeletedAtResponse>(){});
    }

    public CompletableFuture<DeletedAtResponse> deleteRecommendRuleAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.deleteRecommendRuleAsync(indexName, model, objectID, null);
    }

    public RecommendRule getRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRecommendRuleAsync(indexName, model, objectID, requestOptions));
    }

    public RecommendRule getRecommendRule(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.getRecommendRule(indexName, model, objectID, null);
    }

    public CompletableFuture<RecommendRule> getRecommendRuleAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getRecommendRule`.");
        Parameters.requireNonNull((Object)model, "Parameter `model` is required when calling `getRecommendRule`.");
        Parameters.requireNonNull(objectID, "Parameter `objectID` is required when calling `getRecommendRule`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{model}/recommend/rules/{objectID}", new Object[]{indexName, model, objectID}).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<RecommendRule>(){});
    }

    public CompletableFuture<RecommendRule> getRecommendRuleAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull String objectID) throws AlgoliaRuntimeException {
        return this.getRecommendRuleAsync(indexName, model, objectID, null);
    }

    public GetRecommendTaskResponse getRecommendStatus(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRecommendStatusAsync(indexName, model, taskID, requestOptions));
    }

    public GetRecommendTaskResponse getRecommendStatus(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull Long taskID) throws AlgoliaRuntimeException {
        return this.getRecommendStatus(indexName, model, taskID, null);
    }

    public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull Long taskID, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `getRecommendStatus`.");
        Parameters.requireNonNull((Object)model, "Parameter `model` is required when calling `getRecommendStatus`.");
        Parameters.requireNonNull(taskID, "Parameter `taskID` is required when calling `getRecommendStatus`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{model}/task/{taskID}", new Object[]{indexName, model, taskID}).setMethod("GET").build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetRecommendTaskResponse>(){});
    }

    public CompletableFuture<GetRecommendTaskResponse> getRecommendStatusAsync(@Nonnull String indexName, @Nonnull RecommendModels model, @Nonnull Long taskID) throws AlgoliaRuntimeException {
        return this.getRecommendStatusAsync(indexName, model, taskID, null);
    }

    public GetRecommendationsResponse getRecommendations(@Nonnull GetRecommendationsParams getRecommendationsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.getRecommendationsAsync(getRecommendationsParams, requestOptions));
    }

    public GetRecommendationsResponse getRecommendations(@Nonnull GetRecommendationsParams getRecommendationsParams) throws AlgoliaRuntimeException {
        return this.getRecommendations(getRecommendationsParams, null);
    }

    public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(@Nonnull GetRecommendationsParams getRecommendationsParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(getRecommendationsParams, "Parameter `getRecommendationsParams` is required when calling `getRecommendations`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/*/recommendations").setMethod("POST").setBody(getRecommendationsParams).setRead(true).build();
        return this.executeAsync(request, requestOptions, new TypeReference<GetRecommendationsResponse>(){});
    }

    public CompletableFuture<GetRecommendationsResponse> getRecommendationsAsync(@Nonnull GetRecommendationsParams getRecommendationsParams) throws AlgoliaRuntimeException {
        return this.getRecommendationsAsync(getRecommendationsParams, null);
    }

    public SearchRecommendRulesResponse searchRecommendRules(@Nonnull String indexName, @Nonnull RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return LaunderThrowable.await(this.searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, requestOptions));
    }

    public SearchRecommendRulesResponse searchRecommendRules(@Nonnull String indexName, @Nonnull RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams) throws AlgoliaRuntimeException {
        return this.searchRecommendRules(indexName, model, searchRecommendRulesParams, null);
    }

    public SearchRecommendRulesResponse searchRecommendRules(@Nonnull String indexName, @Nonnull RecommendModels model, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchRecommendRules(indexName, model, null, requestOptions);
    }

    public SearchRecommendRulesResponse searchRecommendRules(@Nonnull String indexName, @Nonnull RecommendModels model) throws AlgoliaRuntimeException {
        return this.searchRecommendRules(indexName, model, null, null);
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(@Nonnull String indexName, @Nonnull RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        Parameters.requireNonNull(indexName, "Parameter `indexName` is required when calling `searchRecommendRules`.");
        Parameters.requireNonNull((Object)model, "Parameter `model` is required when calling `searchRecommendRules`.");
        HttpRequest request = HttpRequest.builder().setPath("/1/indexes/{indexName}/{model}/recommend/rules/search", new Object[]{indexName, model}).setMethod("POST").setBody(searchRecommendRulesParams).setRead(true).build();
        return this.executeAsync(request, requestOptions, new TypeReference<SearchRecommendRulesResponse>(){});
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(@Nonnull String indexName, @Nonnull RecommendModels model, SearchRecommendRulesParams searchRecommendRulesParams) throws AlgoliaRuntimeException {
        return this.searchRecommendRulesAsync(indexName, model, searchRecommendRulesParams, null);
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(@Nonnull String indexName, @Nonnull RecommendModels model, RequestOptions requestOptions) throws AlgoliaRuntimeException {
        return this.searchRecommendRulesAsync(indexName, model, null, requestOptions);
    }

    public CompletableFuture<SearchRecommendRulesResponse> searchRecommendRulesAsync(@Nonnull String indexName, @Nonnull RecommendModels model) throws AlgoliaRuntimeException {
        return this.searchRecommendRulesAsync(indexName, model, null, null);
    }
}

