/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.recommend.Range;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface AroundPrecision {
    public static AroundPrecision of(Integer value) {
        return new IntegerWrapper(value);
    }

    public static AroundPrecision of(List<Range> value) {
        return new ListOfRangeWrapper(value);
    }

    @JsonSerialize(using=Serializer.class)
    public static class IntegerWrapper
    implements AroundPrecision {
        private final Integer value;

        IntegerWrapper(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<IntegerWrapper> {
            Serializer() {
            }

            public void serialize(IntegerWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject((Object)value.getValue());
            }
        }
    }

    @JsonSerialize(using=Serializer.class)
    public static class ListOfRangeWrapper
    implements AroundPrecision {
        private final List<Range> value;

        ListOfRangeWrapper(List<Range> value) {
            this.value = value;
        }

        public List<Range> getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<ListOfRangeWrapper> {
            Serializer() {
            }

            public void serialize(ListOfRangeWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject(value.getValue());
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<AroundPrecision> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public AroundPrecision deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isInt()) {
                IntegerWrapper integerWrapper;
                block18: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        Integer value = (Integer)parser.readValueAs(Integer.class);
                        integerWrapper = new IntegerWrapper(value);
                        if (parser == null) break block18;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Integer (error: " + e.getMessage() + ") (type: Integer)");
                        }
                    }
                    parser.close();
                }
                return integerWrapper;
            }
            if (tree.isArray()) {
                ListOfRangeWrapper listOfRangeWrapper;
                block19: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        List value = (List)parser.readValueAs((TypeReference)new TypeReference<List<Range>>(){});
                        listOfRangeWrapper = new ListOfRangeWrapper(value);
                        if (parser == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf List<Range> (error: " + e.getMessage() + ") (type: List<Range>)");
                        }
                    }
                    parser.close();
                }
                return listOfRangeWrapper;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public AroundPrecision getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "AroundPrecision cannot be null");
        }
    }
}

