/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.model.recommend;

import com.algolia.exceptions.AlgoliaRuntimeException;
import com.algolia.model.recommend.HighlightResultOption;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

@JsonDeserialize(using=Deserializer.class)
public interface HighlightResult {
    public static HighlightResult of(Map<String, HighlightResult> value) {
        return new MapOfStringHighlightResultWrapper(value);
    }

    public static HighlightResult of(List<HighlightResult> value) {
        return new ListOfHighlightResultWrapper(value);
    }

    @JsonSerialize(using=Serializer.class)
    public static class MapOfStringHighlightResultWrapper
    implements HighlightResult {
        private final Map<String, HighlightResult> value;

        MapOfStringHighlightResultWrapper(Map<String, HighlightResult> value) {
            this.value = value;
        }

        public Map<String, HighlightResult> getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<MapOfStringHighlightResultWrapper> {
            Serializer() {
            }

            public void serialize(MapOfStringHighlightResultWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject(value.getValue());
            }
        }
    }

    @JsonSerialize(using=Serializer.class)
    public static class ListOfHighlightResultWrapper
    implements HighlightResult {
        private final List<HighlightResult> value;

        ListOfHighlightResultWrapper(List<HighlightResult> value) {
            this.value = value;
        }

        public List<HighlightResult> getValue() {
            return this.value;
        }

        static class Serializer
        extends JsonSerializer<ListOfHighlightResultWrapper> {
            Serializer() {
            }

            public void serialize(ListOfHighlightResultWrapper value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeObject(value.getValue());
            }
        }
    }

    public static class Deserializer
    extends JsonDeserializer<HighlightResult> {
        private static final Logger LOGGER = Logger.getLogger(Deserializer.class.getName());

        public HighlightResult deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            if (tree.isObject() && tree.has("matchLevel") && tree.has("matchedWords")) {
                HighlightResult highlightResult;
                block27: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        highlightResult = (HighlightResult)parser.readValueAs(HighlightResultOption.class);
                        if (parser == null) break block27;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf HighlightResultOption (error: " + e.getMessage() + ") (type: HighlightResultOption)");
                        }
                    }
                    parser.close();
                }
                return highlightResult;
            }
            if (tree.isObject()) {
                MapOfStringHighlightResultWrapper mapOfStringHighlightResultWrapper;
                block28: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        Map value = (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, HighlightResult>>(){});
                        mapOfStringHighlightResultWrapper = new MapOfStringHighlightResultWrapper(value);
                        if (parser == null) break block28;
                    }
                    catch (Throwable value) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable) {
                                    value.addSuppressed(throwable);
                                }
                            }
                            throw value;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf Map<String, HighlightResult> (error: " + e.getMessage() + ") (type: Map<String, HighlightResult>)");
                        }
                    }
                    parser.close();
                }
                return mapOfStringHighlightResultWrapper;
            }
            if (tree.isArray()) {
                ListOfHighlightResultWrapper listOfHighlightResultWrapper;
                block29: {
                    JsonParser parser = tree.traverse(jp.getCodec());
                    try {
                        List value = (List)parser.readValueAs((TypeReference)new TypeReference<List<HighlightResult>>(){});
                        listOfHighlightResultWrapper = new ListOfHighlightResultWrapper(value);
                        if (parser == null) break block29;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (parser != null) {
                                try {
                                    parser.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.finest("Failed to deserialize oneOf List<HighlightResult> (error: " + e.getMessage() + ") (type: List<HighlightResult>)");
                        }
                    }
                    parser.close();
                }
                return listOfHighlightResultWrapper;
            }
            throw new AlgoliaRuntimeException(String.format("Failed to deserialize json element: %s", tree));
        }

        public HighlightResult getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "HighlightResult cannot be null");
        }
    }
}

