/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.helpers;

import android.content.Context;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.BackgroundColorSpan;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.utils.JSONUtils;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class Highlighter {
    private static Highlighter defaultHighlighter;
    private final Pattern pattern;

    public static Highlighter getDefault() {
        if (defaultHighlighter == null) {
            defaultHighlighter = new Highlighter();
        }
        return defaultHighlighter;
    }

    public static void setDefault(@NonNull String regexp) {
        defaultHighlighter = new Highlighter(regexp);
    }

    public static void setDefault(String prefixTag, String postfixTag) {
        defaultHighlighter = new Highlighter(prefixTag, postfixTag);
    }

    public Highlighter(String regexp) {
        this.pattern = Pattern.compile(regexp);
    }

    public Highlighter(String prefixTag, String postfixTag) {
        this(prefixTag + "(.*?)" + postfixTag);
    }

    private Highlighter() {
        this("<em>", "</em>");
    }

    @Nullable
    public Spannable renderHighlightColor(@NonNull JSONObject result, String attribute, @ColorRes int colorId, @NonNull Context context) {
        return this.renderHighlightColor(Highlighter.getHighlightedAttribute(result, attribute), colorId, context);
    }

    @Nullable
    public Spannable renderHighlightColor(@NonNull JSONObject result, String attribute, @NonNull Context context) {
        return this.renderHighlightColor(Highlighter.getHighlightedAttribute(result, attribute), this.getColor(context, R.color.colorHighlighting));
    }

    @Nullable
    public Spannable renderHighlightColor(String markupString, @NonNull Context context) {
        return this.renderHighlightColor(markupString, this.getColor(context, R.color.colorHighlighting));
    }

    @Nullable
    public Spannable renderHighlightColor(String markupString, @ColorRes int colorId, @NonNull Context context) {
        return this.renderHighlightColor(markupString, this.getColor(context, colorId));
    }

    @Nullable
    public Spannable renderHighlightColor(@NonNull JSONObject result, String attribute, @ColorInt int color2) {
        return this.renderHighlightColor(Highlighter.getHighlightedAttribute(result, attribute), color2);
    }

    @Nullable
    public Spannable renderHighlightColor(@Nullable String markupString, @ColorInt int color2) {
        if (markupString == null) {
            return null;
        }
        SpannableStringBuilder result = new SpannableStringBuilder();
        Matcher matcher = this.pattern.matcher(markupString);
        int posIn = 0;
        int posOut = 0;
        while (matcher.find()) {
            result.append((CharSequence)markupString.substring(posIn, matcher.start()));
            String highlightString = matcher.group(1);
            result.append((CharSequence)highlightString);
            BackgroundColorSpan span = new BackgroundColorSpan(color2);
            result.setSpan((Object)span, posOut += matcher.start() - posIn, posOut + highlightString.length(), 33);
            posOut += highlightString.length();
            posIn = matcher.end();
        }
        result.append((CharSequence)markupString.substring(posIn));
        return result;
    }

    private static String getHighlightedAttribute(@NonNull JSONObject result, String attribute) {
        JSONObject highlightResult = result.optJSONObject("_highlightResult");
        if (highlightResult != null) {
            HashMap<String, String> highlightAttribute = JSONUtils.getMapFromJSONPath(highlightResult, attribute);
            if (highlightAttribute != null) {
                String highlightedValue = highlightAttribute.get("value");
                if (highlightedValue != null) {
                    return highlightedValue;
                }
            } else {
                JSONArray array = highlightResult.optJSONArray(attribute);
                if (array != null) {
                    StringBuilder builder = new StringBuilder();
                    int length = array.length();
                    for (int i = 0; i < length; ++i) {
                        String elementValue = ((JSONObject)array.opt(i)).optString("value");
                        builder.append(elementValue);
                        if (i + 1 >= length) continue;
                        builder.append(", ");
                    }
                    return builder.toString();
                }
            }
        }
        return JSONUtils.getStringFromJSONPath(result, attribute);
    }

    @ColorInt
    private int getColor(@NonNull Context context, @ColorRes int colorId) {
        int colorHighlighting = Build.VERSION.SDK_INT >= 23 ? context.getResources().getColor(colorId, context.getTheme()) : context.getResources().getColor(colorId);
        return colorHighlighting;
    }
}

