/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.helpers;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.SearchManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.appcompat.R;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.SearchView;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.events.QueryTextChangeEvent;
import com.algolia.instantsearch.events.QueryTextSubmitEvent;
import com.algolia.instantsearch.events.ResetEvent;
import com.algolia.instantsearch.helpers.SearchProgressController;
import com.algolia.instantsearch.helpers.Searcher;
import com.algolia.instantsearch.model.AlgoliaErrorListener;
import com.algolia.instantsearch.model.AlgoliaResultListener;
import com.algolia.instantsearch.model.AlgoliaSearcherListener;
import com.algolia.instantsearch.ui.views.Hits;
import com.algolia.instantsearch.ui.views.RefinementList;
import com.algolia.instantsearch.ui.views.SearchBox;
import com.algolia.instantsearch.ui.views.filters.AlgoliaFilter;
import com.algolia.instantsearch.utils.LayoutViews;
import com.algolia.instantsearch.utils.SearchViewFacade;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.greenrobot.eventbus.EventBus;

public class InstantSearch {
    public static final int DELAY_PROGRESSBAR_NO_ANIMATIONS = 200;
    @Nullable
    private SearchViewFacade searchView;
    @NonNull
    private final Set<View> widgets = new HashSet<View>();
    @NonNull
    private final Set<AlgoliaResultListener> resultListeners = new HashSet<AlgoliaResultListener>();
    @NonNull
    private final Set<AlgoliaErrorListener> errorListeners = new HashSet<AlgoliaErrorListener>();
    @NonNull
    private final Searcher searcher;
    private Menu searchMenu;
    private int searchMenuId;
    private static int itemLayoutId = -42;
    private boolean showProgressBar;
    private SearchProgressController progressController;
    private boolean searchOnEmptyString;
    private int progressBarDelay = 0;

    public InstantSearch(@NonNull Activity activity, @NonNull Searcher searcher) {
        this(searcher);
        this.processActivity(activity);
    }

    public InstantSearch(@NonNull Activity activity, @NonNull Menu menu, @IdRes int menuItemId, @NonNull Searcher searcher) {
        this(searcher);
        this.registerSearchView(activity, menu, menuItemId);
        this.processActivity(activity);
    }

    private InstantSearch(@NonNull Searcher searcher) {
        this.searcher = searcher;
        this.enableProgressBar();
    }

    public void search() {
        this.searcher.search();
    }

    public void registerSearchView(@NonNull Activity activity, @NonNull Menu menu, int id2) {
        this.searchMenu = menu;
        this.searchMenuId = id2;
        SearchViewFacade actionView = new SearchViewFacade(menu, id2);
        this.registerSearchView(activity, actionView);
    }

    public void registerSearchView(@NonNull Activity activity, @NonNull SearchView searchView) {
        this.registerSearchView(activity, new SearchViewFacade(searchView));
    }

    public void registerSearchView(@NonNull Activity activity, @NonNull android.support.v7.widget.SearchView searchView) {
        this.registerSearchView(activity, new SearchViewFacade(searchView));
    }

    public void reset() {
        this.searcher.reset();
        EventBus.getDefault().post((Object)new ResetEvent());
    }

    public void enableProgressBar(int delay) {
        this.enableProgressBar();
        this.progressBarDelay = delay;
    }

    public void enableProgressBar() {
        this.showProgressBar = true;
        if (Build.VERSION.SDK_INT < 14) {
            this.progressBarDelay = 200;
        }
        this.progressController = new SearchProgressController(new SearchProgressController.ProgressListener(){

            @Override
            public void onStart() {
                InstantSearch.this.updateProgressBar(InstantSearch.this.searchView, true);
            }

            @Override
            public void onStop() {
                InstantSearch.this.updateProgressBar(InstantSearch.this.searchView, false);
            }
        }, this.progressBarDelay);
    }

    public void disableProgressBar() {
        this.updateProgressBar(this.searchView, false);
        this.progressController.disable();
    }

    public void registerFilters(@NonNull ViewGroup rootView) {
        List<AlgoliaFilter> filterViews = LayoutViews.findByClass(rootView, AlgoliaFilter.class);
        if (filterViews.isEmpty()) {
            throw new IllegalStateException(String.format("No AlgoliaFilter was found in view %s.", rootView));
        }
        this.registerFilters(filterViews);
        this.processAllListeners((View)rootView);
    }

    public void registerFilters(List<AlgoliaFilter> filters) {
        for (AlgoliaFilter filter : filters) {
            this.searcher.addFacet(filter.getAttribute());
        }
    }

    public static int getItemLayoutId() {
        if (itemLayoutId == 0) {
            throw new IllegalStateException("Your Hits widget is missing an algolia:itemLayout attribute to specify the hits item layout.");
        }
        return itemLayoutId;
    }

    public void setSearchOnEmptyString(boolean searchOnEmptyString) {
        this.searchOnEmptyString = searchOnEmptyString;
    }

    public boolean hasSearchOnEmptyString() {
        return this.searchOnEmptyString;
    }

    private void registerSearchView(@NonNull Activity activity, @NonNull SearchViewFacade searchView) {
        this.searchView = searchView;
        searchView.setSearchableInfo(((SearchManager)activity.getSystemService("search")).getSearchableInfo(activity.getComponentName()));
        searchView.setIconifiedByDefault(false);
        this.linkSearchViewToSearcher(searchView);
    }

    private void processActivity(@NonNull Activity activity) {
        List<String> refinementAttributes;
        String[] facets;
        View rootView = activity.getWindow().getDecorView().getRootView();
        if (this.searchView == null) {
            this.searchView = InstantSearch.getSearchView(rootView);
        }
        if (this.searchView != null) {
            this.linkSearchViewToSearcher(this.searchView);
            SearchManager manager = (SearchManager)activity.getSystemService("search");
            this.searchView.setSearchableInfo(manager.getSearchableInfo(activity.getComponentName()));
        }
        if ((facets = (refinementAttributes = this.processAllListeners(rootView)).toArray(new String[refinementAttributes.size()])).length > 0) {
            this.searcher.addFacet(facets);
        }
    }

    private void processListener(View widget) {
        Object listener;
        if (widget instanceof AlgoliaResultListener) {
            listener = (AlgoliaResultListener)widget;
            if (!this.resultListeners.contains(listener)) {
                this.resultListeners.add((AlgoliaResultListener)listener);
            }
            this.searcher.registerResultListener((AlgoliaResultListener)listener);
        }
        if (widget instanceof AlgoliaErrorListener) {
            listener = (AlgoliaErrorListener)widget;
            if (!this.errorListeners.contains(listener)) {
                this.errorListeners.add((AlgoliaErrorListener)listener);
            }
            this.searcher.registerErrorListener((AlgoliaErrorListener)listener);
        }
        if (widget instanceof AlgoliaSearcherListener) {
            listener = (AlgoliaSearcherListener)widget;
            listener.initWithSearcher(this.searcher);
        }
        if (!this.widgets.contains(widget)) {
            this.widgets.add(widget);
        }
    }

    private List<String> processAllListeners(View rootView) {
        ArrayList<String> refinementAttributes = new ArrayList<String>();
        List<AlgoliaResultListener> resultListeners = LayoutViews.findByClass((ViewGroup)rootView, AlgoliaResultListener.class);
        if (resultListeners.size() == 0) {
            throw new IllegalStateException("You need to add at least one AlgoliaResultListener.");
        }
        for (AlgoliaResultListener algoliaResultListener : resultListeners) {
            if (!this.resultListeners.contains(algoliaResultListener)) {
                this.resultListeners.add(algoliaResultListener);
            }
            this.searcher.registerResultListener(algoliaResultListener);
            this.prepareWidget(rootView, algoliaResultListener, refinementAttributes);
        }
        List<AlgoliaErrorListener> errorListeners = LayoutViews.findByClass((ViewGroup)rootView, AlgoliaErrorListener.class);
        for (AlgoliaErrorListener listener : errorListeners) {
            if (!this.errorListeners.contains(listener)) {
                this.errorListeners.add(listener);
            }
            this.searcher.registerErrorListener(listener);
            this.prepareWidget(rootView, listener, refinementAttributes);
        }
        List<AlgoliaSearcherListener> list = LayoutViews.findByClass((ViewGroup)rootView, AlgoliaSearcherListener.class);
        for (AlgoliaSearcherListener listener : list) {
            listener.initWithSearcher(this.searcher);
            this.prepareWidget(rootView, listener, refinementAttributes);
        }
        return refinementAttributes;
    }

    private void prepareWidget(Object listener) {
        this.prepareWidget(null, listener, null);
    }

    private void prepareWidget(@Nullable View rootView, Object listener, @Nullable List<String> refinementAttributes) {
        if (listener instanceof View) {
            this.prepareWidget(rootView, (View)listener, refinementAttributes);
        }
    }

    private void prepareWidget(@Nullable View rootView, View widget, @Nullable List<String> refinementAttributes) {
        if (!this.widgets.contains(widget)) {
            this.widgets.add(widget);
            if (widget instanceof Hits) {
                this.searcher.getQuery().setHitsPerPage(((Hits)widget).getHitsPerPage());
                ((Hits)widget).setEmptyView(InstantSearch.getEmptyView(rootView));
                itemLayoutId = ((Hits)widget).getLayoutId();
                if (itemLayoutId == -42) {
                    throw new IllegalStateException("To use the Hits widget, you need to specify an item layout with algolia:itemLayout.");
                }
            } else if (widget instanceof RefinementList) {
                this.searcher.addFacet(((RefinementList)widget).getAttribute(), ((RefinementList)widget).getOperation() == 0, new ArrayList<String>());
                if (refinementAttributes != null) {
                    refinementAttributes.add(((RefinementList)widget).getAttribute());
                }
            } else if (widget instanceof ListView) {
                ((ListView)widget).setEmptyView(InstantSearch.getEmptyView(rootView));
            }
        }
    }

    @SuppressLint(value={"InflateParams"})
    private void updateProgressBar(@Nullable SearchViewFacade searchView, boolean showProgress) {
        if (!this.showProgressBar) {
            return;
        }
        if (searchView == null && Build.VERSION.SDK_INT >= 11) {
            searchView = new SearchViewFacade(this.searchMenu, this.searchMenuId);
        }
        if (searchView != null) {
            int searchPlateId = searchView.getContext().getResources().getIdentifier("android:id/search_plate", null, null);
            LinearLayout searchPlate = (LinearLayout)searchView.findViewById(searchPlateId);
            if (searchPlate == null && (searchPlate = (LinearLayout)searchView.findViewById(R.id.search_plate)) == null) {
                Log.e((String)"Algolia|InstantSearch", (String)"Could not find a view with id @id/search_plate in SearchView.");
                return;
            }
            View progressBarView = searchPlate.findViewById(R.id.search_progress_bar);
            if (progressBarView != null) {
                if (Build.VERSION.SDK_INT >= 14) {
                    progressBarView.animate().setDuration(200L).alpha(showProgress ? 1.0f : 0.0f).start();
                } else {
                    progressBarView.setVisibility(showProgress ? 0 : 8);
                }
            } else if (showProgress) {
                searchPlate.setGravity(17);
                searchPlate.addView(LayoutInflater.from((Context)searchView.getContext()).inflate(R.layout.loading_icon, null), 1);
            }
        }
    }

    private void linkSearchViewToSearcher(final @NonNull SearchViewFacade searchView) {
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                EventBus.getDefault().post((Object)new QueryTextSubmitEvent());
                searchView.clearFocus();
                return true;
            }

            public boolean onQueryTextChange(String newText) {
                EventBus.getDefault().post((Object)new QueryTextChangeEvent(newText));
                if (newText.length() == 0 && InstantSearch.this.searchOnEmptyString) {
                    return true;
                }
                InstantSearch.this.searcher.setQuery(InstantSearch.this.searcher.getQuery().setQuery(searchView.getQuery().toString())).search();
                return true;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static SearchViewFacade getSearchView(@NonNull View rootView) {
        SearchViewFacade facade = null;
        List<SearchBox> searchBoxes = LayoutViews.findByClass(rootView, SearchBox.class);
        if (searchBoxes.size() != 0) {
            if (searchBoxes.size() != 1) throw new IllegalStateException("You cannot have more than one SearchBox.");
            return new SearchViewFacade(searchBoxes.get(0));
        }
        List<SearchView> searchViews = LayoutViews.findByClass(rootView, SearchView.class);
        if (searchViews.size() == 0) {
            List<android.support.v7.widget.SearchView> supportViews = LayoutViews.findByClass(rootView, android.support.v7.widget.SearchView.class);
            if (supportViews.size() != 0) {
                if (supportViews.size() <= 1) return new SearchViewFacade(supportViews.get(0));
                SearchView labeledSearchView = (SearchView)rootView.findViewById(R.id.searchBox);
                if (labeledSearchView != null) return new SearchViewFacade((SearchView)rootView.findViewById(R.id.searchBox));
                throw new IllegalStateException("If you have several SearchViews, you need to identify the Algolia one with @id/searchBox.");
            }
        } else {
            if (searchViews.size() <= 1) return new SearchViewFacade(searchViews.get(0));
            SearchView labeledSearchView = (SearchView)rootView.findViewById(R.id.searchBox);
            if (labeledSearchView != null) return new SearchViewFacade(labeledSearchView);
            throw new IllegalStateException("If you have several SearchViews, you need to identify the Algolia one with @id/searchBox.");
        }
        Log.e((String)"Algolia|InstantSearch", (String)"No SearchBox or SearchView was found in your activity.");
        return facade;
    }

    @Nullable
    private static View getEmptyView(@Nullable View rootView) {
        if (rootView == null) {
            throw new RuntimeException("A null rootView was passed to getEmptyView, but Hits/RefinementList require one.");
        }
        return rootView.findViewById(16908292);
    }
}

