/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.helpers;

import android.os.Handler;
import com.algolia.instantsearch.events.CancelEvent;
import com.algolia.instantsearch.events.ErrorEvent;
import com.algolia.instantsearch.events.ResultEvent;
import com.algolia.instantsearch.events.SearchEvent;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class SearchProgressController {
    public static final int DEFAULT_DELAY = 0;
    private final ProgressListener listener;
    private final int delay;
    private int currentCount;

    public SearchProgressController(ProgressListener listener) {
        this(listener, 0);
    }

    public SearchProgressController(ProgressListener listener, int delay) {
        this.listener = listener;
        this.delay = delay;
        this.enable();
    }

    public void enable() {
        EventBus.getDefault().register((Object)this);
    }

    public void disable() {
        EventBus.getDefault().unregister((Object)this);
        this.currentCount = 0;
    }

    @Subscribe
    public void onSearch(SearchEvent event) {
        if (this.delay == 0) {
            this.listener.onStart();
        } else {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    SearchProgressController.this.listener.onStart();
                }
            }, (long)this.delay);
        }
        ++this.currentCount;
    }

    @Subscribe
    public void onError(ErrorEvent event) {
        this.decrementAndCheckCount();
    }

    @Subscribe
    public void onCancel(CancelEvent event) {
        this.decrementAndCheckCount();
    }

    @Subscribe
    public void onResult(ResultEvent event) {
        this.decrementAndCheckCount();
    }

    private void decrementAndCheckCount() {
        --this.currentCount;
        if (this.currentCount == 0) {
            this.listener.onStop();
        }
    }

    public static interface ProgressListener {
        public void onStart();

        public void onStop();
    }
}

