/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.helpers;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import com.algolia.instantsearch.events.CancelEvent;
import com.algolia.instantsearch.events.ErrorEvent;
import com.algolia.instantsearch.events.FacetRefinementEvent;
import com.algolia.instantsearch.events.NumericRefinementEvent;
import com.algolia.instantsearch.events.RefinementEvent;
import com.algolia.instantsearch.events.ResultEvent;
import com.algolia.instantsearch.events.SearchEvent;
import com.algolia.instantsearch.model.AlgoliaErrorListener;
import com.algolia.instantsearch.model.AlgoliaResultListener;
import com.algolia.instantsearch.model.FacetStat;
import com.algolia.instantsearch.model.NumericRefinement;
import com.algolia.instantsearch.model.SearchResults;
import com.algolia.search.saas.AbstractClient;
import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Client;
import com.algolia.search.saas.CompletionHandler;
import com.algolia.search.saas.Index;
import com.algolia.search.saas.Query;
import com.algolia.search.saas.Request;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Searcher {
    private static Searcher instance;
    private final EventBus bus;
    private Index index;
    private final Client client;
    private Query query;
    private final List<AlgoliaResultListener> resultListeners = new ArrayList<AlgoliaResultListener>();
    private final List<AlgoliaErrorListener> errorListeners = new ArrayList<AlgoliaErrorListener>();
    private static int lastRequestId;
    private int lastResponseId;
    private int lastRequestPage;
    private int lastResponsePage;
    private boolean endReached;
    private final List<String> disjunctiveFacets = new ArrayList<String>();
    private final Map<String, List<String>> refinementMap = new HashMap<String, List<String>>();
    private final Map<String, SparseArray<NumericRefinement>> numericRefinements = new HashMap<String, SparseArray<NumericRefinement>>();
    private final Map<String, Boolean> booleanFilterMap = new HashMap<String, Boolean>();
    private final List<String> facets = new ArrayList<String>();
    private final Map<String, FacetStat> facetStats = new HashMap<String, FacetStat>();
    private final HashMap<String, Integer> facetRequestCount = new HashMap();
    private final SparseArray<Request> pendingRequests = new SparseArray();

    public static Searcher get() {
        if (instance == null) {
            throw new IllegalStateException("You cannot use Searcher#get before having called Searcher#create at least once.");
        }
        return instance;
    }

    public static Searcher create(@NonNull Index index) {
        if (instance == null) {
            instance = new Searcher(index);
        }
        return instance;
    }

    public static Searcher create(@NonNull String appId, @NonNull String apiKey, @NonNull String indexName) {
        return Searcher.create(new Client(appId, apiKey).getIndex(indexName));
    }

    private Searcher(@NonNull Index index) {
        this.index = index;
        this.client = index.getClient();
        this.query = new Query();
        this.client.addUserAgent(new AbstractClient.LibraryVersion("InstantSearch Android", String.valueOf("1.0.0")));
        this.bus = EventBus.getDefault();
    }

    @NonNull
    public Searcher search(String queryString) {
        this.query.setQuery(queryString);
        this.search();
        return this;
    }

    @NonNull
    public Searcher search() {
        this.endReached = false;
        this.lastRequestPage = 0;
        this.lastResponsePage = -1;
        final int currentRequestId = ++lastRequestId;
        this.bus.post((Object)new SearchEvent(this.query, currentRequestId));
        CompletionHandler searchHandler = new CompletionHandler(){

            public void requestCompleted(@Nullable JSONObject content, @Nullable AlgoliaException error) {
                Searcher.this.pendingRequests.remove(currentRequestId);
                for (int i = 0; i < Searcher.this.pendingRequests.size(); ++i) {
                    int reqId = Searcher.this.pendingRequests.keyAt(i);
                    Request request = (Request)Searcher.this.pendingRequests.valueAt(i);
                    if (reqId >= currentRequestId) continue;
                    Searcher.this.cancelRequest(request, reqId);
                }
                if (currentRequestId <= Searcher.this.lastResponseId) {
                    Log.e((String)"Algolia|Searcher", (String)("We already displayed results for request " + Searcher.this.lastResponseId + ", current request (" + currentRequestId + ") should have been canceled"));
                }
                if (content == null || !Searcher.hasHits(content)) {
                    Searcher.this.endReached = true;
                } else {
                    Searcher.this.checkIfLastPage(content);
                }
                Searcher.this.lastResponseId = currentRequestId;
                Searcher.this.lastResponsePage = 0;
                if (error != null) {
                    Searcher.this.bus.post((Object)new ErrorEvent(error, Searcher.this.query, currentRequestId));
                    for (AlgoliaErrorListener listener : Searcher.this.errorListeners) {
                        listener.onError(Searcher.this.query, error);
                    }
                } else if (content == null) {
                    Log.e((String)"Algolia|Searcher", (String)"content is null but error is not.");
                } else {
                    Searcher.this.bus.post((Object)new ResultEvent(content, Searcher.this.query, currentRequestId));
                    Searcher.this.updateListeners(content, false);
                    Searcher.this.updateFacetStats(content);
                }
            }
        };
        Request searchRequest = this.disjunctiveFacets.size() != 0 ? this.index.searchDisjunctiveFacetingAsync(this.query, this.disjunctiveFacets, this.refinementMap, searchHandler) : this.index.searchAsync(this.query, searchHandler);
        this.pendingRequests.put(currentRequestId, (Object)searchRequest);
        return this;
    }

    @NonNull
    public Searcher loadMore() {
        if (!this.hasMoreHits()) {
            return this;
        }
        Query loadMoreQuery = new Query(this.query);
        loadMoreQuery.setPage(Integer.valueOf(++this.lastRequestPage));
        final int currentRequestId = ++lastRequestId;
        this.bus.post((Object)new SearchEvent(this.query, currentRequestId));
        this.pendingRequests.put(currentRequestId, (Object)this.index.searchAsync(loadMoreQuery, new CompletionHandler(){

            public void requestCompleted(@NonNull JSONObject content, @Nullable AlgoliaException error) {
                Searcher.this.pendingRequests.remove(currentRequestId);
                if (error != null) {
                    Searcher.this.bus.post((Object)new ErrorEvent(error, Searcher.this.query, currentRequestId));
                    for (AlgoliaErrorListener listener : Searcher.this.errorListeners) {
                        listener.onError(Searcher.this.query, error);
                    }
                } else {
                    if (currentRequestId <= Searcher.this.lastResponseId) {
                        return;
                    }
                    Searcher.this.bus.post((Object)new ResultEvent(content, Searcher.this.query, currentRequestId));
                    if (Searcher.hasHits(content)) {
                        Searcher.this.updateListeners(content, true);
                        Searcher.this.updateFacetStats(content);
                        Searcher.this.lastResponsePage = Searcher.this.lastRequestPage;
                        Searcher.this.checkIfLastPage(content);
                    } else {
                        Searcher.this.endReached = true;
                    }
                }
            }
        }));
        return this;
    }

    public boolean hasMoreHits() {
        return !this.endReached && this.lastRequestPage <= this.lastResponsePage;
    }

    @NonNull
    public Searcher reset() {
        this.lastResponsePage = 0;
        this.lastRequestPage = 0;
        this.lastResponseId = 0;
        this.endReached = false;
        this.clearFacetRefinements();
        this.cancelPendingRequests();
        this.numericRefinements.clear();
        return this;
    }

    public boolean hasPendingRequests() {
        return this.pendingRequests.size() != 0;
    }

    public Searcher cancelPendingRequests() {
        if (this.pendingRequests.size() != 0) {
            for (int i = 0; i < this.pendingRequests.size(); ++i) {
                int reqId = this.pendingRequests.keyAt(i);
                Request r = (Request)this.pendingRequests.valueAt(i);
                if (r.isFinished() || r.isCancelled()) continue;
                this.cancelRequest(r, reqId);
            }
        }
        return this;
    }

    public void addFacet(@NonNull String attribute, boolean isDisjunctiveFacet, @Nullable ArrayList<String> values) {
        if (isDisjunctiveFacet) {
            this.disjunctiveFacets.add(attribute);
        }
        if (values == null) {
            values = new ArrayList();
        }
        this.refinementMap.put(attribute, values);
    }

    @NonNull
    public Searcher updateFacetRefinement(@NonNull String attribute, @NonNull String value, boolean active) {
        if (active) {
            this.addFacetRefinement(attribute, value);
        } else {
            this.removeFacetRefinement(attribute, value);
        }
        return this;
    }

    @NonNull
    public Searcher addFacetRefinement(@NonNull String attribute, @NonNull String value) {
        this.bus.post((Object)new FacetRefinementEvent(RefinementEvent.Operation.ADD, attribute, value));
        List<String> attributeRefinements = this.getOrCreateRefinements(attribute);
        attributeRefinements.add(value);
        this.rebuildQueryFacetFilters();
        return this;
    }

    @NonNull
    public Searcher removeFacetRefinement(@NonNull String attribute, @NonNull String value) {
        this.bus.post((Object)new FacetRefinementEvent(RefinementEvent.Operation.REMOVE, attribute, value));
        List<String> attributeRefinements = this.getOrCreateRefinements(attribute);
        attributeRefinements.remove(value);
        this.rebuildQueryFacetFilters();
        return this;
    }

    public boolean hasFacetRefinement(@NonNull String attribute, @NonNull String value) {
        List<String> attributeRefinements = this.refinementMap.get(attribute);
        return attributeRefinements != null && attributeRefinements.contains(value);
    }

    public Searcher clearFacetRefinements() {
        this.refinementMap.clear();
        this.disjunctiveFacets.clear();
        this.rebuildQueryFacetFilters();
        return this;
    }

    public Searcher clearFacetRefinements(@NonNull String attribute) {
        List<String> stringList = this.refinementMap.get(attribute);
        if (stringList != null) {
            stringList.clear();
        }
        this.disjunctiveFacets.remove(attribute);
        this.rebuildQueryFacetFilters();
        return this;
    }

    @Nullable
    public NumericRefinement getNumericRefinement(@NonNull String attribute, int operator) {
        NumericRefinement.checkOperatorIsValid(operator);
        SparseArray<NumericRefinement> attributeRefinements = this.numericRefinements.get(attribute);
        return attributeRefinements == null ? null : (NumericRefinement)attributeRefinements.get(operator);
    }

    public Searcher addNumericRefinement(@NonNull NumericRefinement refinement) {
        this.bus.post((Object)new NumericRefinementEvent(RefinementEvent.Operation.ADD, refinement));
        SparseArray refinements = this.numericRefinements.get(refinement.attribute);
        if (refinements == null) {
            refinements = new SparseArray();
        }
        refinements.put(refinement.operator, (Object)refinement);
        this.numericRefinements.put(refinement.attribute, (SparseArray<NumericRefinement>)refinements);
        this.rebuildQueryNumericFilters();
        return this;
    }

    public Searcher removeNumericRefinement(@NonNull String attribute) {
        return this.removeNumericRefinement(attribute, -42, -42.0);
    }

    public Searcher removeNumericRefinement(@NonNull NumericRefinement refinement) {
        return this.removeNumericRefinement(refinement.attribute, refinement.operator, refinement.value);
    }

    public Searcher removeNumericRefinement(@NonNull String attribute, @NonNull Integer operator) {
        return this.removeNumericRefinement(attribute, operator, -42.0);
    }

    private Searcher removeNumericRefinement(@NonNull String attribute, @NonNull Integer operator, @NonNull Double value) {
        if (operator == -42) {
            this.numericRefinements.remove(attribute);
        } else {
            NumericRefinement.checkOperatorIsValid(operator);
            this.numericRefinements.get(attribute).remove(operator.intValue());
        }
        this.bus.post((Object)new NumericRefinementEvent(RefinementEvent.Operation.REMOVE, new NumericRefinement(attribute, operator, value)));
        this.rebuildQueryNumericFilters();
        return this;
    }

    public Searcher addBooleanFilter(String attribute, Boolean value) {
        this.booleanFilterMap.put(attribute, value);
        this.rebuildQueryFacetFilters();
        return this;
    }

    @Nullable
    public Boolean getBooleanFilter(String attribute) {
        return this.booleanFilterMap.get(attribute);
    }

    public Searcher removeBooleanFilter(String attribute) {
        this.booleanFilterMap.remove(attribute);
        this.rebuildQueryFacetFilters();
        return this;
    }

    public Searcher addFacet(String ... attributes) {
        String[] stringArray = attributes;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String attribute;
            Integer value = this.facetRequestCount.get(attribute = stringArray[i]);
            this.facetRequestCount.put(attribute, value == null ? 1 : value + 1);
            if (value != null && value != 0) continue;
            this.facets.add(attribute);
        }
        this.rebuildQueryFacets();
        return this;
    }

    public Searcher removeFacet(String ... attributes) {
        for (String attribute : attributes) {
            Integer value = this.facetRequestCount.get(attribute);
            if (value == null) {
                Log.e((String)"Algolia|Searcher", (String)("removeFacet called for" + attribute + " which was not currently a facet."));
                continue;
            }
            if (value == 1) {
                this.facets.remove(attribute);
                this.facetRequestCount.put(attribute, 0);
                continue;
            }
            this.facetRequestCount.put(attribute, value - 1);
        }
        this.rebuildQueryFacets();
        return this;
    }

    public Searcher deleteFacet(String ... attributes) {
        for (String attribute : attributes) {
            this.facetRequestCount.put(attribute, 0);
            this.facets.remove(attribute);
        }
        this.rebuildQueryFacets();
        return this;
    }

    Searcher registerResultListener(@NonNull AlgoliaResultListener resultListener) {
        if (!this.resultListeners.contains(resultListener)) {
            this.resultListeners.add(resultListener);
        }
        return this;
    }

    Searcher registerErrorListener(@NonNull AlgoliaErrorListener errorListener) {
        if (!this.errorListeners.contains(errorListener)) {
            this.errorListeners.add(errorListener);
        }
        return this;
    }

    static boolean hasHits(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return false;
        }
        JSONArray resultHits = jsonObject.optJSONArray("hits");
        if (resultHits == null) {
            return false;
        }
        for (int i = 0; i < resultHits.length(); ++i) {
            JSONObject hit = resultHits.optJSONObject(i);
            if (hit == null) continue;
            return true;
        }
        return false;
    }

    public Query getQuery() {
        return this.query;
    }

    @NonNull
    public Searcher setQuery(@NonNull Query query) {
        this.query = query;
        this.query.setPage(Integer.valueOf(0));
        return this;
    }

    public Index getIndex() {
        return this.index;
    }

    @NonNull
    public Searcher setIndex(@NonNull String indexName) {
        this.index = this.client.getIndex(indexName);
        this.query.setPage(Integer.valueOf(0));
        return this;
    }

    private void updateFacetStats(JSONObject content) {
        if (content == null) {
            return;
        }
        JSONObject facets = content.optJSONObject("facets");
        JSONObject facets_stats = content.optJSONObject("facets_stats");
        if (facets != null) {
            Iterator keys = facets.keys();
            while (keys.hasNext()) {
                this.updateFacetStat(facets, facets_stats, (String)keys.next());
            }
        }
    }

    private void updateFacetStat(JSONObject facets, JSONObject facets_stats, String attribute) {
        JSONObject attributeStats;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double sum = 0.0;
        if (facets_stats != null && (attributeStats = facets_stats.optJSONObject(attribute)) != null) {
            try {
                min = attributeStats.getDouble("min");
                max = attributeStats.getDouble("max");
                sum = attributeStats.getDouble("sum");
                double avg = attributeStats.getDouble("avg");
                this.facetStats.put(attribute, new FacetStat(min, max, avg, sum));
                return;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        JSONObject values = facets.optJSONObject(attribute);
        Iterator valueKeys = values.keys();
        while (valueKeys.hasNext()) {
            boolean attributeValue;
            String valueKey = (String)valueKeys.next();
            if (!valueKey.equals("true") && !valueKey.equals("false")) continue;
            boolean bl = attributeValue = !valueKey.equals("false");
            if ((double)attributeValue < min) {
                min = (double)attributeValue;
            }
            if ((double)attributeValue > max) {
                max = (double)attributeValue;
            }
            sum += (double)attributeValue;
        }
        if (min != Double.MAX_VALUE && max != Double.MIN_VALUE) {
            double avg = sum / (double)values.length();
            this.facetStats.put(attribute, new FacetStat(min, max, avg, sum));
        }
    }

    @Nullable
    public FacetStat getFacetStat(String attribute) {
        return this.facetStats.get(attribute);
    }

    public void getUpdatedFacetStats() {
        this.index.searchAsync(this.query, new CompletionHandler(){

            public void requestCompleted(JSONObject content, AlgoliaException error) {
                if (error == null) {
                    Searcher.this.updateFacetStats(content);
                } else {
                    Log.e((String)"Algolia|Searcher", (String)("Error while getting updated facet stats:" + error.getMessage()));
                }
            }
        });
    }

    private Searcher rebuildQueryFacetFilters() {
        JSONArray facetFilters = new JSONArray();
        for (Map.Entry<String, List<String>> entry : this.refinementMap.entrySet()) {
            List<String> values = entry.getValue();
            String attribute = entry.getKey();
            for (String value : values) {
                facetFilters.put((Object)(attribute + ":" + value));
            }
        }
        for (Map.Entry<String, Object> entry : this.booleanFilterMap.entrySet()) {
            facetFilters.put((Object)(entry.getKey() + ":" + entry.getValue()));
        }
        this.query.setFacetFilters(facetFilters);
        this.query.setPage(Integer.valueOf(0));
        return this;
    }

    private void rebuildQueryNumericFilters() {
        JSONArray numericFilters = new JSONArray();
        for (SparseArray<NumericRefinement> refinements : this.numericRefinements.values()) {
            for (int i = 0; i < refinements.size(); ++i) {
                numericFilters.put((Object)((NumericRefinement)refinements.valueAt(i)).toString());
            }
        }
        this.query.setNumericFilters(numericFilters);
        this.query.setPage(Integer.valueOf(0));
    }

    private Searcher rebuildQueryFacets() {
        String[] facetArray = this.facets.toArray(new String[this.facets.size()]);
        this.query.setFacets(facetArray);
        return this;
    }

    @NonNull
    private List<String> getOrCreateRefinements(@NonNull String attribute) {
        List<String> attributeRefinements = this.refinementMap.get(attribute);
        if (attributeRefinements == null) {
            attributeRefinements = new ArrayList<String>();
            this.refinementMap.put(attribute, attributeRefinements);
        }
        return attributeRefinements;
    }

    private void cancelRequest(Request request, Integer requestSeqNumber) {
        if (request.isCancelled()) {
            throw new IllegalStateException("cancelRequest was called on a request that was already canceled.");
        }
        request.cancel();
        this.bus.post((Object)new CancelEvent(request, requestSeqNumber));
        this.pendingRequests.delete(requestSeqNumber.intValue());
    }

    private void checkIfLastPage(@NonNull JSONObject content) {
        if (content.optInt("nbPages") == content.optInt("page") + 1) {
            this.endReached = true;
        }
    }

    private void updateListeners(@NonNull JSONObject hits, boolean isLoadingMore) {
        for (AlgoliaResultListener listener : this.resultListeners) {
            listener.onResults(new SearchResults(hits), isLoadingMore);
        }
    }
}

